/*
 * Decompiled with CFR 0.152.
 */
package plugins.fmp.multiSPOTS96.dlg.d_spotsMeasures;

import icy.roi.ROI2D;
import icy.util.StringUtil;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import plugins.fmp.multiSPOTS96.MultiSPOTS96;
import plugins.fmp.multiSPOTS96.experiment.Experiment;
import plugins.fmp.multiSPOTS96.experiment.sequence.SequenceKymos;
import plugins.fmp.multiSPOTS96.experiment.spots.Spot;
import plugins.fmp.multiSPOTS96.experiment.spots.SpotMeasure;

public class Edit
extends JPanel
implements PropertyChangeListener {
    private static final long serialVersionUID = 2580935598417087197L;
    private JComboBox<String> roiTypeCombo = new JComboBox<String>(new String[]{"sum", "clean", "fly present/absent"});
    private JButton cutAndInterpolateButton = new JButton("Cut & interpolate");
    private JButton compensateButton = new JButton("Compensate (poop deposit)");
    private JComboBox<String> directionCombo = new JComboBox<String>(new String[]{"up", "down"});
    private String buildMedianString = "Build median";
    private JButton buildMedianButton = new JButton(this.buildMedianString);
    private MultiSPOTS96 parent0 = null;

    void init(GridLayout capLayout, MultiSPOTS96 parent0) {
        this.setLayout(capLayout);
        this.parent0 = parent0;
        FlowLayout layoutLeft = new FlowLayout(0);
        layoutLeft.setVgap(0);
        JPanel panel1 = new JPanel(layoutLeft);
        panel1.add(this.cutAndInterpolateButton);
        panel1.add(new JLabel("Apply to ", 2));
        panel1.add(this.roiTypeCombo);
        this.add(panel1);
        JPanel panel2 = new JPanel(layoutLeft);
        panel2.add(this.compensateButton);
        panel2.add(this.directionCombo);
        this.add(panel2);
        JPanel panel3 = new JPanel(layoutLeft);
        this.add(panel3);
        this.roiTypeCombo.setSelectedIndex(1);
        this.defineListeners();
    }

    private void defineListeners() {
        this.cutAndInterpolateButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Experiment exp = (Experiment)((Edit)Edit.this).parent0.expListCombo.getSelectedItem();
                if (exp != null) {
                    Edit.this.cutAndInterpolate(exp);
                }
            }
        });
        this.compensateButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Experiment exp = (Experiment)((Edit)Edit.this).parent0.expListCombo.getSelectedItem();
                if (exp != null) {
                    Edit.this.compensate(exp);
                }
            }
        });
    }

    void cutAndInterpolate(Experiment exp) {
        SequenceKymos seqKymos = exp.seqKymos;
        ROI2D roiRect = seqKymos.getSequence().getSelectedROI2D();
        if (roiRect == null) {
            return;
        }
        int t = seqKymos.getSequence().getFirstViewer().getPositionT();
        Spot spot = exp.cagesArray.getSpotAtGlobalIndex(t);
        String optionSelected = (String)this.roiTypeCombo.getSelectedItem();
        if (optionSelected.contains("sum")) {
            this.removeAndUpdate(seqKymos, spot, spot.getSum(), roiRect);
        } else if (optionSelected.contains("clean")) {
            this.removeAndUpdate(seqKymos, spot, spot.getSumClean(), roiRect);
        } else if (optionSelected.contains("fly")) {
            this.removeAndUpdate(seqKymos, spot, spot.getFlyPresent(), roiRect);
        }
    }

    void compensate(Experiment exp) {
        SequenceKymos seqKymos = exp.seqKymos;
        ROI2D roiRect = seqKymos.getSequence().getSelectedROI2D();
        if (roiRect == null) {
            return;
        }
        int t = seqKymos.getSequence().getFirstViewer().getPositionT();
        Spot spot = exp.cagesArray.getSpotAtGlobalIndex(t);
        String optionSelected = (String)this.roiTypeCombo.getSelectedItem();
        if (optionSelected.contains("sum")) {
            this.compensateAndUpdate(seqKymos, spot, spot.getSum(), roiRect);
        } else if (optionSelected.contains("clean")) {
            this.compensateAndUpdate(seqKymos, spot, spot.getSumClean(), roiRect);
        } else if (optionSelected.contains("fly")) {
            this.compensateAndUpdate(seqKymos, spot, spot.getFlyPresent(), roiRect);
        }
    }

    private void removeAndUpdate(SequenceKymos seqKymos, Spot spot, SpotMeasure spotMeasure, ROI2D roi) {
        spotMeasure.getSpotLevel2D().cutAndInterpolatePointsEnclosedInSelectedRoi(roi);
        spotMeasure.getSpotLevel2D().transferROItoLevel2D();
    }

    private void compensateAndUpdate(SequenceKymos seqKymos, Spot spot, SpotMeasure spotMeasure, ROI2D roi) {
        boolean bAdd = this.directionCombo.getSelectedIndex() == 0;
        spotMeasure.getSpotLevel2D().compensateOffsetUsingSelectedRoi(roi, bAdd);
        spotMeasure.getSpotLevel2D().transferROItoLevel2D();
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (StringUtil.equals((String)"thread_ended", (String)evt.getPropertyName())) {
            this.buildMedianButton.setText(this.buildMedianString);
            Experiment exp = (Experiment)this.parent0.expListCombo.getSelectedItem();
            if (exp != null) {
                exp.load_MS96_spotsMeasures();
                this.parent0.dlgMeasure.tabCharts.displayChartPanels(exp);
            }
        }
    }
}

