/*
 * Decompiled with CFR 0.152.
 */
package plugins.fmp.multiSPOTS96.experiment.cages;

import java.util.List;

public final class CagesArrayInfo {
    private final int totalCages;
    private final int validCages;
    private final int activeCages;
    private final int cagesWithSpots;
    private final int gridSize;
    private final List<String> cageNames;
    private final boolean hasTimeIntervals;
    private final int timeIntervalsCount;

    private CagesArrayInfo(Builder builder) {
        this.totalCages = builder.totalCages;
        this.validCages = builder.validCages;
        this.activeCages = builder.activeCages;
        this.cagesWithSpots = builder.cagesWithSpots;
        this.gridSize = builder.gridSize;
        this.cageNames = builder.cageNames != null ? List.copyOf(builder.cageNames) : List.of();
        this.hasTimeIntervals = builder.hasTimeIntervals;
        this.timeIntervalsCount = builder.timeIntervalsCount;
    }

    public static Builder builder() {
        return new Builder();
    }

    public int getTotalCages() {
        return this.totalCages;
    }

    public int getValidCages() {
        return this.validCages;
    }

    public int getActiveCages() {
        return this.activeCages;
    }

    public int getCagesWithSpots() {
        return this.cagesWithSpots;
    }

    public int getGridSize() {
        return this.gridSize;
    }

    public List<String> getCageNames() {
        return this.cageNames;
    }

    public boolean hasTimeIntervals() {
        return this.hasTimeIntervals;
    }

    public int getTimeIntervalsCount() {
        return this.timeIntervalsCount;
    }

    public boolean hasValidCages() {
        return this.validCages > 0;
    }

    public double getValidCagesRatio() {
        return this.totalCages > 0 ? (double)this.validCages / (double)this.totalCages : 0.0;
    }

    public double getActiveCagesRatio() {
        return this.totalCages > 0 ? (double)this.activeCages / (double)this.totalCages : 0.0;
    }

    public double getSpotsCompletionRatio() {
        return this.totalCages > 0 ? (double)this.cagesWithSpots / (double)this.totalCages : 0.0;
    }

    public boolean isGridComplete() {
        return this.totalCages == this.gridSize;
    }

    public boolean isReadyForAnalysis() {
        return this.activeCages > 0 && this.validCages > 0;
    }

    public boolean hasAnySpots() {
        return this.cagesWithSpots > 0;
    }

    public String toString() {
        return String.format("CagesArrayInfo{total=%d, valid=%d, active=%d, withSpots=%d, grid=%d, timeIntervals=%d}", this.totalCages, this.validCages, this.activeCages, this.cagesWithSpots, this.gridSize, this.timeIntervalsCount);
    }

    public static class Builder {
        private int totalCages;
        private int validCages;
        private int activeCages;
        private int cagesWithSpots;
        private int gridSize;
        private List<String> cageNames;
        private boolean hasTimeIntervals;
        private int timeIntervalsCount;

        public Builder totalCages(int totalCages) {
            this.totalCages = totalCages;
            return this;
        }

        public Builder validCages(int validCages) {
            this.validCages = validCages;
            return this;
        }

        public Builder activeCages(int activeCages) {
            this.activeCages = activeCages;
            return this;
        }

        public Builder cagesWithSpots(int cagesWithSpots) {
            this.cagesWithSpots = cagesWithSpots;
            return this;
        }

        public Builder gridSize(int gridSize) {
            this.gridSize = gridSize;
            return this;
        }

        public Builder cageNames(List<String> cageNames) {
            this.cageNames = cageNames;
            return this;
        }

        public Builder hasTimeIntervals(boolean hasTimeIntervals) {
            this.hasTimeIntervals = hasTimeIntervals;
            return this;
        }

        public Builder timeIntervalsCount(int timeIntervalsCount) {
            this.timeIntervalsCount = timeIntervalsCount;
            return this;
        }

        public CagesArrayInfo build() {
            return new CagesArrayInfo(this);
        }
    }
}

