/*
 * Decompiled with CFR 0.152.
 */
package plugins.fmp.multiSPOTS96.experiment.sequence;

import icy.common.exception.UnsupportedFormatException;
import icy.file.Loader;
import icy.file.Saver;
import icy.gui.frame.progress.ProgressFrame;
import icy.image.IcyBufferedImage;
import icy.roi.ROI2D;
import icy.sequence.MetaDataUtil;
import icy.type.DataType;
import icy.type.collection.array.Array1DUtil;
import java.awt.Rectangle;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;
import java.util.logging.Logger;
import loci.formats.FormatException;
import ome.xml.meta.OMEXMLMetadata;
import plugins.fmp.multiSPOTS96.experiment.EnumStatus;
import plugins.fmp.multiSPOTS96.experiment.ExperimentDirectories;
import plugins.fmp.multiSPOTS96.experiment.cages.Cage;
import plugins.fmp.multiSPOTS96.experiment.cages.CagesArray;
import plugins.fmp.multiSPOTS96.experiment.sequence.ImageAdjustmentOptions;
import plugins.fmp.multiSPOTS96.experiment.sequence.ImageFileDescriptor;
import plugins.fmp.multiSPOTS96.experiment.sequence.ImageProcessingResult;
import plugins.fmp.multiSPOTS96.experiment.sequence.KymographConfiguration;
import plugins.fmp.multiSPOTS96.experiment.sequence.KymographInfo;
import plugins.fmp.multiSPOTS96.experiment.sequence.SequenceCamData;
import plugins.fmp.multiSPOTS96.experiment.spots.Spot;
import plugins.fmp.multiSPOTS96.tools.Comparators;
import plugins.fmp.multiSPOTS96.tools.ROI2D.ROI2DUtilities;
import plugins.kernel.roi.roi2d.ROI2DPolyLine;

public class SequenceKymos
extends SequenceCamData {
    private static final Logger LOGGER = Logger.getLogger(SequenceKymos.class.getName());
    private final ReentrantLock processingLock = new ReentrantLock();
    private volatile boolean isLoadingImages = false;
    private volatile int maxImageWidth = 0;
    private volatile int maxImageHeight = 0;
    private KymographConfiguration configuration;

    public SequenceKymos() {
        this.configuration = KymographConfiguration.defaultConfiguration();
        this.setStatus(EnumStatus.KYMOGRAPH);
    }

    public SequenceKymos(String name, IcyBufferedImage image) {
        super(name, image);
        this.configuration = KymographConfiguration.defaultConfiguration();
        this.setStatus(EnumStatus.KYMOGRAPH);
    }

    public SequenceKymos(List<String> imageNames) {
        if (imageNames == null || imageNames.isEmpty()) {
            throw new IllegalArgumentException("Image names list cannot be null or empty");
        }
        this.configuration = KymographConfiguration.defaultConfiguration();
        this.setImagesList(imageNames);
        this.setStatus(EnumStatus.KYMOGRAPH);
    }

    public static Builder kymographBuilder() {
        return new Builder();
    }

    public KymographInfo getKymographInfo() {
        if (this.getSequence() == null) {
            throw new IllegalStateException("Sequence is not initialized");
        }
        this.processingLock.lock();
        try {
            List<String> imageNames = this.getImagesList();
            KymographInfo kymographInfo = KymographInfo.builder().totalImages(imageNames.size()).maxWidth(this.maxImageWidth).maxHeight(this.maxImageHeight).validImages(this.countValidImages(imageNames)).invalidImages(this.countInvalidImages(imageNames)).isLoading(this.isLoadingImages).imageNames(imageNames).build();
            return kymographInfo;
        }
        finally {
            this.processingLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ImageProcessingResult validateROIs() {
        if (this.getSequence() == null) {
            return ImageProcessingResult.failure(new IllegalStateException("Sequence is not initialized"), "Cannot validate ROIs: sequence is not initialized");
        }
        this.processingLock.lock();
        try {
            long startTime = System.currentTimeMillis();
            int processed = 0;
            int failed = 0;
            ArrayList roiList = this.getSequence().getROI2Ds();
            int sequenceWidth = this.getSequence().getWidth();
            for (ROI2D roi : roiList) {
                if (!(roi instanceof ROI2DPolyLine)) continue;
                try {
                    if (roi.getName() != null && roi.getName().contains("level")) {
                        ROI2DUtilities.interpolateMissingPointsAlongXAxis((ROI2DPolyLine)roi, sequenceWidth);
                        ++processed;
                        continue;
                    }
                    if (roi.getName() == null || !roi.getName().contains("derivative")) continue;
                }
                catch (Exception e) {
                    LOGGER.log(Level.WARNING, "Failed to process ROI: " + roi.getName(), e);
                    ++failed;
                }
            }
            Collections.sort(roiList, new Comparators.ROI2D_Name());
            long processingTime = System.currentTimeMillis() - startTime;
            ImageProcessingResult imageProcessingResult = ImageProcessingResult.builder().success(failed == 0).processedCount(processed).failedCount(failed).processingTimeMs(processingTime).message(String.format("Processed %d ROIs, %d failed", processed, failed)).build();
            return imageProcessingResult;
        }
        finally {
            this.processingLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ImageProcessingResult loadKymographs(List<ImageFileDescriptor> imageDescriptors, ImageAdjustmentOptions adjustmentOptions) {
        if (imageDescriptors == null) {
            throw new IllegalArgumentException("Image descriptors cannot be null");
        }
        if (adjustmentOptions == null) {
            throw new IllegalArgumentException("Adjustment options cannot be null");
        }
        this.processingLock.lock();
        try {
            Rectangle maxDimensions;
            ImageProcessingResult adjustResult;
            this.isLoadingImages = true;
            long startTime = System.currentTimeMillis();
            if (imageDescriptors.isEmpty()) {
                ImageProcessingResult imageProcessingResult = ImageProcessingResult.success(0, "No images to process");
                return imageProcessingResult;
            }
            if (adjustmentOptions.isAdjustSize() && !(adjustResult = this.adjustImageSizes(imageDescriptors, maxDimensions = this.calculateMaxDimensions(imageDescriptors), adjustmentOptions)).isSuccess()) {
                ImageProcessingResult imageProcessingResult = adjustResult;
                return imageProcessingResult;
            }
            List<String> validImageFiles = this.extractValidImageFiles(imageDescriptors);
            if (validImageFiles.isEmpty()) {
                adjustResult = ImageProcessingResult.failure(new IllegalStateException("No valid image files found"), "No valid images to load");
                return adjustResult;
            }
            this.setStatus(EnumStatus.KYMOGRAPH);
            List<String> acceptedFiles = ExperimentDirectories.keepOnlyAcceptedNames_List(validImageFiles, this.configuration.getAcceptedFileExtensions().toArray(new String[0]));
            this.loadImageList(acceptedFiles);
            this.setSequenceNameFromFirstImage(acceptedFiles);
            this.setStatus(EnumStatus.KYMOGRAPH);
            long processingTime = System.currentTimeMillis() - startTime;
            ImageProcessingResult imageProcessingResult = ImageProcessingResult.builder().success(true).processedCount(acceptedFiles.size()).processingTimeMs(processingTime).message(String.format("Successfully loaded %d kymograph images", acceptedFiles.size())).build();
            return imageProcessingResult;
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "Failed to load kymographs", e);
            ImageProcessingResult imageProcessingResult = ImageProcessingResult.failure(e, "Failed to load kymographs: " + e.getMessage());
            return imageProcessingResult;
        }
        finally {
            this.isLoadingImages = false;
            this.processingLock.unlock();
        }
    }

    public ImageProcessingResult loadKymographs(List<ImageFileDescriptor> imageDescriptors) {
        return this.loadKymographs(imageDescriptors, ImageAdjustmentOptions.defaultOptions());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ImageFileDescriptor> createKymographFileList(String baseDirectory, CagesArray cagesArray) {
        if (baseDirectory == null || baseDirectory.trim().isEmpty()) {
            throw new IllegalArgumentException("Base directory cannot be null or empty");
        }
        if (cagesArray == null) {
            throw new IllegalArgumentException("Cages array cannot be null");
        }
        this.processingLock.lock();
        try {
            String fullDirectory = baseDirectory + File.separator;
            if (cagesArray.cagesList.isEmpty()) {
                LOGGER.warning("No cages found in cages array");
                ArrayList<ImageFileDescriptor> arrayList = new ArrayList<ImageFileDescriptor>();
                return arrayList;
            }
            Cage firstCage = cagesArray.cagesList.get(0);
            if (firstCage.spotsArray == null || firstCage.spotsArray.getSpotsList().isEmpty()) {
                LOGGER.warning("No spots found in first cage");
                ArrayList<ImageFileDescriptor> arrayList = new ArrayList<ImageFileDescriptor>();
                return arrayList;
            }
            int totalExpectedFiles = cagesArray.cagesList.size() * firstCage.spotsArray.getSpotsList().size();
            ArrayList<ImageFileDescriptor> fileList = new ArrayList<ImageFileDescriptor>(totalExpectedFiles);
            for (Cage cage : cagesArray.cagesList) {
                if (cage.spotsArray == null) continue;
                for (Spot spot : cage.spotsArray.getSpotsList()) {
                    ImageFileDescriptor descriptor = new ImageFileDescriptor();
                    descriptor.fileName = fullDirectory + spot.getRoi().getName() + ".tiff";
                    descriptor.exists = new File(descriptor.fileName).exists();
                    fileList.add(descriptor);
                }
            }
            ArrayList<ImageFileDescriptor> arrayList = fileList;
            return arrayList;
        }
        finally {
            this.processingLock.unlock();
        }
    }

    public void updateConfiguration(KymographConfiguration configuration) {
        if (configuration == null) {
            throw new IllegalArgumentException("Configuration cannot be null");
        }
        this.processingLock.lock();
        try {
            this.configuration = configuration;
        }
        finally {
            this.processingLock.unlock();
        }
    }

    public KymographConfiguration getConfiguration() {
        return this.configuration;
    }

    @Deprecated
    public void validateRois() {
        this.validateROIs();
    }

    @Deprecated
    public List<ImageFileDescriptor> loadListOfPotentialKymographsFromSpots(String dir, CagesArray cagesArray) {
        return this.createKymographFileList(dir, cagesArray);
    }

    @Deprecated
    public boolean loadKymographImagesFromList(List<ImageFileDescriptor> kymoImagesDesc, boolean adjustImagesSize) {
        ImageAdjustmentOptions options = adjustImagesSize ? ImageAdjustmentOptions.withSizeAdjustment(this.calculateMaxDimensions(kymoImagesDesc)) : ImageAdjustmentOptions.noAdjustment();
        ImageProcessingResult result = this.loadKymographs(kymoImagesDesc, options);
        return result.isSuccess();
    }

    @Deprecated
    public boolean isRunning_loadImages() {
        return this.isLoadingImages;
    }

    @Deprecated
    public int getImageWidthMax() {
        return this.maxImageWidth;
    }

    @Deprecated
    public int getImageHeightMax() {
        return this.maxImageHeight;
    }

    public Rectangle calculateMaxDimensions(List<ImageFileDescriptor> imageDescriptors) {
        int maxWidth = 0;
        int maxHeight = 0;
        for (ImageFileDescriptor descriptor : imageDescriptors) {
            if (!descriptor.exists) continue;
            try {
                this.updateImageDimensions(descriptor);
                maxWidth = Math.max(maxWidth, descriptor.imageWidth);
                maxHeight = Math.max(maxHeight, descriptor.imageHeight);
            }
            catch (Exception e) {
                LOGGER.log(Level.WARNING, "Failed to get dimensions for: " + descriptor.fileName, e);
            }
        }
        this.maxImageWidth = maxWidth;
        this.maxImageHeight = maxHeight;
        return new Rectangle(0, 0, maxWidth, maxHeight);
    }

    private void updateImageDimensions(ImageFileDescriptor descriptor) throws Exception {
        try {
            OMEXMLMetadata metadata = Loader.getOMEXMLMetaData((String)descriptor.fileName);
            descriptor.imageWidth = MetaDataUtil.getSizeX((OMEXMLMetadata)metadata, (int)0);
            descriptor.imageHeight = MetaDataUtil.getSizeY((OMEXMLMetadata)metadata, (int)0);
        }
        catch (UnsupportedFormatException | IOException | InterruptedException e) {
            throw new Exception("Failed to get image dimensions for: " + descriptor.fileName, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ImageProcessingResult adjustImageSizes(List<ImageFileDescriptor> imageDescriptors, Rectangle targetDimensions, ImageAdjustmentOptions options) {
        if (!options.isAdjustSize()) {
            return ImageProcessingResult.success(0, "Size adjustment disabled");
        }
        long startTime = System.currentTimeMillis();
        int processed = 0;
        int failed = 0;
        ArrayList<String> failedFiles = new ArrayList<String>();
        ProgressFrame progress = null;
        if (options.isShowProgress()) {
            progress = new ProgressFrame(options.getProgressMessage());
            progress.setLength((double)imageDescriptors.size());
        }
        try {
            for (ImageFileDescriptor descriptor : imageDescriptors) {
                if (!descriptor.exists) continue;
                if (progress != null) {
                    progress.setMessage("Adjusting: " + descriptor.fileName);
                }
                try {
                    if (descriptor.imageWidth == targetDimensions.width && descriptor.imageHeight == targetDimensions.height) {
                        ++processed;
                        continue;
                    }
                    this.adjustSingleImage(descriptor, targetDimensions);
                    ++processed;
                }
                catch (Exception e) {
                    LOGGER.log(Level.WARNING, "Failed to adjust image: " + descriptor.fileName, e);
                    ++failed;
                    failedFiles.add(descriptor.fileName);
                }
                if (progress == null) continue;
                progress.incPosition();
            }
            long processingTime = System.currentTimeMillis() - startTime;
            ImageProcessingResult imageProcessingResult = ImageProcessingResult.builder().success(failed == 0).processedCount(processed).failedCount(failed).failedFiles(failedFiles).processingTimeMs(processingTime).message(String.format("Adjusted %d images, %d failed", processed, failed)).build();
            return imageProcessingResult;
        }
        finally {
            if (progress != null) {
                progress.close();
            }
        }
    }

    private void adjustSingleImage(ImageFileDescriptor descriptor, Rectangle targetDimensions) throws Exception {
        try {
            IcyBufferedImage sourceImage = Loader.loadImage((String)descriptor.fileName);
            IcyBufferedImage targetImage = new IcyBufferedImage(targetDimensions.width, targetDimensions.height, sourceImage.getSizeC(), sourceImage.getDataType_());
            this.transferImageData(sourceImage, targetImage);
            Saver.saveImage((IcyBufferedImage)targetImage, (File)new File(descriptor.fileName), (boolean)true);
        }
        catch (UnsupportedFormatException | IOException | InterruptedException | FormatException e) {
            throw new Exception("Failed to adjust image: " + descriptor.fileName, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void transferImageData(IcyBufferedImage source, IcyBufferedImage destination) {
        int sourceHeight = source.getSizeY();
        int channelCount = source.getSizeC();
        int sourceWidth = source.getSizeX();
        int destinationWidth = destination.getSizeX();
        DataType dataType = source.getDataType_();
        boolean signed = dataType.isSigned();
        destination.lockRaster();
        try {
            for (int channel = 0; channel < channelCount; ++channel) {
                Object sourceData = source.getDataXY(channel);
                Object destinationData = destination.getDataXY(channel);
                int sourceOffset = 0;
                int destinationOffset = 0;
                for (int y = 0; y < sourceHeight; ++y) {
                    Array1DUtil.arrayToArray((Object)sourceData, (int)sourceOffset, (Object)destinationData, (int)destinationOffset, (int)sourceWidth, (boolean)signed);
                    destination.setDataXY(channel, destinationData);
                    sourceOffset += sourceWidth;
                    destinationOffset += destinationWidth;
                }
            }
        }
        finally {
            destination.releaseRaster(true);
        }
        destination.dataChanged();
    }

    private List<String> extractValidImageFiles(List<ImageFileDescriptor> descriptors) {
        ArrayList<String> validFiles = new ArrayList<String>();
        for (ImageFileDescriptor descriptor : descriptors) {
            if (!descriptor.exists) continue;
            validFiles.add(descriptor.fileName);
        }
        return validFiles;
    }

    private int countValidImages(List<String> imageNames) {
        int count = 0;
        for (String imageName : imageNames) {
            if (!new File(imageName).exists()) continue;
            ++count;
        }
        return count;
    }

    private int countInvalidImages(List<String> imageNames) {
        return imageNames.size() - this.countValidImages(imageNames);
    }

    private void setSequenceNameFromFirstImage(List<String> imageFiles) {
        if (imageFiles.isEmpty()) {
            return;
        }
        try {
            Path imagePath = Paths.get(imageFiles.get(0), new String[0]);
            if (imagePath.getNameCount() >= 2) {
                String sequenceName = imagePath.getName(imagePath.getNameCount() - 2).toString();
                this.getSequence().setName(sequenceName);
            }
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, "Failed to set sequence name from first image", e);
        }
    }

    @Deprecated
    protected void setParentDirectoryAsCSCamFileName(String filename) {
        if (filename != null) {
            this.setSequenceNameFromFirstImage(List.of(filename));
        }
    }

    @Deprecated
    Rectangle getMaxSizeofTiffFiles(List<ImageFileDescriptor> files) {
        return this.calculateMaxDimensions(files);
    }

    @Deprecated
    boolean getImageDim(ImageFileDescriptor fileProp) {
        try {
            this.updateImageDimensions(fileProp);
            return true;
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, "Failed to get image dimensions", e);
            return false;
        }
    }

    @Deprecated
    void adjustImagesToMaxSize(List<ImageFileDescriptor> files, Rectangle rect) {
        ImageAdjustmentOptions options = ImageAdjustmentOptions.withSizeAdjustment(rect);
        this.adjustImageSizes(files, rect, options);
    }

    public static class Builder {
        private String name;
        private IcyBufferedImage image;
        private List<String> imageNames;
        private KymographConfiguration configuration = KymographConfiguration.defaultConfiguration();

        public Builder withName(String name) {
            this.name = name;
            return this;
        }

        public Builder withImage(IcyBufferedImage image) {
            this.image = image;
            return this;
        }

        public Builder withImageList(List<String> imageNames) {
            this.imageNames = imageNames;
            return this;
        }

        public Builder withConfiguration(KymographConfiguration configuration) {
            this.configuration = configuration;
            return this;
        }

        public SequenceKymos build() {
            SequenceKymos sequence = this.name != null && this.image != null ? new SequenceKymos(this.name, this.image) : (this.imageNames != null && !this.imageNames.isEmpty() ? new SequenceKymos(this.imageNames) : new SequenceKymos());
            sequence.updateConfiguration(this.configuration);
            return sequence;
        }
    }
}

