/*
 * Decompiled with CFR 0.152.
 */
package plugins.fmp.multiSPOTS96.experiment.spots;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import plugins.fmp.multiSPOTS96.experiment.spots.SpotLevel2D;

public class SpotMeasure {
    private static final double DEFAULT_FACTOR = 1.0;
    private double[] values;
    private double[] valuesNormalized;
    private int[] isPresent;
    private double factor;
    private int measuredFromNSpots = 1;
    private String name;
    private SpotLevel2D spotLevel2D = null;

    public SpotMeasure(String name) {
        this.name = Objects.requireNonNull(name, "Name cannot be null");
        this.factor = 1.0;
        this.spotLevel2D = new SpotLevel2D(name);
    }

    public void copyMeasures(SpotMeasure source) {
        if (source == null) {
            return;
        }
        if (source.values != null && source.values.length > 0) {
            this.values = Arrays.copyOf(source.values, source.values.length);
        }
        if (source.isPresent != null && source.isPresent.length > 0) {
            this.isPresent = Arrays.copyOf(source.isPresent, source.isPresent.length);
        }
    }

    public void addMeasures(SpotMeasure source) {
        if (source == null) {
            return;
        }
        if (source.values != null && source.values.length > 0) {
            this.addValues(source.values);
        }
        if (source.isPresent != null && source.isPresent.length > 0) {
            this.addPresence(source.isPresent);
        }
        ++this.measuredFromNSpots;
    }

    public void computePI(SpotMeasure measure1, int n1, SpotMeasure measure2, int n2) {
        if (measure1 == null || measure2 == null) {
            return;
        }
        if (measure1.values != null && measure1.values.length > 0 && measure2.values != null && measure2.values.length > 0) {
            this.values = new double[measure1.valuesNormalized.length];
            for (int i = 0; i < measure1.valuesNormalized.length; ++i) {
                double value1 = measure1.valuesNormalized[i] / (double)n1;
                double value2 = measure2.valuesNormalized[i] / (double)n2;
                double sum = value1 + value2;
                this.values[i] = sum > 0.0 ? (value1 - value2) / sum : 0.0;
            }
        }
    }

    public void computeSUM(SpotMeasure measure1, int n1, SpotMeasure measure2, int n2) {
        if (measure1 == null || measure2 == null) {
            return;
        }
        if (measure1.values != null && measure1.values.length > 0 && measure2.values != null && measure2.values.length > 0) {
            this.values = new double[measure1.values.length];
            for (int i = 0; i < measure1.values.length; ++i) {
                this.values[i] = measure1.values[i] / (double)n1 + measure2.values[i] / (double)n2;
            }
        }
    }

    public double getMaximumValue() {
        double maximum = 0.0;
        for (int i = 0; i < this.values.length; ++i) {
            if (!(this.values[i] > maximum)) continue;
            maximum = this.values[i];
        }
        return maximum;
    }

    public void normalizeValuesTo(double norm) {
        for (int i = 0; i < this.values.length; ++i) {
            this.values[i] = this.values[i] / norm;
        }
    }

    public void normalizeValues() {
        double maximum = this.getMaximumValue();
        this.normalizeValuesTo(maximum);
    }

    public void combineIsPresent(SpotMeasure measure1, int n1, SpotMeasure measure2, int n2) {
        if (measure1 == null || measure2 == null) {
            return;
        }
        if (this.isPresent != null && measure1.isPresent != null && measure2.isPresent != null) {
            if (this.isPresent.length != measure1.isPresent.length) {
                this.isPresent = new int[measure1.isPresent.length];
            }
            for (int i = 0; i < this.isPresent.length; ++i) {
                this.isPresent[i] = measure1.isPresent[i] + measure2.isPresent[i];
            }
        }
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = Objects.requireNonNull(name, "Name cannot be null");
    }

    public int getCount() {
        if (this.values == null) {
            return 0;
        }
        return this.values.length;
    }

    public double[] getValues() {
        return this.values;
    }

    public void setValues(double[] values) {
        this.values = values;
    }

    public void setValueAt(int index, double value) {
        if (this.values != null && index >= 0 && index < this.values.length) {
            this.values[index] = value;
        }
    }

    public double getValueAt(int index) {
        return this.values[index];
    }

    public int[] getIsPresent() {
        return this.isPresent;
    }

    public void setIsPresent(int[] isPresent) {
        this.isPresent = isPresent;
    }

    public int getIsPresentAt(int index) {
        return this.isPresent[index];
    }

    public void setIsPresentAt(int index, int value) {
        if (this.isPresent != null && index >= 0 && index < this.isPresent.length) {
            this.isPresent[index] = value;
        }
    }

    public double getFactor() {
        return this.factor;
    }

    public void setFactor(double factor) {
        this.factor = factor;
    }

    public int getMeasuredFromNSpots() {
        return this.measuredFromNSpots;
    }

    public void setMeasuredFromNSpots(int n) {
        this.measuredFromNSpots = n;
    }

    public SpotLevel2D getSpotLevel2D() {
        return this.spotLevel2D;
    }

    public void transferValuesToLevel2D() {
        this.spotLevel2D.transferValues(this.values);
    }

    public void transferIsPresentToLevel2D() {
        this.spotLevel2D.transferIsPresent(this.isPresent);
    }

    public boolean exportYDataToCsv(StringBuilder sbf, String separator) {
        this.transferValuesToLevel2D();
        return this.spotLevel2D.exportYDataToCsv(sbf, separator);
    }

    public boolean importXYDataFromCsv(String[] data, int startAt) {
        boolean flag = this.spotLevel2D.importXYDataFromCsv(data, startAt);
        if (flag) {
            this.values = this.spotLevel2D.transferLevel2DToValues();
        }
        return flag;
    }

    public boolean importYDataFromCsv(String[] data, int startAt) {
        boolean flag = this.spotLevel2D.importYDataFromCsv(data, startAt);
        if (flag) {
            this.values = this.spotLevel2D.transferLevel2DToValues();
        }
        return flag;
    }

    private void addValues(double[] sourceValues) {
        if (this.values == null) {
            this.values = new double[sourceValues.length];
        }
        for (int i = 0; i < sourceValues.length; ++i) {
            int n = i;
            this.values[n] = this.values[n] + sourceValues[i];
        }
    }

    private void addPresence(int[] sourcePresence) {
        if (this.isPresent == null) {
            this.isPresent = new int[sourcePresence.length];
        }
        for (int i = 0; i < sourcePresence.length; ++i) {
            int n = i;
            this.isPresent[n] = this.isPresent[n] + sourcePresence[i];
        }
    }

    public List<Double> getValuesAsSubsampledList(long seriesBinMs, long outputBinMs) {
        if (this.values == null || this.values.length == 0) {
            return new ArrayList<Double>();
        }
        long maxMs = (long)(this.values.length - 1) * seriesBinMs;
        long npoints = maxMs / outputBinMs + 1L;
        ArrayList<Double> result = new ArrayList<Double>();
        for (long i = 0L; i < npoints; ++i) {
            long timeMs = i * outputBinMs;
            int index = (int)(timeMs / seriesBinMs);
            if (index < this.values.length) {
                result.add(this.values[index]);
                continue;
            }
            result.add(0.0);
        }
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        SpotMeasure other = (SpotMeasure)obj;
        return Objects.equals(this.name, other.name) && Double.compare(this.factor, other.factor) == 0 && Arrays.equals(this.values, other.values) && Arrays.equals(this.isPresent, other.isPresent);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.factor, Arrays.hashCode(this.values), Arrays.hashCode(this.isPresent));
    }

    public String toString() {
        return String.format("SpotMeasure{name='%s', factor=%.2f, hasValues=%b, hasPresence=%b}", this.name, this.factor, this.values != null, this.isPresent != null);
    }

    public void buildRunningMedianFromValuesArray(int span, double[] yvalues) {
        if (yvalues == null || yvalues.length == 0) {
            return;
        }
        int npoints = yvalues.length;
        for (int i = 0; i < npoints; ++i) {
            int start = Math.max(0, i - span / 2);
            int end = Math.min(npoints - 1, i + span / 2);
            int count = end - start + 1;
            double[] window = new double[count];
            for (int j = 0; j < count; ++j) {
                window[j] = yvalues[start + j];
            }
            Arrays.sort(window);
            this.values[i] = window[count / 2];
        }
    }
}

