/*
 * Decompiled with CFR 0.152.
 */
package plugins.fmp.multiSPOTS96.experiment.spots;

import icy.util.XMLUtil;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import plugins.fmp.multiSPOTS96.experiment.spots.SpotString;

public class SpotProperties {
    private static final String IDS_SPOTPROPS = "spotProperties";
    private static final String ID_DESCOK = "descriptionOK";
    private static final String ID_VERSIONINFOS = "versionInfos";
    private static final String ID_SPOTVOLUME = "volume";
    private static final String ID_PIXELS = "pixels";
    private static final String ID_RADIUS = "radius";
    private static final String ID_XCOORD = "spotXCoord";
    private static final String ID_YCOORD = "spotYCoord";
    private static final String ID_SPOTSTIMULUS = "stimulus";
    private static final String ID_CONCENTRATION = "concentration";
    private static final String ID_CAGEID = "cageID";
    private static final String ID_CAGEPOSITION = "cagePosition";
    private static final String ID_CAGECOLUMN = "cageColumn";
    private static final String ID_CAGEROW = "cageRow";
    private static final String ID_SPOTARRAYINDEX = "spotArrayIndex";
    private static final String ID_COLOR_R = "spotColor_R";
    private static final String ID_COLOR_G = "spotColor_G";
    private static final String ID_COLOR_B = "spotColor_B";
    private static final String DEFAULT_STIMULUS = "..";
    private static final String DEFAULT_CONCENTRATION = "..";
    private static final double DEFAULT_SPOT_VOLUME = 0.5;
    private static final int DEFAULT_SPOT_N_PIXELS = 1;
    private static final int DEFAULT_SPOT_RADIUS = 30;
    private static final int DEFAULT_SPOT_X_COORD = -1;
    private static final int DEFAULT_SPOT_Y_COORD = -1;
    private static final Color DEFAULT_COLOR = Color.GREEN;
    private static final int DEFAULT_VERSION = 1;
    private static final int DEFAULT_VERSION_INFOS = 0;
    private int version;
    private String name;
    private int cageID;
    private int cagePosition;
    private int cageRow;
    private int cageColumn;
    private int spotArrayIndex;
    private Color color;
    private String stimulus;
    private String concentration;
    private String stimulusI;
    private double spotVolume;
    private int spotNPixels;
    private int countAggregatedSpots;
    private int spotRadius;
    private int spotXCoord;
    private int spotYCoord;
    private boolean descriptionOK;
    private int versionInfos;

    public SpotProperties() {
        this.version = 1;
        this.stimulus = "..";
        this.concentration = "..";
        this.stimulusI = "..";
        this.spotVolume = 0.5;
        this.spotNPixels = 1;
        this.spotRadius = 30;
        this.spotXCoord = -1;
        this.spotYCoord = -1;
        this.countAggregatedSpots = 1;
        this.color = DEFAULT_COLOR;
        this.cageID = -1;
        this.cagePosition = 0;
        this.cageRow = -1;
        this.cageColumn = -1;
        this.spotArrayIndex = -1;
        this.descriptionOK = false;
        this.versionInfos = 0;
    }

    public SpotProperties(SpotProperties source) {
        Objects.requireNonNull(source, "Source properties cannot be null");
        this.copyFrom(source);
    }

    public void copyFrom(SpotProperties source) {
        Objects.requireNonNull(source, "Source properties cannot be null");
        this.version = source.version;
        this.name = source.name;
        this.cageID = source.cageID;
        this.cagePosition = source.cagePosition;
        this.cageRow = source.cageRow;
        this.cageColumn = source.cageColumn;
        this.spotArrayIndex = source.spotArrayIndex;
        this.color = source.color;
        this.stimulus = source.stimulus;
        this.concentration = source.concentration;
        this.stimulusI = source.stimulusI;
        this.spotVolume = source.spotVolume;
        this.spotNPixels = source.spotNPixels;
        this.spotRadius = source.spotRadius;
        this.spotXCoord = source.spotXCoord;
        this.spotYCoord = source.spotYCoord;
        this.countAggregatedSpots = source.countAggregatedSpots;
        this.descriptionOK = source.descriptionOK;
        this.versionInfos = source.versionInfos;
    }

    public boolean hasChanged(SpotProperties other) {
        if (other == null) {
            return true;
        }
        return !Objects.equals(this.name, other.name) || this.cageID != other.cageID || this.cagePosition != other.cagePosition || this.cageRow != other.cageRow || this.cageColumn != other.cageColumn || this.spotArrayIndex != other.spotArrayIndex || !Objects.equals(this.color, other.color) || !Objects.equals(this.stimulus, other.stimulus) || !Objects.equals(this.concentration, other.concentration) || !Objects.equals(this.stimulusI, other.stimulusI) || Double.compare(this.spotVolume, other.spotVolume) != 0 || this.spotNPixels != other.spotNPixels || this.spotRadius != other.spotRadius || this.spotXCoord != other.spotXCoord || this.countAggregatedSpots != other.countAggregatedSpots || this.spotYCoord != other.spotYCoord || this.descriptionOK != other.descriptionOK || this.versionInfos != other.versionInfos;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String sourceName) {
        this.name = sourceName;
    }

    public int getCageID() {
        return this.cageID;
    }

    public void setCageID(int cageID) {
        this.cageID = cageID;
    }

    public int getCagePosition() {
        return this.cagePosition;
    }

    public void setCagePosition(int cagePosition) {
        this.cagePosition = cagePosition;
    }

    public int getCageRow() {
        return this.cageRow;
    }

    public void setCageRow(int cageRow) {
        this.cageRow = cageRow;
    }

    public int getCageColumn() {
        return this.cageColumn;
    }

    public void setCageColumn(int cageColumn) {
        this.cageColumn = cageColumn;
    }

    public int getSpotArrayIndex() {
        return this.spotArrayIndex;
    }

    public void setSpotArrayIndex(int spotArrayIndex) {
        this.spotArrayIndex = spotArrayIndex;
    }

    public Color getColor() {
        return this.color;
    }

    public void setColor(Color color) {
        this.color = Objects.requireNonNull(color, "Color cannot be null");
    }

    public String getStimulus() {
        return this.stimulus;
    }

    public void setStimulus(String stimulus) {
        this.stimulus = Objects.requireNonNull(stimulus, "Stimulus cannot be null");
    }

    public String getConcentration() {
        return this.concentration;
    }

    public void setConcentration(String concentration) {
        this.concentration = Objects.requireNonNull(concentration, "Concentration cannot be null");
    }

    public String getStimulusI() {
        return this.stimulusI;
    }

    public void setStimulusI(String stimulusI) {
        this.stimulusI = Objects.requireNonNull(stimulusI, "Stimulus I cannot be null");
    }

    public double getSpotVolume() {
        return this.spotVolume;
    }

    public void setSpotVolume(double spotVolume) {
        this.spotVolume = spotVolume;
    }

    public int getSpotNPixels() {
        return this.spotNPixels;
    }

    public void setSpotNPixels(int spotNPixels) {
        this.spotNPixels = spotNPixels;
    }

    public int getSpotRadius() {
        return this.spotRadius;
    }

    public void setSpotRadius(int spotRadius) {
        this.spotRadius = spotRadius;
    }

    public int getSpotXCoord() {
        return this.spotXCoord;
    }

    public void setSpotXCoord(int spotXCoord) {
        this.spotXCoord = spotXCoord;
    }

    public int getSpotYCoord() {
        return this.spotYCoord;
    }

    public void setSpotYCoord(int spotYCoord) {
        this.spotYCoord = spotYCoord;
    }

    public int getCountAggregatedSpots() {
        return this.countAggregatedSpots;
    }

    public void setCountAggregatedSpots(int spotsCombined) {
        this.countAggregatedSpots = spotsCombined;
    }

    public boolean isDescriptionOK() {
        return this.descriptionOK;
    }

    public void setDescriptionOK(boolean descriptionOK) {
        this.descriptionOK = descriptionOK;
    }

    public int getVersion() {
        return this.version;
    }

    public void setVersion(int version) {
        this.version = version;
    }

    public int getVersionInfos() {
        return this.versionInfos;
    }

    public void setVersionInfos(int versionInfos) {
        this.versionInfos = versionInfos;
    }

    public boolean isValid() {
        return this.name != null && !this.name.trim().isEmpty() && this.cageID >= -1 && this.cagePosition >= 0 && this.cageRow >= -1 && this.cageColumn >= -1 && this.spotArrayIndex >= -1 && this.color != null && this.stimulus != null && !this.stimulus.trim().isEmpty() && this.concentration != null && !this.concentration.trim().isEmpty() && this.stimulusI != null && !this.stimulusI.trim().isEmpty() && this.spotVolume > 0.0 && this.spotNPixels > 0 && this.spotRadius > 0;
    }

    public List<String> getValidationErrors() {
        ArrayList<String> errors = new ArrayList<String>();
        if (this.name == null || this.name.trim().isEmpty()) {
            errors.add("Source name is required");
        }
        if (this.cageID < -1) {
            errors.add("Cage ID must be >= -1");
        }
        if (this.cagePosition < 0) {
            errors.add("Cage position must be >= 0");
        }
        if (this.cageRow < -1) {
            errors.add("Cage row must be >= -1");
        }
        if (this.cageColumn < -1) {
            errors.add("Cage column must be >= -1");
        }
        if (this.spotArrayIndex < -1) {
            errors.add("Spot array index must be >= -1");
        }
        if (this.color == null) {
            errors.add("Color is required");
        }
        if (this.stimulus == null || this.stimulus.trim().isEmpty()) {
            errors.add("Stimulus is required");
        }
        if (this.concentration == null || this.concentration.trim().isEmpty()) {
            errors.add("Concentration is required");
        }
        if (this.stimulusI == null || this.stimulusI.trim().isEmpty()) {
            errors.add("Stimulus I is required");
        }
        if (this.spotVolume <= 0.0) {
            errors.add("Spot volume must be > 0");
        }
        if (this.spotNPixels <= 0) {
            errors.add("Spot number of pixels must be > 0");
        }
        if (this.spotRadius <= 0) {
            errors.add("Spot radius must be > 0");
        }
        return errors;
    }

    public boolean saveSpotDescriptionToXml(Node node) {
        Element propertiesNode = XMLUtil.addElement((Node)node, (String)IDS_SPOTPROPS);
        if (propertiesNode == null) {
            return false;
        }
        XMLUtil.setElementIntValue((Node)propertiesNode, (String)"version", (int)1);
        return true;
    }

    public boolean loadSpotDescriptionFromXml(Document doc) {
        if (doc == null) {
            return false;
        }
        Element node = XMLUtil.getElement((Node)XMLUtil.getRootElement((Document)doc), (String)IDS_SPOTPROPS);
        if (node == null) {
            return false;
        }
        this.version = XMLUtil.getElementIntValue((Node)node, (String)"version", (int)1);
        return this.loadFromXml(node);
    }

    public boolean loadFromXml(Node node) {
        Element nodeParameters = XMLUtil.getElement((Node)node, (String)IDS_SPOTPROPS);
        if (nodeParameters == null) {
            return false;
        }
        try {
            this.spotArrayIndex = XMLUtil.getElementIntValue((Node)nodeParameters, (String)ID_SPOTARRAYINDEX, (int)this.spotArrayIndex);
            this.cageID = XMLUtil.getElementIntValue((Node)nodeParameters, (String)ID_CAGEID, (int)this.cageID);
            this.cagePosition = XMLUtil.getElementIntValue((Node)nodeParameters, (String)ID_CAGEPOSITION, (int)this.cagePosition);
            this.cageColumn = XMLUtil.getElementIntValue((Node)nodeParameters, (String)ID_CAGECOLUMN, (int)this.cageColumn);
            this.cageRow = XMLUtil.getElementIntValue((Node)nodeParameters, (String)ID_CAGEROW, (int)this.cageRow);
            this.descriptionOK = XMLUtil.getElementBooleanValue((Node)nodeParameters, (String)ID_DESCOK, (boolean)false);
            this.spotVolume = XMLUtil.getElementDoubleValue((Node)nodeParameters, (String)ID_SPOTVOLUME, (double)Double.NaN);
            this.spotNPixels = XMLUtil.getElementIntValue((Node)nodeParameters, (String)ID_PIXELS, (int)1);
            this.spotRadius = XMLUtil.getElementIntValue((Node)nodeParameters, (String)ID_RADIUS, (int)30);
            this.spotXCoord = XMLUtil.getElementIntValue((Node)nodeParameters, (String)ID_XCOORD, (int)-1);
            this.spotYCoord = XMLUtil.getElementIntValue((Node)nodeParameters, (String)ID_YCOORD, (int)-1);
            this.stimulus = XMLUtil.getElementValue((Node)nodeParameters, (String)ID_SPOTSTIMULUS, (String)"..");
            this.concentration = XMLUtil.getElementValue((Node)nodeParameters, (String)ID_CONCENTRATION, (String)"..");
            int r = XMLUtil.getElementIntValue((Node)nodeParameters, (String)ID_COLOR_R, (int)this.color.getRed());
            int g = XMLUtil.getElementIntValue((Node)nodeParameters, (String)ID_COLOR_G, (int)this.color.getGreen());
            int b = XMLUtil.getElementIntValue((Node)nodeParameters, (String)ID_COLOR_B, (int)this.color.getBlue());
            this.color = new Color(r, g, b);
            return true;
        }
        catch (Exception e) {
            System.err.println("Error loading properties from XML: " + e.getMessage());
            return false;
        }
    }

    public boolean saveToXml(Node node) {
        Element nodeParameters = XMLUtil.setElement((Node)node, (String)IDS_SPOTPROPS);
        if (nodeParameters == null) {
            return false;
        }
        try {
            XMLUtil.setElementIntValue((Node)nodeParameters, (String)ID_SPOTARRAYINDEX, (int)this.spotArrayIndex);
            XMLUtil.setElementIntValue((Node)nodeParameters, (String)ID_CAGEID, (int)this.cageID);
            XMLUtil.setElementIntValue((Node)nodeParameters, (String)ID_CAGEPOSITION, (int)this.cagePosition);
            XMLUtil.setElementIntValue((Node)nodeParameters, (String)ID_CAGECOLUMN, (int)this.cageColumn);
            XMLUtil.setElementIntValue((Node)nodeParameters, (String)ID_CAGEROW, (int)this.cageRow);
            XMLUtil.setElementIntValue((Node)nodeParameters, (String)ID_VERSIONINFOS, (int)this.versionInfos);
            XMLUtil.setElementBooleanValue((Node)nodeParameters, (String)ID_DESCOK, (boolean)this.descriptionOK);
            XMLUtil.setElementDoubleValue((Node)nodeParameters, (String)ID_SPOTVOLUME, (double)this.spotVolume);
            XMLUtil.setElementIntValue((Node)nodeParameters, (String)ID_PIXELS, (int)this.spotNPixels);
            XMLUtil.setElementIntValue((Node)nodeParameters, (String)ID_RADIUS, (int)this.spotRadius);
            XMLUtil.setElementIntValue((Node)nodeParameters, (String)ID_XCOORD, (int)this.spotXCoord);
            XMLUtil.setElementIntValue((Node)nodeParameters, (String)ID_YCOORD, (int)this.spotYCoord);
            XMLUtil.setElementValue((Node)nodeParameters, (String)ID_SPOTSTIMULUS, (String)this.stimulus);
            XMLUtil.setElementValue((Node)nodeParameters, (String)ID_CONCENTRATION, (String)this.concentration);
            XMLUtil.setElementIntValue((Node)nodeParameters, (String)ID_COLOR_R, (int)this.color.getRed());
            XMLUtil.setElementIntValue((Node)nodeParameters, (String)ID_COLOR_G, (int)this.color.getGreen());
            XMLUtil.setElementIntValue((Node)nodeParameters, (String)ID_COLOR_B, (int)this.color.getBlue());
            return true;
        }
        catch (Exception e) {
            System.err.println("Error saving properties to XML: " + e.getMessage());
            return false;
        }
    }

    public void importFromCsv(String[] data) {
        Objects.requireNonNull(data, "CSV data cannot be null");
        if (data.length < 6) {
            throw new IllegalArgumentException("CSV data must have at least 6 elements");
        }
        try {
            int index = 0;
            this.name = data[index++];
            this.spotArrayIndex = Integer.parseInt(data[index++]);
            this.cageID = Integer.parseInt(data[index++]);
            if (this.cageID < 0) {
                this.cageID = SpotString.getCageIDFromSpotName(this.name);
            }
            this.cagePosition = Integer.parseInt(data[index++]);
            if (data.length >= 11) {
                this.cageColumn = Integer.parseInt(data[index++]);
                this.cageRow = Integer.parseInt(data[index++]);
            }
            if (data.length == 10) {
                this.spotRadius = Integer.parseInt(data[index++]);
            }
            this.spotVolume = Double.parseDouble(data[index++]);
            this.spotNPixels = Integer.parseInt(data[index++]);
            this.spotRadius = Integer.parseInt(data[index++]);
            this.stimulus = data[index++];
            this.concentration = data[index++];
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("Invalid numeric value in CSV data", e);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new IllegalArgumentException("Insufficient data in CSV array", e);
        }
    }

    public static String exportHeaderToCsv(String csvSeparator) {
        Objects.requireNonNull(csvSeparator, "CSV separator cannot be null");
        StringBuilder sbf = new StringBuilder();
        sbf.append("#").append(csvSeparator).append("#\n");
        sbf.append("#").append(csvSeparator).append("SPOTS").append(csvSeparator).append("multiSPOTS96 data\n");
        List<String> row2 = Arrays.asList("name", "index", ID_CAGEID, "cagePos", ID_CAGECOLUMN, ID_CAGEROW, ID_SPOTVOLUME, "npixels", ID_RADIUS, "stim", "conc");
        sbf.append(String.join((CharSequence)csvSeparator, row2));
        sbf.append("\n");
        return sbf.toString();
    }

    public String exportToCsv(String csvSeparator) {
        Objects.requireNonNull(csvSeparator, "CSV separator cannot be null");
        StringBuilder sbf = new StringBuilder();
        List<String> row = Arrays.asList(this.name != null ? this.name : "", String.valueOf(this.spotArrayIndex), String.valueOf(this.cageID), String.valueOf(this.cagePosition), String.valueOf(this.cageColumn), String.valueOf(this.cageRow), String.valueOf(this.spotVolume), String.valueOf(this.spotNPixels), String.valueOf(this.spotRadius), this.stimulus != null ? this.stimulus.replace(",", ".") : "", this.concentration != null ? this.concentration.replace(",", ".") : "");
        sbf.append(String.join((CharSequence)csvSeparator, row));
        sbf.append("\n");
        return sbf.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        SpotProperties other = (SpotProperties)obj;
        return Objects.equals(this.name, other.name) && this.cageID == other.cageID && this.cagePosition == other.cagePosition && this.cageRow == other.cageRow && this.cageColumn == other.cageColumn && this.spotArrayIndex == other.spotArrayIndex && Objects.equals(this.color, other.color) && Objects.equals(this.stimulus, other.stimulus) && Objects.equals(this.concentration, other.concentration) && Objects.equals(this.stimulusI, other.stimulusI) && Double.compare(this.spotVolume, other.spotVolume) == 0 && this.spotNPixels == other.spotNPixels && this.spotRadius == other.spotRadius && this.spotXCoord == other.spotXCoord && this.spotYCoord == other.spotYCoord && this.descriptionOK == other.descriptionOK && this.versionInfos == other.versionInfos;
    }

    public int hashCode() {
        return Objects.hash(this.name, this.cageID, this.cagePosition, this.cageRow, this.cageColumn, this.spotArrayIndex, this.color, this.stimulus, this.concentration, this.stimulusI, this.spotVolume, this.spotNPixels, this.spotRadius, this.spotXCoord, this.spotYCoord, this.descriptionOK, this.versionInfos);
    }

    public String toString() {
        return String.format("SpotProperties{name='%s', cageID=%d, position=%d, stimulus='%s', concentration='%s', volume=%.2f}", this.name, this.cageID, this.cagePosition, this.stimulus, this.concentration, this.spotVolume);
    }
}

