/*
 * Decompiled with CFR 0.152.
 */
package plugins.fmp.multiSPOTS96.series;

import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import java.lang.management.MemoryUsage;
import plugins.fmp.multiSPOTS96.series.BuildSeriesOptions;

public class BuildSpotsMeasuresMemoryTest {
    private static final MemoryMXBean memoryBean = ManagementFactory.getMemoryMXBean();

    public static void configureForMemoryOptimization(BuildSeriesOptions options, OptimizationLevel level) {
        switch (level) {
            case AGGRESSIVE: {
                options.batchSize = 3;
                options.maxConcurrentTasks = 1;
                options.enableMemoryCleanup = true;
                options.enableGarbageCollection = true;
                options.usePrimitiveArrays = true;
                break;
            }
            case CONSERVATIVE: {
                options.batchSize = 5;
                options.maxConcurrentTasks = 2;
                options.enableMemoryCleanup = true;
                options.enableGarbageCollection = true;
                options.usePrimitiveArrays = true;
                break;
            }
            case BALANCED: {
                options.batchSize = 10;
                options.maxConcurrentTasks = 4;
                options.enableMemoryCleanup = true;
                options.enableGarbageCollection = true;
                options.usePrimitiveArrays = true;
                break;
            }
            case PERFORMANCE: {
                options.batchSize = 20;
                options.maxConcurrentTasks = 8;
                options.enableMemoryCleanup = false;
                options.enableGarbageCollection = false;
                options.usePrimitiveArrays = true;
            }
        }
    }

    public static MemorySnapshot takeSnapshot() {
        return new MemorySnapshot();
    }

    public static MemoryComparison compareMemory(MemorySnapshot before, MemorySnapshot after) {
        return new MemoryComparison(before, after);
    }

    public static void printMemoryStatus(String label) {
        MemorySnapshot snapshot = BuildSpotsMeasuresMemoryTest.takeSnapshot();
        System.out.println(label + ": " + snapshot);
    }

    public static void forceGarbageCollection() {
        System.gc();
        try {
            Thread.sleep(100L);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    public static String getMemoryStats() {
        MemorySnapshot snapshot = BuildSpotsMeasuresMemoryTest.takeSnapshot();
        return String.format("Memory Stats: Heap=%dMB/%dMB (%.1f%%), NonHeap=%dMB", snapshot.getHeapUsedMB(), snapshot.getHeapMaxMB(), snapshot.getHeapUsagePercent(), snapshot.getNonHeapUsedMB());
    }

    public static boolean validateMemoryOptimizations(BuildSeriesOptions options) {
        boolean valid = true;
        if (options.batchSize < 1 || options.batchSize > 100) {
            System.err.println("Warning: batchSize should be between 1 and 100, got: " + options.batchSize);
            valid = false;
        }
        if (options.maxConcurrentTasks < 1 || options.maxConcurrentTasks > 16) {
            System.err.println("Warning: maxConcurrentTasks should be between 1 and 16, got: " + options.maxConcurrentTasks);
            valid = false;
        }
        if (options.batchSize < options.maxConcurrentTasks) {
            System.err.println("Warning: batchSize should be >= maxConcurrentTasks for optimal performance");
            valid = false;
        }
        return valid;
    }

    public static void exampleUsage() {
        System.out.println("=== Memory Optimization Test Example ===");
        MemorySnapshot initial = BuildSpotsMeasuresMemoryTest.takeSnapshot();
        System.out.println("Initial: " + initial);
        BuildSeriesOptions options = new BuildSeriesOptions();
        BuildSpotsMeasuresMemoryTest.configureForMemoryOptimization(options, OptimizationLevel.AGGRESSIVE);
        if (BuildSpotsMeasuresMemoryTest.validateMemoryOptimizations(options)) {
            System.out.println("Configuration validated successfully");
        }
        System.out.println("Simulating processing...");
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        MemorySnapshot final_snapshot = BuildSpotsMeasuresMemoryTest.takeSnapshot();
        MemoryComparison comparison = BuildSpotsMeasuresMemoryTest.compareMemory(initial, final_snapshot);
        System.out.println("Result: " + comparison);
        BuildSpotsMeasuresMemoryTest.forceGarbageCollection();
        MemorySnapshot afterGC = BuildSpotsMeasuresMemoryTest.takeSnapshot();
        System.out.println("After GC: " + afterGC);
    }

    public static enum OptimizationLevel {
        AGGRESSIVE,
        CONSERVATIVE,
        BALANCED,
        PERFORMANCE;

    }

    public static class MemorySnapshot {
        public final long heapUsed;
        public final long heapMax;
        public final long nonHeapUsed;
        public final long timestamp;

        public MemorySnapshot() {
            MemoryUsage heap = memoryBean.getHeapMemoryUsage();
            MemoryUsage nonHeap = memoryBean.getNonHeapMemoryUsage();
            this.heapUsed = heap.getUsed();
            this.heapMax = heap.getMax();
            this.nonHeapUsed = nonHeap.getUsed();
            this.timestamp = System.currentTimeMillis();
        }

        public long getHeapUsedMB() {
            return this.heapUsed / 1024L / 1024L;
        }

        public long getHeapMaxMB() {
            return this.heapMax / 1024L / 1024L;
        }

        public long getNonHeapUsedMB() {
            return this.nonHeapUsed / 1024L / 1024L;
        }

        public double getHeapUsagePercent() {
            return (double)this.heapUsed / (double)this.heapMax * 100.0;
        }

        public String toString() {
            return String.format("Memory: Heap=%dMB/%dMB (%.1f%%), NonHeap=%dMB", this.getHeapUsedMB(), this.getHeapMaxMB(), this.getHeapUsagePercent(), this.getNonHeapUsedMB());
        }
    }

    public static class MemoryComparison {
        public final MemorySnapshot before;
        public final MemorySnapshot after;
        public final long durationMs;

        public MemoryComparison(MemorySnapshot before, MemorySnapshot after) {
            this.before = before;
            this.after = after;
            this.durationMs = after.timestamp - before.timestamp;
        }

        public long getHeapIncreaseMB() {
            return this.after.getHeapUsedMB() - this.before.getHeapUsedMB();
        }

        public long getPeakHeapMB() {
            return Math.max(this.before.getHeapUsedMB(), this.after.getHeapUsedMB());
        }

        public double getHeapIncreasePercent() {
            if (this.before.heapUsed == 0L) {
                return 0.0;
            }
            return (double)(this.after.heapUsed - this.before.heapUsed) / (double)this.before.heapUsed * 100.0;
        }

        public String toString() {
            return String.format("Memory Change: +%dMB (%.1f%%), Peak: %dMB, Duration: %dms", this.getHeapIncreaseMB(), this.getHeapIncreasePercent(), this.getPeakHeapMB(), this.durationMs);
        }
    }
}

