/*
 * Decompiled with CFR 0.152.
 */
package plugins.fmp.multiSPOTS96.series;

import icy.gui.frame.progress.ProgressFrame;
import icy.image.IcyBufferedImage;
import icy.roi.BooleanMask2D;
import icy.sequence.Sequence;
import icy.system.thread.Processor;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.stream.Collectors;
import plugins.fmp.multiSPOTS96.experiment.Experiment;
import plugins.fmp.multiSPOTS96.experiment.cages.Cage;
import plugins.fmp.multiSPOTS96.experiment.spots.Spot;
import plugins.fmp.multiSPOTS96.experiment.spots.SpotsArray;
import plugins.fmp.multiSPOTS96.series.BuildSeriesOptions;
import plugins.kernel.roi.roi2d.ROI2DArea;
import plugins.kernel.roi.roi2d.ROI2DPolygon;
import plugins.kernel.roi.roi2d.ROI2DShape;

public class DetectSpotsTools {
    BooleanMask2D[] findBlobs(ROI2DArea binarizedImageRoi, BooleanMask2D cageMask) throws InterruptedException {
        if (cageMask == null) {
            return null;
        }
        ROI2DArea roi = new ROI2DArea(binarizedImageRoi.getBooleanMask(true).getIntersection(cageMask));
        BooleanMask2D roiBooleanMask = roi.getBooleanMask(true);
        return roiBooleanMask.getComponents();
    }

    public ROI2DArea binarizeImage(IcyBufferedImage img, BuildSeriesOptions options) {
        if (img == null) {
            return null;
        }
        boolean[] mask = new boolean[img.getSizeX() * img.getSizeY()];
        if (options.btrackWhite) {
            byte[] arrayRed = img.getDataXYAsByte(0);
            byte[] arrayGreen = img.getDataXYAsByte(1);
            byte[] arrayBlue = img.getDataXYAsByte(2);
            for (int i = 0; i < arrayRed.length; ++i) {
                float r = arrayRed[i] & 0xFF;
                float g = arrayGreen[i] & 0xFF;
                float b = arrayBlue[i] & 0xFF;
                float intensity = (r + g + b) / 3.0f;
                mask[i] = intensity > (float)options.threshold;
            }
        } else {
            byte[] arrayChan = img.getDataXYAsByte(options.videoChannel);
            for (int i = 0; i < arrayChan.length; ++i) {
                mask[i] = (arrayChan[i] & 0xFF) < options.threshold;
            }
        }
        BooleanMask2D bmask = new BooleanMask2D(img.getBounds(), mask);
        return new ROI2DArea(bmask);
    }

    public void findSpots(Experiment exp, Sequence seqNegative, BuildSeriesOptions options, IcyBufferedImage workimage) throws InterruptedException {
        exp.cagesArray.computeBooleanMasksForCages();
        ROI2DArea binarizedImageRoi = this.binarizeImage(workimage, options);
        for (Cage cage : exp.cagesArray.cagesList) {
            if (!options.selectedIndexes.contains(cage.getProperties().getCageID())) continue;
            cage.spotsArray = new SpotsArray();
            int spotID = 0;
            try {
                BooleanMask2D[] blobs = this.findBlobs(binarizedImageRoi, cage.cageMask2D);
                if (blobs == null) {
                    System.out.println("no blobs found for cage " + cage.getRoi().getName());
                    continue;
                }
                System.out.println(cage.getRoi().getName() + " n blobs=" + blobs.length);
                for (int i = 0; i < blobs.length; ++i) {
                    int npoints = blobs[i].getNumberOfPoints();
                    if (npoints < 2) continue;
                    try {
                        List points = blobs[i].getConnectedContourPoints();
                        if (points == null) continue;
                        List points2s = points.stream().map(point -> new Point2D.Double(point.getX(), point.getY())).collect(Collectors.toList());
                        ROI2DPolygon roi = new ROI2DPolygon(points2s);
                        Spot spot = new Spot((ROI2DShape)roi);
                        spot.setName(cage.getProperties().getCageID(), spotID);
                        spot.getProperties().setCageID(cage.getProperties().getCageID());
                        cage.spotsArray.addSpot(spot);
                        ++spotID;
                        continue;
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }

    protected void waitDetectCompletion(Processor processor, ArrayList<Future<?>> futuresArray, ProgressFrame progressBar) {
        int frame = 1;
        int nframes = futuresArray.size();
        while (!futuresArray.isEmpty()) {
            Future<?> f = futuresArray.get(futuresArray.size() - 1);
            if (progressBar != null) {
                progressBar.setMessage("Analyze frame: " + frame + "//" + nframes);
            }
            try {
                f.get();
            }
            catch (ExecutionException e) {
                System.out.println("FlyDetectTools:waitDetectCompletion - frame:" + frame + " Execution exception: " + e);
            }
            catch (InterruptedException e) {
                System.out.println("FlyDetectTools:waitDetectCompletion - Interrupted exception: " + e);
            }
            futuresArray.remove(f);
            ++frame;
        }
    }
}

