/*
 * Decompiled with CFR 0.152.
 */
package plugins.fmp.multiSPOTS96.series;

import icy.gui.frame.progress.ProgressFrame;
import icy.image.IcyBufferedImage;
import icy.image.IcyBufferedImageUtil;
import icy.image.ImageUtil;
import icy.type.geom.Polygon2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.util.logging.Logger;
import javax.vecmath.Vector2d;
import plugins.fmp.multiSPOTS96.dlg.a_experiment.CorrectDrift;
import plugins.fmp.multiSPOTS96.experiment.Experiment;
import plugins.fmp.multiSPOTS96.series.BuildSeries;
import plugins.fmp.multiSPOTS96.series.ImageProcessor;
import plugins.fmp.multiSPOTS96.series.ProcessingResult;
import plugins.fmp.multiSPOTS96.series.ProgressReporter;
import plugins.fmp.multiSPOTS96.series.SafeImageProcessor;
import plugins.fmp.multiSPOTS96.tools.GaspardRigidRegistration;
import plugins.fmp.multiSPOTS96.tools.imageTransform.ImageTransformInterface;
import plugins.fmp.multiSPOTS96.tools.imageTransform.ImageTransformOptions;

public class Registration
extends BuildSeries {
    private final ProgressReporter progressReporter;
    private static final Logger LOGGER = Logger.getLogger(CorrectDrift.class.getName());
    private static final double MIN_TRANSLATION_THRESHOLD = 0.001;
    private static final double MIN_ROTATION_THRESHOLD = 0.001;

    public Registration() {
        this(new SafeImageProcessor(), ProgressReporter.NO_OP);
    }

    public Registration(ImageProcessor imageProcessor, ProgressReporter progressReporter) {
        this.progressReporter = progressReporter;
    }

    @Override
    void analyzeExperiment(Experiment experiment) {
        ProcessingResult<Void> result = this.analyzeExperimentSafely(experiment);
        if (result.isFailure()) {
            System.err.println("Background analysis failed: " + result.getErrorMessage());
            this.progressReporter.failed(result.getErrorMessage());
        } else {
            this.progressReporter.completed();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ProcessingResult<Void> analyzeExperimentSafely(Experiment experiment) {
        try {
            ProcessingResult<Void> validationResult = this.validateExperiment(experiment);
            if (validationResult.isFailure()) {
                ProcessingResult<Void> processingResult = validationResult;
                return processingResult;
            }
            ProcessingResult<Void> loadResult = this.loadExperimentData(experiment);
            if (loadResult.isFailure()) {
                ProcessingResult<Void> processingResult = loadResult;
                return processingResult;
            }
            int iiFirst = this.options.fromFrame;
            int iiLast = this.options.toFrame;
            int referenceFrame = this.options.referenceFrame;
            ProcessingResult<Void> buildResult = this.correctDriftAndRotation(experiment, iiFirst, iiLast, referenceFrame);
            if (buildResult.isFailure()) {
                ProcessingResult<Void> processingResult = buildResult;
                return processingResult;
            }
            ProcessingResult<Void> processingResult = ProcessingResult.success();
            return processingResult;
        }
        finally {
            this.cleanupResources();
        }
    }

    private ProcessingResult<Void> validateExperiment(Experiment experiment) {
        if (experiment == null) {
            return ProcessingResult.failure("Experiment cannot be null");
        }
        if (experiment.seqCamData == null) {
            return ProcessingResult.failure("Experiment must have camera data");
        }
        return ProcessingResult.success();
    }

    private ProcessingResult<Void> loadExperimentData(Experiment experiment) {
        try {
            boolean loadSuccess = this.loadSeqCamDataAndCages(experiment);
            if (!loadSuccess) {
                return ProcessingResult.failure("Failed to load DrosoTrack data");
            }
            return ProcessingResult.success();
        }
        catch (Exception e) {
            return ProcessingResult.failure("Error loading experiment data", e);
        }
    }

    private void cleanupResources() {
    }

    private ProcessingResult<Void> correctDriftAndRotation(Experiment exp, int iiFirst, int iiLast, int referenceFrame) {
        ProgressFrame progressBar1 = new ProgressFrame("Analyze stack");
        ImageTransformOptions transformOptions = new ImageTransformOptions();
        transformOptions.transformOption = this.options.transformop;
        ImageTransformInterface transformFunction = transformOptions.transformOption.getFunction();
        Polygon2D polygon2D = exp.cagesArray.getPolygon2DEnclosingAllCages();
        Rectangle rect = polygon2D.getBounds();
        String fileNameReference = exp.seqCamData.getFileNameFromImageList(referenceFrame);
        IcyBufferedImage referenceImage = this.imageIORead(fileNameReference);
        IcyBufferedImage refImageTransformed = transformFunction.getTransformedImage(referenceImage, transformOptions);
        IcyBufferedImage reducedReferenceImage = IcyBufferedImageUtil.getSubImage((IcyBufferedImage)refImageTransformed, (int)rect.x, (int)rect.y, (int)rect.height, (int)rect.width);
        boolean referenceChannel = false;
        for (int frame = iiFirst; frame < iiLast && !this.stopFlag; ++frame) {
            progressBar1.setMessage("Analyze frame: " + frame + "//" + iiLast);
            String fileName = exp.seqCamData.getFileNameFromImageList(frame);
            if (fileName == null) {
                System.out.println("filename null at t=" + frame);
                continue;
            }
            IcyBufferedImage workImage = this.imageIORead(fileName);
            IcyBufferedImage workImageTransformed = transformFunction.getTransformedImage(workImage, transformOptions);
            IcyBufferedImage reducedWorkImage = IcyBufferedImageUtil.getSubImage((IcyBufferedImage)workImageTransformed, (int)rect.x, (int)rect.y, (int)rect.height, (int)rect.width);
            Vector2d translation = GaspardRigidRegistration.findTranslation2D(reducedWorkImage, 0, reducedReferenceImage, 0);
            boolean change = false;
            if (translation.lengthSquared() > 0.001) {
                change = true;
                workImage = GaspardRigidRegistration.applyTranslation2D(workImage, -1, translation, true);
                LOGGER.info("Applied translation correction: (" + translation.x + ", " + translation.y + ")");
            }
            boolean rotate = false;
            if (!change) {
                translation = null;
            } else {
                workImageTransformed = transformFunction.getTransformedImage(workImage, transformOptions);
                reducedWorkImage = IcyBufferedImageUtil.getSubImage((IcyBufferedImage)workImageTransformed, (int)rect.x, (int)rect.y, (int)rect.height, (int)rect.width);
            }
            double angle = GaspardRigidRegistration.findRotation2D(reducedWorkImage, 0, reducedReferenceImage, 0, translation);
            if (Math.abs(angle) > 0.001) {
                rotate = true;
                workImage = GaspardRigidRegistration.applyRotation2D(workImage, -1, angle, true);
                LOGGER.info("Applied rotation correction: " + Math.toDegrees(angle) + " degrees");
                workImageTransformed = transformFunction.getTransformedImage(workImage, transformOptions);
                reducedWorkImage = IcyBufferedImageUtil.getSubImage((IcyBufferedImage)workImageTransformed, (int)rect.x, (int)rect.y, (int)rect.height, (int)rect.width);
                Vector2d translation2 = GaspardRigidRegistration.findTranslation2D(reducedWorkImage, 0, reducedReferenceImage, 0);
                if (translation2.lengthSquared() > 0.001) {
                    workImage = GaspardRigidRegistration.applyTranslation2D(workImage, -1, translation2, true);
                }
            }
            if (rotate) {
                GaspardRigidRegistration.getTranslation2D(workImage, referenceImage, 0);
            }
            if (!change && !rotate) continue;
            System.out.println("image:" + frame + "  change=" + change + "(" + translation + ") --  rotation=" + rotate + "(" + angle + ")");
            File outputfile = new File(fileName);
            BufferedImage image = ImageUtil.toRGBImage((Image)workImage);
            boolean success = ImageUtil.save((RenderedImage)image, (String)"jpg", (File)outputfile);
            System.out.println("save file " + fileName + " --->" + success);
        }
        progressBar1.close();
        return ProcessingResult.success();
    }
}

