/*
 * Decompiled with CFR 0.152.
 */
package plugins.fmp.multiSPOTS96.series;

import java.util.logging.Logger;
import plugins.fmp.multiSPOTS96.experiment.Experiment;
import plugins.fmp.multiSPOTS96.series.BuildSeries;
import plugins.fmp.multiSPOTS96.series.ProcessingResult;
import plugins.fmp.multiSPOTS96.series.ProgressReporter;
import plugins.fmp.multiSPOTS96.series.RegistrationOptions;
import plugins.fmp.multiSPOTS96.series.RegistrationProcessor;
import plugins.fmp.multiSPOTS96.series.SafeRegistrationProcessor;
import plugins.fmp.multiSPOTS96.tools.imageTransform.ImageTransformEnums;
import plugins.fmp.multiSPOTS96.tools.imageTransform.ImageTransformOptions;

public class RegistrationRefactored
extends BuildSeries {
    private static final Logger LOGGER = Logger.getLogger(RegistrationRefactored.class.getName());
    private final RegistrationProcessor registrationProcessor;
    private final ProgressReporter progressReporter;

    public RegistrationRefactored() {
        this(new SafeRegistrationProcessor(), ProgressReporter.NO_OP);
    }

    public RegistrationRefactored(RegistrationProcessor registrationProcessor, ProgressReporter progressReporter) {
        this.registrationProcessor = registrationProcessor;
        this.progressReporter = progressReporter;
    }

    @Override
    void analyzeExperiment(Experiment experiment) {
        LOGGER.info("Starting registration analysis for experiment: " + experiment.getResultsDirectory());
        RegistrationOptions options = this.createRegistrationOptions();
        ProcessingResult<RegistrationProcessor.RegistrationResult> result = this.registrationProcessor.correctDriftAndRotation(experiment, options);
        if (result.isFailure()) {
            String errorMessage = "Registration analysis failed: " + result.getErrorMessage();
            LOGGER.severe(errorMessage);
            this.progressReporter.failed(errorMessage);
        } else {
            RegistrationProcessor.RegistrationResult registrationResult = result.getDataOrThrow();
            LOGGER.info("Registration completed successfully. Processed: " + registrationResult.getFramesProcessed() + " frames, Corrected: " + registrationResult.getFramesCorrected() + " frames");
            this.progressReporter.completed();
        }
    }

    private RegistrationOptions createRegistrationOptions() {
        return new RegistrationOptions().fromFrame(this.options.fromFrame).toFrame(this.options.toFrame).referenceFrame(this.options.referenceFrame).translationThreshold(0.001).rotationThreshold(0.001).transformOptions(this.createImageTransformOptions(this.options.transformop)).saveCorrectedImages(true).preserveImageSize(true).referenceChannel(0).progressReporter(this.progressReporter);
    }

    public ProcessingResult<RegistrationProcessor.RegistrationResult> correctDriftOnly(Experiment experiment) {
        RegistrationOptions options = this.createRegistrationOptions();
        return this.registrationProcessor.correctDrift(experiment, options);
    }

    public ProcessingResult<RegistrationProcessor.RegistrationResult> correctRotationOnly(Experiment experiment) {
        RegistrationOptions options = this.createRegistrationOptions();
        return this.registrationProcessor.correctRotation(experiment, options);
    }

    public ProcessingResult<RegistrationProcessor.RegistrationResult> analyzeRegistration(Experiment experiment) {
        RegistrationOptions options = this.createRegistrationOptions().saveCorrectedImages(false);
        return this.registrationProcessor.correctDriftAndRotation(experiment, options);
    }

    private ImageTransformOptions createImageTransformOptions(ImageTransformEnums transformEnum) {
        ImageTransformOptions options = new ImageTransformOptions();
        options.transformOption = transformEnum;
        return options;
    }
}

