/*
 * Decompiled with CFR 0.152.
 */
package plugins.fmp.multiSPOTS96.tools.JComponents;

import java.awt.Component;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JList;
import javax.swing.ListModel;

public class SequenceNameListRenderer
extends DefaultListCellRenderer {
    private static final long serialVersionUID = 7571369946954820177L;

    @Override
    public Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        String valueText;
        String indexPrefix;
        Component c = super.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
        ListModel<?> model = list.getModel();
        int totalItems = model.getSize();
        if (index < 0) {
            index = list.getSelectedIndex();
        }
        String displayText = indexPrefix = String.format("[%d:%d] ", index + 1, totalItems);
        if (value != null && (valueText = value.toString()) != null) {
            displayText = displayText + this.truncateIfNeeded(valueText, indexPrefix.length());
        }
        this.setText(displayText);
        return c;
    }

    private String truncateIfNeeded(String text, int prefixLength) {
        int availableLength = 70 - prefixLength;
        if (text.length() <= availableLength) {
            return text;
        }
        int charactersToShow = availableLength - 3;
        if (charactersToShow <= 0) {
            return "...";
        }
        return "..." + text.substring(text.length() - charactersToShow);
    }
}

