/*
 * Decompiled with CFR 0.152.
 */
package plugins.fmp.multiSPOTS96.tools.imageTransform.transforms;

import icy.image.IcyBufferedImage;
import java.util.logging.Logger;
import plugins.fmp.multiSPOTS96.tools.imageTransform.AlgorithmException;
import plugins.fmp.multiSPOTS96.tools.imageTransform.ArrayOperationCache;
import plugins.fmp.multiSPOTS96.tools.imageTransform.ImageTransformBase;
import plugins.fmp.multiSPOTS96.tools.imageTransform.ImageTransformConstants;
import plugins.fmp.multiSPOTS96.tools.imageTransform.ImageTransformException;
import plugins.fmp.multiSPOTS96.tools.imageTransform.ImageTransformOptions;
import plugins.fmp.multiSPOTS96.tools.imageTransform.InvalidParameterException;

public class LinearCombination
extends ImageTransformBase {
    private static final Logger logger = Logger.getLogger(LinearCombination.class.getName());
    private static final ArrayOperationCache arrayCache = new ArrayOperationCache();
    private final double[] weights;

    public LinearCombination(double wR, double wG, double wB) {
        this.weights = new double[]{wR, wG, wB};
    }

    public LinearCombination(double[] weights) {
        if (weights == null || weights.length != 3) {
            throw new IllegalArgumentException("Weights array must contain exactly 3 values");
        }
        this.weights = (double[])weights.clone();
    }

    public static LinearCombination createGrayscale() {
        return new LinearCombination(ImageTransformConstants.LinearCombination.GRAYSCALE_WEIGHTS);
    }

    public static LinearCombination createEqualWeight() {
        return new LinearCombination(ImageTransformConstants.LinearCombination.EQUAL_WEIGHTS);
    }

    @Override
    protected void validateTransformSpecificParameters(IcyBufferedImage sourceImage, ImageTransformOptions options, String transformName) throws ImageTransformException {
        if (sourceImage.getSizeC() < 3) {
            throw new InvalidParameterException("channels", sourceImage.getSizeC(), "Linear combination requires at least 3 channels", transformName);
        }
        boolean allZero = true;
        for (double weight : this.weights) {
            if (weight == 0.0) continue;
            allZero = false;
            break;
        }
        if (allZero) {
            throw new InvalidParameterException("weights", this.weights, "At least one weight must be non-zero", transformName);
        }
        double maxWeight = Math.max(Math.abs(this.weights[0]), Math.max(Math.abs(this.weights[1]), Math.abs(this.weights[2])));
        if (maxWeight > 10.0) {
            logger.warning("Large weight detected: " + maxWeight + ". Results may be out of range.");
        }
    }

    @Override
    protected IcyBufferedImage executeTransform(IcyBufferedImage sourceImage, ImageTransformOptions options) throws ImageTransformException {
        try {
            IcyBufferedImage resultImage = this.createResultImage(sourceImage, 3);
            double[][] rgbArrays = this.getRGBArraysOptimized(sourceImage);
            double[] resultArray = arrayCache.linearCombination(rgbArrays, this.weights);
            this.copyArrayToImage(resultArray, resultImage, options.copyResultsToThe3planes);
            return resultImage;
        }
        catch (Exception e) {
            throw new AlgorithmException("Linear combination computation", e.getMessage(), e);
        }
    }

    public double[] getWeights() {
        return (double[])this.weights.clone();
    }

    public String getDescription() {
        return String.format("Linear combination: %.3f*R + %.3f*G + %.3f*B", this.weights[0], this.weights[1], this.weights[2]);
    }

    public String toString() {
        return this.getDescription();
    }
}

