/*
 * Decompiled with CFR 0.152.
 */
package plugins.fmp.multiSPOTS96.tools.toExcel;

import icy.gui.frame.progress.ProgressFrame;
import java.awt.Point;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.text.SimpleDateFormat;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.util.CellReference;
import org.apache.poi.xssf.streaming.SXSSFSheet;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;
import plugins.fmp.multiSPOTS96.experiment.Experiment;
import plugins.fmp.multiSPOTS96.experiment.ExperimentProperties;
import plugins.fmp.multiSPOTS96.experiment.cages.Cage;
import plugins.fmp.multiSPOTS96.experiment.spots.Spot;
import plugins.fmp.multiSPOTS96.tools.JComponents.JComboBoxExperiment;
import plugins.fmp.multiSPOTS96.tools.toExcel.EnumXLSColumnHeader;
import plugins.fmp.multiSPOTS96.tools.toExcel.EnumXLSExport;
import plugins.fmp.multiSPOTS96.tools.toExcel.ExcelResourceManager;
import plugins.fmp.multiSPOTS96.tools.toExcel.XLSExportOptions;
import plugins.fmp.multiSPOTS96.tools.toExcel.XLSResults;
import plugins.fmp.multiSPOTS96.tools.toExcel.XLSUtils;
import plugins.fmp.multiSPOTS96.tools.toExcel.exceptions.ExcelDataException;
import plugins.fmp.multiSPOTS96.tools.toExcel.exceptions.ExcelExportException;
import plugins.fmp.multiSPOTS96.tools.toExcel.exceptions.ExcelResourceException;

public abstract class XLSExport {
    protected XLSExportOptions options = null;
    protected Experiment expAll = null;
    protected JComboBoxExperiment expList = null;
    protected ExcelResourceManager resourceManager = null;
    protected CellStyle redCellStyle = null;
    protected CellStyle blueCellStyle = null;

    public final void exportToFile(String filename, XLSExportOptions options) throws ExcelExportException {
        System.out.println("XLSExportBase:exportToFile() - start output");
        this.options = options;
        this.expList = options.expList;
        try (ExcelResourceManager resourceManager = new ExcelResourceManager(filename);){
            this.resourceManager = resourceManager;
            this.redCellStyle = resourceManager.getRedCellStyle();
            this.blueCellStyle = resourceManager.getBlueCellStyle();
            this.prepareExperiments();
            this.validateExportParameters();
            this.executeExport();
            resourceManager.saveAndClose();
        }
        catch (ExcelResourceException e) {
            throw new ExcelExportException("Resource management failed during export", "export_to_file", filename, e);
        }
        catch (Exception e) {
            throw new ExcelExportException("Unexpected error during export", "export_to_file", filename, e);
        }
        finally {
            this.cleanup();
        }
        System.out.println("XLSExport:exportToFile() - XLS output finished");
    }

    protected void prepareExperiments() throws ExcelDataException {
        try {
            this.expList.loadListOfMeasuresFromAllExperiments(true, this.options.onlyalive);
            this.expList.chainExperimentsUsingKymoIndexes(this.options.collateSeries);
            this.expList.setFirstImageForAllExperiments(this.options.collateSeries);
            this.expAll = this.expList.get_MsTime_of_StartAndEnd_AllExperiments(this.options);
        }
        catch (Exception e) {
            throw new ExcelDataException("Failed to prepare experiments for export", "prepare_experiments", "experiment_loading", e);
        }
    }

    protected void validateExportParameters() throws ExcelDataException {
        if (this.options == null) {
            throw new ExcelDataException("Export options cannot be null", "validate_parameters", "options_validation");
        }
        if (this.expList == null) {
            throw new ExcelDataException("Experiment list cannot be null", "validate_parameters", "expList_validation");
        }
        if (this.options.experimentIndexFirst < 0 || this.options.experimentIndexLast < 0) {
            throw new ExcelDataException("Invalid experiment index range", "validate_parameters", "index_validation");
        }
        if (this.options.experimentIndexFirst > this.options.experimentIndexLast) {
            throw new ExcelDataException("First experiment index cannot be greater than last", "validate_parameters", "index_validation");
        }
    }

    protected void executeExport() throws ExcelExportException {
        int nbexpts = this.expList.getItemCount();
        try (ProgressFrame progress = new ProgressFrame("Export data to Excel");){
            progress.setLength((double)nbexpts);
            int column = 1;
            int iSeries = 0;
            for (int index = this.options.experimentIndexFirst; index <= this.options.experimentIndexLast; ++index) {
                Experiment exp = (Experiment)this.expList.getItemAt(index);
                exp.load_MS96_spotsMeasures();
                if (this.shouldSkipExperiment(exp)) continue;
                progress.setMessage("Export experiment " + (index + 1) + " of " + nbexpts);
                String seriesIdentifier = CellReference.convertNumToColString((int)iSeries);
                column = this.exportExperimentData(exp, this.options, column, seriesIdentifier);
                ++iSeries;
                progress.incPosition();
            }
            progress.setMessage("Save Excel file to disk... ");
        }
    }

    protected boolean shouldSkipExperiment(Experiment exp) {
        return exp.chainToPreviousExperiment != null;
    }

    protected abstract int exportExperimentData(Experiment var1, XLSExportOptions var2, int var3, String var4) throws ExcelExportException;

    protected void cleanup() {
    }

    protected SXSSFSheet getSheet(String title, EnumXLSExport xlsExport) throws ExcelResourceException {
        SXSSFWorkbook workbook = this.resourceManager.getWorkbook();
        SXSSFSheet sheet = workbook.getSheet(title);
        if (sheet == null) {
            sheet = workbook.createSheet(title);
            this.writeTopRowDescriptors(sheet);
            this.writeTopRowTimeIntervals(sheet, this.getDescriptorRowCount(), xlsExport);
        }
        return sheet;
    }

    protected int writeTopRowDescriptors(SXSSFSheet sheet) {
        int nextcol = -1;
        for (EnumXLSColumnHeader header : EnumXLSColumnHeader.values()) {
            XLSUtils.setValue(sheet, 0, header.getValue(), this.options.transpose, header.getName());
            if (nextcol >= header.getValue()) continue;
            nextcol = header.getValue();
        }
        return nextcol + 1;
    }

    protected void writeTopRowTimeIntervals(SXSSFSheet sheet, int row, EnumXLSExport xlsExport) {
        boolean transpose = this.options.transpose;
        Point pt = new Point(0, row);
        long duration = this.expAll.seqCamData.getLastImageMs() - this.expAll.seqCamData.getFirstImageMs();
        for (long interval = 0L; interval < duration; interval += (long)this.options.buildExcelStepMs) {
            int i = (int)(interval / (long)this.options.buildExcelUnitMs);
            XLSUtils.setValue(sheet, pt, transpose, "t" + i);
            ++pt.y;
        }
    }

    protected int getDescriptorRowCount() {
        return EnumXLSColumnHeader.values().length;
    }

    protected Point writeExperimentSeparator(SXSSFSheet sheet, Point pt) {
        boolean transpose = this.options.transpose;
        XLSUtils.setValue(sheet, pt, transpose, "--");
        ++pt.x;
        XLSUtils.setValue(sheet, pt, transpose, "--");
        ++pt.x;
        return pt;
    }

    protected Point writeExperimentSpotInfos(SXSSFSheet sheet, Point pt, Experiment exp, String charSeries, Cage cage, Spot spot, EnumXLSExport xlsExportType) {
        int x = pt.x;
        int y = pt.y;
        boolean transpose = this.options.transpose;
        this.writeFileInformation(sheet, x, y, transpose, exp);
        this.writeExperimentProperties(sheet, x, y, transpose, exp);
        this.writeSpotProperties(sheet, x, y, transpose, spot, cage, charSeries, xlsExportType);
        this.writeCageProperties(sheet, x, y, transpose, cage);
        pt.y = y + 26 + 1;
        return pt;
    }

    private void writeFileInformation(SXSSFSheet sheet, int x, int y, boolean transpose, Experiment exp) {
        String filename = exp.getResultsDirectory();
        if (filename == null) {
            filename = exp.seqCamData.getImagesDirectory();
        }
        Path path = Paths.get(filename, new String[0]);
        SimpleDateFormat df = new SimpleDateFormat("MM/dd/yyyy");
        String date = df.format(exp.chainImageFirst_ms);
        String name0 = path.toString();
        String cam = this.extractCameraInfo(name0);
        XLSUtils.setValue(sheet, x, y + 0, transpose, name0);
        XLSUtils.setValue(sheet, x, y + 1, transpose, date);
        XLSUtils.setValue(sheet, x, y + 3, transpose, cam);
    }

    private String extractCameraInfo(String filename) {
        int pos = filename.indexOf("cam");
        if (pos > 0) {
            int pos5 = pos + 5;
            if (pos5 >= filename.length()) {
                pos5 = filename.length() - 1;
            }
            return filename.substring(pos, pos5);
        }
        return "-";
    }

    private void writeExperimentProperties(SXSSFSheet sheet, int x, int y, boolean transpose, Experiment exp) {
        ExperimentProperties props = exp.getProperties();
        XLSUtils.setFieldValue(sheet, x, y, transpose, props, EnumXLSColumnHeader.EXP_BOXID);
        XLSUtils.setFieldValue(sheet, x, y, transpose, props, EnumXLSColumnHeader.EXP_EXPT);
        XLSUtils.setFieldValue(sheet, x, y, transpose, props, EnumXLSColumnHeader.EXP_STIM);
        XLSUtils.setFieldValue(sheet, x, y, transpose, props, EnumXLSColumnHeader.EXP_CONC);
        XLSUtils.setFieldValue(sheet, x, y, transpose, props, EnumXLSColumnHeader.EXP_STRAIN);
        XLSUtils.setFieldValue(sheet, x, y, transpose, props, EnumXLSColumnHeader.EXP_SEX);
        XLSUtils.setFieldValue(sheet, x, y, transpose, props, EnumXLSColumnHeader.EXP_COND1);
        XLSUtils.setFieldValue(sheet, x, y, transpose, props, EnumXLSColumnHeader.EXP_COND2);
    }

    private void writeSpotProperties(SXSSFSheet sheet, int x, int y, boolean transpose, Spot spot, Cage cage, String charSeries, EnumXLSExport xlsExportType) {
        XLSUtils.setValue(sheet, x, y + 13, transpose, spot.getProperties().getSpotVolume());
        XLSUtils.setValue(sheet, x, y + 14, transpose, spot.getProperties().getSpotNPixels());
        XLSUtils.setValue(sheet, x, y + 12, transpose, spot.getCagePosition(xlsExportType));
        XLSUtils.setValue(sheet, x, y + 16, transpose, spot.getProperties().getStimulus());
        XLSUtils.setValue(sheet, x, y + 17, transpose, spot.getProperties().getConcentration());
        XLSUtils.setValue(sheet, x, y + 19, transpose, spot.getProperties().getCageID());
        XLSUtils.setValue(sheet, x, y + 20, transpose, spot.getProperties().getCageRow());
        XLSUtils.setValue(sheet, x, y + 21, transpose, spot.getProperties().getCageColumn());
        XLSUtils.setValue(sheet, x, y + 5, transpose, charSeries + spot.getProperties().getCageID());
        XLSUtils.setValue(sheet, x, y + 18, transpose, cage.getProperties().getCageNFlies());
        XLSUtils.setValue(sheet, x, y + 15, transpose, "");
        XLSUtils.setValue(sheet, x, y + 26, transpose, spot.getProperties().getStimulusI());
    }

    private void writeCageProperties(SXSSFSheet sheet, int x, int y, boolean transpose, Cage cage) {
        XLSUtils.setValue(sheet, x, y + 22, transpose, cage.getProperties().getFlyStrain());
        XLSUtils.setValue(sheet, x, y + 23, transpose, cage.getProperties().getFlySex());
        XLSUtils.setValue(sheet, x, y + 24, transpose, cage.getProperties().getFlyAge());
        XLSUtils.setValue(sheet, x, y + 25, transpose, cage.getProperties().getComment());
    }

    protected void handleExportError(Experiment exp, int nOutputFrames) {
        String error = String.format("XLSExport:ExportError() ERROR in %s\n nOutputFrames=%d kymoFirstCol_Ms=%d kymoLastCol_Ms=%d", exp.getResultsDirectory(), nOutputFrames, exp.seqCamData.getTimeManager().getBinFirst_ms(), exp.seqCamData.getTimeManager().getBinLast_ms());
        System.err.println(error);
    }

    protected void writeXLSResult(SXSSFSheet sheet, Point pt, XLSResults xlsResult) {
        int i_from;
        boolean transpose = this.options.transpose;
        if (xlsResult.getValuesOutLength() < 1) {
            return;
        }
        long coltime = this.expAll.seqCamData.getFirstImageMs();
        while (coltime < this.expAll.seqCamData.getLastImageMs() && (i_from = (int)((coltime - this.expAll.seqCamData.getFirstImageMs()) / (long)this.options.buildExcelStepMs)) < xlsResult.getValuesOutLength()) {
            double value = xlsResult.getValuesOut()[i_from];
            if (!Double.isNaN(value)) {
                XLSUtils.setValue(sheet, pt, transpose, value);
            }
            coltime += (long)this.options.buildExcelStepMs;
            ++pt.y;
        }
    }
}

