/*
 * Decompiled with CFR 0.152.
 */
package plugins.fmp.multiSPOTS96.experiment.spots;

import java.awt.Rectangle;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import plugins.fmp.multiSPOTS96.experiment.sequence.TIntervalsArray;
import plugins.fmp.multiSPOTS96.experiment.spots.EnumSpotMeasures;
import plugins.fmp.multiSPOTS96.experiment.spots.Spot;
import plugins.fmp.multiSPOTS96.experiment.spots.SpotsArrayConfiguration;
import plugins.fmp.multiSPOTS96.experiment.spots.SpotsArrayInfo;
import plugins.fmp.multiSPOTS96.experiment.spots.SpotsDataOperationResult;
import plugins.fmp.multiSPOTS96.tools.toExcel.EnumXLSExport;

public class ModernSpotsArray
implements AutoCloseable {
    private static final Logger LOGGER = Logger.getLogger(ModernSpotsArray.class.getName());
    private final ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
    private volatile boolean closed = false;
    private final List<Spot> spotsList = new CopyOnWriteArrayList<Spot>();
    private final Map<String, Spot> spotsByName = new ConcurrentHashMap<String, Spot>();
    private final SpotsArrayConfiguration configuration;
    private TIntervalsArray timeIntervals;

    public ModernSpotsArray() {
        this.configuration = SpotsArrayConfiguration.defaultConfiguration();
        this.timeIntervals = new TIntervalsArray();
    }

    public ModernSpotsArray(SpotsArrayConfiguration configuration) {
        if (configuration == null) {
            throw new IllegalArgumentException("Configuration cannot be null");
        }
        this.configuration = configuration;
        this.timeIntervals = new TIntervalsArray();
    }

    public static Builder builder() {
        return new Builder();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SpotsArrayInfo getSpotsInfo() {
        this.ensureNotClosed();
        this.lock.readLock().lock();
        try {
            List<String> spotNames = this.spotsList.stream().map(spot -> spot.getRoi().getName()).collect(Collectors.toList());
            int validSpots = (int)this.spotsList.stream().filter(spot -> spot.isValid()).count();
            int spotsWithMeasures = (int)this.spotsList.stream().filter(spot -> spot.getMeasurements(EnumXLSExport.AREA_SUMCLEAN).getSpotLevel2D().getLevel2D().getPointCount() > 0).count();
            int spotsReady = (int)this.spotsList.stream().filter(spot -> spot.isReadyForAnalysis()).count();
            SpotsArrayInfo spotsArrayInfo = SpotsArrayInfo.builder().totalSpots(this.spotsList.size()).validSpots(validSpots).spotsWithMeasures(spotsWithMeasures).spotsReadyForAnalysis(spotsReady).spotNames(spotNames).hasTimeIntervals(this.timeIntervals != null && this.timeIntervals.size() > 0).timeIntervalsCount(this.timeIntervals != null ? this.timeIntervals.size() : 0).build();
            return spotsArrayInfo;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SpotsDataOperationResult addSpot(Spot spot) {
        if (spot == null) {
            return SpotsDataOperationResult.failure("ADD_SPOT", new IllegalArgumentException("Spot cannot be null"), "Cannot add null spot");
        }
        this.ensureNotClosed();
        this.lock.writeLock().lock();
        try {
            long startTime = System.currentTimeMillis();
            if (this.configuration.isValidateSpots() && !this.isValidSpot(spot)) {
                SpotsDataOperationResult spotsDataOperationResult = SpotsDataOperationResult.failure("ADD_SPOT", new IllegalArgumentException("Invalid spot"), "Spot validation failed");
                return spotsDataOperationResult;
            }
            String spotName = spot.getRoi().getName();
            if (this.spotsByName.containsKey(spotName)) {
                if (this.configuration.isStrictValidation()) {
                    SpotsDataOperationResult spotsDataOperationResult = SpotsDataOperationResult.failure("ADD_SPOT", new IllegalStateException("Duplicate spot"), "Spot with name '" + spotName + "' already exists");
                    return spotsDataOperationResult;
                }
                this.removeSpotByName(spotName);
            }
            this.spotsList.add(spot);
            this.spotsByName.put(spotName, spot);
            if (this.configuration.isAutoSortSpots()) {
                Collections.sort(this.spotsList);
            }
            long processingTime = System.currentTimeMillis() - startTime;
            SpotsDataOperationResult spotsDataOperationResult = SpotsDataOperationResult.success("ADD_SPOT", 1, "Successfully added spot: " + spotName).toBuilder().processingTimeMs(processingTime).build();
            return spotsDataOperationResult;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    public Optional<Spot> findSpotByName(String name) {
        if (name == null || name.trim().isEmpty()) {
            throw new IllegalArgumentException("Name cannot be null or empty");
        }
        this.ensureNotClosed();
        return Optional.ofNullable(this.spotsByName.get(name));
    }

    public List<Spot> findSpotsContainingPattern(String pattern) {
        if (pattern == null) {
            throw new IllegalArgumentException("Pattern cannot be null");
        }
        this.ensureNotClosed();
        this.lock.readLock().lock();
        try {
            List<Spot> list = this.spotsList.stream().filter(spot -> spot.getRoi().getName().contains(pattern)).collect(Collectors.toList());
            return list;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeSpotByName(String name) {
        if (name == null || name.trim().isEmpty()) {
            return false;
        }
        this.ensureNotClosed();
        this.lock.writeLock().lock();
        try {
            Spot spot = this.spotsByName.remove(name);
            if (spot != null) {
                this.spotsList.remove(spot);
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SpotsDataOperationResult loadFromCsv(String directory, EnumSpotMeasures measureType) {
        if (directory == null || directory.trim().isEmpty()) {
            return SpotsDataOperationResult.failure("CSV_LOAD", new IllegalArgumentException("Directory cannot be null or empty"), "Invalid directory");
        }
        if (measureType == null) {
            return SpotsDataOperationResult.failure("CSV_LOAD", new IllegalArgumentException("Measure type cannot be null"), "Invalid measure type");
        }
        this.ensureNotClosed();
        this.lock.writeLock().lock();
        try {
            long startTime = System.currentTimeMillis();
            Path csvPath = Paths.get(directory, "SpotsMeasures.csv");
            if (!Files.exists(csvPath, new LinkOption[0])) {
                SpotsDataOperationResult spotsDataOperationResult = SpotsDataOperationResult.failure("CSV_LOAD", new IllegalArgumentException("CSV file not found"), "File does not exist: " + csvPath);
                return spotsDataOperationResult;
            }
            int processedCount = 0;
            int failedCount = 0;
            ArrayList<String> failedItems = new ArrayList();
            try {
                CsvDataLoader loader = new CsvDataLoader(this.configuration);
                CsvLoadResult result = loader.loadSpots(csvPath, measureType);
                processedCount = result.getProcessedCount();
                failedCount = result.getFailedCount();
                failedItems = result.getFailedItems();
                this.rebuildIndexes();
            }
            catch (IOException e) {
                SpotsDataOperationResult spotsDataOperationResult = SpotsDataOperationResult.failure("CSV_LOAD", e, "IO error during CSV loading");
                this.lock.writeLock().unlock();
                return spotsDataOperationResult;
            }
            long processingTime = System.currentTimeMillis() - startTime;
            if (failedCount == 0) {
                SpotsDataOperationResult spotsDataOperationResult = SpotsDataOperationResult.success("CSV_LOAD", processedCount, String.format("Successfully loaded %d spots from CSV", processedCount)).toBuilder().processingTimeMs(processingTime).build();
                return spotsDataOperationResult;
            }
            SpotsDataOperationResult spotsDataOperationResult = SpotsDataOperationResult.partial("CSV_LOAD", processedCount, failedCount, String.format("Loaded %d spots, failed %d", processedCount, failedCount)).toBuilder().processingTimeMs(processingTime).failedItems(failedItems).build();
            return spotsDataOperationResult;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SpotsDataOperationResult mergeFrom(ModernSpotsArray sourceArray) {
        if (sourceArray == null) {
            return SpotsDataOperationResult.failure("MERGE", new IllegalArgumentException("Source array cannot be null"), "Invalid source array");
        }
        this.ensureNotClosed();
        this.lock.writeLock().lock();
        try {
            long startTime = System.currentTimeMillis();
            int processedCount = 0;
            int skippedCount = 0;
            ArrayList<String> processedItems = new ArrayList<String>();
            ArrayList<String> skippedItems = new ArrayList<String>();
            SpotsArrayInfo sourceInfo = sourceArray.getSpotsInfo();
            for (String spotName : sourceInfo.getSpotNames()) {
                Optional<Spot> sourceSpot = sourceArray.findSpotByName(spotName);
                if (!sourceSpot.isPresent()) continue;
                if (!this.spotsByName.containsKey(spotName)) {
                    Spot spotCopy = new Spot(sourceSpot.get(), true);
                    SpotsDataOperationResult addResult = this.addSpot(spotCopy);
                    if (addResult.isSuccess()) {
                        ++processedCount;
                        processedItems.add(spotName);
                        continue;
                    }
                    ++skippedCount;
                    skippedItems.add(spotName);
                    continue;
                }
                ++skippedCount;
                skippedItems.add(spotName + " (duplicate)");
            }
            long processingTime = System.currentTimeMillis() - startTime;
            SpotsDataOperationResult spotsDataOperationResult = SpotsDataOperationResult.builder().success(processedCount > 0).operationType("MERGE").processedCount(processedCount).failedCount(skippedCount).processedItems(processedItems).failedItems(skippedItems).processingTimeMs(processingTime).message(String.format("Merged %d spots, skipped %d duplicates", processedCount, skippedCount)).build();
            return spotsDataOperationResult;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    public SpotsArrayConfiguration getConfiguration() {
        return this.configuration;
    }

    @Override
    public void close() {
        if (!this.closed) {
            this.lock.writeLock().lock();
            try {
                if (!this.closed) {
                    this.spotsList.clear();
                    this.spotsByName.clear();
                    this.closed = true;
                }
            }
            finally {
                this.lock.writeLock().unlock();
            }
        }
    }

    private void ensureNotClosed() {
        if (this.closed) {
            throw new IllegalStateException("SpotsArray is closed");
        }
    }

    private boolean isValidSpot(Spot spot) {
        if (spot == null || spot.getRoi() == null) {
            return false;
        }
        String name = spot.getRoi().getName();
        if (name == null || name.trim().isEmpty()) {
            return false;
        }
        if (this.configuration.isStrictValidation()) {
            Rectangle bounds = spot.getRoi().getBounds();
            if (bounds.width <= 0 || bounds.height <= 0) {
                return false;
            }
        }
        return true;
    }

    private void rebuildIndexes() {
        this.spotsByName.clear();
        for (Spot spot : this.spotsList) {
            if (spot.getRoi() == null || spot.getRoi().getName() == null) continue;
            this.spotsByName.put(spot.getRoi().getName(), spot);
        }
    }

    public static class Builder {
        private SpotsArrayConfiguration configuration = SpotsArrayConfiguration.defaultConfiguration();

        public Builder withConfiguration(SpotsArrayConfiguration configuration) {
            this.configuration = configuration;
            return this;
        }

        public ModernSpotsArray build() {
            return new ModernSpotsArray(this.configuration);
        }
    }

    private static class CsvDataLoader {
        private final SpotsArrayConfiguration config;

        CsvDataLoader(SpotsArrayConfiguration config) {
            this.config = config;
        }

        CsvLoadResult loadSpots(Path csvPath, EnumSpotMeasures measureType) throws IOException {
            return new CsvLoadResult(0, 0, List.of());
        }
    }

    private static class CsvLoadResult {
        private final int processedCount;
        private final int failedCount;
        private final List<String> failedItems;

        CsvLoadResult(int processedCount, int failedCount, List<String> failedItems) {
            this.processedCount = processedCount;
            this.failedCount = failedCount;
            this.failedItems = failedItems;
        }

        int getProcessedCount() {
            return this.processedCount;
        }

        int getFailedCount() {
            return this.failedCount;
        }

        List<String> getFailedItems() {
            return this.failedItems;
        }
    }
}

