/*
 * Decompiled with CFR 0.152.
 */
package plugins.fmp.multiSPOTS96.experiment.spots;

import icy.roi.ROI2D;
import icy.type.geom.Polyline2D;
import java.awt.Color;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import plugins.fmp.multiSPOTS96.tools.polyline.Level2D;
import plugins.kernel.roi.roi2d.ROI2DPolyLine;

public class SpotLevel2D {
    private static final double DEFAULT_FACTOR = 1.0;
    private Level2D level2D;
    private Level2D level2DOld;
    private ROI2DPolyLine roi;
    private double factor;
    private String name;

    public SpotLevel2D(String name) {
        this.name = Objects.requireNonNull(name, "Name cannot be null");
        this.factor = 1.0;
        this.level2D = new Level2D();
        this.level2DOld = new Level2D();
    }

    public SpotLevel2D(String name, List<Point2D> limit) {
        this(name);
        if (limit != null && !limit.isEmpty()) {
            this.setLevel2D(new Level2D(limit));
        }
    }

    public void copyLevel2D(SpotLevel2D source) {
        if (source != null && source.getLevel2D() != null) {
            this.setLevel2D(source.getLevel2D().clone());
        }
    }

    public void clearLevel2D() {
        this.setLevel2D(new Level2D());
    }

    public void transferValues(double[] values) {
        if (values == null || values.length == 0) {
            return;
        }
        int npoints = values.length;
        double[] xpoints = new double[npoints];
        double[] ypoints = new double[npoints];
        for (int i = 0; i < npoints; ++i) {
            xpoints[i] = i;
            ypoints[i] = values[i];
        }
        this.setLevel2D(new Level2D(xpoints, ypoints, npoints));
    }

    public double[] transferLevel2DToValues() {
        double[] values = new double[this.level2D.npoints];
        for (int i = 0; i < this.level2D.npoints; ++i) {
            values[i] = this.level2D.ypoints[i];
        }
        return values;
    }

    public void transferIsPresent(int[] isPresent) {
        if (isPresent == null || isPresent.length == 0) {
            return;
        }
        int npoints = isPresent.length;
        double[] xpoints = new double[npoints];
        double[] ypoints = new double[npoints];
        for (int i = 0; i < npoints; ++i) {
            xpoints[i] = i;
            ypoints[i] = isPresent[i] > 0 ? 1.0 : 0.0;
        }
        this.setLevel2D(new Level2D(xpoints, ypoints, npoints));
    }

    public int getLevel2DNPoints() {
        return this.level2D != null ? this.level2D.npoints : 0;
    }

    public Level2D getLevel2D() {
        return this.level2D;
    }

    public void setLevel2D(Level2D level2D) {
        this.level2D = level2D;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = Objects.requireNonNull(name, "Name cannot be null");
    }

    public ROI2DPolyLine getRoi() {
        return this.roi;
    }

    public void setRoi(ROI2DPolyLine roi) {
        this.roi = roi;
    }

    public boolean isThereAnyMeasuresDone() {
        return this.level2D != null && this.level2D.npoints > 0;
    }

    public List<Double> getLevel2DYAsList() {
        if (this.level2D == null || this.level2D.ypoints == null) {
            return new ArrayList<Double>();
        }
        ArrayList<Double> result = new ArrayList<Double>();
        for (double value : this.level2D.ypoints) {
            result.add(value);
        }
        return result;
    }

    public void adjustLevel2DToImageWidth(int imageWidth) {
        if (this.level2D == null) {
            return;
        }
        if (this.level2DOld == null || this.level2DOld.npoints == 0) {
            this.level2DOld = this.level2D.clone();
        }
        if (this.level2D.npoints > imageWidth) {
            this.level2D.cropPolylineToNewWidth(imageWidth);
        }
    }

    public void cropLevel2DToNPoints(int npoints) {
        if (this.level2D != null) {
            this.level2D.cropPolylineToNewWidth(npoints);
        }
    }

    public int restoreCroppedLevel2D() {
        if (this.level2DOld != null && this.level2DOld.npoints > 0) {
            this.level2D = this.level2DOld.clone();
            return this.level2DOld.npoints;
        }
        return 0;
    }

    public ROI2DPolyLine getROIForImage(String name, int time, int imageHeight) {
        if (this.level2D == null || this.level2D.npoints == 0) {
            return null;
        }
        Polyline2D polyline = this.getPolyline2DFromLevel2D(this.level2D, imageHeight);
        if (polyline == null) {
            return null;
        }
        ROI2DPolyLine result = new ROI2DPolyLine(polyline);
        result.setName(name);
        this.setROI2DColorAndStrokeFromName(result);
        return result;
    }

    public Polyline2D getPolyline2DFromLevel2D(Level2D level2D, int imageHeight) {
        if (level2D == null || level2D.npoints == 0) {
            return null;
        }
        return level2D.expandPolylineToNewWidth(imageHeight);
    }

    private void setROI2DColorAndStrokeFromName(ROI2DPolyLine roi) {
        if (roi == null) {
            return;
        }
        if (this.name.contains("sum")) {
            roi.setColor(Color.RED);
            roi.setStroke(2.0);
        } else if (this.name.contains("clean")) {
            roi.setColor(Color.GREEN);
            roi.setStroke(1.0);
        } else if (this.name.contains("flyPresent")) {
            roi.setColor(Color.BLUE);
            roi.setStroke(1.0);
        } else {
            roi.setColor(Color.YELLOW);
            roi.setStroke(1.0);
        }
    }

    public void transferROItoLevel2D() {
        if (this.roi == null) {
            return;
        }
        Polyline2D polyline = this.roi.getPolyline2D();
        if (polyline != null) {
            this.level2D = new Level2D(polyline);
        }
    }

    public void compensateOffsetUsingSelectedRoi(ROI2D roi, boolean add) {
        if (roi == null || this.level2D == null) {
            return;
        }
    }

    public void cutAndInterpolatePointsEnclosedInSelectedRoi(ROI2D roi) {
        if (roi == null || this.level2D == null) {
            return;
        }
    }

    public boolean exportXYDataToCsv(StringBuilder sbf, String separator) {
        if (this.level2D == null || this.level2D.npoints == 0) {
            return false;
        }
        sbf.append(this.level2D.ypoints.length);
        sbf.append(separator);
        for (int i = 0; i < this.level2D.npoints; ++i) {
            if (i > 0) {
                sbf.append(separator);
            }
            sbf.append(this.level2D.xpoints[i]).append(separator).append(this.level2D.ypoints[i]);
        }
        return true;
    }

    public boolean exportYDataToCsv(StringBuilder sbf, String separator) {
        if (this.level2D == null || this.level2D.ypoints == null) {
            return false;
        }
        sbf.append(this.level2D.ypoints.length);
        sbf.append(separator);
        for (int i = 0; i < this.level2D.ypoints.length; ++i) {
            if (i > 0) {
                sbf.append(separator);
            }
            sbf.append(this.level2D.ypoints[i]);
        }
        return true;
    }

    public boolean importXYDataFromCsv(String[] data, int startAt) {
        if (data == null || data.length < startAt + 2) {
            return false;
        }
        try {
            int npoints = (data.length - startAt) / 2;
            double[] xpoints = new double[npoints];
            double[] ypoints = new double[npoints];
            for (int i = 0; i < npoints; ++i) {
                xpoints[i] = Double.parseDouble(data[startAt + i * 2]);
                ypoints[i] = Double.parseDouble(data[startAt + i * 2 + 1]);
            }
            this.setLevel2D(new Level2D(xpoints, ypoints, npoints));
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    public boolean importYDataFromCsv(String[] data, int startAt) {
        if (data == null || data.length < startAt + 1) {
            return false;
        }
        try {
            int npoints = data.length - startAt;
            double[] ypoints = new double[npoints];
            for (int i = 0; i < npoints; ++i) {
                ypoints[i] = Double.parseDouble(data[startAt + i]);
            }
            double[] xpoints = new double[npoints];
            for (int i = 0; i < npoints; ++i) {
                xpoints[i] = i;
            }
            this.setLevel2D(new Level2D(xpoints, ypoints, npoints));
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        SpotLevel2D other = (SpotLevel2D)obj;
        return Objects.equals(this.name, other.name) && Objects.equals((Object)this.level2D, (Object)other.level2D);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.name, this.factor, this.level2D});
    }

    public String toString() {
        return String.format("SpotMeasure{name='%s', factor=%.2f, level2DPoints=%d}", this.name, this.factor, this.getLevel2DNPoints());
    }
}

