/*
 * Decompiled with CFR 0.152.
 */
package plugins.fmp.multiSPOTS96.experiment.spots;

import icy.type.geom.Polygon2D;
import icy.util.XMLUtil;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import plugins.fmp.multiSPOTS96.experiment.sequence.TInterval;
import plugins.fmp.multiSPOTS96.experiment.sequence.TIntervalsArray;
import plugins.fmp.multiSPOTS96.experiment.spots.EnumSpotMeasures;
import plugins.fmp.multiSPOTS96.experiment.spots.Spot;
import plugins.fmp.multiSPOTS96.experiment.spots.SpotMeasure;
import plugins.fmp.multiSPOTS96.series.BuildSeriesOptions;
import plugins.fmp.multiSPOTS96.tools.toExcel.EnumXLSExport;

public class SpotsArray {
    private static final String ID_SPOTTRACK = "spotTrack";
    private static final String ID_NSPOTS = "N_spots";
    private static final String ID_LISTOFSPOTS = "List_of_spots";
    private static final String ID_SPOT_ = "spot_";
    private static final String CSV_FILENAME = "SpotsMeasures.csv";
    private static final String CSV_SEPARATOR = ";";
    private static final int DEFAULT_VERSION = 2;
    private final List<Spot> spotsList = new ArrayList<Spot>();
    private TIntervalsArray timeIntervals = new TIntervalsArray();

    public List<Spot> getSpotsList() {
        return this.spotsList;
    }

    public int getSpotsCount() {
        return this.spotsList.size();
    }

    public boolean isEmpty() {
        return this.spotsList.isEmpty();
    }

    public void addSpot(Spot spot) {
        Objects.requireNonNull(spot, "Spot cannot be null");
        this.spotsList.add(spot);
    }

    public boolean removeSpot(Spot spot) {
        return this.spotsList.remove(spot);
    }

    public void clearSpots() {
        this.spotsList.clear();
    }

    public void sortSpots() {
        Collections.sort(this.spotsList);
    }

    public Spot findSpotByName(String name) {
        if (name == null || name.trim().isEmpty()) {
            return null;
        }
        return this.spotsList.stream().filter(spot -> name.equals(spot.getName())).findFirst().orElse(null);
    }

    public List<Spot> findSpotsContainingPattern(String pattern) {
        if (pattern == null || pattern.trim().isEmpty()) {
            return new ArrayList<Spot>();
        }
        return this.spotsList.stream().filter(spot -> spot.getName() != null && spot.getName().contains(pattern)).collect(Collectors.toList());
    }

    public boolean isSpotPresent(Spot newSpot) {
        if (newSpot == null) {
            return false;
        }
        String newSpotName = newSpot.getName();
        for (Spot spot : this.spotsList) {
            if (!spot.getName().equals(newSpotName)) continue;
            return true;
        }
        return false;
    }

    public boolean loadSpotsMeasures(String directory) {
        return this.loadSpots(directory, EnumSpotMeasures.SPOTS_MEASURES);
    }

    public boolean loadSpotsAll(String directory) {
        return this.loadSpots(directory, EnumSpotMeasures.ALL);
    }

    private boolean loadSpots(String directory, EnumSpotMeasures measureType) {
        if (directory == null) {
            return false;
        }
        try {
            return this.csvLoadSpots(directory, measureType);
        }
        catch (Exception e) {
            System.err.println("Error loading spots: " + e.getMessage());
            return false;
        }
    }

    public boolean saveSpotsAll(String directory) {
        if (directory == null) {
            return false;
        }
        return this.csvSaveSpots(directory);
    }

    public boolean saveSpotsMeasures(String directory) {
        if (directory == null) {
            return false;
        }
        return this.csvSaveSpots(directory);
    }

    public boolean saveToXml(Node node) {
        if (node == null) {
            return false;
        }
        try {
            Element nodeSpotsArray = XMLUtil.setElement((Node)node, (String)ID_LISTOFSPOTS);
            XMLUtil.setElementIntValue((Node)nodeSpotsArray, (String)ID_NSPOTS, (int)this.spotsList.size());
            this.sortSpots();
            for (int i = 0; i < this.spotsList.size(); ++i) {
                Element nodeSpot = XMLUtil.setElement((Node)node, (String)(ID_SPOT_ + i));
                this.spotsList.get(i).saveToXml(nodeSpot);
            }
            return true;
        }
        catch (Exception e) {
            System.err.println("Error saving spots array to XML: " + e.getMessage());
            return false;
        }
    }

    public boolean loadFromXml(Node node) {
        if (node == null) {
            return false;
        }
        try {
            Element nodeSpotsArray = XMLUtil.getElement((Node)node, (String)ID_LISTOFSPOTS);
            if (nodeSpotsArray == null) {
                return false;
            }
            int nitems = XMLUtil.getElementIntValue((Node)nodeSpotsArray, (String)ID_NSPOTS, (int)0);
            this.spotsList.clear();
            for (int i = 0; i < nitems; ++i) {
                Spot spot;
                Element nodeSpot = XMLUtil.getElement((Node)node, (String)(ID_SPOT_ + i));
                if (nodeSpot == null || !(spot = new Spot()).loadFromXml(nodeSpot) || this.isSpotPresent(spot)) continue;
                this.spotsList.add(spot);
            }
            return true;
        }
        catch (Exception e) {
            System.err.println("Error loading spots array from XML: " + e.getMessage());
            return false;
        }
    }

    public boolean saveDescriptorsToXml(String fileName) {
        if (fileName == null) {
            return false;
        }
        try {
            Document doc = XMLUtil.createDocument((boolean)true);
            if (doc == null) {
                return false;
            }
            this.saveListOfSpotsToXml(XMLUtil.getRootElement((Document)doc));
            return XMLUtil.saveDocument((Document)doc, (String)fileName);
        }
        catch (Exception e) {
            System.err.println("Error saving descriptors to XML: " + e.getMessage());
            return false;
        }
    }

    public boolean loadDescriptorsFromXml(String fileName) {
        if (fileName == null) {
            return false;
        }
        try {
            Document doc = XMLUtil.loadDocument((String)fileName);
            if (doc == null) {
                return false;
            }
            return this.loadSpotsOnlyV1(doc);
        }
        catch (Exception e) {
            System.err.println("Error loading descriptors from XML: " + e.getMessage());
            return false;
        }
    }

    public void copySpotsInfo(SpotsArray sourceArray) {
        this.copySpots(sourceArray, false);
    }

    public void copySpots(SpotsArray sourceArray, boolean includeMeasurements) {
        if (sourceArray == null) {
            return;
        }
        this.spotsList.clear();
        for (Spot sourceSpot : sourceArray.getSpotsList()) {
            Spot spot = new Spot(sourceSpot, includeMeasurements);
            this.spotsList.add(spot);
        }
    }

    public void pasteSpotsInfo(SpotsArray targetArray) {
        this.pasteSpots(targetArray, false);
    }

    public void pasteSpots(SpotsArray targetArray, boolean includeMeasurements) {
        if (targetArray == null) {
            return;
        }
        block0: for (Spot targetSpot : targetArray.getSpotsList()) {
            for (Spot sourceSpot : this.spotsList) {
                if (sourceSpot.compareTo(targetSpot) != 0) continue;
                targetSpot.copyFrom(sourceSpot, includeMeasurements);
                continue block0;
            }
        }
    }

    public void mergeSpots(SpotsArray sourceArray) {
        if (sourceArray == null) {
            return;
        }
        for (Spot sourceSpot : sourceArray.getSpotsList()) {
            if (this.isSpotPresent(sourceSpot)) continue;
            this.spotsList.add(sourceSpot);
        }
    }

    public void adjustSpotsLevel2DMeasuresToImageWidth(int imageWidth) {
        this.spotsList.forEach(spot -> spot.adjustLevel2DMeasuresToImageWidth(imageWidth));
    }

    public void cropSpotsLevel2DMeasuresToImageWidth(int imageWidth) {
        this.spotsList.forEach(spot -> spot.cropLevel2DMeasuresToImageWidth(imageWidth));
    }

    public void initializeLevel2DMeasures() {
        this.spotsList.forEach(Spot::initializeLevel2DMeasures);
    }

    public void transferMeasuresToLevel2D() {
        this.spotsList.forEach(Spot::transferMeasuresToLevel2D);
    }

    public TIntervalsArray getTimeIntervals() {
        return this.timeIntervals;
    }

    public void setTimeIntervals(TIntervalsArray timeIntervals) {
        this.timeIntervals = timeIntervals;
    }

    public int findFirstTimeInterval(long intervalT) {
        return this.timeIntervals != null ? this.timeIntervals.findStartItem(intervalT) : -1;
    }

    public long getTimeIntervalAt(int selectedItem) {
        return this.timeIntervals != null ? this.timeIntervals.getTIntervalAt((int)selectedItem).start : -1L;
    }

    public int addTimeInterval(long start) {
        if (this.timeIntervals == null) {
            this.timeIntervals = new TIntervalsArray();
        }
        return this.timeIntervals.addIfNew(new TInterval(start, -1L));
    }

    public void deleteTimeInterval(long start) {
        if (this.timeIntervals != null) {
            this.timeIntervals.deleteIntervalStartingAt(start);
        }
    }

    public void medianFilterFromSumToSumClean() {
        int span = 10;
        this.spotsList.forEach(spot -> {
            SpotMeasure sumIn = spot.getSum();
            SpotMeasure sumClean = spot.getSumClean();
            if (sumIn != null && sumClean != null) {
                sumClean.buildRunningMedianFromValuesArray(span, sumIn.getValues());
            }
        });
    }

    public double getScalingFactorToPhysicalUnits(EnumXLSExport xlsOption) {
        return 1.0;
    }

    public Polygon2D get2DPolygonEnclosingSpots() {
        if (this.spotsList.isEmpty()) {
            return new Polygon2D();
        }
        return new Polygon2D();
    }

    public void setFilterOfSpotsToAnalyze(boolean setFilter, BuildSeriesOptions options) {
        this.spotsList.forEach(spot -> spot.setReadyForAnalysis(setFilter));
    }

    private boolean saveListOfSpotsToXml(Node node) {
        Element spotsNode = XMLUtil.getElement((Node)node, (String)ID_SPOTTRACK);
        if (spotsNode == null) {
            return false;
        }
        XMLUtil.setElementIntValue((Node)spotsNode, (String)"version", (int)2);
        Element nodeSpotsArray = XMLUtil.setElement((Node)spotsNode, (String)ID_LISTOFSPOTS);
        XMLUtil.setElementIntValue((Node)nodeSpotsArray, (String)ID_NSPOTS, (int)this.spotsList.size());
        this.sortSpots();
        for (int i = 0; i < this.spotsList.size(); ++i) {
            Element nodeSpot = XMLUtil.setElement((Node)spotsNode, (String)(ID_SPOT_ + i));
            this.spotsList.get(i).saveToXml(nodeSpot);
        }
        return true;
    }

    private boolean loadSpotsOnlyV1(Document doc) {
        Element node = XMLUtil.getElement((Node)XMLUtil.getRootElement((Document)doc), (String)ID_SPOTTRACK);
        if (node == null) {
            return false;
        }
        Element nodeSpotsArray = XMLUtil.getElement((Node)node, (String)ID_LISTOFSPOTS);
        if (nodeSpotsArray == null) {
            return false;
        }
        int nitems = XMLUtil.getElementIntValue((Node)nodeSpotsArray, (String)ID_NSPOTS, (int)0);
        this.spotsList.clear();
        for (int i = 0; i < nitems; ++i) {
            Spot spot;
            Element nodeSpot = XMLUtil.getElement((Node)node, (String)(ID_SPOT_ + i));
            if (nodeSpot == null || !(spot = new Spot()).loadFromXml(nodeSpot) || this.isSpotPresent(spot)) continue;
            this.spotsList.add(spot);
        }
        return true;
    }

    private boolean csvLoadSpots(String directory, EnumSpotMeasures measureType) throws Exception {
        Path csvPath = Paths.get(directory, CSV_FILENAME);
        if (!Files.exists(csvPath, new LinkOption[0])) {
            return false;
        }
        try (BufferedReader reader = new BufferedReader(new FileReader(csvPath.toFile()));){
            String line;
            String sep = CSV_SEPARATOR;
            block16: while ((line = reader.readLine()) != null) {
                String[] data;
                if (line.charAt(0) == '#') {
                    sep = String.valueOf(line.charAt(1));
                }
                if (!(data = line.split(sep))[0].equals("#")) continue;
                switch (data[1]) {
                    case "SPOTS_ARRAY": {
                        this.csvLoadSpotsDescription(reader, sep);
                        continue block16;
                    }
                    case "SPOTS": {
                        this.csvLoadSpotsArray(reader, sep);
                        continue block16;
                    }
                }
                EnumSpotMeasures measure = EnumSpotMeasures.findByText(data[1]);
                if (measure == null) continue;
                this.csvLoadSpotsMeasures(reader, measure, sep);
            }
            reader.close();
            boolean bl = true;
            return bl;
        }
    }

    private String csvLoadSpotsArray(BufferedReader reader, String csvSeparator) throws IOException {
        String line = reader.readLine();
        while ((line = reader.readLine()) != null) {
            String[] spotData = line.split(csvSeparator);
            if (spotData[0].equals("#")) {
                return spotData[1];
            }
            Spot spot = this.findSpotByName(spotData[0]);
            if (spot != null) continue;
            spot = new Spot();
            this.spotsList.add(spot);
            spot.getProperties().importFromCsv(spotData);
        }
        return null;
    }

    private String csvLoadSpotsDescription(BufferedReader reader, String csvSeparator) throws IOException {
        String line = reader.readLine();
        String[] data = line.split(csvSeparator);
        String motif = data[0].substring(0, Math.min(data[0].length(), 6));
        if (motif.equals("n spot")) {
            int nspots = Integer.valueOf(data[1]);
            if (nspots < this.spotsList.size()) {
                this.spotsList.subList(nspots, this.spotsList.size()).clear();
            }
            if ((line = reader.readLine()) != null) {
                data = line.split(csvSeparator);
            }
        }
        if (data[0].equals("#")) {
            return data[1];
        }
        return null;
    }

    private String csvLoadSpotsMeasures(BufferedReader reader, EnumSpotMeasures measureType, String csvSeparator) throws IOException {
        String line = reader.readLine();
        boolean y = true;
        boolean x = line.contains("xi");
        while ((line = reader.readLine()) != null) {
            String[] data = line.split(csvSeparator);
            if (data[0].equals("#")) {
                return data[1];
            }
            Spot spot = this.findSpotByName(data[0]);
            if (spot == null) {
                spot = new Spot();
                this.spotsList.add(spot);
            }
            spot.importMeasuresOneType(measureType, data, x, y);
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean csvSaveSpots(String directory) {
        Path csvPath = Paths.get(directory, CSV_FILENAME);
        try (FileWriter writer = new FileWriter(csvPath.toFile());){
            if (!this.csvSaveSpotsArraySection(writer)) {
                boolean bl = false;
                return bl;
            }
            if (!this.csvSaveMeasuresSection(writer, EnumSpotMeasures.AREA_SUM)) {
                boolean bl = false;
                return bl;
            }
            if (!this.csvSaveMeasuresSection(writer, EnumSpotMeasures.AREA_SUMCLEAN)) {
                boolean bl = false;
                return bl;
            }
            boolean bl = true;
            return bl;
        }
        catch (IOException e) {
            System.err.println("Error saving spots to CSV: " + e.getMessage());
            return false;
        }
    }

    private boolean csvSaveSpotsArraySection(FileWriter writer) throws IOException {
        writer.write("#;#\n");
        writer.write("#;SPOTS_ARRAY;multiSPOTS96 data\n");
        writer.write("n spots=;" + this.spotsList.size() + "\n");
        writer.write("#;#\n");
        writer.write("#;SPOTS;multiSPOTS96 data\n");
        writer.write("name;index;cageID;cagePos;cageColumn;cageRow;volume;npixels;radius;stim;conc\n");
        for (Spot spot : this.spotsList) {
            writer.write(spot.getProperties().exportToCsv(CSV_SEPARATOR));
        }
        return true;
    }

    private boolean csvSaveMeasuresSection(FileWriter writer, EnumSpotMeasures measureType) throws IOException {
        writer.write("#;#\n");
        writer.write("#;" + measureType.toString() + CSV_SEPARATOR + "v0\n");
        writer.write("name;index;npts;yi\n");
        for (Spot spot : this.spotsList) {
            writer.write(spot.exportMeasuresOneType(measureType, CSV_SEPARATOR));
        }
        return true;
    }

    public String toString() {
        return String.format("SpotsArray{spotsCount=%d, hasTimeIntervals=%b}", this.spotsList.size(), this.timeIntervals != null);
    }
}

