/*
 * Decompiled with CFR 0.152.
 */
package plugins.fmp.multiSPOTS96.experiment.spots;

import java.util.List;
import java.util.Optional;

public class SpotsDataOperationResult {
    private final boolean success;
    private final int processedCount;
    private final int failedCount;
    private final List<String> processedItems;
    private final List<String> failedItems;
    private final Optional<Exception> lastError;
    private final String message;
    private final long processingTimeMs;
    private final String operationType;

    private SpotsDataOperationResult(Builder builder) {
        this.success = builder.success;
        this.processedCount = builder.processedCount;
        this.failedCount = builder.failedCount;
        this.processedItems = builder.processedItems != null ? List.copyOf(builder.processedItems) : List.of();
        this.failedItems = builder.failedItems != null ? List.copyOf(builder.failedItems) : List.of();
        this.lastError = Optional.ofNullable(builder.lastError);
        this.message = builder.message;
        this.processingTimeMs = builder.processingTimeMs;
        this.operationType = builder.operationType;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static SpotsDataOperationResult success(String operationType, int processedCount, String message) {
        return SpotsDataOperationResult.builder().success(true).operationType(operationType).processedCount(processedCount).message(message).build();
    }

    public static SpotsDataOperationResult failure(String operationType, Exception error, String message) {
        return SpotsDataOperationResult.builder().success(false).operationType(operationType).lastError(error).message(message).build();
    }

    public static SpotsDataOperationResult partial(String operationType, int processedCount, int failedCount, String message) {
        return SpotsDataOperationResult.builder().success(processedCount > 0).operationType(operationType).processedCount(processedCount).failedCount(failedCount).message(message).build();
    }

    public boolean isSuccess() {
        return this.success;
    }

    public int getProcessedCount() {
        return this.processedCount;
    }

    public int getFailedCount() {
        return this.failedCount;
    }

    public List<String> getProcessedItems() {
        return this.processedItems;
    }

    public List<String> getFailedItems() {
        return this.failedItems;
    }

    public Optional<Exception> getLastError() {
        return this.lastError;
    }

    public String getMessage() {
        return this.message;
    }

    public long getProcessingTimeMs() {
        return this.processingTimeMs;
    }

    public String getOperationType() {
        return this.operationType;
    }

    public int getTotalCount() {
        return this.processedCount + this.failedCount;
    }

    public double getSuccessRate() {
        int total = this.getTotalCount();
        return total > 0 ? (double)this.processedCount / (double)total : 0.0;
    }

    public boolean hasErrors() {
        return this.failedCount > 0 || this.lastError.isPresent();
    }

    public boolean hasPartialFailure() {
        return this.processedCount > 0 && this.failedCount > 0;
    }

    public Builder toBuilder() {
        return SpotsDataOperationResult.builder().success(this.success).processedCount(this.processedCount).failedCount(this.failedCount).processedItems(this.processedItems).failedItems(this.failedItems).lastError(this.lastError.orElse(null)).message(this.message).processingTimeMs(this.processingTimeMs).operationType(this.operationType);
    }

    public String toString() {
        return String.format("SpotsDataOperationResult{type='%s', success=%b, processed=%d, failed=%d, time=%dms, message='%s'}", this.operationType, this.success, this.processedCount, this.failedCount, this.processingTimeMs, this.message);
    }

    public static class Builder {
        private boolean success = true;
        private int processedCount = 0;
        private int failedCount = 0;
        private List<String> processedItems;
        private List<String> failedItems;
        private Exception lastError;
        private String message = "";
        private long processingTimeMs = 0L;
        private String operationType = "UNKNOWN";

        public Builder success(boolean success) {
            this.success = success;
            return this;
        }

        public Builder processedCount(int processedCount) {
            this.processedCount = processedCount;
            return this;
        }

        public Builder failedCount(int failedCount) {
            this.failedCount = failedCount;
            return this;
        }

        public Builder processedItems(List<String> processedItems) {
            this.processedItems = processedItems;
            return this;
        }

        public Builder failedItems(List<String> failedItems) {
            this.failedItems = failedItems;
            return this;
        }

        public Builder lastError(Exception lastError) {
            this.lastError = lastError;
            return this;
        }

        public Builder message(String message) {
            this.message = message;
            return this;
        }

        public Builder processingTimeMs(long processingTimeMs) {
            this.processingTimeMs = processingTimeMs;
            return this;
        }

        public Builder operationType(String operationType) {
            this.operationType = operationType;
            return this;
        }

        public SpotsDataOperationResult build() {
            return new SpotsDataOperationResult(this);
        }
    }
}

