/*
 * Decompiled with CFR 0.152.
 */
package plugins.fmp.multiSPOTS96.series;

import icy.gui.frame.progress.ProgressFrame;
import icy.gui.viewer.Viewer;
import icy.image.IcyBufferedImage;
import icy.roi.ROI;
import icy.sequence.Sequence;
import icy.system.thread.Processor;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import javax.imageio.ImageIO;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import plugins.fmp.multiSPOTS96.experiment.Experiment;
import plugins.fmp.multiSPOTS96.series.BuildSeriesOptions;
import plugins.fmp.multiSPOTS96.tools.JComponents.JComboBoxExperiment;
import plugins.fmp.multiSPOTS96.tools.ViewerFMP;
import plugins.kernel.roi.roi2d.ROI2DRectangle;

public abstract class BuildSeries
extends SwingWorker<Integer, Integer> {
    public BuildSeriesOptions options = new BuildSeriesOptions();
    public boolean stopFlag = false;
    public boolean threadRunning = false;
    int nframescomputed = 0;
    int nframestotal = 0;
    int selectedExperimentIndex = -1;
    Sequence seqNegative = null;
    ViewerFMP vNegative = null;
    public final String THREAD_ENDED = "thread_ended";
    public final String THREAD_DONE = "thread_done";

    @Override
    protected Integer doInBackground() throws Exception {
        System.out.println("BuildSeries:doInBackground loop over experiments");
        this.threadRunning = true;
        int nbiterations = 0;
        JComboBoxExperiment expList = this.options.expList;
        ProgressFrame progress = new ProgressFrame("Analyze series");
        this.selectedExperimentIndex = expList.getSelectedIndex();
        this.selectList(expList, -1);
        int index = expList.index0;
        while (index <= expList.index1 && !this.stopFlag) {
            long startTimeInNs = System.nanoTime();
            Experiment exp = (Experiment)expList.getItemAt(index);
            progress.setMessage("Processing file: " + (index + 1) + "//" + (expList.index1 + 1));
            System.out.println("BuildSeries:doInBackground " + (index + 1) + ": " + exp.getResultsDirectory());
            exp.setBinSubDirectory(this.options.binSubDirectory);
            boolean flag = exp.createDirectoryIfDoesNotExist(exp.getKymosBinFullDirectory());
            if (flag) {
                this.analyzeExperiment(exp);
                long endTime2InNs = System.nanoTime();
                System.out.println("BuildSeries:doInBackground process ended - duration: " + (float)(endTime2InNs - startTimeInNs) / 1.0E9f + " s");
            } else {
                System.out.println("BuildSeries:doInBackground process aborted - subdirectory not created: " + exp.getKymosBinFullDirectory());
            }
            System.gc();
            ++index;
            ++nbiterations;
        }
        progress.close();
        this.threadRunning = false;
        this.selectList(expList, this.selectedExperimentIndex);
        return nbiterations;
    }

    private void selectList(final JComboBoxExperiment expList, final int index) {
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    expList.setSelectedIndex(index);
                }
            });
        }
        catch (InterruptedException | InvocationTargetException e) {
            e.printStackTrace();
        }
    }

    @Override
    protected void done() {
        int statusMsg = 0;
        try {
            statusMsg = (Integer)super.get();
        }
        catch (InterruptedException | ExecutionException e) {
            e.printStackTrace();
        }
        if (!this.threadRunning || this.stopFlag) {
            this.firePropertyChange("thread_ended", null, statusMsg);
        } else {
            this.firePropertyChange("thread_done", null, statusMsg);
        }
    }

    abstract void analyzeExperiment(Experiment var1);

    protected void waitFuturesCompletion(Processor processor, ArrayList<Future<?>> futuresArray, ProgressFrame progressBar) {
        int frame = 1;
        this.nframescomputed = futuresArray.size();
        this.nframestotal = 0;
        while (!futuresArray.isEmpty()) {
            Future<?> f = futuresArray.get(futuresArray.size() - 1);
            if (progressBar != null) {
                progressBar.setMessage("Analyze frame: " + this.nframestotal + "//" + this.nframescomputed);
            }
            try {
                f.get();
            }
            catch (ExecutionException e) {
                System.out.println("BuildSeries:waitFuturesCompletion - frame:" + frame + " Execution exception: " + e);
            }
            catch (InterruptedException e) {
                System.out.println("BuildSeries:waitFuturesCompletion - Interrupted exception: " + e);
            }
            futuresArray.remove(f);
            ++frame;
        }
    }

    protected boolean checkBoundsForCages(Experiment exp) {
        exp.cagesArray.detectBin_Ms = this.options.t_Ms_BinDuration;
        if (this.options.isFrameFixed) {
            exp.cagesArray.detectFirst_Ms = this.options.t_Ms_First;
            exp.cagesArray.detectLast_Ms = this.options.t_Ms_Last;
            if (exp.cagesArray.detectLast_Ms > exp.seqCamData.getLastImageMs()) {
                exp.cagesArray.detectLast_Ms = exp.seqCamData.getLastImageMs();
            }
        } else {
            exp.cagesArray.detectFirst_Ms = exp.seqCamData.getFirstImageMs();
            exp.cagesArray.detectLast_Ms = exp.seqCamData.getLastImageMs();
        }
        exp.cagesArray.detect_threshold = this.options.threshold;
        boolean flag = true;
        if (exp.cagesArray.cagesList.size() < 1) {
            System.out.println("BuildSeries:checkBoundsForCages ! skipped experiment with no cage: " + exp.getResultsDirectory());
            flag = false;
        }
        return flag;
    }

    protected void getTimeLimitsOfSequence(Experiment exp) {
        exp.getFileIntervalsFromSeqCamData();
        if (exp.seqCamData.getTimeManager().getBinImage_ms() == 0L) {
            exp.loadFileIntervalsFromSeqCamData();
        }
        exp.seqCamData.getTimeManager().setBinDurationMs(exp.seqCamData.getTimeManager().getBinImage_ms());
        if (this.options.isFrameFixed) {
            exp.seqCamData.getTimeManager().setBinFirst_ms(this.options.t_Ms_First);
            exp.seqCamData.getTimeManager().setBinLast_ms(this.options.t_Ms_Last);
            if (exp.seqCamData.getTimeManager().getBinLast_ms() + exp.seqCamData.getFirstImageMs() > exp.seqCamData.getLastImageMs()) {
                exp.seqCamData.getTimeManager().setBinLast_ms(exp.seqCamData.getLastImageMs() - exp.seqCamData.getFirstImageMs());
            }
        } else {
            exp.seqCamData.getTimeManager().setBinFirst_ms(0L);
            exp.seqCamData.getTimeManager().setBinLast_ms(exp.seqCamData.getLastImageMs() - exp.seqCamData.getFirstImageMs());
        }
    }

    public IcyBufferedImage imageIORead(String name) {
        BufferedImage image = null;
        try {
            image = ImageIO.read(new File(name));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return IcyBufferedImage.createFrom((BufferedImage)image);
    }

    protected boolean loadSeqCamDataAndCages(Experiment exp) {
        exp.seqCamData.attachSequence(exp.seqCamData.getImageLoader().initSequenceFromFirstImage(exp.seqCamData.getImagesList(true)));
        boolean flag = exp.load_MS96_cages();
        return flag;
    }

    void closeSequence(Sequence seq) {
        if (seq != null) {
            seq.close();
            seq = null;
        }
    }

    void closeViewer(Viewer v) {
        if (v != null) {
            v.close();
            v = null;
        }
    }

    Sequence newSequence(String title, IcyBufferedImage image) {
        Sequence seq = new Sequence();
        seq.setName(title);
        seq.setImage(0, 0, (BufferedImage)image);
        return seq;
    }

    void displayRectanglesAsROIs(Sequence seq, List<Rectangle2D> listRectangles, boolean eraseOldPoints) {
        if (eraseOldPoints) {
            seq.removeAllROI();
        }
        for (Rectangle2D rectangle : listRectangles) {
            ROI2DRectangle flyPoint = new ROI2DRectangle(rectangle);
            seq.addROI((ROI)flyPoint);
        }
    }

    void openFlyDetectViewers(final Experiment exp) {
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    BuildSeries.this.seqNegative = BuildSeries.this.newSequence("detectionImage", exp.seqCamData.getReferenceImage());
                    BuildSeries.this.vNegative = new ViewerFMP(BuildSeries.this.seqNegative, false, true);
                    BuildSeries.this.vNegative.setVisible(true);
                }
            });
        }
        catch (InterruptedException | InvocationTargetException e) {
            e.printStackTrace();
        }
    }
}

