/*
 * Decompiled with CFR 0.152.
 */
package plugins.fmp.multiSPOTS96.series;

import icy.file.Saver;
import icy.gui.frame.progress.ProgressFrame;
import icy.image.IcyBufferedImage;
import icy.image.IcyBufferedImageCursor;
import icy.image.IcyBufferedImageUtil;
import icy.sequence.Sequence;
import icy.system.SystemUtil;
import icy.system.thread.Processor;
import icy.type.DataType;
import java.awt.Point;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import javax.swing.SwingUtilities;
import loci.formats.FormatException;
import plugins.fmp.multiSPOTS96.experiment.Experiment;
import plugins.fmp.multiSPOTS96.experiment.cages.Cage;
import plugins.fmp.multiSPOTS96.experiment.sequence.KymographConfiguration;
import plugins.fmp.multiSPOTS96.experiment.sequence.SequenceCamData;
import plugins.fmp.multiSPOTS96.experiment.sequence.SequenceKymos;
import plugins.fmp.multiSPOTS96.experiment.spots.Spot;
import plugins.fmp.multiSPOTS96.experiment.spots.SpotsArray;
import plugins.fmp.multiSPOTS96.series.BuildSeries;
import plugins.fmp.multiSPOTS96.tools.GaspardRigidRegistration;
import plugins.fmp.multiSPOTS96.tools.ROI2D.ROI2DProcessingException;
import plugins.fmp.multiSPOTS96.tools.ROI2D.ROI2DValidationException;
import plugins.fmp.multiSPOTS96.tools.ROI2D.ROI2DWithMask;
import plugins.fmp.multiSPOTS96.tools.ViewerFMP;

public class BuildSpotsKymos
extends BuildSeries {
    public Sequence seqData = new Sequence();
    private ViewerFMP vData = null;
    private int kymoImageWidth = 0;

    @Override
    void analyzeExperiment(Experiment exp) {
        if (!this.loadExperimentDataToBuildKymos(exp) || exp.cagesArray.getTotalNumberOfSpots() < 1) {
            return;
        }
        this.openKymoViewers(exp);
        this.getTimeLimitsOfSequence(exp);
        if (this.buildKymo(exp)) {
            this.saveComputation(exp);
        }
        this.closeKymoViewers(exp);
    }

    private boolean loadExperimentDataToBuildKymos(Experiment exp) {
        boolean flag = exp.load_MS96_cages();
        exp.seqCamData.attachSequence(exp.seqCamData.getImageLoader().initSequenceFromFirstImage(exp.seqCamData.getImagesList(true)));
        return flag;
    }

    private void saveComputation(final Experiment exp) {
        String directory;
        if (this.options.doCreateBinDir) {
            exp.setBinSubDirectory(exp.getBinNameFromKymoFrameStep());
        }
        if ((directory = exp.getDirectoryToSaveResults()) == null) {
            return;
        }
        ProgressFrame progressBar = new ProgressFrame("Save kymographs");
        int nframes = exp.seqKymos.getSequence().getSizeT();
        int nCPUs = SystemUtil.getNumberOfCPUs();
        Processor processor = new Processor(nCPUs);
        processor.setThreadName("buildkymo2");
        processor.setPriority(5);
        ArrayList futuresArray = new ArrayList(nframes);
        futuresArray.clear();
        final SpotsArray spotsArray = exp.cagesArray.getAllSpotsArray();
        int t = 0;
        while (t < exp.seqKymos.getSequence().getSizeT()) {
            final int t_index = t++;
            futuresArray.add(processor.submit(new Runnable(){

                @Override
                public void run() {
                    Spot spot = spotsArray.getSpotsList().get(t_index);
                    String filename = directory + File.separator + spot.getRoi().getName() + ".tiff";
                    File file = new File(filename);
                    IcyBufferedImage image = exp.seqKymos.getSeqImage(t_index, 0);
                    try {
                        Saver.saveImage((IcyBufferedImage)image, (File)file, (boolean)true);
                    }
                    catch (FormatException e) {
                        e.printStackTrace();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }));
        }
        this.waitFuturesCompletion(processor, futuresArray, progressBar);
        progressBar.close();
        exp.save_MS96_experiment();
    }

    private boolean buildKymo(final Experiment exp) {
        if (exp.cagesArray.getTotalNumberOfSpots() < 1) {
            System.out.println("BuildKymoSpots:buildKymo Abort (1): nb spots = 0");
            return false;
        }
        this.initArraysToBuildKymographImages(exp);
        this.threadRunning = true;
        this.stopFlag = false;
        boolean iiFirst = false;
        int iiLast = exp.seqCamData.getImageLoader().getFixedNumberOfImages() > 0L ? (int)exp.seqCamData.getImageLoader().getFixedNumberOfImages() : exp.seqCamData.getImageLoader().getNTotalFrames();
        int iiDelta = (int)exp.seqKymos.getTimeManager().getDeltaImage();
        ProgressFrame progressBar1 = new ProgressFrame("Analyze stack frame ");
        Processor processor = new Processor(SystemUtil.getNumberOfCPUs());
        processor.setThreadName("buildKymograph");
        processor.setPriority(5);
        int ntasks = iiLast - 0;
        ArrayList tasks = new ArrayList(ntasks);
        tasks.clear();
        this.vData.setTitle(exp.seqCamData.getCSCamFileName());
        for (int ii = 0; ii < iiLast; ii += iiDelta) {
            final int t = ii;
            if (this.options.concurrentDisplay) {
                IcyBufferedImage sourceImage0 = this.imageIORead(exp.seqCamData.getFileNameFromImageList(t));
                this.seqData.setImage(0, 0, (BufferedImage)sourceImage0);
                this.vData.setTitle("Frame #" + ii + " /" + iiLast);
            }
            progressBar1.setMessage("Analyze frame: " + t + "//" + iiLast);
            final IcyBufferedImage sourceImage = this.loadImageFromIndex(exp, t);
            tasks.add(processor.submit(new Runnable(){

                @Override
                public void run() {
                    int sizeC = sourceImage.getSizeC();
                    IcyBufferedImageCursor cursorSource = new IcyBufferedImageCursor(sourceImage);
                    for (Cage cage : exp.cagesArray.cagesList) {
                        for (Spot spot : cage.spotsArray.getSpotsList()) {
                            BuildSpotsKymos.this.analyzeImageWithSpot2(cursorSource, spot, t - 0, sizeC);
                        }
                    }
                }
            }));
        }
        this.waitFuturesCompletion(processor, tasks, null);
        progressBar1.close();
        ProgressFrame progressBar2 = new ProgressFrame("Combine results into kymograph");
        int sizeC = this.seqData.getSizeC();
        this.exportSpotImages_to_Kymograph(exp, sizeC);
        progressBar2.close();
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void analyzeImageWithSpot2(IcyBufferedImageCursor cursorSource, Spot spot, int t, int sizeC) {
        ROI2DWithMask roiT = spot.getROIMask();
        Point[] maskPoints = roiT.getMaskPoints();
        if (maskPoints == null) {
            return;
        }
        for (int chan = 0; chan < sizeC; ++chan) {
            IcyBufferedImageCursor cursor = new IcyBufferedImageCursor(spot.getSpotImage());
            try {
                int i = 0;
                for (int j = roiT.getYMin(); j < roiT.getYMax(); ++j) {
                    double iSum = 0.0;
                    int iN = 0;
                    for (int y = 0; y < maskPoints.length; ++y) {
                        Point pt = maskPoints[y];
                        if (pt.y != j) continue;
                        iSum += cursorSource.get((int)pt.getX(), (int)pt.getY(), chan);
                        ++iN;
                    }
                    if (iN == 0) {
                        iN = 1;
                    }
                    cursor.set(t, i, chan, iSum / (double)iN);
                    ++i;
                }
                continue;
            }
            finally {
                cursor.commitChanges();
            }
        }
    }

    private IcyBufferedImage loadImageFromIndex(Experiment exp, int frameIndex) {
        IcyBufferedImage sourceImage = this.imageIORead(exp.seqCamData.getFileNameFromImageList(frameIndex));
        if (this.options.doRegistration) {
            String referenceImageName = exp.seqCamData.getFileNameFromImageList(this.options.referenceFrame);
            IcyBufferedImage referenceImage = this.imageIORead(referenceImageName);
            this.adjustImage(sourceImage, referenceImage);
        }
        return sourceImage;
    }

    private void exportSpotImages_to_Kymograph(Experiment exp, int sizeC) {
        final Sequence seqKymo = exp.seqKymos.getSequence();
        seqKymo.beginUpdate();
        Processor processor = new Processor(SystemUtil.getNumberOfCPUs());
        processor.setThreadName("buildKymograph");
        processor.setPriority(5);
        int nbspots = exp.cagesArray.getTotalNumberOfSpots();
        ArrayList tasks = new ArrayList(nbspots);
        tasks.clear();
        final int vertical_resolution = this.getMaxImageHeight(exp);
        int indexSpot = 0;
        for (Cage cage : exp.cagesArray.cagesList) {
            for (final Spot spot : cage.spotsArray.getSpotsList()) {
                final int indexSpotKymo = indexSpot++;
                tasks.add(processor.submit(new Runnable(){

                    @Override
                    public void run() {
                        IcyBufferedImage kymoImage = IcyBufferedImageUtil.scale((IcyBufferedImage)spot.getSpotImage(), (int)spot.getSpotImage().getWidth(), (int)vertical_resolution);
                        seqKymo.setImage(indexSpotKymo, 0, (BufferedImage)kymoImage);
                        spot.setSpotImage(null);
                    }
                }));
            }
        }
        this.waitFuturesCompletion(processor, tasks, null);
        seqKymo.endUpdate();
    }

    private int getMaxImageHeight(Experiment exp) {
        int maxImageHeight = 0;
        for (Cage cage : exp.cagesArray.cagesList) {
            for (Spot spot : cage.spotsArray.getSpotsList()) {
                int height = spot.getSpotImage().getHeight();
                if (height <= maxImageHeight) continue;
                maxImageHeight = height;
            }
        }
        return maxImageHeight;
    }

    private void initArraysToBuildKymographImages(Experiment exp) {
        DataType dataType;
        if (exp.seqKymos == null) {
            exp.seqKymos = SequenceKymos.kymographBuilder().withConfiguration(KymographConfiguration.qualityProcessing()).build();
        }
        SequenceKymos seqKymos = exp.seqKymos;
        seqKymos.attachSequence(new Sequence());
        SequenceCamData seqCamData = exp.seqCamData;
        if (seqCamData.getSequence() == null) {
            seqCamData.attachSequence(exp.seqCamData.getImageLoader().initSequenceFromFirstImage(exp.seqCamData.getImagesList(true)));
        }
        this.kymoImageWidth = exp.seqCamData.getImageLoader().getNTotalFrames();
        int numC = seqCamData.getSequence().getSizeC();
        if (numC <= 0) {
            numC = 3;
        }
        if ((dataType = seqCamData.getSequence().getDataType_()).toString().equals("undefined")) {
            dataType = DataType.UBYTE;
        }
        for (Cage cage : exp.cagesArray.cagesList) {
            for (Spot spot : cage.spotsArray.getSpotsList()) {
                int imageHeight = 0;
                ROI2DWithMask roiT = null;
                try {
                    roiT = new ROI2DWithMask(spot.getRoi());
                    roiT.buildMask2DFromInputRoi();
                    int imageHeight_i = roiT.getMask2DHeight();
                    if (imageHeight_i > imageHeight) {
                        imageHeight = imageHeight_i;
                    }
                }
                catch (ROI2DProcessingException | ROI2DValidationException e) {
                    System.err.println("Error getting mask height for ROI at time " + spot.getRoi().getName() + ": " + e.getMessage());
                    e.printStackTrace();
                }
                spot.setROIMask(roiT);
                spot.setSpotImage(new IcyBufferedImage(this.kymoImageWidth, imageHeight, numC, dataType));
            }
        }
    }

    private void adjustImage(IcyBufferedImage workImage, IcyBufferedImage referenceImage) {
        int referenceChannel = 0;
        GaspardRigidRegistration.getTranslation2D(workImage, referenceImage, referenceChannel);
        boolean rotate = GaspardRigidRegistration.correctRotation2D(workImage, referenceImage, referenceChannel);
        if (rotate) {
            GaspardRigidRegistration.getTranslation2D(workImage, referenceImage, referenceChannel);
        }
    }

    private void closeKymoViewers(Experiment exp) {
        this.closeViewer(this.vData);
        this.closeSequence(this.seqData);
        exp.seqKymos.closeSequence();
    }

    private void openKymoViewers(final Experiment exp) {
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    BuildSpotsKymos.this.seqData = BuildSpotsKymos.this.newSequence("analyze stack starting with file " + exp.seqCamData.getSequence().getName(), exp.seqCamData.getSeqImage(0, 0));
                    BuildSpotsKymos.this.vData = new ViewerFMP(BuildSpotsKymos.this.seqData, true, true);
                }
            });
        }
        catch (InterruptedException | InvocationTargetException e) {
            e.printStackTrace();
        }
    }
}

