/*
 * Decompiled with CFR 0.152.
 */
package plugins.fmp.multiSPOTS96.series.options;

import plugins.fmp.multiSPOTS96.series.BuildSeriesOptions;

public class TimeOptions {
    private final boolean isFrameFixed;
    private final long firstMs;
    private final long lastMs;
    private final long binDurationMs;
    private final long fromFrame;
    private final int referenceFrame;
    private final int seriesFirst;
    private final int seriesLast;
    private final int backgroundNFrames;
    private final int backgroundFirst;
    private final boolean runBackwards;
    private final boolean analyzePartOnly;

    private TimeOptions(Builder builder) {
        this.isFrameFixed = builder.isFrameFixed;
        this.firstMs = this.validateTimeMs(builder.firstMs, "firstMs");
        this.lastMs = this.validateTimeMs(builder.lastMs, "lastMs");
        this.binDurationMs = this.validateBinDurationMs(builder.binDurationMs);
        this.fromFrame = this.validateFrameIndex(builder.fromFrame, "fromFrame");
        this.referenceFrame = (int)this.validateFrameIndex(builder.referenceFrame, "referenceFrame");
        this.seriesFirst = (int)this.validateFrameIndex(builder.seriesFirst, "seriesFirst");
        this.seriesLast = (int)this.validateFrameIndex(builder.seriesLast, "seriesLast");
        this.backgroundNFrames = this.validateBackgroundNFrames(builder.backgroundNFrames);
        this.backgroundFirst = (int)this.validateFrameIndex(builder.backgroundFirst, "backgroundFirst");
        this.runBackwards = builder.runBackwards;
        this.analyzePartOnly = builder.analyzePartOnly;
        this.validateTimeRelationships();
    }

    public boolean isFrameFixed() {
        return this.isFrameFixed;
    }

    public long getFirstMs() {
        return this.firstMs;
    }

    public long getLastMs() {
        return this.lastMs;
    }

    public long getBinDurationMs() {
        return this.binDurationMs;
    }

    public long getFromFrame() {
        return this.fromFrame;
    }

    public int getReferenceFrame() {
        return this.referenceFrame;
    }

    public int getSeriesFirst() {
        return this.seriesFirst;
    }

    public int getSeriesLast() {
        return this.seriesLast;
    }

    public int getBackgroundNFrames() {
        return this.backgroundNFrames;
    }

    public int getBackgroundFirst() {
        return this.backgroundFirst;
    }

    public boolean isRunBackwards() {
        return this.runBackwards;
    }

    public boolean isAnalyzePartOnly() {
        return this.analyzePartOnly;
    }

    private long validateTimeMs(long timeMs, String fieldName) {
        if (timeMs < 0L) {
            throw new IllegalArgumentException(fieldName + " must be non-negative, got: " + timeMs);
        }
        return timeMs;
    }

    private long validateBinDurationMs(long binDurationMs) {
        if (binDurationMs < 1L) {
            throw new IllegalArgumentException("Bin duration must be positive, got: " + binDurationMs);
        }
        return binDurationMs;
    }

    private long validateFrameIndex(long frameIndex, String fieldName) {
        if (frameIndex < 0L) {
            throw new IllegalArgumentException(fieldName + " must be non-negative, got: " + frameIndex);
        }
        return frameIndex;
    }

    private int validateBackgroundNFrames(int backgroundNFrames) {
        if (backgroundNFrames < 1) {
            throw new IllegalArgumentException("Background number of frames must be positive, got: " + backgroundNFrames);
        }
        return backgroundNFrames;
    }

    private void validateTimeRelationships() {
        if (this.isFrameFixed && this.firstMs > this.lastMs) {
            throw new IllegalArgumentException("First time (" + this.firstMs + ") cannot be greater than last time (" + this.lastMs + ")");
        }
        if (this.seriesFirst > this.seriesLast && this.seriesLast > 0) {
            throw new IllegalArgumentException("Series first (" + this.seriesFirst + ") cannot be greater than series last (" + this.seriesLast + ")");
        }
    }

    public static Builder builder() {
        return new Builder();
    }

    public static TimeOptions fromLegacyOptions(BuildSeriesOptions legacy) {
        return TimeOptions.builder().frameFixed(legacy.isFrameFixed).firstMs(legacy.t_Ms_First).lastMs(legacy.t_Ms_Last).binDurationMs(legacy.t_Ms_BinDuration).fromFrame(legacy.fromFrame).referenceFrame(legacy.referenceFrame).seriesFirst(legacy.seriesFirst).seriesLast(legacy.seriesLast).backgroundNFrames(legacy.backgroundNFrames).backgroundFirst(legacy.backgroundFirst).runBackwards(legacy.runBackwards).analyzePartOnly(legacy.analyzePartOnly).build();
    }

    public static class Builder {
        private boolean isFrameFixed = false;
        private long firstMs = 0L;
        private long lastMs = 0L;
        private long binDurationMs = 1L;
        private long fromFrame = 0L;
        private int referenceFrame = 0;
        private int seriesFirst = 0;
        private int seriesLast = 0;
        private int backgroundNFrames = 60;
        private int backgroundFirst = 0;
        private boolean runBackwards = false;
        private boolean analyzePartOnly = false;

        public Builder frameFixed(boolean isFrameFixed) {
            this.isFrameFixed = isFrameFixed;
            return this;
        }

        public Builder firstMs(long firstMs) {
            this.firstMs = firstMs;
            return this;
        }

        public Builder lastMs(long lastMs) {
            this.lastMs = lastMs;
            return this;
        }

        public Builder binDurationMs(long binDurationMs) {
            this.binDurationMs = binDurationMs;
            return this;
        }

        public Builder fromFrame(long fromFrame) {
            this.fromFrame = fromFrame;
            return this;
        }

        public Builder referenceFrame(int referenceFrame) {
            this.referenceFrame = referenceFrame;
            return this;
        }

        public Builder seriesFirst(int seriesFirst) {
            this.seriesFirst = seriesFirst;
            return this;
        }

        public Builder seriesLast(int seriesLast) {
            this.seriesLast = seriesLast;
            return this;
        }

        public Builder backgroundNFrames(int backgroundNFrames) {
            this.backgroundNFrames = backgroundNFrames;
            return this;
        }

        public Builder backgroundFirst(int backgroundFirst) {
            this.backgroundFirst = backgroundFirst;
            return this;
        }

        public Builder runBackwards(boolean runBackwards) {
            this.runBackwards = runBackwards;
            return this;
        }

        public Builder analyzePartOnly(boolean analyzePartOnly) {
            this.analyzePartOnly = analyzePartOnly;
            return this;
        }

        public TimeOptions build() {
            return new TimeOptions(this);
        }
    }
}

