/*
 * Decompiled with CFR 0.152.
 */
package plugins.fmp.multiSPOTS96.tools;

import icy.sequence.Sequence;
import java.util.List;
import java.util.logging.Logger;
import plugins.nherve.toolbox.image.feature.DefaultClusteringAlgorithmImpl;
import plugins.nherve.toolbox.image.feature.IcySupportRegion;
import plugins.nherve.toolbox.image.feature.Segmentable;
import plugins.nherve.toolbox.image.feature.SegmentableIcyBufferedImage;
import plugins.nherve.toolbox.image.feature.Signature;
import plugins.nherve.toolbox.image.feature.clustering.KMeans;
import plugins.nherve.toolbox.image.feature.descriptor.ColorPixel;
import plugins.nherve.toolbox.image.feature.descriptor.DefaultDescriptorImpl;
import plugins.nherve.toolbox.image.feature.region.GridFactory;
import plugins.nherve.toolbox.image.feature.region.SupportRegionException;
import plugins.nherve.toolbox.image.feature.signature.SignatureException;
import plugins.nherve.toolbox.image.feature.signature.VectorSignature;
import plugins.nherve.toolbox.image.mask.MaskException;
import plugins.nherve.toolbox.image.segmentation.DefaultSegmentationAlgorithm;
import plugins.nherve.toolbox.image.segmentation.Segmentation;
import plugins.nherve.toolbox.image.segmentation.SegmentationException;

public class ImageKMeans {
    private static final Logger LOGGER = Logger.getLogger(ImageKMeans.class.getName());
    private static final int DEFAULT_NUM_CLUSTERS = 5;
    private static final int DEFAULT_NUM_ITERATIONS = 100;
    private static final double DEFAULT_STABILITY_THRESHOLD = 0.01;
    private static final int DEFAULT_COLOR_SPACE = 0;

    public static Segmentation doClustering(Sequence seq, int nbc2, int nbi2, double stab2, int cs) throws SupportRegionException, SegmentationException, MaskException, NumberFormatException, SignatureException {
        if (seq == null) {
            throw new IllegalArgumentException("Sequence cannot be null");
        }
        if (nbc2 <= 0) {
            throw new IllegalArgumentException("Number of clusters must be positive: " + nbc2);
        }
        if (nbi2 <= 0) {
            throw new IllegalArgumentException("Number of iterations must be positive: " + nbi2);
        }
        if (stab2 < 0.0) {
            throw new IllegalArgumentException("Stability threshold cannot be negative: " + stab2);
        }
        Segmentation segmentation = null;
        try {
            segmentation = ImageKMeans.doClusteringKM(seq, nbc2, nbi2, stab2, cs);
            if (segmentation != null) {
                segmentation.reInitColors(seq.getImage(0, 0));
            } else {
                LOGGER.warning("K-means clustering returned null result");
            }
        }
        catch (Exception e) {
            LOGGER.severe("Error during K-means clustering: " + e.getMessage());
            throw e;
        }
        return segmentation;
    }

    private static Segmentation doClusteringKM(Sequence currentSequence, int nbc2, int nbi2, double stab2, int cs) throws SupportRegionException, SegmentationException, MaskException, NumberFormatException, SignatureException {
        if (currentSequence == null) {
            throw new IllegalArgumentException("Current sequence cannot be null");
        }
        LOGGER.fine("Creating segmentable image from sequence");
        SegmentableIcyBufferedImage img = new SegmentableIcyBufferedImage(currentSequence.getFirstImage());
        LOGGER.fine("Configuring K-means algorithm");
        KMeans km2 = new KMeans(nbc2, nbi2, stab2);
        km2.setLogEnabled(false);
        Segmentation seg = null;
        ColorPixel col = null;
        LOGGER.fine("Setting up color pixel descriptor");
        ColorPixel cd = new ColorPixel(false);
        cd.setColorSpace(cs);
        col = cd;
        col.setLogEnabled(false);
        LOGGER.fine("Creating grid factory and extracting regions");
        GridFactory factory = new GridFactory(4);
        factory.setLogEnabled(false);
        List lRegions = factory.extractRegions((Segmentable)img);
        if (lRegions == null || lRegions.isEmpty()) {
            LOGGER.warning("No regions extracted from image");
            return null;
        }
        IcySupportRegion[] regions = new IcySupportRegion[lRegions.size()];
        int r = 0;
        for (IcySupportRegion sr : lRegions) {
            if (sr == null) continue;
            regions[r++] = sr;
        }
        LOGGER.fine("Extracted " + r + " regions from image");
        if (r == 0) {
            LOGGER.warning("No valid regions found after filtering");
            return null;
        }
        seg = ImageKMeans.doSingleClustering(img, regions, (DefaultDescriptorImpl<SegmentableIcyBufferedImage, ? extends Signature>)col, (DefaultClusteringAlgorithmImpl<VectorSignature>)km2);
        return seg;
    }

    private static Segmentation doSingleClustering(SegmentableIcyBufferedImage img, IcySupportRegion[] regions, DefaultDescriptorImpl<SegmentableIcyBufferedImage, ? extends Signature> descriptor, DefaultClusteringAlgorithmImpl<VectorSignature> algo) throws SupportRegionException, SegmentationException {
        if (img == null) {
            throw new IllegalArgumentException("Image cannot be null");
        }
        if (regions == null || regions.length == 0) {
            throw new IllegalArgumentException("Regions cannot be null or empty");
        }
        if (descriptor == null) {
            throw new IllegalArgumentException("Descriptor cannot be null");
        }
        if (algo == null) {
            throw new IllegalArgumentException("Algorithm cannot be null");
        }
        DefaultSegmentationAlgorithm segAlgo = new DefaultSegmentationAlgorithm(descriptor, algo);
        segAlgo.setLogEnabled(false);
        Segmentation seg = segAlgo.segment((Segmentable)img, regions);
        if (seg == null) {
            LOGGER.warning("Segmentation returned null result");
        }
        return seg;
    }

    public static Segmentation doClustering(Sequence seq) throws SupportRegionException, SegmentationException, MaskException, NumberFormatException, SignatureException {
        return ImageKMeans.doClustering(seq, 5, 100, 0.01, 0);
    }

    public static Segmentation doClustering(Sequence seq, int numClusters) throws SupportRegionException, SegmentationException, MaskException, NumberFormatException, SignatureException {
        if (numClusters <= 0) {
            throw new IllegalArgumentException("Number of clusters must be positive: " + numClusters);
        }
        return ImageKMeans.doClustering(seq, numClusters, 100, 0.01, 0);
    }
}

