/*
 * Decompiled with CFR 0.152.
 */
package plugins.fmp.multiSPOTS96.tools.polyline;

import icy.type.geom.Polyline2D;
import java.awt.geom.Point2D;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Level2D
extends Polyline2D {
    private static final Logger LOGGER = Logger.getLogger(Level2D.class.getName());

    public Level2D() {
    }

    public Level2D(int numPoints) {
        if (numPoints < 0) {
            throw new IllegalArgumentException("Number of points cannot be negative: " + numPoints);
        }
        this.npoints = numPoints;
        this.xpoints = new double[numPoints];
        this.ypoints = new double[numPoints];
        for (int i = 0; i < numPoints; ++i) {
            this.xpoints[i] = i;
        }
    }

    public Level2D(Polyline2D polyline) {
        if (polyline == null) {
            throw new IllegalArgumentException("Source polyline cannot be null");
        }
        this.npoints = polyline.npoints;
        this.xpoints = new double[this.npoints];
        this.ypoints = new double[this.npoints];
        System.arraycopy(polyline.xpoints, 0, this.xpoints, 0, this.npoints);
        System.arraycopy(polyline.ypoints, 0, this.ypoints, 0, this.npoints);
    }

    public Level2D(double[] xPoints, double[] yPoints, int numPoints) {
        if (xPoints == null || yPoints == null) {
            throw new IllegalArgumentException("Coordinate arrays cannot be null");
        }
        if (numPoints < 0) {
            throw new IllegalArgumentException("Number of points cannot be negative: " + numPoints);
        }
        if (xPoints.length < numPoints || yPoints.length < numPoints) {
            throw new IllegalArgumentException("Arrays are too small for the specified number of points");
        }
        this.npoints = numPoints;
        this.xpoints = new double[numPoints];
        this.ypoints = new double[numPoints];
        System.arraycopy(xPoints, 0, this.xpoints, 0, numPoints);
        System.arraycopy(yPoints, 0, this.ypoints, 0, numPoints);
    }

    public Level2D(int[] xPoints, int[] yPoints, int numPoints) {
        if (xPoints == null || yPoints == null) {
            throw new IllegalArgumentException("Coordinate arrays cannot be null");
        }
        if (numPoints < 0) {
            throw new IllegalArgumentException("Number of points cannot be negative: " + numPoints);
        }
        if (xPoints.length < numPoints || yPoints.length < numPoints) {
            throw new IllegalArgumentException("Arrays are too small for the specified number of points");
        }
        this.npoints = numPoints;
        this.xpoints = new double[numPoints];
        this.ypoints = new double[numPoints];
        for (int i = 0; i < numPoints; ++i) {
            this.xpoints[i] = xPoints[i];
            this.ypoints[i] = yPoints[i];
        }
    }

    public Level2D(List<Point2D> pointsList) {
        if (pointsList == null) {
            throw new IllegalArgumentException("Points list cannot be null");
        }
        this.npoints = pointsList.size();
        this.xpoints = new double[this.npoints];
        this.ypoints = new double[this.npoints];
        for (int i = 0; i < this.npoints; ++i) {
            Point2D point = pointsList.get(i);
            if (point == null) {
                throw new IllegalArgumentException("Point at index " + i + " is null");
            }
            this.xpoints[i] = point.getX();
            this.ypoints[i] = point.getY();
        }
    }

    public Level2D clone() {
        Level2D cloned = new Level2D(this.npoints);
        System.arraycopy(this.xpoints, 0, cloned.xpoints, 0, this.npoints);
        System.arraycopy(this.ypoints, 0, cloned.ypoints, 0, this.npoints);
        return cloned;
    }

    public Level2D expandPolylineToNewWidth(int imageWidth) {
        if (imageWidth <= 0) {
            throw new IllegalArgumentException("Image width must be positive: " + imageWidth);
        }
        if (this.npoints <= 0) {
            return new Level2D(imageWidth);
        }
        try {
            double[] newXPoints = new double[imageWidth];
            double[] newYPoints = new double[imageWidth];
            for (int j = 0; j < this.npoints; ++j) {
                int startIndex = j * imageWidth / this.npoints;
                int endIndex = (j + 1) * imageWidth / this.npoints;
                double currentY = this.ypoints[j];
                double nextY = j + 1 < this.npoints ? this.ypoints[j + 1] : currentY;
                for (int i = startIndex; i < endIndex && i < imageWidth; ++i) {
                    newXPoints[i] = i;
                    if (endIndex > startIndex) {
                        double ratio = (double)(i - startIndex) / (double)(endIndex - startIndex);
                        newYPoints[i] = currentY + (nextY - currentY) * ratio;
                        continue;
                    }
                    newYPoints[i] = currentY;
                }
            }
            return new Level2D(newXPoints, newYPoints, imageWidth);
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "Error expanding polyline", e);
            return new Level2D(imageWidth);
        }
    }

    public Level2D cropPolylineToNewWidth(int imageWidth) {
        if (imageWidth <= 0) {
            throw new IllegalArgumentException("Image width must be positive: " + imageWidth);
        }
        try {
            double[] newXPoints = new double[imageWidth];
            double[] newYPoints = new double[imageWidth];
            double lastValue = this.npoints > 0 ? this.ypoints[this.npoints - 1] : 0.0;
            for (int i = 0; i < imageWidth; ++i) {
                newXPoints[i] = i;
                newYPoints[i] = i < this.npoints ? this.ypoints[i] : lastValue;
            }
            return new Level2D(newXPoints, newYPoints, imageWidth);
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "Error cropping polyline", e);
            return new Level2D(imageWidth);
        }
    }

    public double getMaximum_Y() {
        double maximum = this.ypoints[0];
        for (int i = 0; i < this.npoints; ++i) {
            if (!(this.ypoints[i] > maximum)) continue;
            maximum = this.ypoints[i];
        }
        return maximum;
    }

    public int getPointCount() {
        return this.npoints;
    }

    public double getYAt(int index) {
        if (index < 0 || index >= this.npoints) {
            throw new IndexOutOfBoundsException("Index " + index + " is out of bounds [0, " + this.npoints + ")");
        }
        return this.ypoints[index];
    }

    public void setYAt(int index, double value) {
        if (index < 0 || index >= this.npoints) {
            throw new IndexOutOfBoundsException("Index " + index + " is out of bounds [0, " + this.npoints + ")");
        }
        this.ypoints[index] = value;
    }
}

