/*
 * Decompiled with CFR 0.152.
 */
package plugins.fmp.multiSPOTS96.dlg.a_browse;

import icy.gui.frame.progress.ProgressFrame;
import icy.gui.viewer.Viewer;
import icy.sequence.Sequence;
import icy.sequence.SequenceEvent;
import icy.sequence.SequenceListener;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import plugins.fmp.multiSPOTS96.MultiSPOTS96;
import plugins.fmp.multiSPOTS96.dlg.a_browse.SelectFilesPanel;
import plugins.fmp.multiSPOTS96.experiment.Experiment;
import plugins.fmp.multiSPOTS96.experiment.ExperimentDirectories;
import plugins.fmp.multiSPOTS96.tools.JComponents.SequenceNameListRenderer;

public class LoadSaveExperiment
extends JPanel
implements PropertyChangeListener,
ItemListener,
SequenceListener {
    private static final long serialVersionUID = -690874563607080412L;
    private JButton createButton = new JButton("Create...");
    private JButton openButton = new JButton("Open...");
    private JButton searchButton = new JButton("Search...");
    private JButton closeButton = new JButton("Close");
    public JCheckBox filteredCheck = new JCheckBox("List filtered");
    public List<String> selectedNames = new ArrayList<String>();
    private SelectFilesPanel dialogSelect = null;
    private JButton previousButton = new JButton("<");
    private JButton nextButton = new JButton(">");
    private MultiSPOTS96 parent0 = null;

    public JPanel initPanel(MultiSPOTS96 parent0) {
        this.parent0 = parent0;
        JPanel navPanel = new JPanel(new BorderLayout());
        SequenceNameListRenderer renderer = new SequenceNameListRenderer();
        parent0.expListCombo.setRenderer(renderer);
        int bWidth = 30;
        int height = 20;
        this.previousButton.setPreferredSize(new Dimension(bWidth, height));
        this.nextButton.setPreferredSize(new Dimension(bWidth, height));
        navPanel.add((Component)this.previousButton, "Before");
        navPanel.add((Component)parent0.expListCombo, "Center");
        navPanel.add((Component)this.nextButton, "After");
        JPanel buttonPanel = new JPanel(new BorderLayout());
        FlowLayout layout = new FlowLayout(0);
        layout.setVgap(1);
        JPanel subPanel = new JPanel(layout);
        subPanel.add(this.openButton);
        subPanel.add(this.createButton);
        subPanel.add(this.searchButton);
        subPanel.add(this.closeButton);
        subPanel.add(this.filteredCheck);
        buttonPanel.add((Component)subPanel, "Before");
        this.defineActionListeners();
        parent0.expListCombo.addItemListener(this);
        JPanel twoLinesPanel = new JPanel(new GridLayout(2, 1));
        twoLinesPanel.add(navPanel);
        twoLinesPanel.add(buttonPanel);
        return twoLinesPanel;
    }

    void closeAllExperiments() {
        this.closeCurrentExperiment();
        this.parent0.expListCombo.removeAllItems();
        this.parent0.dlgExperiment.tabFilter.clearAllCheckBoxes();
        this.parent0.dlgExperiment.tabFilter.filterExpList.removeAllItems();
        this.parent0.dlgExperiment.tabInfos.clearCombos();
        this.filteredCheck.setSelected(false);
    }

    public void closeViewsForCurrentExperiment(Experiment exp) {
        if (exp != null) {
            if (exp.seqCamData != null) {
                exp.save_MS96_experiment();
                exp.save_MS96_spotsMeasures();
            }
            exp.closeSequences();
        }
    }

    public void closeCurrentExperiment() {
        if (this.parent0.expListCombo.getSelectedIndex() < 0) {
            return;
        }
        Experiment exp = (Experiment)this.parent0.expListCombo.getSelectedItem();
        if (exp != null) {
            this.closeViewsForCurrentExperiment(exp);
        }
    }

    void updateBrowseInterface() {
        int isel = this.parent0.expListCombo.getSelectedIndex();
        boolean flag1 = isel != 0;
        boolean flag2 = isel != this.parent0.expListCombo.getItemCount() - 1;
        this.previousButton.setEnabled(flag1);
        this.nextButton.setEnabled(flag2);
    }

    private void defineActionListeners() {
        this.parent0.expListCombo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LoadSaveExperiment.this.updateBrowseInterface();
            }
        });
        this.nextButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ((LoadSaveExperiment)LoadSaveExperiment.this).parent0.expListCombo.setSelectedIndex(((LoadSaveExperiment)LoadSaveExperiment.this).parent0.expListCombo.getSelectedIndex() + 1);
                LoadSaveExperiment.this.updateBrowseInterface();
            }
        });
        this.previousButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ((LoadSaveExperiment)LoadSaveExperiment.this).parent0.expListCombo.setSelectedIndex(((LoadSaveExperiment)LoadSaveExperiment.this).parent0.expListCombo.getSelectedIndex() - 1);
                LoadSaveExperiment.this.updateBrowseInterface();
            }
        });
        this.searchButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                LoadSaveExperiment.this.selectedNames = new ArrayList<String>();
                LoadSaveExperiment.this.dialogSelect = new SelectFilesPanel();
                LoadSaveExperiment.this.dialogSelect.initialize(LoadSaveExperiment.this.parent0, LoadSaveExperiment.this.selectedNames);
            }
        });
        this.createButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                ExperimentDirectories eDAF = new ExperimentDirectories();
                String subDir = ((LoadSaveExperiment)LoadSaveExperiment.this).parent0.expListCombo.stringExpBinSubDirectory;
                if (eDAF.getDirectoriesFromDialog(subDir, null, true)) {
                    int item = ((LoadSaveExperiment)LoadSaveExperiment.this).parent0.expListCombo.addExperiment(new Experiment(eDAF), false);
                    ((LoadSaveExperiment)LoadSaveExperiment.this).parent0.dlgExperiment.tabInfos.initInfosCombos();
                    ((LoadSaveExperiment)LoadSaveExperiment.this).parent0.expListCombo.setSelectedIndex(item);
                }
            }
        });
        this.openButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                ExperimentDirectories eDAF = new ExperimentDirectories();
                String subDir = ((LoadSaveExperiment)LoadSaveExperiment.this).parent0.expListCombo.stringExpBinSubDirectory;
                if (eDAF.getDirectoriesFromDialog(subDir, null, false)) {
                    int item = ((LoadSaveExperiment)LoadSaveExperiment.this).parent0.expListCombo.addExperiment(new Experiment(eDAF), false);
                    ((LoadSaveExperiment)LoadSaveExperiment.this).parent0.dlgExperiment.tabInfos.initInfosCombos();
                    ((LoadSaveExperiment)LoadSaveExperiment.this).parent0.expListCombo.setSelectedIndex(item);
                }
            }
        });
        this.closeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LoadSaveExperiment.this.closeAllExperiments();
                ((LoadSaveExperiment)LoadSaveExperiment.this).parent0.dlgExperiment.tabsPane.setSelectedIndex(0);
                ((LoadSaveExperiment)LoadSaveExperiment.this).parent0.expListCombo.removeAllItems();
                ((LoadSaveExperiment)LoadSaveExperiment.this).parent0.expListCombo.updateUI();
            }
        });
        this.filteredCheck.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                ((LoadSaveExperiment)LoadSaveExperiment.this).parent0.dlgExperiment.tabFilter.filterExperimentList(LoadSaveExperiment.this.filteredCheck.isSelected());
            }
        });
    }

    public void sequenceChanged(SequenceEvent sequenceEvent) {
        Experiment exp;
        if (sequenceEvent.getSourceType() == SequenceEvent.SequenceEventSourceType.SEQUENCE_DATA && (exp = (Experiment)this.parent0.expListCombo.getSelectedItem()) != null && exp.seqCamData.getSequence() != null && sequenceEvent.getSequence() == exp.seqCamData.getSequence()) {
            Viewer v = exp.seqCamData.getSequence().getFirstViewer();
            int t = v.getPositionT();
            v.setTitle(exp.seqCamData.getDecoratedImageName(t));
        }
    }

    public void sequenceClosed(Sequence sequence) {
        sequence.removeListener((SequenceListener)this);
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyName().equals("SELECT1_CLOSED")) {
            if (this.selectedNames.size() < 1) {
                return;
            }
            ExperimentDirectories expDirectories = new ExperimentDirectories();
            final String subDir = this.parent0.expListCombo.stringExpBinSubDirectory;
            if (expDirectories.getDirectoriesFromExptPath(subDir, this.selectedNames.get(0))) {
                int item = this.parent0.expListCombo.addExperiment(new Experiment(expDirectories), false);
                this.parent0.dlgExperiment.tabInfos.initInfosCombos();
                this.parent0.expListCombo.setSelectedIndex(item);
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        for (int i = 1; i < LoadSaveExperiment.this.selectedNames.size(); ++i) {
                            ExperimentDirectories eDAF = new ExperimentDirectories();
                            if (!eDAF.getDirectoriesFromExptPath(subDir, LoadSaveExperiment.this.selectedNames.get(i))) continue;
                            ((LoadSaveExperiment)LoadSaveExperiment.this).parent0.expListCombo.addExperiment(new Experiment(eDAF), false);
                        }
                        LoadSaveExperiment.this.selectedNames.clear();
                        LoadSaveExperiment.this.updateBrowseInterface();
                    }
                });
            }
        }
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        if (e.getStateChange() == 1) {
            Experiment exp = (Experiment)this.parent0.expListCombo.getSelectedItem();
            if (exp != null) {
                this.openSelectedExperiment(exp);
            }
        } else if (e.getStateChange() == 2) {
            Experiment exp = (Experiment)e.getItem();
            this.closeViewsForCurrentExperiment(exp);
        }
    }

    public boolean openSelectedExperiment(Experiment exp) {
        ProgressFrame progressFrame = new ProgressFrame("Load Data");
        exp.load_MS96_experiment();
        boolean flag = true;
        progressFrame.setMessage("Load image");
        ArrayList imagesList = (ArrayList)ExperimentDirectories.getImagesListFromPathV2(exp.seqCamData.getImagesDirectory(), "jpg");
        exp.seqCamData.loadImageList(imagesList);
        this.parent0.dlgExperiment.updateViewerForSequenceCam(exp);
        exp.seqCamData.getSequence().addListener((SequenceListener)this);
        if (exp.seqCamData != null) {
            exp.load_MS96_cages();
            exp.transferCagesROI_toSequence();
            exp.transferSpotsROI_toSequence();
            exp.load_MS96_spotsMeasures();
            this.parent0.dlgMeasure.tabCharts.displayChartPanels(exp);
            progressFrame.setMessage("Load data: update dialogs");
            this.parent0.dlgExperiment.updateDialogs(exp);
            this.parent0.dlgSpots.updateDialogs(exp);
        } else {
            flag = false;
            System.out.println("LoadSaveExperiments:openSelectedExperiment() Error: no jpg files found for this experiment\n");
        }
        this.parent0.dlgExperiment.tabInfos.transferPreviousExperimentInfosToDialog(exp, exp);
        progressFrame.close();
        return flag;
    }
}

