/*
 * Decompiled with CFR 0.152.
 */
package plugins.fmp.multiSPOTS96.dlg.a_experiment;

import icy.gui.viewer.Viewer;
import icy.gui.viewer.ViewerEvent;
import icy.gui.viewer.ViewerListener;
import icy.image.IcyBufferedImage;
import icy.image.ImageUtil;
import icy.sequence.DimensionId;
import icy.sequence.Sequence;
import icy.type.collection.array.Array1DUtil;
import icy.util.StringUtil;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.concurrent.CompletableFuture;
import java.util.logging.Logger;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.vecmath.Vector2d;
import plugins.fmp.multiSPOTS96.MultiSPOTS96;
import plugins.fmp.multiSPOTS96.experiment.Experiment;
import plugins.fmp.multiSPOTS96.series.ProcessingResult;
import plugins.fmp.multiSPOTS96.series.ProgressReporter;
import plugins.fmp.multiSPOTS96.series.RegistrationOptions;
import plugins.fmp.multiSPOTS96.series.RegistrationProcessor;
import plugins.fmp.multiSPOTS96.series.SafeRegistrationProcessor;
import plugins.fmp.multiSPOTS96.tools.GaspardRigidRegistration;
import plugins.fmp.multiSPOTS96.tools.JComponents.JComboBoxExperiment;
import plugins.fmp.multiSPOTS96.tools.imageTransform.ImageTransformEnums;
import plugins.fmp.multiSPOTS96.tools.imageTransform.ImageTransformOptions;

public class CorrectDrift
extends JPanel
implements ViewerListener,
PropertyChangeListener {
    private static final long serialVersionUID = 1L;
    private static final Logger LOGGER = Logger.getLogger(CorrectDrift.class.getName());
    int val = 0;
    int min = 0;
    int max = 10000;
    int step = 1;
    int maxLast = 99999999;
    private final JSpinner startFrameJSpinner = new JSpinner(new SpinnerNumberModel(this.val, this.min, this.max, this.step));
    private final JSpinner referenceFrameJSpinner = new JSpinner(new SpinnerNumberModel(this.val, this.min, this.max, this.step));
    private final JButton runButton = new JButton("Run registration");
    private final JSpinner xSpinner = new JSpinner(new SpinnerNumberModel(0, -500, 500, 1));
    private final JSpinner ySpinner = new JSpinner(new SpinnerNumberModel(0, -500, 500, 1));
    private final JButton testTranslationButton = new JButton("Test");
    private final JButton applyTranslationButton = new JButton("Apply");
    private final JButton restoreTranslationButton = new JButton("Restore 1 step");
    int previousX = 0;
    int previousY = 0;
    int previousT = 0;
    double previousAngle = 0.0;
    private final JSpinner angleSpinner = new JSpinner(new SpinnerNumberModel(0.0, -180.0, 180.0, 1.0));
    private final JButton testRotationButton = new JButton("Test");
    private final JButton applyRotationButton = new JButton("Apply");
    private final JButton restoreRotationButton = new JButton("Restore 1 step");
    private final JSpinner squareSizeSpinner = new JSpinner(new SpinnerNumberModel(10, 0, 500, 1));
    private JComboBoxExperiment experimentList = new JComboBoxExperiment();
    private CompletableFuture<Void> currentTask;
    private final RegistrationProcessor registrationProcessor = new SafeRegistrationProcessor();

    void init(GridLayout capLayout, MultiSPOTS96 parent0) {
        this.experimentList = parent0.expListCombo;
        this.initializeUI(capLayout);
        this.defineActionListeners();
        this.updateButtonStates();
    }

    private void initializeUI(GridLayout capLayout) {
        this.setLayout(capLayout);
        FlowLayout flowlayout = new FlowLayout(0);
        flowlayout.setVgap(1);
        JPanel referencePanel = new JPanel(flowlayout);
        referencePanel.add(new JLabel("Start frame"));
        referencePanel.add(this.startFrameJSpinner);
        this.startFrameJSpinner.setPreferredSize(new Dimension(50, 20));
        referencePanel.add(new JLabel("Ref. frame"));
        referencePanel.add(this.referenceFrameJSpinner);
        this.referenceFrameJSpinner.setPreferredSize(new Dimension(50, 20));
        referencePanel.add(this.runButton);
        this.add(referencePanel);
        JPanel translationPanel = new JPanel(flowlayout);
        translationPanel.add(new JLabel("Translate X"));
        translationPanel.add(this.xSpinner);
        this.xSpinner.setPreferredSize(new Dimension(50, 20));
        translationPanel.add(new JLabel("Y"));
        translationPanel.add(this.ySpinner);
        this.ySpinner.setPreferredSize(new Dimension(50, 20));
        translationPanel.add(this.testTranslationButton);
        translationPanel.add(this.applyTranslationButton);
        translationPanel.add(this.restoreTranslationButton);
        this.add(translationPanel);
        JPanel rotationPanel = new JPanel(flowlayout);
        rotationPanel.add(new JLabel("rotate (degrees)"));
        rotationPanel.add(this.angleSpinner);
        rotationPanel.add(this.testRotationButton);
        rotationPanel.add(this.applyRotationButton);
        rotationPanel.add(this.restoreRotationButton);
        this.add(rotationPanel);
        JPanel chessPanel = new JPanel(flowlayout);
        chessPanel.add(new JLabel("Size of test square (pixels)"));
        chessPanel.add(this.squareSizeSpinner);
        this.add(chessPanel);
        this.restoreTranslationButton.setEnabled(false);
        this.restoreRotationButton.setEnabled(false);
    }

    private void defineActionListeners() {
        this.runButtonListener();
        this.startFrameJSpinnerListener();
        this.testTranslationButtonListener();
        this.applyTranslationButtonListener();
        this.restoreTranslationButtonListener();
        this.testRotationButtonListener();
        this.applyRotationButtonListener();
        this.restoreRotationButtonListener();
    }

    private void runButtonListener() {
        this.runButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Experiment exp = CorrectDrift.this.getCurrentExperiment();
                if (exp != null) {
                    if (CorrectDrift.this.runButton.getText().equals("Run")) {
                        CorrectDrift.this.executeRegistration(exp);
                    } else {
                        CorrectDrift.this.stopComputation();
                    }
                }
            }
        });
    }

    private void startFrameJSpinnerListener() {
        this.startFrameJSpinner.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                Viewer v;
                Experiment exp = CorrectDrift.this.getCurrentExperiment();
                if (exp != null && exp.seqCamData.getSequence() != null && (v = exp.seqCamData.getSequence().getFirstViewer()) != null) {
                    int newValue = (Integer)CorrectDrift.this.startFrameJSpinner.getValue();
                    if (v.getPositionT() != newValue) {
                        v.setPositionT(newValue);
                    }
                }
            }
        });
    }

    private void applyTranslationButtonListener() {
        this.applyTranslationButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Experiment exp = CorrectDrift.this.getCurrentExperiment();
                if (exp != null) {
                    int x = (Integer)CorrectDrift.this.xSpinner.getValue();
                    int y = (Integer)CorrectDrift.this.ySpinner.getValue();
                    CorrectDrift.this.applyTranslation(exp, x, y);
                    CorrectDrift.this.restoreTranslationButton.setEnabled(true);
                    CorrectDrift.this.previousX = x;
                    CorrectDrift.this.previousY = y;
                }
            }
        });
    }

    private void testTranslationButtonListener() {
        this.testTranslationButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Experiment exp = CorrectDrift.this.getCurrentExperiment();
                if (exp != null) {
                    int x = (Integer)CorrectDrift.this.xSpinner.getValue();
                    int y = (Integer)CorrectDrift.this.ySpinner.getValue();
                    CorrectDrift.this.testTranslation(exp, x, y);
                }
            }
        });
    }

    private void restoreTranslationButtonListener() {
        this.restoreTranslationButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Experiment exp = CorrectDrift.this.getCurrentExperiment();
                if (exp != null) {
                    CorrectDrift.this.applyTranslation(exp, -CorrectDrift.this.previousX, -CorrectDrift.this.previousY);
                    CorrectDrift.this.restoreTranslationButton.setEnabled(false);
                    CorrectDrift.this.previousX = 0;
                    CorrectDrift.this.previousY = 0;
                }
            }
        });
    }

    private void applyRotationButtonListener() {
        this.applyRotationButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Experiment exp = CorrectDrift.this.getCurrentExperiment();
                if (exp != null) {
                    double angle = (Double)CorrectDrift.this.angleSpinner.getValue();
                    CorrectDrift.this.applyRotation(exp, angle);
                    CorrectDrift.this.restoreRotationButton.setEnabled(true);
                    CorrectDrift.this.previousAngle = angle;
                }
            }
        });
    }

    private void restoreRotationButtonListener() {
        this.restoreRotationButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Experiment exp = CorrectDrift.this.getCurrentExperiment();
                if (exp != null) {
                    CorrectDrift.this.applyRotation(exp, CorrectDrift.this.previousAngle);
                    CorrectDrift.this.restoreRotationButton.setEnabled(false);
                    CorrectDrift.this.previousAngle = 0.0;
                }
            }
        });
    }

    private void testRotationButtonListener() {
        this.testRotationButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Experiment exp = CorrectDrift.this.getCurrentExperiment();
                if (exp != null) {
                    // empty if block
                }
            }
        });
    }

    public void resetFrameIndex() {
        this.startFrameJSpinner.setValue(0);
        this.referenceFrameJSpinner.setValue(0);
    }

    private Experiment getCurrentExperiment() {
        return (Experiment)this.experimentList.getSelectedItem();
    }

    private void updateButtonStates() {
        boolean isRunning = this.currentTask != null && !this.currentTask.isDone();
        this.runButton.setEnabled(true);
        this.startFrameJSpinner.setEnabled(!isRunning);
        this.referenceFrameJSpinner.setEnabled(!isRunning);
        this.applyTranslationButton.setEnabled(!isRunning);
        this.applyRotationButton.setEnabled(!isRunning);
        this.testTranslationButton.setEnabled(!isRunning);
        this.testRotationButton.setEnabled(!isRunning);
        this.restoreTranslationButton.setEnabled(!isRunning && (this.previousX != 0 || this.previousY != 0));
    }

    public void viewerChanged(ViewerEvent event) {
        Viewer v;
        int t;
        if (event.getType() == ViewerEvent.ViewerEventType.POSITION_CHANGED && event.getDim() == DimensionId.T && (t = (v = event.getSource()).getPositionT()) >= 0) {
            if (t != this.previousT) {
                this.previousT = t;
                this.previousX = 0;
                this.previousY = 0;
                this.restoreTranslationButton.setEnabled(false);
            }
            this.startFrameJSpinner.setValue(t);
        }
    }

    public void viewerClosed(Viewer viewer) {
        viewer.removeListener((ViewerListener)this);
    }

    private void executeRegistration(Experiment experiment) {
        if (this.currentTask != null && !this.currentTask.isDone()) {
            this.showError("Registration already in progress");
            return;
        }
        RegistrationOptions options = this.createRegistrationOptions(experiment);
        ProcessingResult<Void> validationResult = options.validate();
        if (validationResult.isFailure()) {
            this.showError("Invalid registration options: " + validationResult.getErrorMessage());
            return;
        }
        this.currentTask = CompletableFuture.runAsync(() -> {
            try {
                LOGGER.info("Starting registration for experiment: " + experiment.getResultsDirectory());
                ProcessingResult<RegistrationProcessor.RegistrationResult> result = this.registrationProcessor.correctDriftAndRotation(experiment, options);
                if (result.isFailure()) {
                    this.showError("Registration failed: " + result.getErrorMessage());
                } else {
                    RegistrationProcessor.RegistrationResult registrationResult = result.getDataOrThrow();
                    this.showSuccess("Registration completed successfully. Processed: " + registrationResult.getFramesProcessed() + " frames, Corrected: " + registrationResult.getFramesCorrected() + " frames");
                }
            }
            catch (Exception e) {
                LOGGER.severe("Unexpected error during registration: " + e.getMessage());
                this.showError("Unexpected error during registration: " + e.getMessage());
            }
        });
        this.updateButtonStates();
        this.runButton.setText("STOP");
    }

    private void stopComputation() {
        if (this.currentTask != null && !this.currentTask.isDone()) {
            this.currentTask.cancel(true);
            LOGGER.info("Registration stopped by user");
        }
        this.updateButtonStates();
        this.runButton.setText("Run");
    }

    private RegistrationOptions createRegistrationOptions(Experiment experiment) {
        int referenceFrame = (Integer)this.referenceFrameJSpinner.getValue();
        int startFrame = 0;
        return new RegistrationOptions().fromFrame(startFrame).toFrame(referenceFrame - 1).referenceFrame(referenceFrame).translationThreshold(0.001).rotationThreshold(0.001).transformOptions(this.createTransformOptions(ImageTransformEnums.NONE)).saveCorrectedImages(true).preserveImageSize(true).referenceChannel(0).progressReporter(new ProgressReporter(){

            @Override
            public void updateMessage(String message) {
            }

            @Override
            public void updateProgress(int percentage) {
            }

            @Override
            public void completed() {
                CorrectDrift.this.updateButtonStates();
            }

            @Override
            public void failed(String errorMessage) {
                CorrectDrift.this.showError(errorMessage);
                CorrectDrift.this.updateButtonStates();
            }

            @Override
            public boolean isCancelled() {
                return false;
            }
        });
    }

    private ImageTransformOptions createTransformOptions(ImageTransformEnums transform) {
        ImageTransformOptions options = new ImageTransformOptions();
        options.transformOption = transform;
        return options;
    }

    private void showError(String message) {
        LOGGER.warning("User error: " + message);
    }

    private void showSuccess(String message) {
        LOGGER.info("Success: " + message);
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (StringUtil.equals((String)"thread_ended", (String)evt.getPropertyName())) {
            this.runButton.setText("Run registration");
            this.runButton.removePropertyChangeListener(this);
        }
    }

    private boolean testTranslation(Experiment exp, int x, int y) {
        IcyBufferedImage imageReference;
        int squareSize = (Integer)this.squareSizeSpinner.getValue();
        int testFrame = (Integer)this.startFrameJSpinner.getValue();
        int referenceFrame = (Integer)this.referenceFrameJSpinner.getValue();
        Sequence seq = exp.seqCamData.getSequence();
        IcyBufferedImage imageTest = seq.getImage(testFrame, 0);
        Sequence chessSeq = this.createChessboardImage(imageTest, imageReference = seq.getImage(referenceFrame, 0), squareSize);
        Viewer v = new Viewer(chessSeq, true);
        return v != null;
    }

    private boolean applyTranslation(Experiment exp, int x, int y) {
        Vector2d translation = new Vector2d((double)x, (double)y);
        int t = (Integer)this.referenceFrameJSpinner.getValue();
        Sequence seq = exp.seqCamData.getSequence();
        IcyBufferedImage workImage = seq.getImage(t, 0);
        workImage = GaspardRigidRegistration.applyTranslation2D(workImage, -1, translation, true);
        seq.setImage(t, 0, (BufferedImage)workImage);
        String fileName = exp.seqCamData.getFileNameFromImageList(t);
        File outputfile = new File(fileName);
        BufferedImage image = ImageUtil.toRGBImage((Image)workImage);
        return ImageUtil.save((RenderedImage)image, (String)"jpg", (File)outputfile);
    }

    private boolean applyRotation(Experiment exp, double angleDegrees) {
        int t = (Integer)this.referenceFrameJSpinner.getValue();
        double angleRadians = Math.toRadians(angleDegrees);
        Sequence seq = exp.seqCamData.getSequence();
        IcyBufferedImage workImage = seq.getImage(t, 0);
        workImage = GaspardRigidRegistration.applyRotation2D(workImage, -1, angleRadians, true);
        seq.setImage(t, 0, (BufferedImage)workImage);
        String fileName = exp.seqCamData.getFileNameFromImageList(t);
        File outputfile = new File(fileName);
        BufferedImage image = ImageUtil.toRGBImage((Image)workImage);
        return ImageUtil.save((RenderedImage)image, (String)"jpg", (File)outputfile);
    }

    private Sequence createChessboardImage(IcyBufferedImage s1Image, IcyBufferedImage s2Image, int squareSize) {
        Dimension resultDim = new Dimension(Math.max(s1Image.getWidth(), s2Image.getWidth()), Math.max(s1Image.getHeight(), s2Image.getHeight()));
        IcyBufferedImage resultImage = new IcyBufferedImage(resultDim.width, resultDim.height, s1Image.getSizeC(), s1Image.getDataType_());
        resultImage.beginUpdate();
        for (int ch = 0; ch < resultImage.getSizeC(); ++ch) {
            double[] resultData = Array1DUtil.arrayToDoubleArray((Object)resultImage.getDataXY(ch), (boolean)resultImage.isSignedDataType());
            double[] s1Data = Array1DUtil.arrayToDoubleArray((Object)s1Image.getDataXY(ch), (boolean)resultImage.isSignedDataType());
            double[] s2Data = Array1DUtil.arrayToDoubleArray((Object)s2Image.getDataXY(ch), (boolean)resultImage.isSignedDataType());
            for (int j = 0; j < resultImage.getHeight(); ++j) {
                int jResultOffset = j * resultImage.getWidth();
                int js1Offset = j * s1Image.getWidth();
                int js2Offset = j * s2Image.getWidth();
                for (int i = 0; i < resultImage.getWidth(); ++i) {
                    boolean showS1;
                    boolean bl = showS1 = (i / squareSize % 2 + j / squareSize % 2) % 2 == 0;
                    if (showS1) {
                        if (i < s1Image.getWidth() && j < s1Image.getHeight()) {
                            resultData[jResultOffset + i] = s1Data[js1Offset + i];
                            continue;
                        }
                        resultData[jResultOffset + i] = 0.0;
                        continue;
                    }
                    resultData[jResultOffset + i] = i < s2Image.getWidth() && j < s2Image.getHeight() ? s2Data[js2Offset + i] : 0.0;
                }
            }
            Array1DUtil.doubleArrayToArray((double[])resultData, (Object)resultImage.getDataXY(ch));
        }
        resultImage.endUpdate();
        Sequence result = new Sequence("composite image", resultImage);
        return result;
    }
}

