/*
 * Decompiled with CFR 0.152.
 */
package plugins.fmp.multiSPOTS96.dlg.d_spotsMeasures;

import icy.gui.viewer.Viewer;
import icy.sequence.Sequence;
import icy.sequence.SequenceEvent;
import icy.sequence.SequenceListener;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Iterator;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import plugins.fmp.multiSPOTS96.MultiSPOTS96;
import plugins.fmp.multiSPOTS96.dlg.d_spotsMeasures.ChartOptions;
import plugins.fmp.multiSPOTS96.experiment.Experiment;
import plugins.fmp.multiSPOTS96.experiment.cages.Cage;
import plugins.fmp.multiSPOTS96.experiment.cages.CageString;
import plugins.fmp.multiSPOTS96.experiment.spots.Spot;
import plugins.fmp.multiSPOTS96.tools.chart.ChartCageArrayFrame;
import plugins.fmp.multiSPOTS96.tools.toExcel.EnumXLSExport;
import plugins.fmp.multiSPOTS96.tools.toExcel.XLSExportOptions;
import plugins.fmp.multiSPOTS96.tools.toExcel.XLSExportOptionsBuilder;

public class Charts
extends JPanel
implements SequenceListener {
    private static final long serialVersionUID = -7079184380174992501L;
    private ChartCageArrayFrame chartCageArray = null;
    private MultiSPOTS96 parent0 = null;
    private JButton displayResultsButton = new JButton("Display results");
    private JButton axisOptionsButton = new JButton("Axis options");
    private ChartOptions graphOptions = null;
    private EnumXLSExport[] measures = new EnumXLSExport[]{EnumXLSExport.AREA_SUM, EnumXLSExport.AREA_SUMCLEAN};
    private JComboBox<EnumXLSExport> exportTypeComboBox = new JComboBox<EnumXLSExport>(this.measures);
    private JCheckBox relativeToCheckbox = new JCheckBox("relative to max", false);
    private JRadioButton displayAllButton = new JRadioButton("all cages");
    private JRadioButton displaySelectedButton = new JRadioButton("cage selected");

    void init(GridLayout capLayout, MultiSPOTS96 parent0) {
        this.setLayout(capLayout);
        this.parent0 = parent0;
        this.setLayout(capLayout);
        FlowLayout layout = new FlowLayout(0);
        layout.setVgap(0);
        JPanel panel01 = new JPanel(layout);
        panel01.add(new JLabel("Measure"));
        panel01.add(this.exportTypeComboBox);
        panel01.add(new JLabel(" display"));
        panel01.add(this.displayAllButton);
        panel01.add(this.displaySelectedButton);
        this.add(panel01);
        JPanel panel02 = new JPanel(layout);
        panel02.add(this.relativeToCheckbox);
        this.add(panel02);
        JPanel panel04 = new JPanel(layout);
        panel04.add(this.displayResultsButton);
        panel04.add(this.axisOptionsButton);
        this.add(panel04);
        ButtonGroup group1 = new ButtonGroup();
        group1.add(this.displayAllButton);
        group1.add(this.displaySelectedButton);
        this.displayAllButton.setSelected(true);
        this.exportTypeComboBox.setSelectedIndex(1);
        this.defineActionListeners();
    }

    private void defineActionListeners() {
        this.exportTypeComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Experiment exp = (Experiment)((Charts)Charts.this).parent0.expListCombo.getSelectedItem();
                if (exp != null) {
                    Charts.this.displayChartPanels(exp);
                }
            }
        });
        this.displayResultsButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Experiment exp = (Experiment)((Charts)Charts.this).parent0.expListCombo.getSelectedItem();
                if (exp != null) {
                    Charts.this.displayChartPanels(exp);
                }
            }
        });
        this.axisOptionsButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Experiment exp = (Experiment)((Charts)Charts.this).parent0.expListCombo.getSelectedItem();
                if (exp != null) {
                    if (Charts.this.graphOptions != null) {
                        Charts.this.graphOptions.close();
                    }
                    Charts.this.graphOptions = new ChartOptions();
                    Charts.this.graphOptions.initialize(Charts.this.parent0, Charts.this.chartCageArray);
                    Charts.this.graphOptions.requestFocus();
                }
            }
        });
        this.relativeToCheckbox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Experiment exp = (Experiment)((Charts)Charts.this).parent0.expListCombo.getSelectedItem();
                if (exp != null) {
                    Charts.this.displayChartPanels(exp);
                }
            }
        });
    }

    private Rectangle getInitialUpperLeftPosition(Experiment exp) {
        Rectangle rectv = new Rectangle(50, 500, 10, 10);
        Viewer v = exp.seqCamData.getSequence().getFirstViewer();
        if (v != null) {
            rectv = v.getBounds();
            rectv.translate(0, rectv.height);
        } else {
            rectv = this.parent0.mainFrame.getBounds();
            rectv.translate(rectv.width, rectv.height + 100);
        }
        int dx = 5;
        int dy = 10;
        rectv.translate(dx, dy);
        return rectv;
    }

    public void displayChartPanels(Experiment exp) {
        exp.seqCamData.getSequence().removeListener((SequenceListener)this);
        EnumXLSExport exportType = (EnumXLSExport)((Object)this.exportTypeComboBox.getSelectedItem());
        if (this.isThereAnyDataToDisplay(exp, exportType)) {
            this.chartCageArray = this.plotSpotMeasuresToChart(exp, exportType, this.chartCageArray);
        }
        exp.seqCamData.getSequence().addListener((SequenceListener)this);
    }

    private ChartCageArrayFrame plotSpotMeasuresToChart(Experiment exp, EnumXLSExport exportType, ChartCageArrayFrame iChart) {
        if (iChart != null) {
            iChart.getMainChartFrame().dispose();
        }
        int first = 0;
        int last = exp.cagesArray.cagesList.size() - 1;
        if (!this.displayAllButton.isSelected()) {
            Cage cageFound = exp.cagesArray.findFirstCageWithSelectedSpot();
            if (cageFound == null) {
                cageFound = exp.cagesArray.findFirstSelectedCage();
            }
            if (cageFound == null) {
                return null;
            }
            exp.seqCamData.centerDisplayOnRoi(cageFound.getRoi());
            String cageNumber = CageString.getCageNumberFromCageRoiName(cageFound.getRoi().getName());
            last = first = Integer.parseInt(cageNumber);
        }
        XLSExportOptions options = XLSExportOptionsBuilder.forChart().withBuildExcelStepMs(60000).withRelativeToT0(this.relativeToCheckbox.isSelected()).withExportType(exportType).withCageRange(first, last).build();
        iChart = new ChartCageArrayFrame();
        iChart.createMainChartPanel("Spots measures", exp, options, this.parent0);
        iChart.setChartSpotUpperLeftLocation(this.getInitialUpperLeftPosition(exp));
        iChart.displayData(exp, options);
        iChart.getMainChartFrame().toFront();
        iChart.getMainChartFrame().requestFocus();
        return iChart;
    }

    public void closeAllCharts() {
        if (this.chartCageArray != null) {
            this.chartCageArray.getMainChartFrame().dispose();
        }
        this.chartCageArray = null;
    }

    private boolean isThereAnyDataToDisplay(Experiment exp, EnumXLSExport option) {
        boolean flag = false;
        for (Cage cage : exp.cagesArray.cagesList) {
            Spot spot;
            Iterator<Spot> iterator = cage.spotsArray.getSpotsList().iterator();
            while (iterator.hasNext() && !(flag = (spot = iterator.next()).hasMeasurements(option))) {
            }
            if (!flag) continue;
            break;
        }
        return flag;
    }

    public void sequenceChanged(SequenceEvent sequenceEvent) {
    }

    public void sequenceClosed(Sequence sequence) {
        sequence.removeListener((SequenceListener)this);
        this.closeAllCharts();
    }
}

