/*
 * Decompiled with CFR 0.152.
 */
package plugins.fmp.multiSPOTS96.experiment.cages;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public final class CageOperationResult {
    private final boolean success;
    private final String operationType;
    private final String message;
    private final Optional<Exception> error;
    private final long processingTimeMs;
    private final Map<String, Object> metadata;

    private CageOperationResult(Builder builder) {
        this.success = builder.success;
        this.operationType = Objects.requireNonNull(builder.operationType, "Operation type cannot be null");
        this.message = builder.message != null ? builder.message : "";
        this.error = Optional.ofNullable(builder.error);
        this.processingTimeMs = builder.processingTimeMs;
        this.metadata = builder.metadata != null ? Map.copyOf(builder.metadata) : Map.of();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static CageOperationResult success(String operationType, String message) {
        return CageOperationResult.builder().success(true).operationType(operationType).message(message).build();
    }

    public static CageOperationResult failure(String operationType, Exception error, String message) {
        return CageOperationResult.builder().success(false).operationType(operationType).error(error).message(message).build();
    }

    public static CageOperationResult partial(String operationType, String message, Map<String, Object> metadata) {
        return CageOperationResult.builder().success(true).operationType(operationType).message(message).metadata(metadata).build();
    }

    public boolean isSuccess() {
        return this.success;
    }

    public String getOperationType() {
        return this.operationType;
    }

    public String getMessage() {
        return this.message;
    }

    public Optional<Exception> getError() {
        return this.error;
    }

    public long getProcessingTimeMs() {
        return this.processingTimeMs;
    }

    public Map<String, Object> getMetadata() {
        return this.metadata;
    }

    public boolean hasError() {
        return this.error.isPresent();
    }

    public boolean hasMetadata() {
        return !this.metadata.isEmpty();
    }

    public Optional<Object> getMetadata(String key) {
        return Optional.ofNullable(this.metadata.get(key));
    }

    public Builder toBuilder() {
        return CageOperationResult.builder().success(this.success).operationType(this.operationType).message(this.message).error(this.error.orElse(null)).processingTimeMs(this.processingTimeMs).metadata(this.metadata);
    }

    public String toString() {
        return String.format("CageOperationResult{type='%s', success=%b, time=%dms, message='%s'}", this.operationType, this.success, this.processingTimeMs, this.message);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        CageOperationResult that = (CageOperationResult)obj;
        return this.success == that.success && this.processingTimeMs == that.processingTimeMs && Objects.equals(this.operationType, that.operationType) && Objects.equals(this.message, that.message);
    }

    public int hashCode() {
        return Objects.hash(this.success, this.operationType, this.message, this.processingTimeMs);
    }

    public static class Builder {
        private boolean success = true;
        private String operationType = "UNKNOWN";
        private String message = "";
        private Exception error;
        private long processingTimeMs = 0L;
        private Map<String, Object> metadata;

        public Builder success(boolean success) {
            this.success = success;
            return this;
        }

        public Builder operationType(String operationType) {
            this.operationType = operationType;
            return this;
        }

        public Builder message(String message) {
            this.message = message;
            return this;
        }

        public Builder error(Exception error) {
            this.error = error;
            return this;
        }

        public Builder processingTimeMs(long processingTimeMs) {
            this.processingTimeMs = processingTimeMs;
            return this;
        }

        public Builder metadata(Map<String, Object> metadata) {
            this.metadata = metadata;
            return this;
        }

        public Builder addMetadata(String key, Object value) {
            if (this.metadata == null) {
                this.metadata = Map.of(key, value);
            } else {
                HashMap<String, Object> newMetadata = new HashMap<String, Object>(this.metadata);
                newMetadata.put(key, value);
                this.metadata = newMetadata;
            }
            return this;
        }

        public CageOperationResult build() {
            return new CageOperationResult(this);
        }
    }
}

