/*
 * Decompiled with CFR 0.152.
 */
package plugins.fmp.multiSPOTS96.series;

import java.util.ArrayList;
import java.util.List;

public class AdvancedMemoryOptions {
    public boolean enableStreaming = true;
    public int streamBufferSize = 5;
    public boolean enablePrefetching = true;
    public int prefetchThreadPriority = 5;
    public boolean enableMemoryPool = true;
    public int maxImagePoolSize = 20;
    public int maxCursorPoolSize = 20;
    public boolean enablePoolStatistics = true;
    public boolean enableCompression = true;
    public int compressionLevel = 1;
    public boolean enableMaskCaching = true;
    public int maxCachedMasks = 100;
    public boolean enableAdaptiveBatchSizing = true;
    public int memoryThresholdPercent = 80;
    public int memoryIncreaseThresholdPercent = 50;
    public int minBatchSize = 3;
    public int maxBatchSize = 50;
    public int batchSizeAdjustmentStep = 2;
    public int maxConcurrentTasks = 4;
    public long threadPoolKeepAliveMs = 60000L;
    public boolean enableThreadPoolStatistics = true;
    public boolean enableMemoryMonitoring = true;
    public long memoryMonitoringIntervalMs = 1000L;
    public boolean enableMemoryLogging = false;
    public int memoryLoggingThresholdPercent = 90;
    public boolean enableForcedGC = true;
    public int forcedGCThresholdPercent = 85;
    public int gcFrequencyBatches = 5;
    public boolean enableProfiling = false;
    public int profilingIntervalBatches = 10;
    public boolean enableAdaptiveOptimization = true;
    public boolean enableDebugLogging = false;
    public boolean enableDetailedErrorReporting = true;
    public boolean enablePerformanceMetrics = false;

    public static AdvancedMemoryOptions createConservative() {
        AdvancedMemoryOptions options = new AdvancedMemoryOptions();
        options.enableStreaming = true;
        options.streamBufferSize = 3;
        options.maxImagePoolSize = 10;
        options.maxCursorPoolSize = 10;
        options.maxConcurrentTasks = 2;
        options.minBatchSize = 2;
        options.maxBatchSize = 20;
        options.memoryThresholdPercent = 70;
        options.enableForcedGC = true;
        options.forcedGCThresholdPercent = 75;
        return options;
    }

    public static AdvancedMemoryOptions createAggressive() {
        AdvancedMemoryOptions options = new AdvancedMemoryOptions();
        options.enableStreaming = true;
        options.streamBufferSize = 10;
        options.maxImagePoolSize = 50;
        options.maxCursorPoolSize = 50;
        options.maxConcurrentTasks = 8;
        options.minBatchSize = 5;
        options.maxBatchSize = 100;
        options.memoryThresholdPercent = 90;
        options.enableForcedGC = false;
        options.enableProfiling = true;
        return options;
    }

    public static AdvancedMemoryOptions createBalanced() {
        AdvancedMemoryOptions options = new AdvancedMemoryOptions();
        return options;
    }

    public ValidationResult validate() {
        ValidationResult result = new ValidationResult();
        if (this.streamBufferSize < 1 || this.streamBufferSize > 50) {
            result.addIssue("streamBufferSize should be between 1 and 50, got: " + this.streamBufferSize);
        }
        if (this.maxImagePoolSize < 1 || this.maxImagePoolSize > 100) {
            result.addIssue("maxImagePoolSize should be between 1 and 100, got: " + this.maxImagePoolSize);
        }
        if (this.maxCursorPoolSize < 1 || this.maxCursorPoolSize > 100) {
            result.addIssue("maxCursorPoolSize should be between 1 and 100, got: " + this.maxCursorPoolSize);
        }
        if (this.compressionLevel < 0 || this.compressionLevel > 9) {
            result.addIssue("compressionLevel should be between 0 and 9, got: " + this.compressionLevel);
        }
        if (this.maxCachedMasks < 1 || this.maxCachedMasks > 1000) {
            result.addIssue("maxCachedMasks should be between 1 and 1000, got: " + this.maxCachedMasks);
        }
        if (this.minBatchSize < 1 || this.minBatchSize > this.maxBatchSize) {
            result.addIssue("minBatchSize should be >= 1 and <= maxBatchSize, got: " + this.minBatchSize);
        }
        if (this.maxBatchSize < this.minBatchSize || this.maxBatchSize > 200) {
            result.addIssue("maxBatchSize should be >= minBatchSize and <= 200, got: " + this.maxBatchSize);
        }
        if (this.memoryThresholdPercent < 50 || this.memoryThresholdPercent > 95) {
            result.addIssue("memoryThresholdPercent should be between 50 and 95, got: " + this.memoryThresholdPercent);
        }
        if (this.maxConcurrentTasks < 1 || this.maxConcurrentTasks > 16) {
            result.addIssue("maxConcurrentTasks should be between 1 and 16, got: " + this.maxConcurrentTasks);
        }
        if (this.threadPoolKeepAliveMs < 1000L || this.threadPoolKeepAliveMs > 300000L) {
            result.addIssue("threadPoolKeepAliveMs should be between 1000 and 300000, got: " + this.threadPoolKeepAliveMs);
        }
        if (this.memoryMonitoringIntervalMs < 100L || this.memoryMonitoringIntervalMs > 10000L) {
            result.addIssue("memoryMonitoringIntervalMs should be between 100 and 10000, got: " + this.memoryMonitoringIntervalMs);
        }
        if (this.memoryLoggingThresholdPercent < 50 || this.memoryLoggingThresholdPercent > 100) {
            result.addIssue("memoryLoggingThresholdPercent should be between 50 and 100, got: " + this.memoryLoggingThresholdPercent);
        }
        if (this.forcedGCThresholdPercent < 50 || this.forcedGCThresholdPercent > 95) {
            result.addIssue("forcedGCThresholdPercent should be between 50 and 95, got: " + this.forcedGCThresholdPercent);
        }
        if (this.gcFrequencyBatches < 1 || this.gcFrequencyBatches > 50) {
            result.addIssue("gcFrequencyBatches should be between 1 and 50, got: " + this.gcFrequencyBatches);
        }
        return result;
    }

    public String getConfigurationSummary() {
        StringBuilder sb = new StringBuilder();
        sb.append("Advanced Memory Options Configuration:\n");
        sb.append("  Streaming: ").append(this.enableStreaming).append(" (buffer: ").append(this.streamBufferSize).append(")\n");
        sb.append("  Memory Pool: ").append(this.enableMemoryPool).append(" (images: ").append(this.maxImagePoolSize).append(", cursors: ").append(this.maxCursorPoolSize).append(")\n");
        sb.append("  Compression: ").append(this.enableCompression).append(" (level: ").append(this.compressionLevel).append(")\n");
        sb.append("  Adaptive Batching: ").append(this.enableAdaptiveBatchSizing).append(" (").append(this.minBatchSize).append("-").append(this.maxBatchSize).append(")\n");
        sb.append("  Concurrent Tasks: ").append(this.maxConcurrentTasks).append("\n");
        sb.append("  Memory Threshold: ").append(this.memoryThresholdPercent).append("%\n");
        sb.append("  Forced GC: ").append(this.enableForcedGC).append(" (").append(this.forcedGCThresholdPercent).append("%)\n");
        return sb.toString();
    }

    public static class ValidationResult {
        private final List<String> issues = new ArrayList<String>();

        public void addIssue(String issue) {
            this.issues.add(issue);
        }

        public boolean isValid() {
            return this.issues.isEmpty();
        }

        public List<String> getIssues() {
            return new ArrayList<String>(this.issues);
        }

        public String toString() {
            if (this.isValid()) {
                return "Configuration is valid";
            }
            StringBuilder sb = new StringBuilder("Configuration issues:\n");
            for (String issue : this.issues) {
                sb.append("  - ").append(issue).append("\n");
            }
            return sb.toString();
        }
    }
}

