/*
 * Decompiled with CFR 0.152.
 */
package plugins.fmp.multiSPOTS96.series;

import icy.image.IcyBufferedImage;
import icy.image.IcyBufferedImageUtil;
import icy.sequence.Sequence;
import java.awt.image.BufferedImage;
import java.lang.reflect.InvocationTargetException;
import javax.swing.SwingUtilities;
import plugins.fmp.multiSPOTS96.experiment.Experiment;
import plugins.fmp.multiSPOTS96.series.BuildSeries;
import plugins.fmp.multiSPOTS96.series.DetectFlyTools;
import plugins.fmp.multiSPOTS96.series.ImageProcessor;
import plugins.fmp.multiSPOTS96.series.ProcessingResult;
import plugins.fmp.multiSPOTS96.series.ProgressReporter;
import plugins.fmp.multiSPOTS96.series.SafeImageProcessor;
import plugins.fmp.multiSPOTS96.tools.ViewerFMP;
import plugins.fmp.multiSPOTS96.tools.imageTransform.ImageTransformEnums;
import plugins.fmp.multiSPOTS96.tools.imageTransform.ImageTransformOptions;

public class BuildBackground
extends BuildSeries {
    private final ImageProcessor imageProcessor;
    private final ProgressReporter progressReporter;
    private Sequence dataSequence = new Sequence();
    private Sequence referenceSequence = null;
    private ViewerFMP dataViewer = null;
    private ViewerFMP referenceViewer = null;
    private DetectFlyTools flyDetectionTools = new DetectFlyTools();
    private static final int MINIMUM_PIXELS_CHANGED_THRESHOLD = 10;

    public BuildBackground() {
        this(new SafeImageProcessor(), ProgressReporter.NO_OP);
    }

    public BuildBackground(ImageProcessor imageProcessor, ProgressReporter progressReporter) {
        this.imageProcessor = imageProcessor;
        this.progressReporter = progressReporter;
    }

    @Override
    void analyzeExperiment(Experiment experiment) {
        ProcessingResult<Void> result = this.analyzeExperimentSafely(experiment);
        if (result.isFailure()) {
            System.err.println("Background analysis failed: " + result.getErrorMessage());
            this.progressReporter.failed(result.getErrorMessage());
        } else {
            this.progressReporter.completed();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ProcessingResult<Void> analyzeExperimentSafely(Experiment experiment) {
        try {
            ProcessingResult<Void> validationResult = this.validateExperiment(experiment);
            if (validationResult.isFailure()) {
                ProcessingResult<Void> processingResult = validationResult;
                return processingResult;
            }
            ProcessingResult<Void> loadResult = this.loadExperimentData(experiment);
            if (loadResult.isFailure()) {
                ProcessingResult<Void> processingResult = loadResult;
                return processingResult;
            }
            ProcessingResult<Void> boundsResult = this.validateBoundsForCages(experiment);
            if (boundsResult.isFailure()) {
                ProcessingResult<Void> processingResult = boundsResult;
                return processingResult;
            }
            ProcessingResult<Void> buildResult = this.buildBackgroundSafely(experiment);
            if (buildResult.isFailure()) {
                ProcessingResult<Void> processingResult = buildResult;
                return processingResult;
            }
            ProcessingResult<Void> processingResult = ProcessingResult.success();
            return processingResult;
        }
        finally {
            this.cleanupResources();
        }
    }

    private ProcessingResult<Void> validateExperiment(Experiment experiment) {
        if (experiment == null) {
            return ProcessingResult.failure("Experiment cannot be null");
        }
        if (experiment.seqCamData == null) {
            return ProcessingResult.failure("Experiment must have camera data");
        }
        return ProcessingResult.success();
    }

    private ProcessingResult<Void> loadExperimentData(Experiment experiment) {
        try {
            boolean loadSuccess = this.loadSeqCamDataAndCages(experiment);
            if (!loadSuccess) {
                return ProcessingResult.failure("Failed to load DrosoTrack data");
            }
            return ProcessingResult.success();
        }
        catch (Exception e) {
            return ProcessingResult.failure("Error loading experiment data", e);
        }
    }

    private ProcessingResult<Void> validateBoundsForCages(Experiment experiment) {
        try {
            boolean boundsValid = this.checkBoundsForCages(experiment);
            if (!boundsValid) {
                return ProcessingResult.failure("Invalid bounds for cages");
            }
            return ProcessingResult.success();
        }
        catch (Exception e) {
            return ProcessingResult.failure("Error validating cage bounds", e);
        }
    }

    private ProcessingResult<Void> buildBackgroundSafely(Experiment experiment) {
        try {
            this.initializeDetectionParameters(experiment);
            ProcessingResult<Void> viewerResult = this.openBackgroundViewers(experiment);
            if (viewerResult.isFailure()) {
                return viewerResult;
            }
            ProcessingResult<Void> backgroundResult = this.executeBackgroundBuilding(experiment);
            if (backgroundResult.isFailure()) {
                return backgroundResult;
            }
            ProcessingResult<Void> saveResult = this.saveBackgroundResults(experiment);
            if (saveResult.isFailure()) {
                return saveResult;
            }
            return ProcessingResult.success();
        }
        catch (Exception e) {
            return ProcessingResult.failure("Unexpected error during background building", e);
        }
    }

    private void initializeDetectionParameters(Experiment experiment) {
        experiment.cleanPreviousDetectedFliesROIs();
        this.flyDetectionTools.initParametersForDetection(experiment, this.options);
        experiment.cagesArray.initFlyPositions(this.options.detectCage);
        this.options.threshold = this.options.thresholdDiff;
    }

    private ProcessingResult<Void> openBackgroundViewers(Experiment experiment) {
        try {
            SwingUtilities.invokeAndWait(() -> {
                this.createDataSequence(experiment);
                this.createReferenceSequence(experiment);
            });
            return ProcessingResult.success();
        }
        catch (InterruptedException | InvocationTargetException e) {
            return ProcessingResult.failure("Failed to open background viewers", e);
        }
    }

    private void createDataSequence(Experiment experiment) {
        this.dataSequence = this.newSequence("data recorded", experiment.seqCamData.getSeqImage(0, 0));
        this.dataViewer = new ViewerFMP(this.dataSequence, true, true);
    }

    private void createReferenceSequence(Experiment experiment) {
        experiment.seqReference = this.referenceSequence = this.newSequence("referenceImage", experiment.seqCamData.getReferenceImage());
        this.referenceViewer = new ViewerFMP(this.referenceSequence, true, true);
    }

    private ProcessingResult<Void> executeBackgroundBuilding(Experiment experiment) {
        try {
            ImageTransformOptions transformOptions = this.createTransformOptions();
            ProcessingResult<Void> buildResult = this.buildBackgroundImages(experiment, transformOptions);
            return buildResult;
        }
        catch (Exception e) {
            return ProcessingResult.failure("Error during background building execution", e);
        }
    }

    private ImageTransformOptions createTransformOptions() {
        ImageTransformOptions transformOptions = new ImageTransformOptions();
        transformOptions.transformOption = ImageTransformEnums.SUBTRACT;
        transformOptions.setSingleThreshold(this.options.backgroundThreshold, this.stopFlag);
        transformOptions.background_delta = this.options.background_delta;
        transformOptions.background_jitter = this.options.background_jitter;
        return transformOptions;
    }

    private ProcessingResult<Void> buildBackgroundImages(Experiment experiment, ImageTransformOptions transformOptions) {
        this.progressReporter.updateMessage("Building background image...");
        try {
            ProcessingResult<IcyBufferedImage> initialBackgroundResult = this.loadInitialBackgroundImage(experiment);
            if (initialBackgroundResult.isFailure()) {
                return ProcessingResult.failure("Failed to load initial background: " + initialBackgroundResult.getErrorMessage());
            }
            transformOptions.backgroundImage = initialBackgroundResult.getData().orElse(null);
            FrameRange frameRange = this.calculateFrameRange(experiment);
            ProcessingResult<Void> processResult = this.processFramesForBackground(experiment, transformOptions, frameRange);
            if (processResult.isFailure()) {
                return processResult;
            }
            return ProcessingResult.success();
        }
        catch (Exception e) {
            return ProcessingResult.failure("Error building background images", e);
        }
    }

    private ProcessingResult<IcyBufferedImage> loadInitialBackgroundImage(Experiment experiment) {
        String filename = experiment.seqCamData.getFileNameFromImageList(this.options.backgroundFirst);
        return this.imageProcessor.loadImage(filename);
    }

    private FrameRange calculateFrameRange(Experiment experiment) {
        long firstMs = experiment.cagesArray.detectFirst_Ms + (long)this.options.backgroundFirst * experiment.seqCamData.getTimeManager().getBinImage_ms();
        int firstFrame = (int)((firstMs - experiment.cagesArray.detectFirst_Ms) / experiment.seqCamData.getTimeManager().getBinImage_ms());
        int lastFrame = this.options.backgroundFirst + this.options.backgroundNFrames;
        int totalFrames = experiment.seqCamData.getImageLoader().getNTotalFrames();
        if (lastFrame > totalFrames) {
            lastFrame = totalFrames;
        }
        return new FrameRange(firstFrame, lastFrame);
    }

    private ProcessingResult<Void> processFramesForBackground(Experiment experiment, ImageTransformOptions transformOptions, FrameRange frameRange) {
        for (int frame = frameRange.getFirst() + 1; frame <= frameRange.getLast() && !this.stopFlag; ++frame) {
            this.progressReporter.updateProgress("Processing frame", frame, frameRange.getLast());
            ProcessingResult<IcyBufferedImage> imageResult = this.loadFrame(experiment, frame);
            if (imageResult.isFailure()) {
                return ProcessingResult.failure("Failed to load frame %d: %s", frame, imageResult.getErrorMessage());
            }
            IcyBufferedImage currentImage = imageResult.getData().orElse(null);
            this.dataSequence.setImage(0, 0, (BufferedImage)currentImage);
            ProcessingResult<ImageProcessor.BackgroundTransformResult> transformResult = this.imageProcessor.transformBackground(currentImage, transformOptions.backgroundImage, transformOptions);
            if (transformResult.isFailure()) {
                return ProcessingResult.failure("Background transformation failed at frame %d: %s", frame, transformResult.getErrorMessage());
            }
            this.referenceSequence.setImage(0, 0, (BufferedImage)transformOptions.backgroundImage);
            ImageProcessor.BackgroundTransformResult result = transformResult.getData().orElse(null);
            if (result == null || result.getPixelsChanged() >= 10) continue;
            this.progressReporter.updateMessage("Background converged at frame %d", frame);
            break;
        }
        return ProcessingResult.success();
    }

    private ProcessingResult<IcyBufferedImage> loadFrame(Experiment experiment, int frameIndex) {
        String filename = experiment.seqCamData.getFileNameFromImageList(frameIndex);
        return this.imageProcessor.loadImage(filename);
    }

    private ProcessingResult<Void> saveBackgroundResults(Experiment experiment) {
        try {
            experiment.seqCamData.setReferenceImage(IcyBufferedImageUtil.getCopy((IcyBufferedImage)this.referenceSequence.getFirstImage()));
            experiment.saveReferenceImage(this.referenceSequence.getFirstImage());
            return ProcessingResult.success();
        }
        catch (Exception e) {
            return ProcessingResult.failure("Failed to save background results", e);
        }
    }

    private void cleanupResources() {
        this.closeViewer(this.referenceViewer);
        this.closeViewer(this.dataViewer);
        this.closeSequence(this.referenceSequence);
        this.closeSequence(this.dataSequence);
    }

    private static class FrameRange {
        private final int first;
        private final int last;

        public FrameRange(int first, int last) {
            this.first = first;
            this.last = last;
        }

        public int getFirst() {
            return this.first;
        }

        public int getLast() {
            return this.last;
        }
    }
}

