/*
 * Decompiled with CFR 0.152.
 */
package plugins.fmp.multiSPOTS96.series;

import icy.gui.frame.progress.ProgressFrame;
import icy.image.IcyBufferedImage;
import icy.image.IcyBufferedImageCursor;
import icy.sequence.Sequence;
import java.awt.Point;
import java.awt.image.BufferedImage;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import javax.swing.SwingUtilities;
import plugins.fmp.multiSPOTS96.experiment.Experiment;
import plugins.fmp.multiSPOTS96.experiment.cages.Cage;
import plugins.fmp.multiSPOTS96.experiment.sequence.SequenceCamData;
import plugins.fmp.multiSPOTS96.experiment.spots.Spot;
import plugins.fmp.multiSPOTS96.series.AdvancedMemoryOptions;
import plugins.fmp.multiSPOTS96.series.BuildSeries;
import plugins.fmp.multiSPOTS96.series.ResultsThreshold;
import plugins.fmp.multiSPOTS96.tools.ROI2D.ROI2DProcessingException;
import plugins.fmp.multiSPOTS96.tools.ROI2D.ROI2DValidationException;
import plugins.fmp.multiSPOTS96.tools.ROI2D.ROI2DWithMask;
import plugins.fmp.multiSPOTS96.tools.ViewerFMP;
import plugins.fmp.multiSPOTS96.tools.imageTransform.ImageTransformInterface;
import plugins.fmp.multiSPOTS96.tools.imageTransform.ImageTransformOptions;

public class BuildSpotsMeasuresAdvanced
extends BuildSeries {
    private final LinkedBlockingQueue<IcyBufferedImage> imagePool = new LinkedBlockingQueue();
    private final LinkedBlockingQueue<IcyBufferedImageCursor> cursorPool = new LinkedBlockingQueue();
    private final int MAX_POOL_SIZE = 20;
    private final AtomicInteger poolHits = new AtomicInteger(0);
    private final AtomicInteger poolMisses = new AtomicInteger(0);
    private final StreamingImageProcessor streamingProcessor;
    private final int STREAM_BUFFER_SIZE = 5;
    private final ConcurrentHashMap<String, CompressedMask> compressedMasks = new ConcurrentHashMap();
    private final MemoryMonitor memoryMonitor;
    private final AdaptiveBatchSizer adaptiveBatchSizer;
    private final AdvancedMemoryOptions advancedOptions;
    public Sequence seqData = new Sequence();
    private ViewerFMP vData = null;
    private ImageTransformOptions transformOptions01 = null;
    ImageTransformInterface transformFunctionSpot = null;
    ImageTransformOptions transformOptions02 = null;
    ImageTransformInterface transformFunctionFly = null;

    public BuildSpotsMeasuresAdvanced(AdvancedMemoryOptions advancedOptions) {
        this.advancedOptions = advancedOptions == null ? new AdvancedMemoryOptions() : advancedOptions;
        this.streamingProcessor = new StreamingImageProcessor(5);
        this.memoryMonitor = new MemoryMonitor();
        this.adaptiveBatchSizer = new AdaptiveBatchSizer(this.memoryMonitor);
    }

    @Override
    void analyzeExperiment(Experiment exp) {
        this.getTimeLimitsOfSequence(exp);
        this.loadExperimentDataToMeasureSpots(exp);
        exp.cagesArray.setFilterOfSpotsToAnalyze(true, this.options);
        this.openViewers(exp);
        if (this.measureSpotsAdvanced(exp)) {
            this.saveComputation(exp);
        }
        exp.cagesArray.setFilterOfSpotsToAnalyze(false, this.options);
        this.closeViewers();
        this.cleanupResources();
    }

    private boolean loadExperimentDataToMeasureSpots(Experiment exp) {
        exp.load_MS96_experiment();
        exp.seqCamData.attachSequence(exp.seqCamData.getImageLoader().initSequenceFromFirstImage(exp.seqCamData.getImagesList(true)));
        boolean flag = exp.load_MS96_cages();
        if (exp.seqCamData.getTimeManager().getBinDurationMs() == 0L) {
            exp.loadFileIntervalsFromSeqCamData();
        }
        return flag;
    }

    private void saveComputation(Experiment exp) {
        String directory = exp.getDirectoryToSaveResults();
        if (directory == null) {
            return;
        }
        exp.cagesArray.transferMeasuresToLevel2D();
        exp.cagesArray.medianFilterFromSumToSumClean();
        exp.save_MS96_experiment();
        exp.save_MS96_spotsMeasures();
    }

    private void initMeasureSpots(Experiment exp) {
        this.initMasks2DCompressed(exp);
        this.initSpotsDataArrays(exp);
        if (this.transformFunctionSpot == null) {
            this.transformOptions01 = new ImageTransformOptions();
            this.transformOptions01.transformOption = this.options.transform01;
            this.transformOptions01.copyResultsToThe3planes = false;
            this.transformOptions01.setSingleThreshold(this.options.spotThreshold, this.options.spotThresholdUp);
            this.transformFunctionSpot = this.options.transform01.getFunction();
            this.transformOptions02 = new ImageTransformOptions();
            this.transformOptions02.transformOption = this.options.transform02;
            this.transformOptions02.copyResultsToThe3planes = false;
            this.transformFunctionFly = this.options.transform02.getFunction();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean measureSpotsAdvanced(Experiment exp) {
        if (exp.cagesArray.getTotalNumberOfSpots() < 1) {
            System.out.println("DetectAreas:measureAreas Abort (1): nbspots = 0");
            return false;
        }
        this.threadRunning = true;
        this.stopFlag = false;
        if (!exp.seqCamData.build_MsTimesArray_From_FileNamesList()) {
            return false;
        }
        int iiFirst = 0;
        int iiLast = exp.seqCamData.getImageLoader().getNTotalFrames();
        this.vData.setTitle(exp.seqCamData.getCSCamFileName() + ": " + iiFirst + "-" + iiLast);
        ProgressFrame progressBar1 = new ProgressFrame("Analyze stack (Advanced)");
        this.adaptiveBatchSizer.initialize(iiLast - iiFirst, this.memoryMonitor.getAvailableMemoryMB());
        this.initMeasureSpots(exp);
        this.streamingProcessor.start(exp.seqCamData, iiFirst, iiLast);
        try {
            for (int batchStart = iiFirst; batchStart < iiLast; batchStart += this.adaptiveBatchSizer.getCurrentBatchSize()) {
                if (this.stopFlag) {
                    break;
                }
                int batchEnd = Math.min(batchStart + this.adaptiveBatchSizer.getCurrentBatchSize(), iiLast);
                this.processFrameBatchAdvanced(exp, batchStart, batchEnd, iiFirst, iiLast, progressBar1);
                this.adaptiveBatchSizer.updateBatchSize(this.memoryMonitor.getMemoryUsagePercent());
                if (!(this.memoryMonitor.getMemoryUsagePercent() > (double)this.advancedOptions.memoryThresholdPercent)) continue;
                System.gc();
            }
        }
        finally {
            this.streamingProcessor.stop();
        }
        progressBar1.close();
        return true;
    }

    private void processFrameBatchAdvanced(final Experiment exp, int batchStart, int batchEnd, final int iiFirst, int iiLast, ProgressFrame progressBar1) {
        ThreadPoolExecutor executor = new ThreadPoolExecutor(this.advancedOptions.maxConcurrentTasks, this.advancedOptions.maxConcurrentTasks, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(batchEnd - batchStart));
        ArrayList tasks = new ArrayList(batchEnd - batchStart);
        int ii = batchStart;
        while (ii < batchEnd) {
            IcyBufferedImage sourceImage0;
            if (this.options.concurrentDisplay && (sourceImage0 = this.streamingProcessor.getImage(ii)) != null) {
                this.seqData.setImage(0, 0, (BufferedImage)sourceImage0);
                this.vData.setTitle("Frame #" + ii + " /" + iiLast);
            }
            final int t = ii++;
            progressBar1.setMessage("Analyze frame: " + t + "//" + iiLast);
            tasks.add(executor.submit(new Runnable(){

                @Override
                public void run() {
                    BuildSpotsMeasuresAdvanced.this.processSingleFrameAdvanced(exp, t, iiFirst);
                }
            }));
        }
        this.waitFuturesCompletion(null, tasks, null);
        executor.shutdown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processSingleFrameAdvanced(Experiment exp, int frameIndex, int iiFirst) {
        IcyBufferedImageCursor cursorToMeasureArea;
        IcyBufferedImageCursor cursorToDetectFly;
        IcyBufferedImage transformToDetectFly;
        IcyBufferedImage transformToMeasureArea;
        IcyBufferedImage sourceImage;
        block5: {
            sourceImage = null;
            transformToMeasureArea = null;
            transformToDetectFly = null;
            cursorToDetectFly = null;
            cursorToMeasureArea = null;
            sourceImage = this.streamingProcessor.getImage(frameIndex);
            if (sourceImage != null) break block5;
            System.err.println("Failed to get image for frame " + frameIndex);
            this.returnImageToPool(transformToMeasureArea);
            this.returnImageToPool(transformToDetectFly);
            this.returnCursorToPool(cursorToDetectFly);
            this.returnCursorToPool(cursorToMeasureArea);
            return;
        }
        try {
            IcyBufferedImage newTransformToDetectFly;
            IcyBufferedImage newTransformToMeasureArea;
            transformToMeasureArea = this.getImageFromPool();
            transformToDetectFly = this.getImageFromPool();
            transformToMeasureArea = transformToMeasureArea == null ? this.transformFunctionSpot.getTransformedImage(sourceImage, this.transformOptions01) : (newTransformToMeasureArea = this.transformFunctionSpot.getTransformedImage(sourceImage, this.transformOptions01));
            transformToDetectFly = transformToDetectFly == null ? this.transformFunctionFly.getTransformedImage(sourceImage, this.transformOptions02) : (newTransformToDetectFly = this.transformFunctionFly.getTransformedImage(sourceImage, this.transformOptions02));
            cursorToDetectFly = this.getCursorFromPool(transformToDetectFly);
            cursorToMeasureArea = this.getCursorFromPool(transformToMeasureArea);
            int ii_local = frameIndex - iiFirst;
            for (Cage cage : exp.cagesArray.cagesList) {
                for (Spot spot : cage.spotsArray.getSpotsList()) {
                    if (!spot.isReadyForAnalysis()) continue;
                    ROI2DWithMask roiT = spot.getROIMask();
                    ResultsThreshold results = this.measureSpotOverThresholdCompressed(cursorToMeasureArea, cursorToDetectFly, roiT);
                    spot.getFlyPresent().setIsPresentAt(ii_local, results.nPoints_fly_present);
                    spot.getSum().setValueAt(ii_local, results.sumOverThreshold / (double)results.npoints_in);
                    if (results.nPoints_no_fly == results.npoints_in) continue;
                    spot.getSum().setValueAt(ii_local, results.sumTot_no_fly_over_threshold / (double)results.nPoints_no_fly);
                }
            }
            this.returnImageToPool(transformToMeasureArea);
            this.returnImageToPool(transformToDetectFly);
            this.returnCursorToPool(cursorToDetectFly);
            this.returnCursorToPool(cursorToMeasureArea);
        }
        catch (Throwable throwable) {
            this.returnImageToPool(transformToMeasureArea);
            this.returnImageToPool(transformToDetectFly);
            this.returnCursorToPool(cursorToDetectFly);
            this.returnCursorToPool(cursorToMeasureArea);
            throw throwable;
        }
    }

    private ResultsThreshold measureSpotOverThresholdCompressed(IcyBufferedImageCursor cursorToMeasureArea, IcyBufferedImageCursor cursorToDetectFly, ROI2DWithMask roiT) {
        ResultsThreshold result = new ResultsThreshold();
        CompressedMask compressedMask = this.getCompressedMask(roiT);
        if (compressedMask == null) {
            result.npoints_in = 0;
            return result;
        }
        int[] maskX = compressedMask.getXCoordinates();
        int[] maskY = compressedMask.getYCoordinates();
        result.npoints_in = maskX.length;
        for (int offset = 0; offset < maskX.length; ++offset) {
            int x = maskX[offset];
            int y = maskY[offset];
            int value = (int)cursorToMeasureArea.get(x, y, 0);
            int value_to_detect_fly = (int)cursorToDetectFly.get(x, y, 0);
            boolean isFlyThere = this.isFlyPresent(value_to_detect_fly);
            if (!isFlyThere) {
                ++result.nPoints_no_fly;
            } else {
                ++result.nPoints_fly_present;
            }
            if (!this.isOverThreshold(value)) continue;
            result.sumOverThreshold += (double)value;
            ++result.nPointsOverThreshold;
            if (isFlyThere) continue;
            result.sumTot_no_fly_over_threshold += (double)value;
        }
        return result;
    }

    private CompressedMask getCompressedMask(ROI2DWithMask roiT) {
        String maskKey = roiT.getInputRoi().getName() + "_" + System.identityHashCode(roiT.getInputRoi());
        return this.compressedMasks.computeIfAbsent(maskKey, key -> {
            Point[] maskPoints = roiT.getMaskPoints();
            if (maskPoints == null || maskPoints.length == 0) {
                return null;
            }
            return new CompressedMask(maskPoints);
        });
    }

    private boolean isFlyPresent(double value) {
        boolean flag;
        boolean bl = flag = value > (double)this.options.flyThreshold;
        if (!this.options.flyThresholdUp) {
            flag = !flag;
        }
        return flag;
    }

    private boolean isOverThreshold(double value) {
        boolean flag;
        boolean bl = flag = value > (double)this.options.spotThreshold;
        if (!this.options.spotThresholdUp) {
            flag = !flag;
        }
        return flag;
    }

    private void initSpotsDataArrays(Experiment exp) {
        int nFrames = exp.seqCamData.getImageLoader().getNTotalFrames();
        int spotArrayGlobalIndex = 0;
        for (Cage cage : exp.cagesArray.cagesList) {
            int spotPosition = 0;
            for (Spot spot : cage.spotsArray.getSpotsList()) {
                spot.getProperties().setCagePosition(spotPosition);
                spot.getProperties().setCageID(cage.getProperties().getCageID());
                spot.getProperties().setSpotArrayIndex(spotArrayGlobalIndex);
                spot.getSum().setValues(new double[nFrames]);
                spot.getSumClean().setValues(new double[nFrames]);
                spot.getFlyPresent().setIsPresent(new int[nFrames]);
                ++spotArrayGlobalIndex;
                ++spotPosition;
            }
        }
    }

    private void initMasks2DCompressed(Experiment exp) {
        SequenceCamData seqCamData = exp.seqCamData;
        if (seqCamData.getSequence() == null) {
            seqCamData.attachSequence(exp.seqCamData.getImageLoader().initSequenceFromFirstImage(exp.seqCamData.getImagesList(true)));
        }
        for (Cage cage : exp.cagesArray.cagesList) {
            for (Spot spot : cage.spotsArray.getSpotsList()) {
                ROI2DWithMask roiT = null;
                try {
                    roiT = new ROI2DWithMask(spot.getRoi());
                    roiT.buildMask2DFromInputRoi();
                }
                catch (ROI2DProcessingException | ROI2DValidationException e) {
                    System.err.println("Error building mask for ROI: " + e.getMessage());
                    e.printStackTrace();
                }
                spot.setROIMask(roiT);
            }
        }
    }

    private IcyBufferedImage getImageFromPool() {
        IcyBufferedImage image = this.imagePool.poll();
        if (image != null) {
            this.poolHits.incrementAndGet();
        } else {
            this.poolMisses.incrementAndGet();
        }
        return image;
    }

    private void returnImageToPool(IcyBufferedImage image) {
        if (image != null && this.imagePool.size() < 20) {
            this.imagePool.offer(image);
        }
    }

    private IcyBufferedImageCursor getCursorFromPool(IcyBufferedImage image) {
        IcyBufferedImageCursor cursor = this.cursorPool.poll();
        if (cursor != null) {
            this.poolHits.incrementAndGet();
            cursor = new IcyBufferedImageCursor(image);
        } else {
            this.poolMisses.incrementAndGet();
            cursor = new IcyBufferedImageCursor(image);
        }
        return cursor;
    }

    private void returnCursorToPool(IcyBufferedImageCursor cursor) {
        if (cursor != null && this.cursorPool.size() < 20) {
            this.cursorPool.offer(cursor);
        }
    }

    private void cleanupResources() {
        this.imagePool.clear();
        this.cursorPool.clear();
        this.compressedMasks.clear();
        System.out.println("Memory Pool Stats - Hits: " + this.poolHits.get() + ", Misses: " + this.poolMisses.get());
        System.out.println("Hit Rate: " + (double)this.poolHits.get() * 100.0 / (double)(this.poolHits.get() + this.poolMisses.get()) + "%");
    }

    private void closeViewers() {
        this.closeViewer(this.vData);
        this.closeSequence(this.seqData);
    }

    private void openViewers(final Experiment exp) {
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    BuildSpotsMeasuresAdvanced.this.seqData = BuildSpotsMeasuresAdvanced.this.newSequence(exp.seqCamData.getCSCamFileName(), exp.seqCamData.getSeqImage(0, 0));
                    BuildSpotsMeasuresAdvanced.this.vData = new ViewerFMP(BuildSpotsMeasuresAdvanced.this.seqData, true, true);
                }
            });
        }
        catch (InterruptedException | InvocationTargetException e) {
            e.printStackTrace();
        }
    }

    public class StreamingImageProcessor {
        private final int bufferSize;
        private final ConcurrentHashMap<Integer, IcyBufferedImage> imageBuffer = new ConcurrentHashMap();
        private final ArrayList<String> imageFiles;
        private final int startFrame;
        private final int endFrame;
        private volatile boolean running = false;
        private Thread prefetchThread;

        public StreamingImageProcessor(int bufferSize) {
            this.bufferSize = bufferSize;
            this.imageFiles = new ArrayList();
            this.startFrame = 0;
            this.endFrame = 0;
        }

        public void start(SequenceCamData seqCamData, int startFrame, int endFrame) {
            this.running = true;
            for (int i = startFrame; i < endFrame; ++i) {
                String fileName = seqCamData.getFileNameFromImageList(i);
                if (fileName == null) continue;
                this.imageFiles.add(fileName);
            }
            this.prefetchThread = new Thread(() -> this.prefetchImages());
            this.prefetchThread.setDaemon(true);
            this.prefetchThread.start();
        }

        public void stop() {
            this.running = false;
            if (this.prefetchThread != null) {
                this.prefetchThread.interrupt();
            }
            this.imageBuffer.clear();
        }

        public IcyBufferedImage getImage(int frameIndex) {
            String fileName;
            IcyBufferedImage image = this.imageBuffer.get(frameIndex);
            if (image == null && (fileName = this.imageFiles.get(frameIndex)) != null) {
                image = BuildSpotsMeasuresAdvanced.this.imageIORead(fileName);
                this.imageBuffer.put(frameIndex, image);
            }
            return image;
        }

        private void prefetchImages() {
            for (int currentFrame = 0; this.running && currentFrame < this.imageFiles.size(); currentFrame += this.bufferSize) {
                int i;
                for (i = 0; i < this.bufferSize && currentFrame + i < this.imageFiles.size(); ++i) {
                    String fileName;
                    int frameIndex = currentFrame + i;
                    if (this.imageBuffer.containsKey(frameIndex) || (fileName = this.imageFiles.get(frameIndex)) == null) continue;
                    IcyBufferedImage image = BuildSpotsMeasuresAdvanced.this.imageIORead(fileName);
                    this.imageBuffer.put(frameIndex, image);
                }
                if (this.imageBuffer.size() > this.bufferSize * 2) {
                    for (i = Math.max(0, currentFrame - this.bufferSize); i < currentFrame; ++i) {
                        this.imageBuffer.remove(i);
                    }
                }
                try {
                    Thread.sleep(100L);
                    continue;
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    break;
                }
            }
        }
    }

    public static class MemoryMonitor {
        private final Runtime runtime = Runtime.getRuntime();

        public long getTotalMemoryMB() {
            return this.runtime.totalMemory() / 1024L / 1024L;
        }

        public long getFreeMemoryMB() {
            return this.runtime.freeMemory() / 1024L / 1024L;
        }

        public long getUsedMemoryMB() {
            return this.getTotalMemoryMB() - this.getFreeMemoryMB();
        }

        public long getMaxMemoryMB() {
            return this.runtime.maxMemory() / 1024L / 1024L;
        }

        public double getMemoryUsagePercent() {
            return (double)this.getUsedMemoryMB() / (double)this.getMaxMemoryMB() * 100.0;
        }

        public long getAvailableMemoryMB() {
            return this.getMaxMemoryMB() - this.getUsedMemoryMB();
        }
    }

    public static class AdaptiveBatchSizer {
        private final MemoryMonitor memoryMonitor;
        private int currentBatchSize;
        private final int minBatchSize = 3;
        private final int maxBatchSize = 50;

        public AdaptiveBatchSizer(MemoryMonitor memoryMonitor) {
            this.memoryMonitor = memoryMonitor;
            this.currentBatchSize = 10;
        }

        public void initialize(int totalFrames, long availableMemoryMB) {
            int optimalBatchSize = (int)Math.min(50L, Math.max(3L, availableMemoryMB / 100L));
            this.currentBatchSize = Math.min(optimalBatchSize, totalFrames);
        }

        public void updateBatchSize(double memoryUsagePercent) {
            if (memoryUsagePercent > 85.0) {
                this.currentBatchSize = Math.max(3, this.currentBatchSize - 2);
            } else if (memoryUsagePercent < 50.0) {
                this.currentBatchSize = Math.min(50, this.currentBatchSize + 1);
            }
        }

        public int getCurrentBatchSize() {
            return this.currentBatchSize;
        }
    }

    public static class CompressedMask {
        private final int[] xCoords;
        private final int[] yCoords;
        private final byte[] compressedData;
        private final int originalSize;

        public CompressedMask(Point[] points) {
            this.xCoords = new int[points.length];
            this.yCoords = new int[points.length];
            this.originalSize = points.length * 8;
            for (int i = 0; i < points.length; ++i) {
                this.xCoords[i] = points[i].x;
                this.yCoords[i] = points[i].y;
            }
            this.compressedData = this.compressCoordinates(this.xCoords, this.yCoords);
        }

        public int[] getXCoordinates() {
            return this.xCoords;
        }

        public int[] getYCoordinates() {
            return this.yCoords;
        }

        public double getCompressionRatio() {
            return (double)this.compressedData.length / (double)this.originalSize;
        }

        private byte[] compressCoordinates(int[] x, int[] y) {
            ArrayList<Byte> compressed = new ArrayList<Byte>();
            for (int i = 0; i < x.length; ++i) {
                if (i > 0 && x[i] == x[i - 1] + 1 && y[i] == y[i - 1]) {
                    compressed.add((byte)1);
                    continue;
                }
                if (i > 0 && x[i] == x[i - 1] && y[i] == y[i - 1] + 1) {
                    compressed.add((byte)2);
                    continue;
                }
                compressed.add((byte)0);
                compressed.add((byte)(x[i] >> 8));
                compressed.add((byte)(x[i] & 0xFF));
                compressed.add((byte)(y[i] >> 8));
                compressed.add((byte)(y[i] & 0xFF));
            }
            byte[] result = new byte[compressed.size()];
            for (int i = 0; i < compressed.size(); ++i) {
                result[i] = (Byte)compressed.get(i);
            }
            return result;
        }
    }
}

