/*
 * Decompiled with CFR 0.152.
 */
package plugins.fmp.multiSPOTS96.tools.ROI2D;

import icy.roi.ROI;
import icy.roi.ROIEvent;
import icy.roi.ROIListener;
import icy.sequence.Sequence;
import icy.type.geom.Polygon2D;
import icy.type.geom.Polyline2D;
import java.awt.Color;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.logging.Logger;
import plugins.fmp.multiSPOTS96.tools.ROI2D.ROI2DGeometryException;
import plugins.fmp.multiSPOTS96.tools.ROI2D.ROI2DPolygonPlus;
import plugins.fmp.multiSPOTS96.tools.ROI2D.ROI2DProcessingException;
import plugins.fmp.multiSPOTS96.tools.ROI2D.ROI2DValidationException;
import plugins.fmp.multiSPOTS96.tools.ROI2D.ROI2DValidator;
import plugins.kernel.roi.roi2d.ROI2DPolyLine;

public class ROI2DGrid
implements ROIListener {
    private static final Logger logger = Logger.getLogger(ROI2DGrid.class.getName());
    private final ReadWriteLock lock = new ReentrantReadWriteLock();
    private Point2D.Double[][] grid;
    private ArrayList<ROI2DPolyLine> columnRois;
    private ArrayList<ROI2DPolyLine> rowRois;
    private ArrayList<ROI2DPolygonPlus> areaRois;
    private int gridRows = 0;
    private int gridColumns = 0;
    private volatile boolean updateEnabled = true;
    private boolean gridInitialized = false;

    public void createGridFromFrame(Polygon2D polygon, int columns, int rows) throws ROI2DValidationException, ROI2DGeometryException {
        ROI2DValidator.validateNotNull(polygon, "polygon");
        ROI2DValidator.validatePolygonSides(polygon, 4, "polygon");
        ROI2DValidator.validateGridDimensions(columns, rows);
        this.lock.writeLock().lock();
        try {
            this.gridRows = rows + 1;
            this.gridColumns = columns + 1;
            this.grid = this.createGridWithPolygon(polygon, columns, rows);
            this.columnRois = new ArrayList(this.gridColumns);
            this.rowRois = new ArrayList(this.gridRows);
            this.createColumnRois();
            this.createRowRois();
            this.gridInitialized = true;
        }
        catch (Exception e) {
            this.gridInitialized = false;
            throw new ROI2DGeometryException("createGridFromFrame", "Failed to create grid", e);
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    private void createColumnRois() {
        for (int column = 0; column < this.gridColumns; ++column) {
            ROI2DPolyLine roi = this.getVerticalROI(column);
            roi.setName("col_" + column);
            this.columnRois.add(roi);
            roi.addListener((ROIListener)this);
        }
    }

    private void createRowRois() {
        for (int row = 0; row < this.gridRows; ++row) {
            ROI2DPolyLine roi = this.getHorizontalROI(row);
            roi.setName("row_" + row);
            this.rowRois.add(roi);
            roi.addListener((ROIListener)this);
        }
    }

    public ArrayList<ROI2DPolyLine> getHorizontalRois() {
        this.lock.readLock().lock();
        try {
            ArrayList<ROI2DPolyLine> arrayList = this.rowRois != null ? new ArrayList<ROI2DPolyLine>(this.rowRois) : new ArrayList();
            return arrayList;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public ArrayList<ROI2DPolyLine> getVerticalRois() {
        this.lock.readLock().lock();
        try {
            ArrayList<ROI2DPolyLine> arrayList = this.columnRois != null ? new ArrayList<ROI2DPolyLine>(this.columnRois) : new ArrayList();
            return arrayList;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public ArrayList<ROI2DPolygonPlus> getAreaRois() {
        this.lock.readLock().lock();
        try {
            ArrayList<ROI2DPolygonPlus> arrayList = this.areaRois != null ? new ArrayList<ROI2DPolygonPlus>(this.areaRois) : new ArrayList();
            return arrayList;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList<ROI2DPolygonPlus> getSelectedAreaRois() {
        this.lock.readLock().lock();
        try {
            ArrayList<ROI2DPolygonPlus> selectedRois = new ArrayList<ROI2DPolygonPlus>();
            if (this.areaRois != null) {
                for (ROI2DPolygonPlus roiP : this.areaRois) {
                    if (!roiP.isSelected()) continue;
                    selectedRois.add(roiP);
                }
            }
            ArrayList<ROI2DPolygonPlus> arrayList = selectedRois;
            return arrayList;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ROI2DPolygonPlus getAreaAt(int position) throws ROI2DValidationException {
        this.lock.readLock().lock();
        try {
            if (this.areaRois == null) {
                ROI2DPolygonPlus rOI2DPolygonPlus = null;
                return rOI2DPolygonPlus;
            }
            ROI2DValidator.validateArrayIndex(position, this.areaRois.size(), "position");
            ROI2DPolygonPlus roiP = this.areaRois.get(position);
            int actualPosition = roiP.getCagePosition();
            if (actualPosition != position) {
                for (ROI2DPolygonPlus roi : this.areaRois) {
                    if (roi.getCagePosition() != position) continue;
                    ROI2DPolygonPlus rOI2DPolygonPlus = roi;
                    return rOI2DPolygonPlus;
                }
                Iterator<ROI2DPolygonPlus> iterator = null;
                return iterator;
            }
            ROI2DPolygonPlus rOI2DPolygonPlus = roiP;
            return rOI2DPolygonPlus;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Point2D.Double[][] getGridPoints() {
        this.lock.readLock().lock();
        try {
            if (this.grid == null) {
                Point2D.Double[][] doubleArray = null;
                return doubleArray;
            }
            Point2D.Double[][] copy = new Point2D.Double[this.grid.length][];
            for (int i = 0; i < this.grid.length; ++i) {
                if (this.grid[i] == null) continue;
                copy[i] = new Point2D.Double[this.grid[i].length];
                for (int j = 0; j < this.grid[i].length; ++j) {
                    if (this.grid[i][j] == null) continue;
                    copy[i][j] = (Point2D.Double)this.grid[i][j].clone();
                }
            }
            Point2D.Double[][] doubleArray = copy;
            return doubleArray;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public void clearGridRois(Sequence sequence) throws ROI2DValidationException {
        ROI2DValidator.validateNotNull(sequence, "sequence");
        this.lock.writeLock().lock();
        try {
            if (this.rowRois != null && !this.rowRois.isEmpty()) {
                sequence.removeROIs(this.rowRois, false);
            }
            if (this.columnRois != null && !this.columnRois.isEmpty()) {
                sequence.removeROIs(this.columnRois, false);
            }
            if (this.areaRois != null && !this.areaRois.isEmpty()) {
                sequence.removeROIs(this.areaRois, false);
            }
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    public void gridToRois(String cageRoot, Color color, int widthInterval, int heightInterval) throws ROI2DValidationException, ROI2DProcessingException {
        if (cageRoot == null) {
            cageRoot = "cage_";
        }
        if (!this.gridInitialized) {
            throw new ROI2DProcessingException("gridToRois", "Grid has not been initialized. Call createGridFromFrame() first");
        }
        this.lock.writeLock().lock();
        try {
            int totalAreas = (this.gridColumns - 1) * (this.gridRows - 1);
            this.areaRois = new ArrayList(totalAreas);
            int index = 0;
            for (int row = 0; row < this.gridRows - 1; ++row) {
                for (int column = 0; column < this.gridColumns - 1; ++column) {
                    ROI2DPolygonPlus roiP = this.createRoiPolygon(column, row, widthInterval, heightInterval);
                    roiP.setName(cageRoot + String.format("%03d", index));
                    if (color != null) {
                        roiP.setColor(color);
                    }
                    try {
                        roiP.setCageRow(row);
                        roiP.setCageColumn(column);
                        roiP.setCagePosition(index);
                    }
                    catch (ROI2DValidationException e) {
                        throw new ROI2DProcessingException("gridToRois", "Failed to set cage properties", e);
                    }
                    this.areaRois.add(roiP);
                    ++index;
                }
            }
        }
        catch (ROI2DValidationException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ROI2DProcessingException("gridToRois", "Failed to convert grid to ROIs", e);
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    private ROI2DPolygonPlus createRoiPolygon(int column, int row, int width, int height) throws ROI2DValidationException {
        ROI2DValidator.validateArrayIndex(column, this.gridColumns - 1, "column");
        ROI2DValidator.validateArrayIndex(row, this.gridRows - 1, "row");
        ArrayList<Point2D> points = new ArrayList<Point2D>(4);
        Point2D.Double pt = (Point2D.Double)this.grid[column][row].clone();
        pt.x += (double)width;
        pt.y += (double)height;
        points.add(pt);
        pt = (Point2D.Double)this.grid[column][row + 1].clone();
        pt.x += (double)width;
        pt.y -= (double)height;
        points.add(pt);
        pt = (Point2D.Double)this.grid[column + 1][row + 1].clone();
        pt.x -= (double)width;
        pt.y -= (double)height;
        points.add(pt);
        pt = (Point2D.Double)this.grid[column + 1][row].clone();
        pt.x -= (double)width;
        pt.y += (double)height;
        points.add(pt);
        return new ROI2DPolygonPlus(points, row, column);
    }

    private Point2D.Double[][] createGridWithPolygon(Polygon2D polygon, int columns, int rows) throws ROI2DGeometryException {
        try {
            Point2D.Double[][] arrayPoints = new Point2D.Double[columns + 1][rows + 1];
            for (int col = 0; col <= columns; ++col) {
                double ratioX = (double)col / (double)columns;
                double x = polygon.xpoints[0] + (polygon.xpoints[3] - polygon.xpoints[0]) * ratioX;
                double y = polygon.ypoints[0] + (polygon.ypoints[3] - polygon.ypoints[0]) * ratioX;
                Point2D.Double point0 = new Point2D.Double(x, y);
                x = polygon.xpoints[1] + (polygon.xpoints[2] - polygon.xpoints[1]) * ratioX;
                y = polygon.ypoints[1] + (polygon.ypoints[2] - polygon.ypoints[1]) * ratioX;
                Point2D.Double point1 = new Point2D.Double(x, y);
                for (int row = 0; row <= rows; ++row) {
                    double ratioY = (double)row / (double)rows;
                    x = point0.x + (point1.x - point0.x) * ratioY;
                    y = point0.y + (point1.y - point0.y) * ratioY;
                    arrayPoints[col][row] = new Point2D.Double(x, y);
                }
            }
            return arrayPoints;
        }
        catch (Exception e) {
            throw new ROI2DGeometryException("createGridWithPolygon", "Failed to create grid points", e);
        }
    }

    private ROI2DPolyLine getVerticalROI(int column) {
        ArrayList<Point2D.Double> points = new ArrayList<Point2D.Double>(this.gridRows);
        for (int row = 0; row < this.gridRows; ++row) {
            points.add(this.grid[column][row]);
        }
        return new ROI2DPolyLine(points);
    }

    private ROI2DPolyLine getHorizontalROI(int row) {
        ArrayList<Point2D.Double> points = new ArrayList<Point2D.Double>(this.gridColumns);
        for (int column = 0; column < this.gridColumns; ++column) {
            points.add(this.grid[column][row]);
        }
        return new ROI2DPolyLine(points);
    }

    private Polyline2D getVerticalLine(int column) {
        double[] xpoints = new double[this.gridRows];
        double[] ypoints = new double[this.gridRows];
        for (int row = 0; row < this.gridRows; ++row) {
            xpoints[row] = this.grid[column][row].x;
            ypoints[row] = this.grid[column][row].y;
        }
        return new Polyline2D(xpoints, ypoints, this.gridRows);
    }

    private Polyline2D getHorizontalLine(int row) {
        double[] xpoints = new double[this.gridColumns];
        double[] ypoints = new double[this.gridColumns];
        for (int column = 0; column < this.gridColumns; ++column) {
            xpoints[column] = this.grid[column][row].x;
            ypoints[column] = this.grid[column][row].y;
        }
        return new Polyline2D(xpoints, ypoints, this.gridColumns);
    }

    private void updateGridFromVerticalROI(int column, ROI2DPolyLine roi) {
        Polyline2D line = roi.getPolyline2D();
        for (int row = 0; row < this.gridRows; ++row) {
            if (row >= line.npoints) continue;
            this.grid[column][row].x = line.xpoints[row];
            this.grid[column][row].y = line.ypoints[row];
        }
    }

    private void updateGridFromHorizontalROI(int row, ROI2DPolyLine roi) {
        Polyline2D line = roi.getPolyline2D();
        for (int column = 0; column < this.gridColumns; ++column) {
            if (column >= line.npoints) continue;
            this.grid[column][row].x = line.xpoints[column];
            this.grid[column][row].y = line.ypoints[column];
        }
    }

    private void updateHorizontalROIFromGridValues(int row) {
        if (row >= 0 && row < this.rowRois.size()) {
            ROI2DPolyLine roi = this.rowRois.get(row);
            roi.setPolyline2D(this.getHorizontalLine(row));
        }
    }

    private void updateVerticalROIFromGridValues(int column) {
        if (column >= 0 && column < this.columnRois.size()) {
            ROI2DPolyLine roi = this.columnRois.get(column);
            roi.setPolyline2D(this.getVerticalLine(column));
        }
    }

    public boolean isGridInitialized() {
        this.lock.readLock().lock();
        try {
            boolean bl = this.gridInitialized;
            return bl;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public int getGridRows() {
        this.lock.readLock().lock();
        try {
            int n = this.gridRows;
            return n;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public int getGridColumns() {
        this.lock.readLock().lock();
        try {
            int n = this.gridColumns;
            return n;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public void setUpdateEnabled(boolean enabled) {
        this.updateEnabled = enabled;
    }

    public boolean isUpdateEnabled() {
        return this.updateEnabled;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void roiChanged(ROIEvent event) {
        if (!this.updateEnabled || !this.gridInitialized) {
            return;
        }
        if (event.getType() == ROIEvent.ROIEventType.ROI_CHANGED) {
            this.lock.writeLock().lock();
            try {
                ROI roi = event.getSource();
                String name = roi.getName();
                if (name == null) {
                    return;
                }
                int index = this.extractIndexFromName(name);
                if (index < 0) {
                    return;
                }
                this.updateEnabled = false;
                try {
                    if (name.contains("row")) {
                        this.handleRowUpdate(index, (ROI2DPolyLine)roi);
                    } else if (name.contains("col")) {
                        this.handleColumnUpdate(index, (ROI2DPolyLine)roi);
                    }
                }
                finally {
                    this.updateEnabled = true;
                }
            }
            catch (Exception e) {
                logger.warning("Failed to update grid from ROI change: " + e.getMessage());
            }
            finally {
                this.lock.writeLock().unlock();
            }
        }
    }

    private void handleRowUpdate(int index, ROI2DPolyLine roi) {
        if (index >= 0 && index < this.gridRows) {
            this.updateGridFromHorizontalROI(index, roi);
            for (int i = 0; i < this.gridColumns; ++i) {
                this.updateVerticalROIFromGridValues(i);
            }
        }
    }

    private void handleColumnUpdate(int index, ROI2DPolyLine roi) {
        if (index >= 0 && index < this.gridColumns) {
            this.updateGridFromVerticalROI(index, roi);
            for (int i = 0; i < this.gridRows; ++i) {
                this.updateHorizontalROIFromGridValues(i);
            }
        }
    }

    private int extractIndexFromName(String name) {
        try {
            int lastSeparator = name.lastIndexOf("_");
            if (lastSeparator >= 0 && lastSeparator < name.length() - 1) {
                return Integer.parseInt(name.substring(lastSeparator + 1));
            }
        }
        catch (NumberFormatException e) {
            logger.warning("Failed to extract index from ROI name: " + name);
        }
        return -1;
    }

    public String toString() {
        this.lock.readLock().lock();
        try {
            String string = String.format("ROI2DGrid[rows=%d, columns=%d, initialized=%s, areas=%d]", this.gridRows, this.gridColumns, this.gridInitialized, this.areaRois != null ? this.areaRois.size() : 0);
            return string;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }
}

