/*
 * Decompiled with CFR 0.152.
 */
package plugins.fmp.multiSPOTS96.tools.canvas2D;

import icy.canvas.Canvas2D;
import icy.gui.component.button.IcyButton;
import icy.gui.viewer.Viewer;
import icy.image.IcyBufferedImage;
import icy.resource.icon.IcyIcon;
import icy.sequence.Sequence;
import java.awt.Component;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.logging.Logger;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JToolBar;
import plugins.fmp.multiSPOTS96.resource.ResourceUtilFMP;
import plugins.fmp.multiSPOTS96.tools.canvas2D.Canvas2DConstants;
import plugins.fmp.multiSPOTS96.tools.imageTransform.ImageTransformEnums;
import plugins.fmp.multiSPOTS96.tools.imageTransform.ImageTransformInterface;
import plugins.fmp.multiSPOTS96.tools.imageTransform.ImageTransformOptions;

public class Canvas2D_3Transforms
extends Canvas2D {
    private static final long serialVersionUID = 8827595503996677250L;
    private static final Logger logger = Logger.getLogger(Canvas2D_3Transforms.class.getName());
    private final JComboBox<ImageTransformEnums> transformsComboStep1;
    private final JComboBox<ImageTransformEnums> transformsComboStep2;
    private ImageTransformInterface transformStep1;
    private ImageTransformInterface transformStep2;
    private final ImageTransformOptions optionsStep1 = new ImageTransformOptions();
    private final ImageTransformOptions optionsStep2 = new ImageTransformOptions();
    private final TransformStep1Handler transformStep1Handler;
    private final TransformStep2Handler transformStep2Handler;
    private final ScalingHandler scalingHandler;
    private final NavigationHandler navigationHandler;

    public Canvas2D_3Transforms(Viewer viewer) {
        super(viewer);
        this.transformsComboStep1 = new JComboBox<ImageTransformEnums>(Canvas2DConstants.DefaultTransforms.STEP1_TRANSFORMS);
        this.transformsComboStep2 = new JComboBox<ImageTransformEnums>(Canvas2DConstants.DefaultTransforms.STEP2_TRANSFORMS);
        this.transformStep1 = ImageTransformEnums.NONE.getFunction();
        this.transformStep2 = ImageTransformEnums.NONE.getFunction();
        this.transformStep1Handler = new TransformStep1Handler();
        this.transformStep2Handler = new TransformStep2Handler();
        this.scalingHandler = new ScalingHandler();
        this.navigationHandler = new NavigationHandler();
    }

    public void customizeToolbar(JToolBar toolBar) {
        try {
            this.setupToolbarStep1(toolBar);
            super.customizeToolbar(toolBar);
        }
        catch (Exception e) {
            logger.severe(String.format("Failed to setup toolbar: %s", e.getMessage()));
        }
    }

    private void setupToolbarStep1(JToolBar toolBar) {
        for (int i = 3; i >= 0; --i) {
            if (toolBar.getComponentCount() <= i) continue;
            toolBar.remove(i);
        }
        toolBar.addSeparator();
        toolBar.add(new JLabel("step1"));
        toolBar.add(this.transformsComboStep1);
        this.transformsComboStep1.setToolTipText("transform image step 1");
        this.addScalingButtons(toolBar);
        this.transformsComboStep1.addActionListener(this.transformStep1Handler);
        this.transformsComboStep1.setSelectedIndex(0);
        this.refresh();
    }

    private void addScalingButtons(JToolBar toolBar) {
        IcyButton fitYAxisButton = this.createToolbarButton(ResourceUtilFMP.ICON_FIT_YAXIS, "Set image scale ratio to 1:1 and fit Y axis to the window height", this.scalingHandler::fitYAxis);
        toolBar.add((Component)fitYAxisButton);
        IcyButton fitXYAxisButton = this.createToolbarButton(ResourceUtilFMP.ICON_FIT_XAXIS, "Fit X and Y axis to the window size", this.scalingHandler::fitXYAxis);
        toolBar.add((Component)fitXYAxisButton);
    }

    private IcyButton createToolbarButton(IcyIcon icon, String tooltip, Runnable action) {
        IcyButton button = new IcyButton(icon);
        button.setSelected(false);
        button.setFocusable(false);
        button.setToolTipText(tooltip);
        button.addActionListener(e -> action.run());
        return button;
    }

    @Deprecated
    void zoomImage_1_1() {
        this.scalingHandler.fitYAxis();
    }

    @Deprecated
    void shrinkImage_to_fit() {
        this.scalingHandler.fitXYAxis();
    }

    public IcyBufferedImage getImage(int t, int z, int c) {
        try {
            IcyBufferedImage originalImage = super.getImage(t, z, c);
            if (originalImage == null) {
                return null;
            }
            if (this.transformStep1 != null) {
                IcyBufferedImage step1Result = this.transformStep1.getTransformedImage(originalImage, this.optionsStep1);
                if (this.transformStep2 != null) {
                    return this.transformStep2.getTransformedImage(step1Result, this.optionsStep2);
                }
                return step1Result;
            }
            return super.getImage(t, z, c);
        }
        catch (Exception e) {
            logger.severe(String.format("Image transformation failed: %s", e.getMessage()));
            return super.getImage(t, z, c);
        }
    }

    public int addTransformStep1(ImageTransformEnums transform) {
        if (transform == null) {
            throw new IllegalArgumentException("Transform enum cannot be null");
        }
        int indexFound = -1;
        for (int index = 0; index < this.transformsComboStep1.getItemCount(); ++index) {
            if (transform != this.transformsComboStep1.getItemAt(index)) continue;
            indexFound = index;
            break;
        }
        if (indexFound < 0) {
            this.transformsComboStep1.addItem(transform);
            this.transformsComboStep1.setSelectedItem((Object)transform);
            indexFound = this.transformsComboStep1.getSelectedIndex();
        }
        return indexFound;
    }

    public void updateTransformsStep1(ImageTransformEnums[] transforms) {
        this.updateTransformsCombo(transforms, this.transformsComboStep1);
    }

    public void updateTransformsStep2(ImageTransformEnums[] transforms) {
        this.updateTransformsCombo(transforms, this.transformsComboStep2);
    }

    private void updateTransformsCombo(ImageTransformEnums[] transforms, JComboBox<ImageTransformEnums> comboBox) {
        ActionListener[] listeners;
        for (ActionListener actionListener : listeners = comboBox.getActionListeners()) {
            comboBox.removeActionListener(actionListener);
        }
        comboBox.removeAllItems();
        comboBox.addItem(ImageTransformEnums.NONE);
        for (ImageTransformEnums imageTransformEnums : transforms) {
            comboBox.addItem(imageTransformEnums);
        }
        for (ActionListener actionListener : listeners) {
            comboBox.addActionListener(actionListener);
        }
    }

    public ImageTransformOptions getOptionsStep1() {
        return this.optionsStep1;
    }

    public void setOptionsStep1(ImageTransformOptions options) {
        if (options != null) {
            this.copyOptionsFields(options, this.optionsStep1);
        }
    }

    public ImageTransformOptions getOptionsStep2() {
        return this.optionsStep2;
    }

    public void setOptionsStep2(ImageTransformOptions options) {
        if (options != null) {
            this.copyOptionsFields(options, this.optionsStep2);
        }
    }

    public void setTransformStep1(int index, ImageTransformOptions options) {
        this.validateTransformIndex(index, this.transformsComboStep1.getItemCount());
        this.transformsComboStep1.setSelectedIndex(index);
        if (options != null) {
            this.copyOptionsFields(options, this.optionsStep1);
        }
    }

    public void setTransformStep1(ImageTransformEnums transform, ImageTransformOptions options) {
        if (transform == null) {
            throw new IllegalArgumentException("Transform enum cannot be null");
        }
        this.transformsComboStep1.setSelectedItem((Object)transform);
        if (options != null) {
            this.copyOptionsFields(options, this.optionsStep1);
        }
    }

    public void setTransformStep1Index(int index) {
        this.setTransformStep1(index, null);
    }

    public void setTransformStep2Index(int index) {
        this.setTransformStep2(index, null);
    }

    public int getTransformStep1ItemCount() {
        return this.transformsComboStep1.getItemCount();
    }

    public int getTransformStep2ItemCount() {
        return this.transformsComboStep2.getItemCount();
    }

    public void setTransformStep2(int index, ImageTransformOptions options) {
        this.validateTransformIndex(index, this.transformsComboStep2.getItemCount());
        this.transformsComboStep2.setSelectedIndex(index);
        if (options != null) {
            this.copyOptionsFields(options, this.optionsStep2);
        }
    }

    public void setTransformStep2(ImageTransformEnums transform, ImageTransformOptions options) {
        if (transform == null) {
            throw new IllegalArgumentException("Transform enum cannot be null");
        }
        this.transformsComboStep2.setSelectedItem((Object)transform);
        if (options != null) {
            this.copyOptionsFields(options, this.optionsStep2);
        }
    }

    private void validateTransformIndex(int index, int maxIndex) {
        if (index < 0 || index >= maxIndex) {
            throw new IllegalArgumentException(String.format("Invalid transform index: %d", index));
        }
    }

    private void copyOptionsFields(ImageTransformOptions source, ImageTransformOptions target) {
        if (source == null || target == null) {
            return;
        }
        target.transformOption = source.transformOption;
        target.backgroundImage = source.backgroundImage;
        target.secondImage = source.secondImage;
        target.copyResultsToThe3planes = source.copyResultsToThe3planes;
        target.simplethreshold = source.simplethreshold;
        target.background_delta = source.background_delta;
        target.background_jitter = source.background_jitter;
        target.colorthreshold = source.colorthreshold;
        target.colordistanceType = source.colordistanceType;
        target.ifGreater = source.ifGreater;
        target.colorarray = source.colorarray;
        target.xfirst = source.xfirst;
        target.xlast = source.xlast;
        target.yfirst = source.yfirst;
        target.ylast = source.ylast;
        target.channel0 = source.channel0;
        target.channel1 = source.channel1;
        target.channel2 = source.channel2;
        target.w0 = source.w0;
        target.w1 = source.w1;
        target.w2 = source.w2;
        target.spanDiff = source.spanDiff;
    }

    @Deprecated
    public void selectImageTransformFunctionStep1(int iselected, ImageTransformOptions options) {
        this.setTransformStep1(iselected, options);
    }

    @Deprecated
    public void selectImageTransformFunctionStep2(int iselected, ImageTransformOptions options) {
        this.setTransformStep2(iselected, options);
    }

    @Deprecated
    public void selectIndexStep1(int iselected, ImageTransformOptions options) {
        this.setTransformStep1(iselected, options);
    }

    @Deprecated
    public void selectItemStep1(ImageTransformEnums item, ImageTransformOptions options) {
        this.setTransformStep1(item, options);
    }

    @Deprecated
    public void selectIndexStep2(int iselected, ImageTransformOptions options) {
        this.setTransformStep2(iselected, options);
    }

    @Deprecated
    public void selectItemStep2(ImageTransformEnums item, ImageTransformOptions options) {
        this.setTransformStep2(item, options);
    }

    @Deprecated
    public int addTransformsComboStep1(ImageTransformEnums transform) {
        return this.addTransformStep1(transform);
    }

    @Deprecated
    public void updateTransformsComboStep1(ImageTransformEnums[] transformArray) {
        this.updateTransformsStep1(transformArray);
    }

    @Deprecated
    public void updateTransformsComboStep2(ImageTransformEnums[] transformArray) {
        this.updateTransformsStep2(transformArray);
    }

    public void customizeToolbarStep2(JToolBar toolBar) {
        try {
            this.addNavigationButtons(toolBar);
            super.customizeToolbar(toolBar);
            this.addStep2Controls(toolBar);
        }
        catch (Exception e) {
            logger.severe(String.format("Failed to setup toolbar: %s", e.getMessage()));
        }
    }

    private void addNavigationButtons(JToolBar toolBar) {
        toolBar.addSeparator();
        IcyButton previousButton = this.createToolbarButton(ResourceUtilFMP.ICON_PREVIOUS_IMAGE, "Previous", this.navigationHandler::goToPrevious);
        toolBar.add((Component)previousButton, 0);
        IcyButton nextButton = this.createToolbarButton(ResourceUtilFMP.ICON_NEXT_IMAGE, "Next", this.navigationHandler::goToNext);
        toolBar.add((Component)nextButton, 1);
    }

    private void addStep2Controls(JToolBar toolBar) {
        toolBar.add((Component)new JLabel("step2"), 6);
        toolBar.add((Component)this.transformsComboStep2, 7);
        this.transformsComboStep2.setToolTipText("transform image step 2");
        this.transformsComboStep2.addActionListener(this.transformStep2Handler);
    }

    public void setReferenceImage(IcyBufferedImage referenceImage) {
        this.optionsStep1.backgroundImage = referenceImage;
    }

    @Deprecated
    public void setTransformStep1ReferenceImage(IcyBufferedImage refImage) {
        this.setReferenceImage(refImage);
    }

    private class TransformStep1Handler
    implements ActionListener {
        private TransformStep1Handler() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ImageTransformEnums selectedTransform = (ImageTransformEnums)((Object)Canvas2D_3Transforms.this.transformsComboStep1.getSelectedItem());
            if (selectedTransform != null) {
                ((Canvas2D_3Transforms)Canvas2D_3Transforms.this).optionsStep1.transformOption = selectedTransform;
                Canvas2D_3Transforms.this.transformStep1 = selectedTransform.getFunction();
                Canvas2D_3Transforms.this.refresh();
            }
        }
    }

    private class TransformStep2Handler
    implements ActionListener {
        private TransformStep2Handler() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ImageTransformEnums selectedTransform = (ImageTransformEnums)((Object)Canvas2D_3Transforms.this.transformsComboStep2.getSelectedItem());
            if (selectedTransform != null) {
                Canvas2D_3Transforms.this.transformStep2 = selectedTransform.getFunction();
                Canvas2D_3Transforms.this.refresh();
            }
        }
    }

    private class ScalingHandler {
        private ScalingHandler() {
        }

        public void fitYAxis() {
            try {
                double scaleY;
                Sequence sequence = Canvas2D_3Transforms.this.getSequence();
                if (sequence == null) {
                    return;
                }
                Rectangle imageRect = sequence.getBounds2D();
                Rectangle canvasRect = Canvas2D_3Transforms.this.getCanvasVisibleRect();
                double scaleX = scaleY = canvasRect.getHeight() / imageRect.getHeight();
                int offsetX = (int)((double)canvasRect.width / Canvas2D_3Transforms.this.getScaleX() / 2.0);
                Canvas2D_3Transforms.this.setMouseImagePos(offsetX, imageRect.height / 2);
                Canvas2D_3Transforms.this.setScale(scaleX, scaleY, true, true);
            }
            catch (Exception e) {
                logger.warning("Failed to fit Y axis: " + e.getMessage());
            }
        }

        public void fitXYAxis() {
            try {
                Sequence sequence = Canvas2D_3Transforms.this.getSequence();
                if (sequence == null) {
                    return;
                }
                Rectangle imageRect = sequence.getBounds2D();
                Rectangle canvasRect = Canvas2D_3Transforms.this.getCanvasVisibleRect();
                double scaleX = canvasRect.getWidth() / imageRect.getWidth();
                double scaleY = canvasRect.getHeight() / imageRect.getHeight();
                Canvas2D_3Transforms.this.setMouseImagePos(imageRect.width / 2, imageRect.height / 2);
                Canvas2D_3Transforms.this.setScale(scaleX, scaleY, true, true);
            }
            catch (Exception e) {
                logger.warning("Failed to fit XY axis: " + e.getMessage());
            }
        }
    }

    private class NavigationHandler {
        private NavigationHandler() {
        }

        public void goToPrevious() {
            int currentT = Canvas2D_3Transforms.this.getPositionT();
            if (currentT > 0) {
                Canvas2D_3Transforms.this.setPositionT(currentT - 1);
            }
        }

        public void goToNext() {
            int currentT = Canvas2D_3Transforms.this.getPositionT();
            Canvas2D_3Transforms.this.setPositionT(currentT + 1);
        }
    }
}

