/*
 * Decompiled with CFR 0.152.
 */
package plugins.fmp.multiSPOTS96.tools.chart;

import icy.gui.frame.IcyFrame;
import icy.gui.util.GuiUtil;
import icy.gui.viewer.Viewer;
import icy.roi.ROI;
import icy.roi.ROI2D;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.geom.Point2D;
import java.util.logging.Logger;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.jfree.chart.ChartMouseEvent;
import org.jfree.chart.ChartMouseListener;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.entity.ChartEntity;
import org.jfree.chart.entity.XYItemEntity;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.plot.PlotRenderingInfo;
import org.jfree.chart.plot.XYPlot;
import org.jfree.data.Range;
import org.jfree.data.xy.XYDataset;
import org.jfree.data.xy.XYSeriesCollection;
import plugins.fmp.multiSPOTS96.MultiSPOTS96;
import plugins.fmp.multiSPOTS96.experiment.Experiment;
import plugins.fmp.multiSPOTS96.experiment.cages.Cage;
import plugins.fmp.multiSPOTS96.experiment.spots.Spot;
import plugins.fmp.multiSPOTS96.tools.chart.ChartCageBuild;
import plugins.fmp.multiSPOTS96.tools.chart.ChartCagePair;
import plugins.fmp.multiSPOTS96.tools.chart.ChartCagePanel;
import plugins.fmp.multiSPOTS96.tools.toExcel.XLSExportOptions;

public class ChartCageArrayFrame
extends IcyFrame {
    private static final Logger LOGGER = Logger.getLogger(ChartCageArrayFrame.class.getName());
    private static final int DEFAULT_CHART_WIDTH = 200;
    private static final int DEFAULT_CHART_HEIGHT = 100;
    private static final int MIN_CHART_WIDTH = 50;
    private static final int MAX_CHART_WIDTH = 1200;
    private static final int MIN_CHART_HEIGHT = 25;
    private static final int MAX_CHART_HEIGHT = 600;
    private static final int DEFAULT_FRAME_WIDTH = 300;
    private static final int DEFAULT_FRAME_HEIGHT = 70;
    private static final double RELATIVE_Y_MIN = -0.2;
    private static final double RELATIVE_Y_MAX = 1.2;
    private static final String CHART_ID_DELIMITER = ":";
    private static final int MAX_DESCRIPTION_LENGTH = 16;
    private static final int LEFT_MOUSE_BUTTON = 1;
    private JPanel mainChartPanel = null;
    private IcyFrame mainChartFrame = null;
    private Range yRange = null;
    private Range xRange = null;
    private Point graphLocation = new Point(0, 0);
    private int nPanelsAlongX = 1;
    private int nPanelsAlongY = 1;
    public ChartCagePair[][] chartPanelArray = null;
    private Experiment experiment = null;
    private MultiSPOTS96 parent = null;

    public void createMainChartPanel(String title, Experiment exp, XLSExportOptions xlsExportOptions, MultiSPOTS96 parent0) {
        if (exp == null) {
            throw new IllegalArgumentException("Experiment cannot be null");
        }
        if (xlsExportOptions == null) {
            throw new IllegalArgumentException("Export options cannot be null");
        }
        if (title == null || title.trim().isEmpty()) {
            throw new IllegalArgumentException("Title cannot be null or empty");
        }
        this.parent = parent0;
        this.experiment = exp;
        this.mainChartPanel = new JPanel();
        boolean flag = xlsExportOptions.cageIndexFirst == xlsExportOptions.cageIndexLast;
        this.nPanelsAlongX = flag ? 1 : exp.cagesArray.nCagesAlongX;
        this.nPanelsAlongY = flag ? 1 : exp.cagesArray.nCagesAlongY;
        this.mainChartPanel.setLayout(new GridLayout(this.nPanelsAlongY, this.nPanelsAlongX));
        this.mainChartFrame = GuiUtil.generateTitleFrame((String)title, (JPanel)new JPanel(), (Dimension)new Dimension(300, 70), (boolean)true, (boolean)true, (boolean)true, (boolean)true);
        JScrollPane scrollPane = new JScrollPane(this.mainChartPanel);
        this.mainChartFrame.add((Component)scrollPane);
        this.chartPanelArray = new ChartCagePair[this.nPanelsAlongY][this.nPanelsAlongX];
    }

    private NumberAxis setYaxis(String label, int row, int col, XLSExportOptions xlsExportOptions) {
        NumberAxis yAxis = new NumberAxis();
        String yLegend = label + " " + String.valueOf((char)((row *= this.experiment.cagesArray.nRowsPerCage) + 65)) + Integer.toString(col *= this.experiment.cagesArray.nColumnsPerCage);
        yAxis.setLabel(yLegend);
        if (xlsExportOptions.relativeToT0 || xlsExportOptions.relativeToMedianT0) {
            yAxis.setAutoRange(false);
            yAxis.setRange(-0.2, 1.2);
        } else {
            yAxis.setAutoRange(true);
            yAxis.setAutoRangeIncludesZero(false);
        }
        return yAxis;
    }

    private NumberAxis setXaxis(String label, XLSExportOptions xlsExportOptions) {
        NumberAxis xAxis = new NumberAxis();
        xAxis.setLabel(label);
        xAxis.setAutoRange(true);
        xAxis.setAutoRangeIncludesZero(false);
        return xAxis;
    }

    public void displayData(Experiment exp, XLSExportOptions xlsExportOptions) {
        if (exp == null) {
            throw new IllegalArgumentException("Experiment cannot be null");
        }
        if (xlsExportOptions == null) {
            throw new IllegalArgumentException("Export options cannot be null");
        }
        this.experiment = exp;
        this.createChartPanelArray(xlsExportOptions);
        this.arrangePanelsInDisplay(xlsExportOptions);
        this.displayChartFrame();
    }

    private void createChartPanelArray(XLSExportOptions xlsExportOptions) {
        int indexCage = 0;
        for (int row = 0; row < this.experiment.cagesArray.nCagesAlongY; ++row) {
            int col = 0;
            while (col < this.experiment.cagesArray.nCagesAlongX) {
                if (indexCage >= xlsExportOptions.cageIndexFirst && indexCage <= xlsExportOptions.cageIndexLast) {
                    Cage cage = this.experiment.cagesArray.getCageFromRowColCoordinates(row, col);
                    if (cage == null) {
                        LOGGER.warning("No cage found at row " + row + ", col " + col);
                    } else {
                        ChartCagePanel chartPanel = this.createChartPanelForCage(cage, row, col, xlsExportOptions);
                        this.chartPanelArray[row][col] = new ChartCagePair(chartPanel, cage);
                    }
                }
                ++col;
                ++indexCage;
            }
        }
    }

    private ChartCagePanel createChartPanelForCage(Cage cage, int row, int col, XLSExportOptions xlsExportOptions) {
        if (cage.spotsArray.getSpotsCount() < 1) {
            ChartCagePanel chartPanel = new ChartCagePanel(null, 200, 100, 50, 25, 1200, 600, true, true, true, true, false, true);
            return chartPanel;
        }
        ChartCageBuild.initMaxMin();
        XYSeriesCollection xyDataSetList = ChartCageBuild.getSpotDataDirectlyFromOneCage(this.experiment, cage, xlsExportOptions);
        NumberAxis xAxis = this.setXaxis("", xlsExportOptions);
        NumberAxis yAxis = this.setYaxis(cage.getRoi().getName(), row, col, xlsExportOptions);
        XYPlot xyPlot = ChartCageBuild.buildXYPlot(xyDataSetList, xAxis, yAxis);
        JFreeChart chart = new JFreeChart(null, null, (Plot)xyPlot, false);
        chart.setID("row:" + row + ":icol:" + col + ":cageID:" + cage.getProperties().getCagePosition());
        ChartCagePanel chartCagePanel = new ChartCagePanel(chart, 200, 100, 50, 25, 1200, 600, true, true, true, true, false, true);
        chartCagePanel.addChartMouseListener(new SpotChartMouseListener(this.experiment, xlsExportOptions));
        chartCagePanel.subscribeToCagePropertiesUpdates(cage);
        return chartCagePanel;
    }

    private void arrangePanelsInDisplay(XLSExportOptions xlsExportOptions) {
        if (xlsExportOptions.cageIndexFirst == xlsExportOptions.cageIndexLast) {
            int indexCage = xlsExportOptions.cageIndexFirst;
            int row = indexCage / this.experiment.cagesArray.nCagesAlongX;
            int col = indexCage % this.experiment.cagesArray.nCagesAlongX;
            if (row >= 0 && row < this.chartPanelArray.length && col >= 0 && col < this.chartPanelArray[0].length) {
                ChartCagePair pair = this.chartPanelArray[row][col];
                if (pair != null && pair.getChartPanel() != null) {
                    this.mainChartPanel.add((Component)pair.getChartPanel());
                } else {
                    this.mainChartPanel.add(new JPanel());
                }
            }
        } else {
            for (int row = 0; row < this.nPanelsAlongY; ++row) {
                for (int col = 0; col < this.nPanelsAlongX; ++col) {
                    ChartCagePair pair;
                    ChartPanel chartPanel = null;
                    if (row < this.chartPanelArray.length && col < this.chartPanelArray[0].length && (pair = this.chartPanelArray[row][col]) != null) {
                        chartPanel = pair.getChartPanel();
                    }
                    if (chartPanel == null) {
                        this.mainChartPanel.add(new JPanel());
                        continue;
                    }
                    this.mainChartPanel.add((Component)chartPanel);
                }
            }
        }
    }

    private void displayChartFrame() {
        this.mainChartFrame.pack();
        this.mainChartFrame.setLocation(this.graphLocation);
        this.mainChartFrame.addToDesktopPane();
        this.mainChartFrame.setVisible(true);
    }

    public void setChartSpotUpperLeftLocation(Rectangle rectv) {
        if (rectv == null) {
            throw new IllegalArgumentException("Reference rectangle cannot be null");
        }
        this.graphLocation = new Point(rectv.x, rectv.y);
    }

    private Spot getSpotFromClickedChart(ChartMouseEvent e) {
        if (e == null) {
            LOGGER.warning("Chart mouse event is null");
            return null;
        }
        MouseEvent trigger = e.getTrigger();
        if (trigger.getButton() != 1) {
            return null;
        }
        JFreeChart chart = e.getChart();
        if (chart == null || chart.getID() == null) {
            LOGGER.warning("Chart or chart ID is null");
            return null;
        }
        String[] chartID = chart.getID().split(CHART_ID_DELIMITER);
        if (chartID.length < 4) {
            LOGGER.warning("Invalid chart ID format: " + chart.getID());
            return null;
        }
        try {
            int row = Integer.parseInt(chartID[1]);
            int col = Integer.parseInt(chartID[3]);
            if (row < 0 || row >= this.chartPanelArray.length || col < 0 || col >= this.chartPanelArray[0].length) {
                LOGGER.warning("Invalid chart coordinates: row=" + row + ", col=" + col);
                return null;
            }
            Cage cage = this.chartPanelArray[row][col].getCage();
            if (cage == null) {
                LOGGER.warning("Clicked chart has no associated cage");
                return null;
            }
            ChartPanel panel = this.chartPanelArray[row][col].getChartPanel();
            if (panel == null) {
                LOGGER.warning("Clicked chart has no associated panel");
                return null;
            }
            PlotRenderingInfo plotInfo = panel.getChartRenderingInfo().getPlotInfo();
            Point2D pointClicked = panel.translateScreenToJava2D(trigger.getPoint());
            int subplotIndex = plotInfo.getSubplotIndex(pointClicked);
            XYPlot xyPlot = (XYPlot)chart.getPlot();
            Spot spotFound = null;
            String description = null;
            ChartEntity chartEntity = e.getEntity();
            if (chartEntity != null && chartEntity instanceof XYItemEntity) {
                spotFound = this.getSpotFromXYItemEntity((XYItemEntity)chartEntity);
            } else if (subplotIndex >= 0) {
                XYDataset xyDataset = xyPlot.getDataset(0);
                if (xyDataset != null && xyDataset.getSeriesCount() > 0) {
                    description = (String)((Object)xyDataset.getSeriesKey(0));
                    spotFound = this.experiment.cagesArray.getSpotFromROIName(description);
                }
            } else if (cage.spotsArray.getSpotsCount() > 0) {
                spotFound = cage.spotsArray.getSpotsList().get(0);
            }
            if (spotFound == null) {
                LOGGER.warning("Failed to find spot from clicked chart");
                return null;
            }
            int index = this.experiment.cagesArray.getSpotGlobalPosition(spotFound);
            spotFound.setSpotKymographT(index);
            return spotFound;
        }
        catch (NumberFormatException ex) {
            LOGGER.warning("Could not parse chart coordinates: " + ex.getMessage());
            return null;
        }
    }

    private Spot getSpotFromXYItemEntity(XYItemEntity xyItemEntity) {
        if (xyItemEntity == null) {
            LOGGER.warning("XY item entity is null");
            return null;
        }
        int seriesIndex = xyItemEntity.getSeriesIndex();
        XYDataset xyDataset = xyItemEntity.getDataset();
        if (xyDataset == null) {
            LOGGER.warning("XY dataset is null");
            return null;
        }
        String description = (String)((Object)xyDataset.getSeriesKey(seriesIndex));
        if (description == null) {
            LOGGER.warning("Series description is null");
            return null;
        }
        Spot spotFound = this.experiment.cagesArray.getSpotFromROIName(description = description.substring(0, Math.min(description.length(), 16)));
        if (spotFound == null) {
            LOGGER.warning("Graph clicked but source not found - description (roiName)=" + description);
            return null;
        }
        spotFound.setSpotCamDataT(xyItemEntity.getItem());
        return spotFound;
    }

    private void chartSelectSpot(Experiment exp, Spot spot) {
        if (exp == null || spot == null) {
            LOGGER.warning("Cannot select spot: experiment or spot is null");
            return;
        }
        ROI2D roi = spot.getRoi();
        if (roi != null) {
            exp.seqCamData.getSequence().setFocusedROI((ROI)roi);
            exp.seqCamData.centerDisplayOnRoi(roi);
        }
    }

    private void selectT(Experiment exp, XLSExportOptions xlsExportOptions, Spot spot) {
        if (exp == null || spot == null) {
            LOGGER.warning("Cannot select time: experiment or spot is null");
            return;
        }
        Viewer v = exp.seqCamData.getSequence().getFirstViewer();
        if (v != null && spot.getSpotCamDataT() > 0) {
            int frameIndex = (int)((long)(spot.getSpotCamDataT() * xlsExportOptions.buildExcelStepMs) / exp.seqCamData.getTimeManager().getBinDurationMs());
            v.setPositionT(frameIndex);
        }
    }

    private void chartSelectKymograph(Experiment exp, Spot spot) {
        if (exp == null || spot == null) {
            LOGGER.warning("Cannot select kymograph: experiment or spot is null");
            return;
        }
    }

    private void chartSelectClickedSpot(Experiment exp, XLSExportOptions xlsExportOptions, Spot clickedSpot) {
        String spotName;
        Cage cage;
        if (clickedSpot == null) {
            LOGGER.warning("Clicked spot is null");
            return;
        }
        this.chartSelectSpot(exp, clickedSpot);
        this.selectT(exp, xlsExportOptions, clickedSpot);
        this.chartSelectKymograph(exp, clickedSpot);
        ROI2D roi = clickedSpot.getRoi();
        if (roi != null) {
            exp.seqCamData.getSequence().setSelectedROI((ROI)roi);
        }
        if ((cage = exp.cagesArray.getCageFromSpotROIName(spotName = clickedSpot.getRoi().getName())) != null) {
            ROI2D cageRoi = cage.getRoi();
            exp.seqCamData.centerDisplayOnRoi(cageRoi);
        } else {
            LOGGER.warning("Could not find cage for spot: " + spotName);
        }
    }

    public JPanel getMainChartPanel() {
        return this.mainChartPanel;
    }

    public IcyFrame getMainChartFrame() {
        return this.mainChartFrame;
    }

    public ChartCagePair[][] getChartCagePairArray() {
        return this.chartPanelArray;
    }

    public int getPanelsAlongX() {
        return this.nPanelsAlongX;
    }

    public int getPanelsAlongY() {
        return this.nPanelsAlongY;
    }

    public Range getXRange() {
        return this.xRange;
    }

    public void setXRange(Range range) {
        this.xRange = range;
    }

    public Range getYRange() {
        return this.yRange;
    }

    public void setYRange(Range range) {
        this.yRange = range;
    }

    private class SpotChartMouseListener
    implements ChartMouseListener {
        private final Experiment experiment;
        private final XLSExportOptions xlsOptions;

        public SpotChartMouseListener(Experiment exp, XLSExportOptions options) {
            this.experiment = exp;
            this.xlsOptions = options;
        }

        public void chartMouseClicked(ChartMouseEvent e) {
            Spot clickedSpot = ChartCageArrayFrame.this.getSpotFromClickedChart(e);
            if (clickedSpot != null) {
                ChartCageArrayFrame.this.chartSelectClickedSpot(this.experiment, this.xlsOptions, clickedSpot);
                Cage cage = this.experiment.cagesArray.getCageFromID(clickedSpot.getProperties().getCageID());
                if (cage != null && ChartCageArrayFrame.this.parent != null && ((ChartCageArrayFrame)ChartCageArrayFrame.this).parent.dlgSpots != null) {
                    ((ChartCageArrayFrame)ChartCageArrayFrame.this).parent.dlgSpots.tabInfos.selectCage(cage);
                    ((ChartCageArrayFrame)ChartCageArrayFrame.this).parent.dlgSpots.tabInfos.selectSpot(clickedSpot);
                }
            }
        }

        public void chartMouseMoved(ChartMouseEvent e) {
        }
    }
}

