/*
 * Decompiled with CFR 0.152.
 */
package plugins.fmp.multiSPOTS96.tools.chart;

import icy.gui.frame.IcyFrame;
import icy.gui.util.GuiUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import javax.swing.BoxLayout;
import javax.swing.JPanel;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.data.xy.XYDataset;
import org.jfree.data.xy.XYSeries;
import org.jfree.data.xy.XYSeriesCollection;
import plugins.fmp.multiSPOTS96.experiment.cages.Cage;
import plugins.fmp.multiSPOTS96.experiment.cages.FlyPositions;
import plugins.fmp.multiSPOTS96.tools.MaxMinDouble;
import plugins.fmp.multiSPOTS96.tools.chart.ChartData;
import plugins.fmp.multiSPOTS96.tools.toExcel.EnumXLSExport;

public class ChartFliesPositions
extends IcyFrame {
    private static final Logger LOGGER = Logger.getLogger(ChartFliesPositions.class.getName());
    private static final int DEFAULT_CHART_WIDTH = 100;
    private static final int DEFAULT_CHART_HEIGHT = 200;
    private static final int MIN_CHART_WIDTH = 50;
    private static final int MAX_CHART_WIDTH = 100;
    private static final int MIN_CHART_HEIGHT = 100;
    private static final int MAX_CHART_HEIGHT = 200;
    private static final int DEFAULT_FRAME_WIDTH = 300;
    private static final int DEFAULT_FRAME_HEIGHT = 70;
    private static final double BOOLEAN_Y_MIN = 0.0;
    private static final double BOOLEAN_Y_MAX = 1.2;
    private static final double ALIVE_Y_MAX = 1.2;
    private static final double SLEEP_Y_MAX = 1.2;
    private static final double DISTANCE_Y_MIN = 0.0;
    private static final double POSITION_Y_MULTIPLIER = 1.2;
    private static final double ALIVE_VALUE = 1.0;
    private static final double DEAD_VALUE = 0.0;
    private static final double SLEEP_VALUE = 1.0;
    private static final double AWAKE_VALUE = 0.0;
    private JPanel mainChartPanel = null;
    private ArrayList<ChartPanel> chartsInMainChartPanel = null;
    public IcyFrame mainChartFrame = null;
    private String title;
    private Point pt = new Point(0, 0);
    private double globalXMax = 0.0;

    public void createPanel(String cstitle) {
        if (cstitle == null || cstitle.trim().isEmpty()) {
            throw new IllegalArgumentException("Chart title cannot be null or empty");
        }
        this.title = cstitle;
        this.mainChartFrame = GuiUtil.generateTitleFrame((String)this.title, (JPanel)new JPanel(), (Dimension)new Dimension(300, 70), (boolean)true, (boolean)true, (boolean)true, (boolean)true);
        this.mainChartPanel = new JPanel();
        this.mainChartPanel.setLayout(new BoxLayout(this.mainChartPanel, 2));
        this.mainChartFrame.add((Component)this.mainChartPanel);
    }

    public void setLocationRelativeToPoint(Point originPoint, Point deltapt) {
        if (originPoint == null) {
            throw new IllegalArgumentException("Reference point cannot be null");
        }
        if (deltapt == null) {
            throw new IllegalArgumentException("Delta point cannot be null");
        }
        this.pt = new Point(originPoint.x + deltapt.x, originPoint.y + deltapt.y);
    }

    public void displayData(List<Cage> cageList, EnumXLSExport option) {
        if (cageList == null) {
            throw new IllegalArgumentException("Cage list cannot be null");
        }
        if (option == null) {
            throw new IllegalArgumentException("Export option cannot be null");
        }
        ArrayList<XYSeriesCollection> xyDataSetList = new ArrayList<XYSeriesCollection>();
        MaxMinDouble yMaxMin = new MaxMinDouble();
        int count = 0;
        for (Cage cage : cageList) {
            if (cage == null) {
                LOGGER.warning("Null cage in list, skipping");
                continue;
            }
            if (cage.flyPositions == null || cage.flyPositions.flyPositionList.size() <= 0) continue;
            ChartData chartData = this.getDataSet(cage, option);
            XYSeriesCollection xyDataset = chartData.getXYDataset();
            yMaxMin = chartData.getYMaxMin();
            if (count != 0) {
                yMaxMin.getMaxMin(chartData.getYMaxMin());
            }
            xyDataSetList.add(xyDataset);
            ++count;
        }
        this.cleanChartsPanel(this.chartsInMainChartPanel);
        int width = 100;
        boolean displayLabels = false;
        for (XYSeriesCollection xyDataset : xyDataSetList) {
            if (xyDataset == null || xyDataset.getSeriesCount() == 0) {
                LOGGER.warning("Skipping null or empty dataset");
                continue;
            }
            JFreeChart xyChart = ChartFactory.createXYLineChart(null, null, null, (XYDataset)xyDataset, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)true, (boolean)true, (boolean)true);
            xyChart.setAntiAlias(true);
            xyChart.setTextAntiAlias(true);
            ValueAxis yAxis = xyChart.getXYPlot().getRangeAxis(0);
            if (yMaxMin != null) {
                yAxis.setRange(yMaxMin.getMin(), yMaxMin.getMax());
            }
            yAxis.setTickLabelsVisible(displayLabels);
            ValueAxis xAxis = xyChart.getXYPlot().getDomainAxis(0);
            xAxis.setRange(0.0, this.globalXMax);
            ChartPanel xyChartPanel = new ChartPanel(xyChart, width, 200, 50, 100, 100, 200, false, false, true, true, true, true);
            this.mainChartPanel.add((Component)xyChartPanel);
            width = 100;
            displayLabels = false;
        }
        this.mainChartFrame.pack();
        this.mainChartFrame.setLocation(this.pt);
        this.mainChartFrame.addToDesktopPane();
        this.mainChartFrame.setVisible(true);
    }

    private MaxMinDouble addPointsToXYSeries(Cage cage, EnumXLSExport option, XYSeries seriesXY) {
        if (cage == null || seriesXY == null) {
            LOGGER.warning("Cannot add points: cage or series is null");
            return new MaxMinDouble(0.0, 1.0);
        }
        FlyPositions results = cage.flyPositions;
        if (results == null || results.flyPositionList == null) {
            LOGGER.warning("No fly positions data for cage ID: " + cage.getProperties().getCageID());
            return new MaxMinDouble(0.0, 1.0);
        }
        int itmax = results.flyPositionList.size();
        MaxMinDouble yMaxMin = null;
        if (itmax > 0) {
            switch (option) {
                case DISTANCE: {
                    yMaxMin = this.processDistanceData(results, seriesXY, itmax, cage);
                    break;
                }
                case ISALIVE: {
                    yMaxMin = this.processAliveData(results, seriesXY, itmax);
                    break;
                }
                case SLEEP: {
                    yMaxMin = this.processSleepData(results, seriesXY, itmax);
                    break;
                }
                default: {
                    yMaxMin = this.processPositionData(results, seriesXY, itmax, cage);
                    break;
                }
            }
        } else {
            LOGGER.warning("No data points for cage ID: " + cage.getProperties().getCageID());
            yMaxMin = new MaxMinDouble(0.0, 1.0);
        }
        return yMaxMin;
    }

    private MaxMinDouble processDistanceData(FlyPositions results, XYSeries seriesXY, int itmax, Cage cage) {
        double previousY = results.flyPositionList.get((int)0).rectPosition.getY() + results.flyPositionList.get((int)0).rectPosition.getHeight() / 2.0;
        for (int it = 0; it < itmax; ++it) {
            double currentY = results.flyPositionList.get((int)it).rectPosition.getY() + results.flyPositionList.get((int)it).rectPosition.getHeight() / 2.0;
            double ypos = currentY - previousY;
            this.addxyPos(seriesXY, results, it, ypos);
            previousY = currentY;
        }
        Rectangle rect = cage.getRoi().getBounds();
        double length_diagonal = Math.sqrt(rect.height * rect.height + rect.width * rect.width);
        return new MaxMinDouble(0.0, length_diagonal);
    }

    private MaxMinDouble processAliveData(FlyPositions results, XYSeries seriesXY, int itmax) {
        for (int it = 0; it < itmax; ++it) {
            boolean alive = results.flyPositionList.get((int)it).bAlive;
            double ypos = alive ? 1.0 : 0.0;
            this.addxyPos(seriesXY, results, it, ypos);
        }
        return new MaxMinDouble(0.0, 1.2);
    }

    private MaxMinDouble processSleepData(FlyPositions results, XYSeries seriesXY, int itmax) {
        for (int it = 0; it < itmax; ++it) {
            boolean sleep = results.flyPositionList.get((int)it).bSleep;
            double ypos = sleep ? 1.0 : 0.0;
            this.addxyPos(seriesXY, results, it, ypos);
        }
        return new MaxMinDouble(0.0, 1.2);
    }

    private MaxMinDouble processPositionData(FlyPositions results, XYSeries seriesXY, int itmax, Cage cage) {
        Rectangle rect1 = cage.getRoi().getBounds();
        double yOrigin = rect1.getY() + rect1.getHeight();
        for (int it = 0; it < itmax; ++it) {
            Rectangle2D itRect = results.flyPositionList.get((int)it).rectPosition;
            double ypos = yOrigin - itRect.getY();
            this.addxyPos(seriesXY, results, it, ypos);
        }
        return new MaxMinDouble(0.0, (double)rect1.height * 1.2);
    }

    private void addxyPos(XYSeries seriesXY, FlyPositions positionxyt, int it, Double ypos) {
        if (seriesXY == null || positionxyt == null || positionxyt.flyPositionList == null) {
            LOGGER.warning("Cannot add position: series or position data is null");
            return;
        }
        if (it < 0 || it >= positionxyt.flyPositionList.size()) {
            LOGGER.warning("Invalid index " + it + " for position list of size " + positionxyt.flyPositionList.size());
            return;
        }
        double indexT = positionxyt.flyPositionList.get((int)it).flyIndexT;
        seriesXY.add(indexT, (Number)ypos);
        if (this.globalXMax < indexT) {
            this.globalXMax = indexT;
        }
    }

    private ChartData getDataSet(Cage cage, EnumXLSExport option) {
        if (cage == null) {
            LOGGER.warning("Cannot get dataset: cage is null");
            return new ChartData();
        }
        XYSeriesCollection xyDataset = new XYSeriesCollection();
        String name = cage.getRoi().getName();
        XYSeries seriesXY = new XYSeries((Comparable)((Object)name));
        seriesXY.setDescription(name);
        MaxMinDouble yMaxMin = this.addPointsToXYSeries(cage, option, seriesXY);
        xyDataset.addSeries(seriesXY);
        return new ChartData(new MaxMinDouble(this.globalXMax, 0.0), yMaxMin, xyDataset);
    }

    private void cleanChartsPanel(ArrayList<ChartPanel> chartsPanel) {
        if (chartsPanel != null && chartsPanel.size() > 0) {
            chartsPanel.clear();
        }
    }

    public JPanel getMainChartPanel() {
        return this.mainChartPanel;
    }

    public IcyFrame getMainChartFrame() {
        return this.mainChartFrame;
    }

    public double getGlobalXMax() {
        return this.globalXMax;
    }

    public void setGlobalXMax(double globalXMax) {
        this.globalXMax = globalXMax;
    }
}

