/*
 * Decompiled with CFR 0.152.
 */
package plugins.fmp.multiSPOTS96.tools.imageTransform;

import icy.image.IcyBufferedImage;
import icy.type.DataType;
import icy.type.collection.array.Array1DUtil;
import java.awt.image.BufferedImage;
import java.util.logging.Logger;
import plugins.fmp.multiSPOTS96.tools.imageTransform.AlgorithmException;
import plugins.fmp.multiSPOTS96.tools.imageTransform.ArrayOperationCache;
import plugins.fmp.multiSPOTS96.tools.imageTransform.ImageTransformException;
import plugins.fmp.multiSPOTS96.tools.imageTransform.ImageTransformInterface;
import plugins.fmp.multiSPOTS96.tools.imageTransform.ImageTransformOptions;
import plugins.fmp.multiSPOTS96.tools.imageTransform.IncompatibleImageException;
import plugins.fmp.multiSPOTS96.tools.imageTransform.InvalidParameterException;

public abstract class ImageTransformBase
implements ImageTransformInterface {
    private static final Logger logger = Logger.getLogger(ImageTransformBase.class.getName());
    private static final ArrayOperationCache arrayCache = new ArrayOperationCache();

    @Override
    public final IcyBufferedImage getTransformedImage(IcyBufferedImage sourceImage, ImageTransformOptions options) {
        String transformName = this.getClass().getSimpleName();
        try {
            this.validateInputs(sourceImage, options, transformName);
            return this.executeTransformSafely(sourceImage, options, transformName);
        }
        catch (ImageTransformException e) {
            logger.severe("Transform failed: " + e.getMessage());
            return this.handleTransformError(e, sourceImage);
        }
        catch (Exception e) {
            logger.severe("Unexpected error in transform " + transformName + ": " + e.getMessage());
            ImageTransformException transformException = new ImageTransformException("Unexpected error during transformation", (Throwable)e, transformName, "Transform execution");
            return this.handleTransformError(transformException, sourceImage);
        }
    }

    protected abstract IcyBufferedImage executeTransform(IcyBufferedImage var1, ImageTransformOptions var2) throws ImageTransformException;

    protected void validateInputs(IcyBufferedImage sourceImage, ImageTransformOptions options, String transformName) throws ImageTransformException {
        if (sourceImage == null) {
            throw new ImageTransformException("Source image cannot be null", transformName, "Input validation");
        }
        if (options == null) {
            throw new ImageTransformException("Transform options cannot be null", transformName, "Input validation");
        }
        int width = sourceImage.getWidth();
        int height = sourceImage.getHeight();
        if (width < 1 || height < 1) {
            throw new IncompatibleImageException(String.format("Image size %dx%d", width, height), "Dimensions too small", transformName);
        }
        if (width > 16384 || height > 16384) {
            throw new IncompatibleImageException(String.format("Image size %dx%d", width, height), "Dimensions too large", transformName);
        }
        int channels = sourceImage.getSizeC();
        if (channels > 4) {
            throw new IncompatibleImageException(String.format("%d channels", channels), "Too many channels", transformName);
        }
        this.validateTransformSpecificParameters(sourceImage, options, transformName);
    }

    protected void validateTransformSpecificParameters(IcyBufferedImage sourceImage, ImageTransformOptions options, String transformName) throws ImageTransformException {
    }

    private IcyBufferedImage executeTransformSafely(IcyBufferedImage sourceImage, ImageTransformOptions options, String transformName) throws ImageTransformException {
        try {
            this.preprocessImage(sourceImage, options);
            IcyBufferedImage result = this.executeTransform(sourceImage, options);
            result = this.postprocessImage(result, options);
            if (result == null) {
                throw new AlgorithmException("Transform execution", "Null result returned", transformName);
            }
            return result;
        }
        catch (ImageTransformException e) {
            throw e;
        }
        catch (Exception e) {
            throw new AlgorithmException("Transform execution", e.getMessage(), e);
        }
    }

    protected void preprocessImage(IcyBufferedImage sourceImage, ImageTransformOptions options) {
    }

    protected IcyBufferedImage postprocessImage(IcyBufferedImage result, ImageTransformOptions options) {
        return result;
    }

    protected double[][] getRGBArraysOptimized(IcyBufferedImage sourceImage) {
        return arrayCache.getRGBArrays(sourceImage);
    }

    protected IcyBufferedImage createResultImage(IcyBufferedImage sourceImage, int channels) {
        return new IcyBufferedImage(sourceImage.getWidth(), sourceImage.getHeight(), channels, sourceImage.getDataType_());
    }

    protected IcyBufferedImage createResultImage(IcyBufferedImage sourceImage, int channels, DataType dataType) {
        return new IcyBufferedImage(sourceImage.getWidth(), sourceImage.getHeight(), channels, dataType);
    }

    protected void copyArrayToImage(double[] resultArray, IcyBufferedImage resultImage, boolean copyToAllChannels) {
        Array1DUtil.doubleArrayToSafeArray((double[])resultArray, (Object)resultImage.getDataXY(0), (boolean)false);
        resultImage.setDataXY(0, resultImage.getDataXY(0));
        if (copyToAllChannels && resultImage.getSizeC() >= 3) {
            for (int c = 1; c < 3; ++c) {
                resultImage.copyData((BufferedImage)resultImage, 0, c);
                resultImage.setDataXY(c, resultImage.getDataXY(c));
            }
        }
    }

    protected void copyArrayToImage(int[] resultArray, IcyBufferedImage resultImage, boolean copyToAllChannels) {
        Array1DUtil.intArrayToSafeArray((int[])resultArray, (Object)resultImage.getDataXY(0), (boolean)false, (boolean)false);
        resultImage.setDataXY(0, resultImage.getDataXY(0));
        if (copyToAllChannels && resultImage.getSizeC() >= 3) {
            for (int c = 1; c < 3; ++c) {
                resultImage.copyData((BufferedImage)resultImage, 0, c);
                resultImage.setDataXY(c, resultImage.getDataXY(c));
            }
        }
    }

    protected IcyBufferedImage handleTransformError(ImageTransformException error, IcyBufferedImage fallbackImage) {
        logger.warning("Transform error handled: " + error.getMessage());
        return null;
    }

    protected boolean areImagesCompatible(IcyBufferedImage image1, IcyBufferedImage image2) {
        if (image1 == null || image2 == null) {
            return false;
        }
        return image1.getWidth() == image2.getWidth() && image1.getHeight() == image2.getHeight() && image1.getSizeC() == image2.getSizeC();
    }

    protected void validateArrayIndex(int index, int arrayLength, String parameterName) throws InvalidParameterException {
        if (index < 0 || index >= arrayLength) {
            throw new InvalidParameterException(parameterName, index, String.format("Index must be between 0 and %d", arrayLength - 1));
        }
    }

    protected void validateParameterRange(double value, double min, double max, String parameterName) throws InvalidParameterException {
        if (value < min || value > max) {
            throw new InvalidParameterException(parameterName, value, String.format("Value must be between %f and %f", min, max));
        }
    }

    protected String getTransformName() {
        return this.getClass().getSimpleName();
    }
}

