/*
 * Decompiled with CFR 0.152.
 */
package plugins.fmp.multiSPOTS96.tools.polyline;

import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.util.logging.Logger;

public class Line2DPlus
extends Line2D.Double {
    private static final long serialVersionUID = 935528755853877320L;
    private static final Logger LOGGER = Logger.getLogger(Line2DPlus.class.getName());
    private static final double EPSILON = 1.0E-10;
    private static final double MIN_PARAMETER = 0.0;
    private static final double MAX_PARAMETER = 1.0;

    public Line2DPlus() {
    }

    public Line2DPlus(double x1, double y1, double x2, double y2) {
        super(x1, y1, x2, y2);
    }

    public Line2DPlus(Point2D p1, Point2D p2) {
        if (p1 == null || p2 == null) {
            throw new IllegalArgumentException("Line endpoints cannot be null");
        }
        super.setLine(p1, p2);
    }

    public Line2DPlus(Line2D line) {
        if (line == null) {
            throw new IllegalArgumentException("Source line cannot be null");
        }
        super.setLine(line);
    }

    public double getXfromY(double y) {
        if (Double.isNaN(y) || Double.isInfinite(y)) {
            throw new IllegalArgumentException("Y-coordinate must be a finite number: " + y);
        }
        double x1 = this.getX1();
        double x2 = this.getX2();
        double y1 = this.getY1();
        double y2 = this.getY2();
        if (Math.abs(x1 - x2) < 1.0E-10) {
            return x1;
        }
        double slope = (y1 - y2) / (x1 - x2);
        double intercept = y1 - x1 * slope;
        return (y - intercept) / slope;
    }

    public Point2D.Double getIntersection(Line2D line) {
        if (line == null) {
            throw new IllegalArgumentException("Line cannot be null");
        }
        double x1 = this.getX1();
        double y1 = this.getY1();
        double x2 = this.getX2();
        double y2 = this.getY2();
        double x3 = line.getX1();
        double y3 = line.getY1();
        double x4 = line.getX2();
        double y4 = line.getY2();
        double denominator = (y4 - y3) * (x2 - x1) - (x4 - x3) * (y2 - y1);
        if (Math.abs(denominator) < 1.0E-10) {
            return null;
        }
        double numeratorA = (x4 - x3) * (y1 - y3) - (y4 - y3) * (x1 - x3);
        double numeratorB = (x2 - x1) * (y1 - y3) - (y2 - y1) * (x1 - x3);
        double parameterA = numeratorA / denominator;
        double parameterB = numeratorB / denominator;
        if (this.isParameterInRange(parameterA) && this.isParameterInRange(parameterB)) {
            double intersectionX = x1 + parameterA * (x2 - x1);
            double intersectionY = y1 + parameterA * (y2 - y1);
            return new Point2D.Double(intersectionX, intersectionY);
        }
        return null;
    }

    public boolean isVertical() {
        return Math.abs(this.getX1() - this.getX2()) < 1.0E-10;
    }

    public boolean isHorizontal() {
        return Math.abs(this.getY1() - this.getY2()) < 1.0E-10;
    }

    public double getSlope() {
        if (this.isVertical()) {
            throw new ArithmeticException("Cannot calculate slope of vertical line");
        }
        return (this.getY2() - this.getY1()) / (this.getX2() - this.getX1());
    }

    public double getYIntercept() {
        if (this.isVertical()) {
            throw new ArithmeticException("Vertical line has no Y-intercept");
        }
        double slope = this.getSlope();
        return this.getY1() - slope * this.getX1();
    }

    public double getLength() {
        double dx = this.getX2() - this.getX1();
        double dy = this.getY2() - this.getY1();
        return Math.sqrt(dx * dx + dy * dy);
    }

    public Point2D.Double getMidpoint() {
        double midX = (this.getX1() + this.getX2()) / 2.0;
        double midY = (this.getY1() + this.getY2()) / 2.0;
        return new Point2D.Double(midX, midY);
    }

    public boolean containsPoint(Point2D point, double tolerance) {
        if (point == null) {
            throw new IllegalArgumentException("Point cannot be null");
        }
        if (tolerance < 0.0) {
            throw new IllegalArgumentException("Tolerance cannot be negative: " + tolerance);
        }
        return this.ptSegDist(point) <= tolerance;
    }

    public boolean containsPoint(Point2D point) {
        return this.containsPoint(point, 1.0E-10);
    }

    public String toString() {
        return String.format("Line2DPlus[(%f, %f) -> (%f, %f)]", this.getX1(), this.getY1(), this.getX2(), this.getY2());
    }

    private boolean isParameterInRange(double parameter) {
        return parameter >= 0.0 && parameter <= 1.0;
    }
}

