/*
 * Decompiled with CFR 0.152.
 */
package plugins.fmp.multiSPOTS96.tools.toExcel;

import java.awt.Point;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.poi.xssf.streaming.SXSSFSheet;
import plugins.fmp.multiSPOTS96.experiment.Experiment;
import plugins.fmp.multiSPOTS96.experiment.cages.Cage;
import plugins.fmp.multiSPOTS96.experiment.sequence.TimeManager;
import plugins.fmp.multiSPOTS96.experiment.spots.Spot;
import plugins.fmp.multiSPOTS96.tools.toExcel.EnumXLSExport;
import plugins.fmp.multiSPOTS96.tools.toExcel.XLSExport;
import plugins.fmp.multiSPOTS96.tools.toExcel.XLSExportOptions;
import plugins.fmp.multiSPOTS96.tools.toExcel.exceptions.ExcelExportException;
import plugins.fmp.multiSPOTS96.tools.toExcel.exceptions.ExcelResourceException;

public class XLSExportMeasuresFromSpotStreaming
extends XLSExport {
    private static final int CHUNK_SIZE = 512;
    private static final int BUFFER_SIZE = 2048;
    private static final int GC_INTERVAL = 50;
    private final AtomicInteger processedSpots = new AtomicInteger(0);
    private final AtomicInteger totalSpots = new AtomicInteger(0);
    private volatile boolean memoryMonitoringEnabled = false;
    private final AtomicInteger memoryCheckInterval = new AtomicInteger(100);
    private final DataChunkProcessor chunkProcessor = new DataChunkProcessor(512, 2048);
    private final MemoryPool memoryPool = new MemoryPool();

    @Override
    protected int exportExperimentData(Experiment exp, XLSExportOptions xlsExportOptions, int startColumn, String charSeries) throws ExcelExportException {
        int column = startColumn;
        if (this.options.spotAreas) {
            column = this.exportSpotDataChunked(exp, column, charSeries, EnumXLSExport.AREA_SUM);
            this.exportSpotDataChunked(exp, column, charSeries, EnumXLSExport.AREA_FLYPRESENT);
            this.exportSpotDataChunked(exp, column, charSeries, EnumXLSExport.AREA_SUMCLEAN);
        }
        return column;
    }

    protected int exportSpotDataChunked(Experiment exp, int col0, String charSeries, EnumXLSExport exportType) throws ExcelExportException {
        try {
            this.options.exportType = exportType;
            SXSSFSheet sheet = this.getSheet(exportType.toString(), exportType);
            this.totalSpots.set(this.calculateTotalSpots(exp));
            this.processedSpots.set(0);
            int colmax = this.writeExperimentDataChunked(exp, sheet, exportType, col0, charSeries);
            if (this.options.onlyalive) {
                sheet = this.getSheet(exportType.toString() + "_alive", exportType);
                this.writeExperimentDataChunked(exp, sheet, exportType, col0, charSeries);
            }
            return colmax;
        }
        catch (ExcelResourceException e) {
            throw new ExcelExportException("Failed to export spot data", "export_spot_data_chunked", exportType.toString(), e);
        }
    }

    protected int writeExperimentDataChunked(Experiment exp, SXSSFSheet sheet, EnumXLSExport xlsExportType, int col0, String charSeries) {
        Point pt = new Point(col0, 0);
        pt = this.writeExperimentSeparator(sheet, pt);
        for (Cage cage : exp.cagesArray.cagesList) {
            double scalingFactorToPhysicalUnits = cage.spotsArray.getScalingFactorToPhysicalUnits(xlsExportType);
            cage.updateSpotsStimulus_i();
            List<Spot> spots = cage.spotsArray.getSpotsList();
            for (int i = 0; i < spots.size(); i += 512) {
                int endIndex = Math.min(i + 512, spots.size());
                List<Spot> spotChunk = spots.subList(i, endIndex);
                this.processSpotChunk(sheet, pt, exp, charSeries, cage, spotChunk, scalingFactorToPhysicalUnits, xlsExportType);
                System.gc();
            }
        }
        return pt.x;
    }

    protected void processSpotChunk(SXSSFSheet sheet, Point pt, Experiment exp, String charSeries, Cage cage, List<Spot> spotChunk, double scalingFactorToPhysicalUnits, EnumXLSExport xlsExportType) {
        for (Spot spot : spotChunk) {
            pt.y = 0;
            pt = this.writeExperimentSpotInfos(sheet, pt, exp, charSeries, cage, spot, xlsExportType);
            this.writeSpotDataStreaming(sheet, pt, spot, scalingFactorToPhysicalUnits, xlsExportType);
            ++pt.x;
            this.processedSpots.incrementAndGet();
            this.updateProgress();
            if (this.processedSpots.get() % this.memoryCheckInterval.get() != 0) continue;
            this.performMemoryMonitoring();
        }
    }

    protected void writeSpotDataStreaming(SXSSFSheet sheet, Point pt, Spot spot, double scalingFactorToPhysicalUnits, EnumXLSExport xlsExportType) {
        Iterator<Double> dataIterator = this.getSpotDataIterator(spot, xlsExportType);
        if (!dataIterator.hasNext()) {
            return;
        }
        if (this.options.relativeToT0 && xlsExportType != EnumXLSExport.AREA_FLYPRESENT) {
            dataIterator = this.applyRelativeToMaximumStreaming(dataIterator);
        }
        this.writeDataToExcelStreaming(sheet, pt, dataIterator, scalingFactorToPhysicalUnits);
    }

    protected Iterator<Double> getSpotDataIterator(Spot spot, EnumXLSExport xlsExportType) {
        List<Double> dataList = spot.getMeasuresForExcelPass1(xlsExportType, this.getBinData(spot), this.getBinExcel());
        return dataList != null ? dataList.iterator() : new ArrayList().iterator();
    }

    protected Iterator<Double> applyRelativeToMaximumStreaming(Iterator<Double> dataIterator) {
        double maximum = 0.0;
        ArrayList<Double> tempList = new ArrayList<Double>();
        while (dataIterator.hasNext()) {
            Double value2 = dataIterator.next();
            tempList.add(value2);
            if (value2 == null || Double.isNaN(value2)) continue;
            maximum = Math.max(maximum, value2);
        }
        if (maximum == 0.0) {
            return tempList.iterator();
        }
        double finalMaximum = maximum;
        return tempList.stream().map(value -> value != null && !Double.isNaN(value) ? value / finalMaximum : value).iterator();
    }

    protected void writeDataToExcelStreaming(SXSSFSheet sheet, Point pt, Iterator<Double> dataIterator, double scalingFactorToPhysicalUnits) {
        int row = pt.y + this.getDescriptorRowCount();
        while (dataIterator.hasNext()) {
            Double value = dataIterator.next();
            if (value != null && !Double.isNaN(value)) {
                double scaledValue = value * scalingFactorToPhysicalUnits;
                this.chunkProcessor.writeValue(sheet, row, pt.x, scaledValue);
            }
            ++row;
        }
        this.chunkProcessor.flush(sheet);
    }

    private long getBinData(Spot spot) {
        return 1000L;
    }

    private long getBinExcel() {
        return this.options.buildExcelStepMs;
    }

    private int calculateTotalSpots(Experiment exp) {
        int total = 0;
        for (Cage cage : exp.cagesArray.cagesList) {
            total += cage.spotsArray.getSpotsList().size();
        }
        return total;
    }

    private void updateProgress() {
        int current = this.processedSpots.get();
        int total = this.totalSpots.get();
        if (total > 0) {
            double d = (double)current / (double)total * 100.0;
        }
    }

    public void setMemoryMonitoringEnabled(boolean enabled) {
        this.memoryMonitoringEnabled = enabled;
    }

    public boolean isMemoryMonitoringEnabled() {
        return this.memoryMonitoringEnabled;
    }

    public void setMemoryCheckInterval(int interval) {
        this.memoryCheckInterval.set(interval);
    }

    public int getMemoryCheckInterval() {
        return this.memoryCheckInterval.get();
    }

    private void performMemoryMonitoring() {
        long maxMemory;
        if (!this.memoryMonitoringEnabled) {
            return;
        }
        Runtime runtime = Runtime.getRuntime();
        long usedMemory = runtime.totalMemory() - runtime.freeMemory();
        double memoryUsagePercentage = (double)usedMemory / (double)(maxMemory = runtime.maxMemory());
        if (memoryUsagePercentage > 0.8) {
            System.out.println("Warning: High memory usage detected: " + String.format("%.1f%%", memoryUsagePercentage * 100.0));
            if (memoryUsagePercentage > 0.9) {
                System.out.println("Forcing garbage collection due to high memory usage");
                System.gc();
            }
        }
    }

    public String getMemoryUsageStats() {
        Runtime runtime = Runtime.getRuntime();
        long totalMemory = runtime.totalMemory();
        long freeMemory = runtime.freeMemory();
        long usedMemory = totalMemory - freeMemory;
        long maxMemory = runtime.maxMemory();
        double memoryUsagePercentage = (double)usedMemory / (double)maxMemory;
        return String.format("Memory Usage: %.1f%% (%.1f MB used / %.1f MB max)", memoryUsagePercentage * 100.0, (double)usedMemory / 1048576.0, (double)maxMemory / 1048576.0);
    }

    protected int getNOutputFrames(Experiment exp, XLSExportOptions options) {
        TimeManager timeManager = exp.seqCamData.getTimeManager();
        long durationMs = timeManager.getBinLast_ms() - timeManager.getBinFirst_ms();
        int nOutputFrames = (int)(durationMs / (long)options.buildExcelStepMs + 1L);
        if (nOutputFrames <= 1) {
            long binLastMs = timeManager.getBinFirst_ms() + (long)exp.seqCamData.getImageLoader().getNTotalFrames() * timeManager.getBinDurationMs();
            timeManager.setBinLast_ms(binLastMs);
            if (binLastMs <= 0L) {
                this.handleExportError(exp, -1);
            }
            if ((nOutputFrames = (int)((binLastMs - timeManager.getBinFirst_ms()) / (long)options.buildExcelStepMs + 1L)) <= 1) {
                nOutputFrames = exp.seqCamData.getImageLoader().getNTotalFrames();
                this.handleExportError(exp, nOutputFrames);
            }
        }
        return nOutputFrames;
    }

    private static class DataChunkProcessor {
        private final int chunkSize;
        private final int bufferSize;
        private final double[] buffer;
        private int bufferPosition = 0;

        public DataChunkProcessor(int chunkSize, int bufferSize) {
            this.chunkSize = chunkSize;
            this.bufferSize = bufferSize;
            this.buffer = new double[bufferSize];
        }

        public void writeValue(SXSSFSheet sheet, int row, int col, double value) {
            if (this.bufferPosition >= this.bufferSize) {
                this.flush(sheet);
            }
            this.buffer[this.bufferPosition++] = value;
        }

        public void flush(SXSSFSheet sheet) {
            this.bufferPosition = 0;
        }

        public void clear() {
            this.bufferPosition = 0;
            Arrays.fill(this.buffer, 0.0);
        }
    }

    private static class MemoryPool {
        private final Queue<double[]> doubleArrayPool = new LinkedList<double[]>();
        private final Queue<List<Double>> listPool = new LinkedList<List<Double>>();
        private static final int POOL_SIZE = 10;

        private MemoryPool() {
        }

        public double[] getDoubleArray(int size) {
            double[] array = this.doubleArrayPool.poll();
            if (array == null || array.length != size) {
                array = new double[size];
            }
            return array;
        }

        public void returnDoubleArray(double[] array) {
            if (this.doubleArrayPool.size() < 10) {
                Arrays.fill(array, 0.0);
                this.doubleArrayPool.offer(array);
            }
        }

        public List<Double> getList() {
            List<Double> list = this.listPool.poll();
            if (list == null) {
                list = new ArrayList<Double>();
            } else {
                list.clear();
            }
            return list;
        }

        public void returnList(List<Double> list) {
            if (this.listPool.size() < 10) {
                list.clear();
                this.listPool.offer(list);
            }
        }
    }
}

