/*
 * Decompiled with CFR 0.152.
 */
package plugins.fmp.multiSPOTS96.dlg.f_excel;

import icy.gui.component.PopupPanel;
import icy.system.thread.ThreadUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.nio.file.Path;
import java.nio.file.Paths;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import plugins.fmp.multiSPOTS96.MultiSPOTS96;
import plugins.fmp.multiSPOTS96.dlg.f_excel.Options;
import plugins.fmp.multiSPOTS96.dlg.f_excel.SpotsAreas;
import plugins.fmp.multiSPOTS96.experiment.Experiment;
import plugins.fmp.multiSPOTS96.tools.JComponents.Dialog;
import plugins.fmp.multiSPOTS96.tools.JComponents.exceptions.FileDialogException;
import plugins.fmp.multiSPOTS96.tools.toExcel.XLSExportMeasuresCagesAsQuery;
import plugins.fmp.multiSPOTS96.tools.toExcel.XLSExportMeasuresFromSpot;
import plugins.fmp.multiSPOTS96.tools.toExcel.XLSExportOptions;
import plugins.fmp.multiSPOTS96.tools.toExcel.exceptions.ExcelExportException;

public class _DlgExcel_
extends JPanel
implements PropertyChangeListener {
    private static final long serialVersionUID = -4296207607692017074L;
    public PopupPanel capPopupPanel = null;
    private JTabbedPane tabsPane = new JTabbedPane();
    public Options tabCommonOptions = new Options();
    private SpotsAreas spotsAreas = new SpotsAreas();
    private MultiSPOTS96 parent0 = null;

    public void init(JPanel mainPanel, String string, final MultiSPOTS96 parent0) {
        this.parent0 = parent0;
        this.capPopupPanel = new PopupPanel(string);
        JPanel capPanel = this.capPopupPanel.getMainPanel();
        capPanel.setLayout(new BorderLayout());
        this.capPopupPanel.collapse();
        mainPanel.add((Component)this.capPopupPanel);
        GridLayout capLayout = new GridLayout(3, 2);
        this.tabCommonOptions.init(capLayout);
        this.tabsPane.addTab("Common options", null, this.tabCommonOptions, "Define common options");
        this.tabCommonOptions.addPropertyChangeListener(this);
        this.spotsAreas.init(capLayout);
        this.tabsPane.addTab("Spots", null, this.spotsAreas, "Export measures made on spots to file");
        this.spotsAreas.addPropertyChangeListener(this);
        capPanel.add(this.tabsPane);
        this.tabsPane.setSelectedIndex(0);
        this.capPopupPanel.addComponentListener((ComponentListener)new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                parent0.mainFrame.revalidate();
                parent0.mainFrame.pack();
                parent0.mainFrame.repaint();
            }
        });
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        Experiment exp = (Experiment)this.parent0.expListCombo.getSelectedItem();
        if (exp == null) {
            return;
        }
        if (evt.getPropertyName().equals("EXPORT_SPOTSMEASURES")) {
            final String file = this.defineXlsFileName(exp, "_spotsareas.xlsx");
            if (file == null) {
                return;
            }
            this.updateExperrimentsParameters(exp);
            ThreadUtil.bgRun((Runnable)new Runnable(){

                @Override
                public void run() {
                    XLSExportMeasuresFromSpot xlsExport = new XLSExportMeasuresFromSpot();
                    try {
                        xlsExport.exportToFile(file, _DlgExcel_.this.getSpotsOptions());
                    }
                    catch (ExcelExportException e) {
                        e.printStackTrace();
                    }
                }
            });
        } else if (evt.getPropertyName().equals("EXPORT_SPOTSMEASURES_AS_Q")) {
            final String file = this.defineXlsFileName(exp, "_asQ.xlsx");
            if (file == null) {
                return;
            }
            this.updateExperrimentsParameters(exp);
            ThreadUtil.bgRun((Runnable)new Runnable(){

                @Override
                public void run() {
                    XLSExportMeasuresCagesAsQuery xlsExport = new XLSExportMeasuresCagesAsQuery();
                    try {
                        xlsExport.exportQToFile(file, _DlgExcel_.this.getSpotsOptions());
                    }
                    catch (ExcelExportException e) {
                        e.printStackTrace();
                    }
                }
            });
        }
    }

    private String defineXlsFileName(Experiment exp, String pattern) {
        String filename0 = exp.seqCamData.getFileNameFromImageList(0);
        Path directory = Paths.get(filename0, new String[0]).getParent();
        Path subpath = directory.getName(directory.getNameCount() - 1);
        String tentativeName = subpath.toString() + pattern;
        try {
            return Dialog.saveFileAs(tentativeName, directory.getParent().toString(), "xlsx");
        }
        catch (FileDialogException e) {
            e.printStackTrace();
            return null;
        }
    }

    private void updateExperrimentsParameters(Experiment exp) {
        this.parent0.dlgExperiment.tabInfos.getExperimentInfosFromDialog(exp.getProperties());
    }

    private XLSExportOptions getSpotsOptions() {
        boolean fixedIntervals;
        int first = 0;
        int last = this.parent0.expListCombo.getItemCount() - 1;
        if (!this.tabCommonOptions.exportAllFilesCheckBox.isSelected()) {
            first = this.parent0.expListCombo.getSelectedIndex();
            last = this.parent0.expListCombo.getSelectedIndex();
        }
        XLSExportOptions options = new XLSExportOptions();
        options.spotAreas = true;
        options.sum = this.spotsAreas.sumCheckBox.isSelected();
        options.nPixels = this.spotsAreas.nPixelsCheckBox.isSelected();
        options.relativeToT0 = this.spotsAreas.t0CheckBox.isSelected();
        options.transpose = this.tabCommonOptions.transposeCheckBox.isSelected();
        options.buildExcelStepMs = this.tabCommonOptions.getExcelBuildStep();
        options.buildExcelUnitMs = this.tabCommonOptions.binUnit.getMsUnitValue();
        options.fixedIntervals = fixedIntervals = this.tabCommonOptions.isFixedFrameButton.isSelected();
        options.startAll_Ms = this.tabCommonOptions.getStartAllMs();
        options.endAll_Ms = this.tabCommonOptions.getEndAllMs();
        options.collateSeries = false;
        options.padIntervals = false;
        options.absoluteTime = false;
        options.onlyalive = this.spotsAreas.discardNoFlyCageCheckBox.isSelected();
        options.exportAllFiles = this.tabCommonOptions.exportAllFilesCheckBox.isSelected();
        options.expList = this.parent0.expListCombo;
        options.experimentIndexFirst = first;
        options.experimentIndexLast = last;
        return options;
    }
}

