/*
 * Decompiled with CFR 0.152.
 */
package plugins.fmp.multiSPOTS96.experiment.sequence;

import icy.file.Loader;
import icy.file.SequenceFileImporter;
import icy.image.IcyBufferedImage;
import icy.sequence.Sequence;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.logging.Logger;
import javax.imageio.ImageIO;
import plugins.fmp.multiSPOTS96.experiment.sequence.SequenceCamData;

public class ImageLoader {
    private static final Logger LOGGER = Logger.getLogger(ImageLoader.class.getName());
    private ArrayList<String> imagesList = new ArrayList();
    private String imagesDirectory = null;
    private long absoluteIndexFirstImage = 0L;
    private long fixedNumberOfImages = -1L;
    private String fileName = null;
    private int nTotalFrames = 0;

    public String getImagesDirectory() {
        if (this.imagesList.isEmpty()) {
            return this.imagesDirectory;
        }
        Path strPath = Paths.get(this.imagesList.get(0), new String[0]);
        this.imagesDirectory = strPath.getParent().toString();
        return this.imagesDirectory;
    }

    public void setImagesDirectory(String directoryString) {
        this.imagesDirectory = directoryString;
    }

    public String getFileName() {
        if (this.fileName == null && !this.imagesList.isEmpty()) {
            Path path = Paths.get(this.imagesList.get(0), new String[0]);
            int rootlevel = path.getNameCount() - 4;
            if (rootlevel < 0) {
                rootlevel = 0;
            }
            this.fileName = path.subpath(rootlevel, path.getNameCount() - 1).toString();
        }
        return this.fileName;
    }

    public String getFileNameFromImageList(int t) {
        if (this.imagesList.isEmpty()) {
            return null;
        }
        if (t >= 0 && t < this.imagesList.size()) {
            return this.imagesList.get(t);
        }
        return null;
    }

    public boolean loadImages(SequenceCamData seqCamData) {
        if (this.imagesList.isEmpty()) {
            return false;
        }
        Sequence seq = this.loadSequenceFromImagesList(this.imagesList);
        this.nTotalFrames = (int)((long)seq.getSizeT() - this.absoluteIndexFirstImage);
        seqCamData.attachSequence(seq);
        return seq != null;
    }

    public boolean loadFirstImage(SequenceCamData seqCamData) {
        if (this.imagesList.isEmpty()) {
            return false;
        }
        ArrayList<String> singleImageList = new ArrayList<String>();
        singleImageList.add(this.imagesList.get(0));
        Sequence seq = this.loadSequenceFromImagesList(singleImageList);
        seqCamData.attachSequence(seq);
        return seq != null;
    }

    public void loadImageList(List<String> images, SequenceCamData seqCamData) {
        if (images.isEmpty()) {
            return;
        }
        List<String> clippedList = this.clipImagesList(images);
        this.setImagesList(clippedList);
        this.fixedNumberOfImages = images.size();
        this.nTotalFrames = clippedList.size();
        Sequence seq = this.loadSequenceFromImagesList(this.imagesList);
        seqCamData.attachSequence(seq);
    }

    private List<String> clipImagesList(List<String> images) {
        if (this.absoluteIndexFirstImage <= 0L && this.fixedNumberOfImages <= 0L) {
            return new ArrayList<String>(images);
        }
        int startIndex = (int)Math.min(this.absoluteIndexFirstImage, (long)images.size());
        int endIndex = this.fixedNumberOfImages > 0L ? (int)Math.min((long)startIndex + this.fixedNumberOfImages, (long)images.size()) : images.size();
        return new ArrayList<String>(images.subList(startIndex, endIndex));
    }

    public IcyBufferedImage imageIORead(String name) {
        BufferedImage image = null;
        try {
            image = ImageIO.read(new File(name));
            return IcyBufferedImage.createFrom((BufferedImage)image);
        }
        catch (IOException e) {
            LOGGER.severe("Failed to read image: " + name + " - " + e.getMessage());
            return null;
        }
    }

    public Sequence loadSequenceFromImagesList(List<String> images) {
        if (images.isEmpty()) {
            LOGGER.warning("Empty images list provided");
            return null;
        }
        try {
            SequenceFileImporter seqFileImporter = Loader.getSequenceFileImporter((String)images.get(0), (boolean)true);
            List sequenceList = Loader.loadSequences((SequenceFileImporter)seqFileImporter, images, (int)0, (boolean)true, (boolean)false, (boolean)false, (boolean)true, (boolean)false, (boolean)true);
            if (sequenceList.isEmpty()) {
                LOGGER.warning("No sequences loaded");
                return null;
            }
            return (Sequence)sequenceList.get(0);
        }
        catch (Exception e) {
            LOGGER.severe("Error loading sequence: " + e.getMessage());
            return null;
        }
    }

    public Sequence initSequenceFromFirstImage(List<String> images) {
        if (images.isEmpty()) {
            LOGGER.warning("Empty images list provided");
            return null;
        }
        try {
            SequenceFileImporter seqFileImporter = Loader.getSequenceFileImporter((String)images.get(0), (boolean)true);
            return Loader.loadSequence((SequenceFileImporter)seqFileImporter, (String)images.get(0), (int)0, (boolean)false);
        }
        catch (Exception e) {
            LOGGER.severe("Error initializing sequence: " + e.getMessage());
            return null;
        }
    }

    public List<String> getImagesList() {
        return this.imagesList;
    }

    public List<String> getImagesList(boolean sort) {
        if (sort) {
            Collections.sort(this.imagesList);
        }
        return this.imagesList;
    }

    public void setImagesList(List<String> images) {
        this.imagesList.clear();
        this.imagesList = new ArrayList<String>(images);
    }

    public int getImagesCount() {
        return this.imagesList.size();
    }

    public void setAbsoluteIndexFirstImage(long index) {
        this.absoluteIndexFirstImage = index;
    }

    public long getAbsoluteIndexFirstImage() {
        return this.absoluteIndexFirstImage;
    }

    public void setFixedNumberOfImages(long number) {
        this.fixedNumberOfImages = number;
    }

    public long getFixedNumberOfImages() {
        return this.fixedNumberOfImages;
    }

    public void setNTotalFrames(int nTotalFrames) {
        this.nTotalFrames = nTotalFrames;
    }

    public int getNTotalFrames() {
        return this.nTotalFrames;
    }

    public boolean checkIfNFramesIsValid() {
        int nFrames = this.getImagesCount();
        if (nFrames != this.getNTotalFrames()) {
            System.out.println("error: nFrames (seqCamData.camImagesList.size()):" + nFrames + " is different from seqCamData.getImageLoader().getNTotalFrames():" + this.getNTotalFrames());
        }
        return nFrames >= 1;
    }
}

