/*
 * Decompiled with CFR 0.152.
 */
package plugins.fmp.multiSPOTS96.experiment.spots;

import icy.image.IcyBufferedImage;
import icy.roi.BooleanMask2D;
import icy.roi.ROI2D;
import icy.util.XMLUtil;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import plugins.fmp.multiSPOTS96.experiment.spots.EnumSpotMeasures;
import plugins.fmp.multiSPOTS96.experiment.spots.SpotMeasure;
import plugins.fmp.multiSPOTS96.experiment.spots.SpotProperties;
import plugins.fmp.multiSPOTS96.tools.ROI2D.ROI2DUtilities;
import plugins.fmp.multiSPOTS96.tools.ROI2D.ROI2DWithMask;
import plugins.fmp.multiSPOTS96.tools.toExcel.EnumXLSColumnHeader;
import plugins.fmp.multiSPOTS96.tools.toExcel.EnumXLSExport;
import plugins.kernel.roi.roi2d.ROI2DPolyLine;
import plugins.kernel.roi.roi2d.ROI2DShape;

public class Spot
implements Comparable<Spot> {
    private static final String ID_META = "metaMC";
    private static final int DATA_OFFSET = 3;
    private ROI2DShape spotROI2D;
    private ROI2DWithMask spotMask;
    private final SpotProperties properties;
    private final SpotMeasurements measurements;
    private final SpotMetadata metadata;

    public Spot(ROI2DShape roi) {
        this.spotROI2D = Objects.requireNonNull(roi, "ROI cannot be null");
        this.properties = new SpotProperties();
        this.measurements = new SpotMeasurements();
        this.metadata = new SpotMetadata();
    }

    public Spot() {
        this.properties = new SpotProperties();
        this.measurements = new SpotMeasurements();
        this.metadata = new SpotMetadata();
    }

    public Spot(Spot sourceSpot, boolean includeMeasurements) {
        Objects.requireNonNull(sourceSpot, "Source spot cannot be null");
        this.properties = new SpotProperties(sourceSpot.properties);
        this.measurements = new SpotMeasurements(sourceSpot.measurements, includeMeasurements);
        this.metadata = new SpotMetadata(sourceSpot.metadata);
        if (sourceSpot.spotROI2D != null) {
            this.spotROI2D = (ROI2DShape)sourceSpot.spotROI2D.getCopy();
        }
    }

    @Override
    public int compareTo(Spot other) {
        if (other == null) {
            return 1;
        }
        String thisName = this.getName();
        String otherName = other.getName();
        return thisName.compareTo(otherName);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        Spot other = (Spot)obj;
        return Objects.equals(this.getName(), other.getName());
    }

    public int hashCode() {
        return Objects.hash(this.getName());
    }

    public void copyFrom(Spot sourceSpot, boolean includeMeasurements) {
        Objects.requireNonNull(sourceSpot, "Source spot cannot be null");
        this.properties.copyFrom(sourceSpot.properties);
        if (sourceSpot.spotROI2D != null) {
            this.spotROI2D = (ROI2DShape)sourceSpot.spotROI2D.getCopy();
        }
        if (includeMeasurements) {
            this.measurements.copyFrom(sourceSpot.measurements);
        }
    }

    public void addMeasurements(Spot sourceSpot) {
        Objects.requireNonNull(sourceSpot, "Source spot cannot be null");
        this.measurements.addFrom(sourceSpot.measurements);
        this.getProperties().setCountAggregatedSpots(this.getProperties().getCountAggregatedSpots() + 1);
    }

    public void computePI(Spot spot1, Spot spot2) {
        Objects.requireNonNull(spot1, "Spot1 cannot be null");
        Objects.requireNonNull(spot2, "Spot2 cannot be null");
        int n1 = spot1.getProperties().getCountAggregatedSpots();
        int n2 = spot2.getProperties().getCountAggregatedSpots();
        this.measurements.computePI(spot1.measurements, n1, spot2.measurements, n2);
    }

    public void computeSUM(Spot spot1, Spot spot2) {
        Objects.requireNonNull(spot1, "Spot1 cannot be null");
        Objects.requireNonNull(spot2, "Spot2 cannot be null");
        int n1 = spot1.getProperties().getCountAggregatedSpots();
        int n2 = spot2.getProperties().getCountAggregatedSpots();
        this.measurements.computeSUM(spot1.measurements, n1, spot2.measurements, n2);
    }

    public void normalizeMeasures() {
        this.measurements.normalizeMeasures();
    }

    public ROI2D getRoi() {
        return this.spotROI2D;
    }

    public void setRoi(ROI2DShape roi) {
        this.spotROI2D = roi;
    }

    public Point2D getCenter() {
        if (this.spotROI2D == null) {
            return null;
        }
        Point position = this.spotROI2D.getPosition();
        Rectangle bounds = this.spotROI2D.getBounds();
        position.translate(bounds.height / 2, bounds.width / 2);
        return position;
    }

    public ROI2DWithMask getROIMask() {
        return this.spotMask;
    }

    public void setROIMask(ROI2DWithMask roiMasked) {
        this.spotMask = roiMasked;
    }

    public void setName(int cageID, int spotID) {
        String name = String.format("spot_%03d_%03d", cageID, spotID);
        if (this.spotROI2D != null) {
            this.spotROI2D.setName(name);
        }
        this.properties.setName(name);
    }

    public String getName() {
        if (this.properties.getName() == null) {
            String name = this.getRoi() != null ? this.getRoi().getName() : "unnamed_spot";
            this.properties.setName(name);
        }
        return this.properties.getName();
    }

    public String getCombinedStimulusConcentration() {
        return this.properties.getStimulus() + "_" + this.properties.getConcentration();
    }

    public SpotProperties getProperties() {
        return this.properties;
    }

    public String getField(EnumXLSColumnHeader fieldEnum) {
        Objects.requireNonNull(fieldEnum, "Field enum cannot be null");
        switch (fieldEnum) {
            case SPOT_STIM: {
                return this.properties.getStimulus();
            }
            case SPOT_CONC: {
                return this.properties.getConcentration();
            }
            case SPOT_VOLUME: {
                return String.valueOf(this.properties.getSpotVolume());
            }
        }
        return null;
    }

    public void setField(EnumXLSColumnHeader fieldEnum, String value) {
        Objects.requireNonNull(fieldEnum, "Field enum cannot be null");
        Objects.requireNonNull(value, "Value cannot be null");
        switch (fieldEnum) {
            case SPOT_STIM: {
                this.properties.setStimulus(value);
                break;
            }
            case SPOT_CONC: {
                this.properties.setConcentration(value);
                break;
            }
            case SPOT_VOLUME: {
                try {
                    double volume = Double.parseDouble(value);
                    this.properties.setSpotVolume(volume);
                    break;
                }
                catch (NumberFormatException e) {
                    throw new IllegalArgumentException("Invalid volume value: " + value, e);
                }
            }
        }
    }

    public String getCagePosition(EnumXLSExport exportOption) {
        Objects.requireNonNull(exportOption, "Export option cannot be null");
        int cagePosition = this.properties.getCagePosition();
        switch (exportOption) {
            case DISTANCE: 
            case ISALIVE: {
                return cagePosition + "(T=B)";
            }
            case XYIMAGE: 
            case XYTOPCAGE: 
            case XYTIPCAPS: {
                return cagePosition == 0 ? "x" : "y";
            }
        }
        return String.valueOf(cagePosition);
    }

    public long isThereAnyMeasuresDone(EnumXLSExport option) {
        switch (option) {
            case AREA_SUM: {
                return this.measurements.getSumIn().getCount();
            }
            case AREA_SUMCLEAN: {
                return this.measurements.getSumClean().getCount();
            }
            case AREA_FLYPRESENT: {
                return this.measurements.getFlyPresent().getCount();
            }
        }
        return 0L;
    }

    public SpotMeasure getSum() {
        return this.measurements.getSumIn();
    }

    public SpotMeasure getSumClean() {
        return this.measurements.getSumClean();
    }

    public SpotMeasure getFlyPresent() {
        return this.measurements.getFlyPresent();
    }

    public SpotMeasure getMeasurements(EnumXLSExport option) {
        Objects.requireNonNull(option, "Export option cannot be null");
        switch (option) {
            case AREA_SUM: {
                return this.measurements.getSumIn();
            }
            case AREA_SUMCLEAN: {
                return this.measurements.getSumClean();
            }
            case AREA_FLYPRESENT: {
                return this.measurements.getFlyPresent();
            }
        }
        return null;
    }

    public boolean isValid() {
        return this.metadata.isValid();
    }

    public void setValid(boolean valid) {
        this.metadata.setValid(valid);
    }

    public boolean isReadyForAnalysis() {
        return this.metadata.isOkToAnalyze();
    }

    public void setReadyForAnalysis(boolean ready) {
        this.metadata.setOkToAnalyze(ready);
    }

    public BooleanMask2D getMask2DSpot() {
        return this.metadata.getMask2DSpot();
    }

    public void setMask2DSpot(BooleanMask2D mask2DSpot) {
        this.metadata.setMask2DSpot(mask2DSpot);
    }

    public IcyBufferedImage getSpotImage() {
        return this.metadata.getSpotImage();
    }

    public void setSpotImage(IcyBufferedImage image) {
        this.metadata.setSpotImage(image);
    }

    public String getSpotFilenameTiff() {
        return this.metadata.getSpotFilenameTiff();
    }

    public void setSpotFilenameTiff(String name) {
        this.metadata.setSpotFilenameTiff(name);
    }

    public int getSpotKymographT() {
        return this.metadata.getSpotKymographT();
    }

    public void setSpotKymographT(int spotKymographT) {
        this.metadata.setSpotKymographT(spotKymographT);
    }

    public int getSpotCamDataT() {
        return this.metadata.getSpotCamDataT();
    }

    public void setSpotCamDataT(int spotCamDataT) {
        this.metadata.setSpotCamDataT(spotCamDataT);
    }

    public boolean isSelected(List<Integer> selectedIndexes) {
        if (selectedIndexes == null || selectedIndexes.isEmpty()) {
            return false;
        }
        int spotIndex = this.properties.getSpotArrayIndex();
        return selectedIndexes.contains(spotIndex);
    }

    public boolean hasMeasurements(EnumXLSExport option) {
        SpotMeasure measure = this.getMeasurements(option);
        return measure != null && measure.getCount() > 0;
    }

    public List<Double> getMeasuresForExcelPass1(EnumXLSExport exportType, long seriesBinMs, long outputBinMs) {
        SpotMeasure measure = this.getMeasurements(exportType);
        if (measure == null) {
            return new ArrayList<Double>();
        }
        return measure.getValuesAsSubsampledList(seriesBinMs, outputBinMs);
    }

    public void restoreClippedMeasures() {
        this.measurements.restoreClippedMeasures();
    }

    public void transferRoiMeasuresToLevel2D() {
        this.measurements.transferRoiMeasuresToLevel2D();
    }

    public void adjustLevel2DMeasuresToImageWidth(int imageWidth) {
        this.measurements.adjustLevel2DMeasuresToImageWidth(imageWidth);
    }

    public void cropLevel2DMeasuresToImageWidth(int imageWidth) {
        this.measurements.cropLevel2DMeasuresToImageWidth(imageWidth);
    }

    public void initializeLevel2DMeasures() {
        this.measurements.initializeLevel2DMeasures();
    }

    public void transferMeasuresToLevel2D() {
        this.measurements.transferMeasuresToLevel2D();
    }

    public List<ROI2D> transferMeasuresToRois(int imageHeight) {
        return this.measurements.transferLevel2DToRois(imageHeight);
    }

    public void transferRoiToMeasures(ROI2D roi, int imageHeight) {
        this.measurements.transferRoiToMeasures(roi, imageHeight);
    }

    public String exportMeasuresSectionHeader(EnumSpotMeasures measureType, String csvSeparator) {
        return this.measurements.exportSectionHeader(measureType, csvSeparator);
    }

    public String exportMeasuresOneType(EnumSpotMeasures measureType, String csvSeparator) {
        return this.measurements.exportOneType(this.properties.getName(), this.properties.getSpotArrayIndex(), measureType, csvSeparator);
    }

    public void importMeasuresOneType(EnumSpotMeasures measureType, String[] data, boolean includeX, boolean includeY) {
        this.measurements.importOneType(measureType, data, includeX, includeY);
    }

    public boolean loadFromXml(Node node) {
        if (node == null) {
            return false;
        }
        try {
            if (!this.properties.loadFromXml(node)) {
                return false;
            }
            Element nodeMeta = XMLUtil.getElement((Node)node, (String)ID_META);
            if (nodeMeta != null) {
                this.spotROI2D = (ROI2DShape)ROI2DUtilities.loadFromXML_ROI(nodeMeta);
                if (this.spotROI2D != null) {
                    this.spotROI2D.setColor(this.getProperties().getColor());
                    this.getProperties().setName(this.spotROI2D.getName());
                }
            }
            return this.measurements.loadFromXml(node);
        }
        catch (Exception e) {
            System.err.println("Error loading spot from XML: " + e.getMessage());
            return false;
        }
    }

    public boolean saveToXml(Node node) {
        if (node == null) {
            return false;
        }
        try {
            if (!this.properties.saveToXml(node)) {
                return false;
            }
            if (!this.measurements.saveToXml(node)) {
                return false;
            }
            Element nodeMeta = XMLUtil.setElement((Node)node, (String)ID_META);
            if (nodeMeta != null) {
                ROI2DUtilities.saveToXML_ROI(nodeMeta, (ROI2D)this.spotROI2D);
            }
            return true;
        }
        catch (Exception e) {
            System.err.println("Error saving spot to XML: " + e.getMessage());
            return false;
        }
    }

    private static class SpotMeasurements {
        private final SpotMeasure sumIn = new SpotMeasure("sum");
        private final SpotMeasure sumClean = new SpotMeasure("clean");
        private final SpotMeasure flyPresent = new SpotMeasure("flyPresent");

        SpotMeasurements() {
        }

        SpotMeasurements(SpotMeasurements source, boolean includeData) {
            if (includeData) {
                this.copyFrom(source);
            }
        }

        void copyFrom(SpotMeasurements source) {
            this.sumIn.copyMeasures(source.sumIn);
            this.sumClean.copyMeasures(source.sumClean);
            this.flyPresent.copyMeasures(source.flyPresent);
        }

        void addFrom(SpotMeasurements source) {
            this.sumIn.addMeasures(source.sumIn);
            this.sumClean.addMeasures(source.sumClean);
            this.flyPresent.addMeasures(source.flyPresent);
        }

        void computePI(SpotMeasurements measure1, int n1, SpotMeasurements measure2, int n2) {
            this.sumIn.computePI(measure1.sumIn, measure2.sumIn);
            this.sumClean.computePI(measure1.sumClean, measure2.sumClean);
        }

        void computeSUM(SpotMeasurements measure1, int n1, SpotMeasurements measure2, int n2) {
            this.sumIn.computeSUM(measure1.sumIn, n1, measure2.sumIn, n2);
            this.sumClean.computeSUM(measure1.sumClean, n1, measure2.sumClean, n2);
            this.flyPresent.combineIsPresent(measure1.flyPresent, n1, measure2.flyPresent, n2);
        }

        void normalizeMeasures() {
            this.sumIn.normalizeValues();
            this.sumClean.normalizeValues();
        }

        SpotMeasure getSumIn() {
            return this.sumIn;
        }

        SpotMeasure getSumClean() {
            return this.sumClean;
        }

        SpotMeasure getFlyPresent() {
            return this.flyPresent;
        }

        void restoreClippedMeasures() {
            this.restoreClippedMeasure(this.sumIn);
            this.restoreClippedMeasure(this.sumClean);
            this.restoreClippedMeasure(this.flyPresent);
        }

        private void restoreClippedMeasure(SpotMeasure measure) {
            if (measure != null) {
                measure.getSpotLevel2D().restoreCroppedLevel2D();
            }
        }

        public void transferMeasuresToLevel2D() {
            if (this.sumIn != null) {
                this.sumIn.transferValuesToLevel2D();
            }
            if (this.sumClean != null) {
                this.sumClean.transferValuesToLevel2D();
            }
            if (this.flyPresent != null) {
                this.flyPresent.transferIsPresentToLevel2D();
            }
        }

        void transferRoiMeasuresToLevel2D() {
            if (this.sumIn != null) {
                this.sumIn.getSpotLevel2D().transferROItoLevel2D();
            }
            if (this.sumClean != null) {
                this.sumClean.getSpotLevel2D().transferROItoLevel2D();
            }
            if (this.flyPresent != null) {
                this.flyPresent.getSpotLevel2D().transferROItoLevel2D();
            }
        }

        void adjustLevel2DMeasuresToImageWidth(int imageWidth) {
            if (this.sumIn != null) {
                this.sumIn.getSpotLevel2D().adjustLevel2DToImageWidth(imageWidth);
            }
            if (this.sumClean != null) {
                this.sumClean.getSpotLevel2D().adjustLevel2DToImageWidth(imageWidth);
            }
            if (this.flyPresent != null) {
                this.flyPresent.getSpotLevel2D().adjustLevel2DToImageWidth(imageWidth);
            }
        }

        void cropLevel2DMeasuresToImageWidth(int imageWidth) {
            if (this.sumIn != null) {
                this.sumIn.getSpotLevel2D().cropLevel2DToNPoints(imageWidth);
            }
            if (this.sumClean != null) {
                this.sumClean.getSpotLevel2D().cropLevel2DToNPoints(imageWidth);
            }
            if (this.flyPresent != null) {
                this.flyPresent.getSpotLevel2D().cropLevel2DToNPoints(imageWidth);
            }
        }

        void initializeLevel2DMeasures() {
            if (this.sumIn != null) {
                this.sumIn.getSpotLevel2D().clearLevel2D();
            }
            if (this.sumClean != null) {
                this.sumClean.getSpotLevel2D().clearLevel2D();
            }
            if (this.flyPresent != null) {
                this.flyPresent.getSpotLevel2D().clearLevel2D();
            }
        }

        List<ROI2D> transferLevel2DToRois(int imageHeight) {
            ROI2DPolyLine roi;
            ArrayList<ROI2D> rois = new ArrayList<ROI2D>();
            if (this.sumIn != null && (roi = this.sumIn.getSpotLevel2D().getROIForImage("sum", 0, imageHeight)) != null) {
                rois.add((ROI2D)roi);
            }
            return rois;
        }

        void transferRoiToMeasures(ROI2D roi, int imageHeight) {
            if (this.sumIn != null) {
                this.transferRoiToMeasureValue(roi, imageHeight, this.sumIn);
            }
            if (this.sumClean != null) {
                this.transferRoiToMeasureValue(roi, imageHeight, this.sumClean);
            }
            if (this.flyPresent != null) {
                this.transferRoiToMeasureBoolean(roi, this.flyPresent);
            }
        }

        private void transferRoiToMeasureValue(ROI2D roi, int imageHeight, SpotMeasure measure) {
            if (roi != null && measure != null) {
                measure.getSpotLevel2D().transferROItoLevel2D();
            }
        }

        private void transferRoiToMeasureBoolean(ROI2D roi, SpotMeasure measure) {
            if (roi != null && measure != null) {
                measure.getSpotLevel2D().transferROItoLevel2D();
            }
        }

        boolean loadFromXml(Node node) {
            return true;
        }

        boolean saveToXml(Node node) {
            return true;
        }

        String exportSectionHeader(EnumSpotMeasures measureType, String csvSeparator) {
            return "#" + csvSeparator + measureType.toString() + "\n";
        }

        String exportOneType(String sourceName, int spotArrayIndex, EnumSpotMeasures measureType, String csvSeparator) {
            StringBuilder sbf = new StringBuilder();
            sbf.append(sourceName + csvSeparator + spotArrayIndex + csvSeparator);
            switch (measureType) {
                case AREA_SUM: {
                    this.sumIn.exportYDataToCsv(sbf, csvSeparator);
                    break;
                }
                case AREA_SUMCLEAN: {
                    this.sumClean.exportYDataToCsv(sbf, csvSeparator);
                    break;
                }
                case AREA_FLYPRESENT: {
                    this.flyPresent.exportYDataToCsv(sbf, csvSeparator);
                    break;
                }
            }
            sbf.append("\n");
            return sbf.toString();
        }

        void importOneType(EnumSpotMeasures measureType, String[] data, boolean includeX, boolean includeY) {
            if (includeX && includeY) {
                switch (measureType) {
                    case AREA_SUM: {
                        this.sumIn.importXYDataFromCsv(data, 3);
                        break;
                    }
                    case AREA_SUMCLEAN: {
                        this.sumClean.importXYDataFromCsv(data, 3);
                        break;
                    }
                    case AREA_FLYPRESENT: {
                        this.flyPresent.importXYDataFromCsv(data, 3);
                        break;
                    }
                }
            } else if (!includeX && includeY) {
                switch (measureType) {
                    case AREA_SUM: {
                        this.sumIn.importYDataFromCsv(data, 3);
                        break;
                    }
                    case AREA_SUMCLEAN: {
                        this.sumClean.importYDataFromCsv(data, 3);
                        break;
                    }
                    case AREA_FLYPRESENT: {
                        this.flyPresent.importYDataFromCsv(data, 3);
                        break;
                    }
                }
            }
        }
    }

    private static class SpotMetadata {
        private boolean valid = true;
        private boolean okToAnalyze = true;
        private int kymographIndex = -1;
        private int spotCamDataT = -1;
        private int spotKymographT = -1;
        private String spotFilenameTiff;
        private IcyBufferedImage spotImage;
        private BooleanMask2D mask2DSpot;

        SpotMetadata() {
        }

        SpotMetadata(SpotMetadata source) {
            this.valid = source.valid;
            this.okToAnalyze = source.okToAnalyze;
            this.kymographIndex = source.kymographIndex;
            this.spotCamDataT = source.spotCamDataT;
            this.spotKymographT = source.spotKymographT;
            this.spotFilenameTiff = source.spotFilenameTiff;
            this.spotImage = source.spotImage;
            this.mask2DSpot = source.mask2DSpot;
        }

        boolean isValid() {
            return this.valid;
        }

        void setValid(boolean valid) {
            this.valid = valid;
        }

        boolean isOkToAnalyze() {
            return this.okToAnalyze;
        }

        void setOkToAnalyze(boolean okToAnalyze) {
            this.okToAnalyze = okToAnalyze;
        }

        int getSpotCamDataT() {
            return this.spotCamDataT;
        }

        void setSpotCamDataT(int spotCamDataT) {
            this.spotCamDataT = spotCamDataT;
        }

        int getSpotKymographT() {
            return this.spotKymographT;
        }

        void setSpotKymographT(int spotKymographT) {
            this.spotKymographT = spotKymographT;
        }

        String getSpotFilenameTiff() {
            return this.spotFilenameTiff;
        }

        void setSpotFilenameTiff(String spotFilenameTiff) {
            this.spotFilenameTiff = spotFilenameTiff;
        }

        IcyBufferedImage getSpotImage() {
            return this.spotImage;
        }

        void setSpotImage(IcyBufferedImage spotImage) {
            this.spotImage = spotImage;
        }

        BooleanMask2D getMask2DSpot() {
            return this.mask2DSpot;
        }

        void setMask2DSpot(BooleanMask2D mask2DSpot) {
            this.mask2DSpot = mask2DSpot;
        }
    }
}

