/*
 * Decompiled with CFR 0.152.
 */
package plugins.fmp.multiSPOTS96.experiment.spots;

import java.awt.Color;
import javax.swing.table.AbstractTableModel;
import plugins.fmp.multiSPOTS96.experiment.Experiment;
import plugins.fmp.multiSPOTS96.experiment.spots.Spot;
import plugins.fmp.multiSPOTS96.tools.JComponents.JComboBoxExperiment;

public class SpotTableModel
extends AbstractTableModel {
    private static final long serialVersionUID = 6325792669154093747L;
    private JComboBoxExperiment expList = null;
    String[] columnNames = new String[]{"Spot name", "pixels", "uL", "IDCage", "Pos", "Row", "Col", "Stimulus", "Concentration", "Color"};

    public SpotTableModel(JComboBoxExperiment expList) {
        this.expList = expList;
    }

    @Override
    public int getColumnCount() {
        return this.columnNames.length;
    }

    @Override
    public int getRowCount() {
        if (this.expList != null && this.expList.getSelectedIndex() >= 0) {
            Experiment exp = (Experiment)this.expList.getSelectedItem();
            return exp.cagesArray.getTotalNumberOfSpots();
        }
        return 0;
    }

    @Override
    public String getColumnName(int column) {
        return this.columnNames[column];
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        switch (columnIndex) {
            case 0: 
            case 7: 
            case 8: {
                return String.class;
            }
            case 2: {
                return Double.class;
            }
            case 9: {
                return Color.class;
            }
        }
        return Integer.class;
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return columnIndex > 0;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        Spot spot = this.getSpotAt(rowIndex);
        if (spot != null) {
            switch (columnIndex) {
                case 0: {
                    return spot.getRoi().getName();
                }
                case 1: {
                    return spot.getProperties().getSpotNPixels();
                }
                case 2: {
                    return spot.getProperties().getSpotVolume();
                }
                case 3: {
                    return spot.getProperties().getCageID();
                }
                case 4: {
                    return spot.getProperties().getCagePosition();
                }
                case 5: {
                    return spot.getProperties().getCageRow();
                }
                case 6: {
                    return spot.getProperties().getCageColumn();
                }
                case 7: {
                    return spot.getProperties().getStimulus();
                }
                case 8: {
                    return spot.getProperties().getConcentration();
                }
                case 9: {
                    return spot.getProperties().getColor();
                }
            }
        }
        return null;
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        Spot spot = this.getSpotAt(rowIndex);
        if (spot != null && spot.getProperties() != null) {
            switch (columnIndex) {
                case 0: {
                    spot.getRoi().setName(aValue.toString());
                    break;
                }
                case 1: {
                    spot.getProperties().setSpotNPixels((Integer)aValue);
                    break;
                }
                case 2: {
                    spot.getProperties().setSpotVolume((Double)aValue);
                    break;
                }
                case 3: {
                    spot.getProperties().setCageID((Integer)aValue);
                    break;
                }
                case 4: {
                    spot.getProperties().setCagePosition((Integer)aValue);
                    break;
                }
                case 5: {
                    spot.getProperties().setCageRow((Integer)aValue);
                    break;
                }
                case 6: {
                    spot.getProperties().setCageColumn((Integer)aValue);
                    break;
                }
                case 7: {
                    spot.getProperties().setStimulus(aValue.toString());
                    break;
                }
                case 8: {
                    spot.getProperties().setConcentration(aValue.toString());
                    break;
                }
                case 9: {
                    spot.getProperties().setColor((Color)aValue);
                    spot.getRoi().setColor(spot.getProperties().getColor());
                }
            }
        }
    }

    public Spot getSpotAt(int rowIndex) {
        Spot spot = null;
        if (this.expList != null && this.expList.getSelectedIndex() >= 0) {
            Experiment exp = (Experiment)this.expList.getSelectedItem();
            spot = exp.cagesArray.getSpotAtGlobalIndex(rowIndex);
        }
        return spot;
    }
}

