/*
 * Decompiled with CFR 0.152.
 */
package plugins.fmp.multiSPOTS96.series;

import plugins.fmp.multiSPOTS96.series.ProcessingResult;
import plugins.fmp.multiSPOTS96.series.ProgressReporter;
import plugins.fmp.multiSPOTS96.tools.imageTransform.ImageTransformOptions;

public class RegistrationOptions {
    private int fromFrame = 0;
    private int toFrame = 100;
    private int referenceFrame = 0;
    private double translationThreshold = 0.001;
    private double rotationThreshold = 0.001;
    private ImageTransformOptions transformOptions = new ImageTransformOptions();
    private boolean saveCorrectedImages = true;
    private boolean preserveImageSize = true;
    private int referenceChannel = 0;
    private ProgressReporter progressReporter = ProgressReporter.NO_OP;

    public RegistrationOptions fromFrame(int fromFrame) {
        this.fromFrame = fromFrame;
        return this;
    }

    public RegistrationOptions toFrame(int toFrame) {
        this.toFrame = toFrame;
        return this;
    }

    public RegistrationOptions referenceFrame(int referenceFrame) {
        this.referenceFrame = referenceFrame;
        return this;
    }

    public RegistrationOptions translationThreshold(double threshold) {
        this.translationThreshold = threshold;
        return this;
    }

    public RegistrationOptions rotationThreshold(double threshold) {
        this.rotationThreshold = threshold;
        return this;
    }

    public RegistrationOptions transformOptions(ImageTransformOptions options) {
        this.transformOptions = options;
        return this;
    }

    public RegistrationOptions saveCorrectedImages(boolean save) {
        this.saveCorrectedImages = save;
        return this;
    }

    public RegistrationOptions preserveImageSize(boolean preserve) {
        this.preserveImageSize = preserve;
        return this;
    }

    public RegistrationOptions referenceChannel(int channel) {
        this.referenceChannel = channel;
        return this;
    }

    public RegistrationOptions progressReporter(ProgressReporter reporter) {
        this.progressReporter = reporter;
        return this;
    }

    public int getFromFrame() {
        return this.fromFrame;
    }

    public int getToFrame() {
        return this.toFrame;
    }

    public int getReferenceFrame() {
        return this.referenceFrame;
    }

    public double getTranslationThreshold() {
        return this.translationThreshold;
    }

    public double getRotationThreshold() {
        return this.rotationThreshold;
    }

    public ImageTransformOptions getTransformOptions() {
        return this.transformOptions;
    }

    public boolean isSaveCorrectedImages() {
        return this.saveCorrectedImages;
    }

    public boolean isPreserveImageSize() {
        return this.preserveImageSize;
    }

    public int getReferenceChannel() {
        return this.referenceChannel;
    }

    public ProgressReporter getProgressReporter() {
        return this.progressReporter;
    }

    public ProcessingResult<Void> validate() {
        if (this.fromFrame < 0) {
            return ProcessingResult.failure("From frame must be non-negative, got: %d", this.fromFrame);
        }
        if (this.toFrame < this.fromFrame) {
            return ProcessingResult.failure("To frame must be >= from frame, got: %d < %d", this.toFrame, this.fromFrame);
        }
        if (this.referenceFrame < this.fromFrame || this.referenceFrame <= this.toFrame) {
            return ProcessingResult.failure("Reference frame must be within frame range [%d, %d], got: %d", this.fromFrame, this.toFrame, this.referenceFrame);
        }
        if (this.translationThreshold < 0.0) {
            return ProcessingResult.failure("Translation threshold must be non-negative, got: %f", this.translationThreshold);
        }
        if (this.rotationThreshold < 0.0) {
            return ProcessingResult.failure("Rotation threshold must be non-negative, got: %f", this.rotationThreshold);
        }
        if (this.transformOptions == null) {
            return ProcessingResult.failure("Transform options cannot be null");
        }
        if (this.progressReporter == null) {
            return ProcessingResult.failure("Progress reporter cannot be null");
        }
        return ProcessingResult.success();
    }

    public String toString() {
        return String.format("RegistrationOptions{fromFrame=%d, toFrame=%d, referenceFrame=%d, translationThreshold=%.6f, rotationThreshold=%.6f, saveCorrectedImages=%s}", this.fromFrame, this.toFrame, this.referenceFrame, this.translationThreshold, this.rotationThreshold, this.saveCorrectedImages);
    }
}

