/*
 * Decompiled with CFR 0.152.
 */
package plugins.fmp.multiSPOTS96.tools.chart;

import java.util.logging.Logger;
import org.jfree.data.xy.XYSeriesCollection;
import plugins.fmp.multiSPOTS96.tools.MaxMinDouble;

public class ChartData {
    private static final Logger LOGGER = Logger.getLogger(ChartData.class.getName());
    private MaxMinDouble yMaxMin;
    private MaxMinDouble xMaxMin;
    private XYSeriesCollection xyDataset;

    public ChartData() {
        this(null, null, null);
    }

    public ChartData(MaxMinDouble xMaxMin, MaxMinDouble yMaxMin, XYSeriesCollection xyDataset) {
        this.xMaxMin = xMaxMin;
        this.yMaxMin = yMaxMin;
        this.xyDataset = xyDataset;
    }

    public MaxMinDouble getYMaxMin() {
        return this.yMaxMin;
    }

    public void setYMaxMin(MaxMinDouble yMaxMin) {
        this.yMaxMin = yMaxMin;
    }

    public MaxMinDouble getXMaxMin() {
        return this.xMaxMin;
    }

    public void setXMaxMin(MaxMinDouble xMaxMin) {
        this.xMaxMin = xMaxMin;
    }

    public XYSeriesCollection getXYDataset() {
        return this.xyDataset;
    }

    public void setXYDataset(XYSeriesCollection xyDataset) {
        this.xyDataset = xyDataset;
    }

    public boolean isComplete() {
        return this.xMaxMin != null && this.yMaxMin != null && this.xyDataset != null;
    }

    public boolean hasData() {
        return this.xyDataset != null && this.xyDataset.getSeriesCount() > 0;
    }

    public int getSeriesCount() {
        return this.xyDataset != null ? this.xyDataset.getSeriesCount() : 0;
    }

    public String getYRangeString() {
        if (this.yMaxMin == null) {
            return "Y-axis range: not set";
        }
        return String.format("Y-axis range: [%.2f, %.2f]", this.yMaxMin.getMin(), this.yMaxMin.getMax());
    }

    public String getXRangeString() {
        if (this.xMaxMin == null) {
            return "X-axis range: not set";
        }
        return String.format("X-axis range: [%.2f, %.2f]", this.xMaxMin.getMin(), this.xMaxMin.getMax());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("ChartData[");
        sb.append("seriesCount=").append(this.getSeriesCount());
        if (this.xMaxMin != null) {
            sb.append(", xRange=[").append(this.xMaxMin.getMin()).append(", ").append(this.xMaxMin.getMax()).append("]");
        }
        if (this.yMaxMin != null) {
            sb.append(", yRange=[").append(this.yMaxMin.getMin()).append(", ").append(this.yMaxMin.getMax()).append("]");
        }
        sb.append("]");
        return sb.toString();
    }

    public ChartData copy() {
        return new ChartData(this.xMaxMin, this.yMaxMin, this.xyDataset);
    }

    public void clear() {
        this.xMaxMin = null;
        this.yMaxMin = null;
        this.xyDataset = null;
    }
}

