/*
 * Decompiled with CFR 0.152.
 */
package plugins.fmp.multiSPOTS96.tools.imageTransform;

public final class ImageTransformConstants {
    private ImageTransformConstants() {
    }

    public static final class ErrorMessages {
        public static final String NULL_SOURCE_IMAGE = "Source image cannot be null";
        public static final String NULL_OPTIONS = "Transform options cannot be null";
        public static final String INVALID_IMAGE_DIMENSIONS = "Invalid image dimensions: width=%d, height=%d";
        public static final String UNSUPPORTED_CHANNELS = "Unsupported number of channels: %d";
        public static final String INVALID_PARAMETER = "Invalid parameter %s: %s";
        public static final String ALGORITHM_FAILURE = "Algorithm execution failed: %s";
        public static final String INCOMPATIBLE_IMAGES = "Images are not compatible: %s";
        public static final String OUT_OF_BOUNDS = "Array access out of bounds: index=%d, length=%d";

        private ErrorMessages() {
        }
    }

    public static final class Validation {
        public static final int MIN_IMAGE_WIDTH = 1;
        public static final int MIN_IMAGE_HEIGHT = 1;
        public static final int MAX_IMAGE_DIMENSION = 16384;
        public static final int MAX_CHANNELS = 4;

        private Validation() {
        }
    }

    public static final class Performance {
        public static final int ARRAY_CACHE_SIZE = 100;
        public static final int OPTIMIZATION_THRESHOLD = 1000;
        public static final int MAX_CACHEABLE_IMAGE_SIZE = 2073600;

        private Performance() {
        }
    }

    public static final class DifferenceOperations {
        public static final int DEFAULT_Y_SPAN = 4;
        public static final int DEFAULT_X_SPAN = 3;
        public static final int DEFAULT_XY_SPAN = 5;
        public static final int MAX_SPAN = 20;

        private DifferenceOperations() {
        }
    }

    public static final class LinearCombination {
        public static final double[] GRAYSCALE_WEIGHTS = new double[]{0.299, 0.587, 0.114};
        public static final double[] EQUAL_WEIGHTS = new double[]{0.3333333333333333, 0.3333333333333333, 0.3333333333333333};
        public static final double[] RED_WEIGHTS = new double[]{1.0, 0.0, 0.0};
        public static final double[] GREEN_WEIGHTS = new double[]{0.0, 1.0, 0.0};
        public static final double[] BLUE_WEIGHTS = new double[]{0.0, 0.0, 1.0};

        private LinearCombination() {
        }
    }

    public static final class Thresholding {
        public static final byte TRUE_VALUE = -1;
        public static final byte FALSE_VALUE = 0;
        public static final int DEFAULT_THRESHOLD = 128;
        public static final int MIN_THRESHOLD = 0;
        public static final int MAX_THRESHOLD = 255;

        private Thresholding() {
        }
    }

    public static final class EdgeDetection {
        public static final double DEFAULT_DERICHE_ALPHA = 1.0;
        public static final double MIN_DERICHE_ALPHA = 0.1;
        public static final double MAX_DERICHE_ALPHA = 5.0;
        public static final int DEFAULT_SPAN_SIZE = 3;
        public static final int DEFAULT_DELTA = 0;

        private EdgeDetection() {
        }
    }

    public static final class ColorSpace {
        public static final double HSV_SCALING_FACTOR = 100.0;
        public static final int RGB_MAX_VALUE = 255;
        public static final int UNDEFINED_HUE = -1;
        public static final int RGB_CHANNELS = 3;
        public static final double HUE_FULL_CIRCLE = 360.0;
        public static final double HUE_SECTOR_SIZE = 60.0;

        private ColorSpace() {
        }
    }
}

