/*
 * Decompiled with CFR 0.152.
 */
package plugins.fmp.multiSPOTS96.tools.overlay;

import icy.canvas.IcyCanvas;
import icy.canvas.IcyCanvas2D;
import icy.image.IcyBufferedImage;
import icy.painter.Overlay;
import icy.painter.OverlayListener;
import icy.sequence.Sequence;
import icy.type.point.Point5D;
import java.awt.Color;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JButton;
import javax.swing.JComboBox;

public class OverlayTrapMouse
extends Overlay {
    private static final Logger LOGGER = Logger.getLogger(OverlayTrapMouse.class.getName());
    private static final String DEFAULT_OVERLAY_NAME = "Mouse Trap Overlay";
    private static final String UI_OVERLAY_NAME = "Color Picker Overlay";
    private static final int RED_SHIFT = 16;
    private static final int GREEN_SHIFT = 8;
    private static final int BLUE_SHIFT = 0;
    private static final int COLOR_MASK = 255;
    private static final String COLOR_SEPARATOR = ":";
    private static final Color DEFAULT_BUTTON_COLOR = Color.LIGHT_GRAY;
    private Point5D.Double currentPoint;
    private JButton pickColorButton;
    private JComboBox<Color> colorPickComboBox;
    private String originalButtonText;

    public OverlayTrapMouse() {
        super(DEFAULT_OVERLAY_NAME);
    }

    public OverlayTrapMouse(JButton pickColorButton, JComboBox<Color> colorPickComboBox) {
        super(UI_OVERLAY_NAME);
        this.attachInterfaceElements(pickColorButton, colorPickComboBox);
    }

    public OverlayTrapMouse(OverlayListener listener) {
        super(DEFAULT_OVERLAY_NAME);
        if (listener == null) {
            throw new IllegalArgumentException("Overlay listener cannot be null");
        }
        this.addOverlayListener(listener);
    }

    public void attachInterfaceElements(JButton pickColorButton, JComboBox<Color> colorPickComboBox) {
        if (pickColorButton == null) {
            throw new IllegalArgumentException("Pick color button cannot be null");
        }
        if (colorPickComboBox == null) {
            throw new IllegalArgumentException("Color pick combo box cannot be null");
        }
        this.pickColorButton = pickColorButton;
        this.colorPickComboBox = colorPickComboBox;
        this.originalButtonText = pickColorButton.getText();
    }

    public void detachInterfaceElements() {
        if (this.pickColorButton != null && this.originalButtonText != null) {
            this.pickColorButton.setText(this.originalButtonText);
            this.pickColorButton.setBackground(DEFAULT_BUTTON_COLOR);
        }
        this.pickColorButton = null;
        this.colorPickComboBox = null;
        this.originalButtonText = null;
    }

    public boolean hasUIElements() {
        return this.pickColorButton != null && this.colorPickComboBox != null;
    }

    public void mouseClick(MouseEvent event, Point5D.Double imagePoint, IcyCanvas canvas) {
        if (event == null || imagePoint == null || canvas == null) {
            return;
        }
        if (!(canvas instanceof IcyCanvas2D)) {
            return;
        }
        try {
            this.onMouseClicked(canvas.getSequence(), canvas.getPositionT(), imagePoint);
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, "Error handling mouse click", e);
        }
    }

    public void mouseMove(MouseEvent event, Point5D.Double imagePoint, IcyCanvas canvas) {
        if (event == null || imagePoint == null || canvas == null) {
            return;
        }
        if (!(canvas instanceof IcyCanvas2D)) {
            return;
        }
        try {
            this.onMouseMoved(canvas.getSequence(), canvas.getPositionT(), imagePoint);
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, "Error handling mouse move", e);
        }
    }

    private void onMouseClicked(Sequence sequence, int timePosition, Point5D.Double imagePoint) {
        if (sequence == null || imagePoint == null) {
            return;
        }
        Color pickedColor = this.getColorAtPoint(sequence, timePosition, imagePoint);
        if (pickedColor != null && this.hasUIElements()) {
            this.updateUIWithColor(pickedColor);
        }
    }

    private void onMouseMoved(Sequence sequence, int timePosition, Point5D.Double imagePoint) {
        if (sequence == null || imagePoint == null) {
            return;
        }
        Color currentColor = this.getColorAtPoint(sequence, timePosition, imagePoint);
        if (currentColor != null && this.pickColorButton != null) {
            this.updateButtonDisplay(currentColor);
        }
    }

    private void updateUIWithColor(Color pickedColor) {
        if (pickedColor == null) {
            return;
        }
        try {
            this.pickColorButton.setBackground(pickedColor);
            int selectedIndex = this.findOrAddColorToComboBox(pickedColor);
            if (selectedIndex >= 0) {
                this.colorPickComboBox.setSelectedIndex(selectedIndex);
            }
            this.pickColorButton.setBackground(DEFAULT_BUTTON_COLOR);
            if (this.originalButtonText != null) {
                this.pickColorButton.setText(this.originalButtonText);
            }
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, "Error updating UI with color", e);
        }
    }

    private int findOrAddColorToComboBox(Color color) {
        if (color == null || this.colorPickComboBox == null) {
            return -1;
        }
        try {
            for (int i = 0; i < this.colorPickComboBox.getItemCount(); ++i) {
                Color existingColor = this.colorPickComboBox.getItemAt(i);
                if (!color.equals(existingColor)) continue;
                return i;
            }
            this.colorPickComboBox.addItem(color);
            return this.colorPickComboBox.getItemCount() - 1;
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, "Error managing color in combo box", e);
            return -1;
        }
    }

    private void updateButtonDisplay(Color color) {
        if (color == null || this.pickColorButton == null) {
            return;
        }
        try {
            this.pickColorButton.setBackground(color);
            StringBuilder colorText = new StringBuilder();
            colorText.append(color.getRed()).append(COLOR_SEPARATOR).append(color.getGreen()).append(COLOR_SEPARATOR).append(color.getBlue());
            this.pickColorButton.setText(colorText.toString());
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, "Error updating button display", e);
        }
    }

    private Color getColorAtPoint(Sequence sequence, int timePosition, Point5D.Double imagePoint) {
        if (sequence == null || imagePoint == null) {
            return null;
        }
        try {
            int x = (int)imagePoint.getX();
            int y = (int)imagePoint.getY();
            this.setCurrentPoint(imagePoint);
            IcyBufferedImage image = sequence.getImage(timePosition, 0);
            if (image == null) {
                LOGGER.warning("No image available at time position: " + timePosition);
                return null;
            }
            if (!image.isInside(new Point(x, y))) {
                return null;
            }
            int argb = image.getRGB(x, y);
            int red = argb >> 16 & 0xFF;
            int green = argb >> 8 & 0xFF;
            int blue = argb >> 0 & 0xFF;
            return new Color(red, green, blue);
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, "Error extracting color at point", e);
            return null;
        }
    }

    public Point5D.Double getCurrentPoint() {
        return this.currentPoint;
    }

    private void setCurrentPoint(Point5D.Double point) {
        this.currentPoint = point;
    }

    public JButton getPickColorButton() {
        return this.pickColorButton;
    }

    public JComboBox<Color> getColorPickComboBox() {
        return this.colorPickComboBox;
    }

    public String getOriginalButtonText() {
        return this.originalButtonText;
    }
}

