/*
 * Decompiled with CFR 0.152.
 */
package plugins.fmp.multiSPOTS96.tools.toExcel;

import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.poi.hssf.util.HSSFColor;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;
import plugins.fmp.multiSPOTS96.tools.toExcel.exceptions.ExcelResourceException;

public class ExcelResourceManager
implements AutoCloseable {
    private final SXSSFWorkbook workbook;
    private final FileOutputStream fileOutputStream;
    private final String filename;
    private final CellStyle redCellStyle;
    private final CellStyle blueCellStyle;
    private final Font redFont;
    private final Font blueFont;
    private boolean closed = false;

    public ExcelResourceManager(String filename) throws ExcelResourceException {
        this.filename = filename;
        try {
            this.workbook = new SXSSFWorkbook();
            this.fileOutputStream = new FileOutputStream(filename);
            this.workbook.setMissingCellPolicy(Row.MissingCellPolicy.CREATE_NULL_AS_BLANK);
            this.redCellStyle = this.workbook.createCellStyle();
            this.redFont = this.workbook.createFont();
            this.redFont.setColor(HSSFColor.HSSFColorPredefined.RED.getIndex());
            this.redCellStyle.setFont(this.redFont);
            this.blueCellStyle = this.workbook.createCellStyle();
            this.blueFont = this.workbook.createFont();
            this.blueFont.setColor(HSSFColor.HSSFColorPredefined.BLUE.getIndex());
            this.blueCellStyle.setFont(this.blueFont);
        }
        catch (IOException e) {
            throw new ExcelResourceException("Failed to initialize Excel resources", "resource_initialization", filename, e);
        }
    }

    public SXSSFWorkbook getWorkbook() throws ExcelResourceException {
        this.checkNotClosed();
        return this.workbook;
    }

    public CellStyle getRedCellStyle() throws ExcelResourceException {
        this.checkNotClosed();
        return this.redCellStyle;
    }

    public CellStyle getBlueCellStyle() throws ExcelResourceException {
        this.checkNotClosed();
        return this.blueCellStyle;
    }

    public void saveAndClose() throws ExcelResourceException {
        if (this.closed) {
            return;
        }
        try {
            this.workbook.write((OutputStream)this.fileOutputStream);
            this.close();
        }
        catch (IOException e) {
            throw new ExcelResourceException("Failed to save Excel file", "save_operation", this.filename, e);
        }
    }

    @Override
    public void close() throws ExcelResourceException {
        if (this.closed) {
            return;
        }
        Throwable lastException = null;
        if (this.workbook != null) {
            try {
                this.workbook.close();
            }
            catch (IOException e) {
                lastException = new ExcelResourceException("Failed to close workbook", "close_workbook", this.filename, e);
            }
        }
        if (this.fileOutputStream != null) {
            try {
                this.fileOutputStream.close();
            }
            catch (IOException e) {
                if (lastException != null) {
                    lastException.addSuppressed(e);
                }
                lastException = new ExcelResourceException("Failed to close file output stream", "close_stream", this.filename, e);
            }
        }
        this.closed = true;
        if (lastException != null) {
            throw lastException;
        }
    }

    public boolean isClosed() {
        return this.closed;
    }

    public String getFilename() {
        return this.filename;
    }

    private void checkNotClosed() throws ExcelResourceException {
        if (this.closed) {
            throw new ExcelResourceException("Excel resource manager is closed", "resource_access", this.filename);
        }
    }
}

