/*
 * Decompiled with CFR 0.152.
 */
package plugins.fmp.multiSPOTS96.tools.toExcel;

import java.awt.Point;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.poi.xssf.streaming.SXSSFSheet;
import plugins.fmp.multiSPOTS96.experiment.Experiment;
import plugins.fmp.multiSPOTS96.experiment.cages.Cage;
import plugins.fmp.multiSPOTS96.experiment.sequence.TimeManager;
import plugins.fmp.multiSPOTS96.experiment.spots.Spot;
import plugins.fmp.multiSPOTS96.tools.toExcel.EnumXLSExport;
import plugins.fmp.multiSPOTS96.tools.toExcel.XLSExport;
import plugins.fmp.multiSPOTS96.tools.toExcel.XLSExportOptions;
import plugins.fmp.multiSPOTS96.tools.toExcel.exceptions.ExcelExportException;
import plugins.fmp.multiSPOTS96.tools.toExcel.exceptions.ExcelResourceException;

public class XLSExportMeasuresFromSpotOptimized
extends XLSExport {
    private final SpotDataBuffer spotDataBuffer = new SpotDataBuffer(1024);
    private final ExcelRowBuffer excelRowBuffer = new ExcelRowBuffer(1024);
    private static final int BUFFER_SIZE = 1024;
    private static final int GC_INTERVAL = 100;
    private int processedSpots = 0;

    @Override
    protected int exportExperimentData(Experiment exp, XLSExportOptions xlsExportOptions, int startColumn, String charSeries) throws ExcelExportException {
        int column = startColumn;
        if (this.options.spotAreas) {
            column = this.exportSpotDataStreaming(exp, column, charSeries, EnumXLSExport.AREA_SUM);
            this.exportSpotDataStreaming(exp, column, charSeries, EnumXLSExport.AREA_FLYPRESENT);
            this.exportSpotDataStreaming(exp, column, charSeries, EnumXLSExport.AREA_SUMCLEAN);
        }
        return column;
    }

    protected int exportSpotDataStreaming(Experiment exp, int col0, String charSeries, EnumXLSExport exportType) throws ExcelExportException {
        try {
            this.options.exportType = exportType;
            SXSSFSheet sheet = this.getSheet(exportType.toString(), exportType);
            int colmax = this.writeExperimentDataToSheetStreaming(exp, sheet, exportType, col0, charSeries);
            if (this.options.onlyalive) {
                sheet = this.getSheet(exportType.toString() + "_alive", exportType);
                this.writeExperimentDataToSheetStreaming(exp, sheet, exportType, col0, charSeries);
            }
            return colmax;
        }
        catch (ExcelResourceException e) {
            throw new ExcelExportException("Failed to export spot data", "export_spot_data_streaming", exportType.toString(), e);
        }
    }

    protected int writeExperimentDataToSheetStreaming(Experiment exp, SXSSFSheet sheet, EnumXLSExport xlsExportType, int col0, String charSeries) {
        Point pt = new Point(col0, 0);
        pt = this.writeExperimentSeparator(sheet, pt);
        for (Cage cage : exp.cagesArray.cagesList) {
            double scalingFactorToPhysicalUnits = cage.spotsArray.getScalingFactorToPhysicalUnits(xlsExportType);
            cage.updateSpotsStimulus_i();
            for (Spot spot : cage.spotsArray.getSpotsList()) {
                pt.y = 0;
                pt = this.writeExperimentSpotInfos(sheet, pt, exp, charSeries, cage, spot, xlsExportType);
                this.writeSpotDataDirectly(sheet, pt, spot, scalingFactorToPhysicalUnits, xlsExportType);
                ++pt.x;
                ++this.processedSpots;
                if (this.processedSpots % 100 != 0) continue;
                System.gc();
            }
        }
        return pt.x;
    }

    protected void writeSpotDataDirectly(SXSSFSheet sheet, Point pt, Spot spot, double scalingFactorToPhysicalUnits, EnumXLSExport xlsExportType) {
        List<Double> dataList = spot.getMeasuresForExcelPass1(xlsExportType, this.getBinData(spot), this.getBinExcel());
        if (dataList == null || dataList.isEmpty()) {
            return;
        }
        if (this.options.relativeToT0 && xlsExportType != EnumXLSExport.AREA_FLYPRESENT) {
            dataList = this.applyRelativeToMaximum(dataList);
        }
        Iterator<Double> dataIterator = dataList.iterator();
        for (int row = pt.y + this.getDescriptorRowCount(); dataIterator.hasNext() && row < this.excelRowBuffer.getMaxRows(); ++row) {
            double value = dataIterator.next();
            double scaledValue = value * scalingFactorToPhysicalUnits;
            this.excelRowBuffer.setValue(row, pt.x, scaledValue);
        }
        this.excelRowBuffer.flushToSheet(sheet);
    }

    private long getBinData(Spot spot) {
        return 1000L;
    }

    private long getBinExcel() {
        return this.options.buildExcelStepMs;
    }

    private List<Double> applyRelativeToMaximum(List<Double> dataList) {
        if (dataList == null || dataList.isEmpty()) {
            return dataList;
        }
        double maximum = dataList.stream().mapToDouble(Double::doubleValue).max().orElse(1.0);
        if (maximum == 0.0) {
            return dataList;
        }
        return dataList.stream().map(value -> value / maximum).collect(Collectors.toList());
    }

    protected int getNOutputFrames(Experiment exp, XLSExportOptions options) {
        TimeManager timeManager = exp.seqCamData.getTimeManager();
        long durationMs = timeManager.getBinLast_ms() - timeManager.getBinFirst_ms();
        int nOutputFrames = (int)(durationMs / (long)options.buildExcelStepMs + 1L);
        if (nOutputFrames <= 1) {
            long binLastMs = timeManager.getBinFirst_ms() + (long)exp.seqCamData.getImageLoader().getNTotalFrames() * timeManager.getBinDurationMs();
            timeManager.setBinLast_ms(binLastMs);
            if (binLastMs <= 0L) {
                this.handleExportError(exp, -1);
            }
            if ((nOutputFrames = (int)((binLastMs - timeManager.getBinFirst_ms()) / (long)options.buildExcelStepMs + 1L)) <= 1) {
                nOutputFrames = exp.seqCamData.getImageLoader().getNTotalFrames();
                this.handleExportError(exp, nOutputFrames);
            }
        }
        return nOutputFrames;
    }

    private static class SpotDataBuffer {
        private final double[] buffer;
        private final int size;

        public SpotDataBuffer(int size) {
            this.size = size;
            this.buffer = new double[size];
        }

        public void clear() {
            Arrays.fill(this.buffer, 0.0);
        }

        public double[] getBuffer() {
            return this.buffer;
        }

        public int getSize() {
            return this.size;
        }
    }

    private static class ExcelRowBuffer {
        private final double[][] buffer;
        private final int maxRows;
        private final int maxCols;
        private int currentRow = 0;
        private int currentCol = 0;

        public ExcelRowBuffer(int size) {
            this.maxRows = size;
            this.maxCols = size;
            this.buffer = new double[this.maxRows][this.maxCols];
        }

        public void setValue(int row, int col, double value) {
            if (row < this.maxRows && col < this.maxCols) {
                this.buffer[row][col] = value;
            }
        }

        public void flushToSheet(SXSSFSheet sheet) {
            this.clear();
        }

        public void clear() {
            for (int i = 0; i < this.maxRows; ++i) {
                Arrays.fill(this.buffer[i], 0.0);
            }
            this.currentRow = 0;
            this.currentCol = 0;
        }

        public int getMaxRows() {
            return this.maxRows;
        }
    }
}

