/*
 * Decompiled with CFR 0.152.
 */
package plugins.fmp.multiSPOTS96.experiment.sequence;

import icy.roi.ROI2D;

public class ROIOperation {
    private final Type type;
    private final String pattern;
    private final ROI2D roi;
    private final boolean visible;
    private final boolean selected;

    private ROIOperation(Builder builder) {
        this.type = builder.type;
        this.pattern = builder.pattern;
        this.roi = builder.roi;
        this.visible = builder.visible;
        this.selected = builder.selected;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static ROIOperation displayROIs(String pattern, boolean visible) {
        return ROIOperation.builder().type(Type.DISPLAY).pattern(pattern).visible(visible).build();
    }

    public static ROIOperation removeROIs(String pattern) {
        return ROIOperation.builder().type(Type.REMOVE).pattern(pattern).build();
    }

    public static ROIOperation centerOnROI(ROI2D roi) {
        return ROIOperation.builder().type(Type.CENTER).roi(roi).build();
    }

    public static ROIOperation selectROI(ROI2D roi, boolean selected) {
        return ROIOperation.builder().type(Type.SELECT).roi(roi).selected(selected).build();
    }

    public Type getType() {
        return this.type;
    }

    public String getPattern() {
        return this.pattern;
    }

    public ROI2D getRoi() {
        return this.roi;
    }

    public boolean isVisible() {
        return this.visible;
    }

    public boolean isSelected() {
        return this.selected;
    }

    public static class Builder {
        private Type type;
        private String pattern;
        private ROI2D roi;
        private boolean visible;
        private boolean selected;

        public Builder type(Type type) {
            this.type = type;
            return this;
        }

        public Builder pattern(String pattern) {
            this.pattern = pattern;
            return this;
        }

        public Builder roi(ROI2D roi) {
            this.roi = roi;
            return this;
        }

        public Builder visible(boolean visible) {
            this.visible = visible;
            return this;
        }

        public Builder selected(boolean selected) {
            this.selected = selected;
            return this;
        }

        public ROIOperation build() {
            if (this.type == null) {
                throw new IllegalStateException("Operation type must be specified");
            }
            return new ROIOperation(this);
        }
    }

    public static enum Type {
        DISPLAY,
        REMOVE,
        CENTER,
        SELECT;

    }
}

