/*
 * Decompiled with CFR 0.152.
 */
package plugins.fmp.multiSPOTS96.experiment.sequence;

import icy.painter.Overlay;
import icy.sequence.Sequence;
import java.awt.Rectangle;
import java.lang.reflect.InvocationTargetException;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;
import plugins.fmp.multiSPOTS96.tools.ViewerFMP;
import plugins.fmp.multiSPOTS96.tools.imageTransform.ImageTransformEnums;
import plugins.fmp.multiSPOTS96.tools.overlay.OverlayThreshold;

public class ViewerManager {
    private static final Logger LOGGER = Logger.getLogger(ViewerManager.class.getName());
    private OverlayThreshold overlayThresholdCam = null;

    public void displayViewerAtRectangle(final Sequence seq, final Rectangle parentRect) {
        if (seq == null) {
            LOGGER.warning("Cannot display viewer: sequence is null");
            return;
        }
        if (parentRect == null) {
            LOGGER.warning("Cannot display viewer: parent rectangle is null");
            return;
        }
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    ViewerFMP v = (ViewerFMP)seq.getFirstViewer();
                    if (v == null) {
                        v = new ViewerFMP(seq, true, true);
                    }
                    Rectangle viewerBounds = v.getBoundsInternal();
                    viewerBounds.setLocation(parentRect.x + parentRect.width, parentRect.y);
                    v.setBounds(viewerBounds);
                }
            });
        }
        catch (InterruptedException | InvocationTargetException e) {
            LOGGER.severe("Error displaying viewer: " + e.getMessage());
        }
    }

    public void updateOverlay(Sequence seq) {
        if (seq == null) {
            LOGGER.warning("Cannot update overlay: sequence is null");
            return;
        }
        if (this.overlayThresholdCam == null) {
            this.overlayThresholdCam = new OverlayThreshold(seq);
        } else {
            seq.removeOverlay((Overlay)this.overlayThresholdCam);
            this.overlayThresholdCam.setSequence(seq);
        }
        seq.addOverlay((Overlay)this.overlayThresholdCam);
    }

    public void removeOverlay(Sequence seq) {
        if (seq == null || this.overlayThresholdCam == null) {
            return;
        }
        seq.removeOverlay((Overlay)this.overlayThresholdCam);
    }

    public void updateOverlayThreshold(int threshold, ImageTransformEnums transform, boolean ifGreater) {
        if (this.overlayThresholdCam == null) {
            return;
        }
        this.overlayThresholdCam.setThresholdSingle(threshold, transform, ifGreater);
        this.overlayThresholdCam.painterChanged();
    }

    public OverlayThreshold getOverlayThresholdCam() {
        return this.overlayThresholdCam;
    }

    public void setOverlayThresholdCam(OverlayThreshold overlay) {
        this.overlayThresholdCam = overlay;
    }
}

