/*
 * Decompiled with CFR 0.152.
 */
package plugins.fmp.multiSPOTS96.series;

import plugins.fmp.multiSPOTS96.series.MemoryMonitor;

public class AdaptiveBatchSizer {
    private final MemoryMonitor memoryMonitor;
    private int currentBatchSize;
    private final int minBatchSize = 1;
    private final int maxBatchSize = 10;

    public AdaptiveBatchSizer(MemoryMonitor memoryMonitor) {
        this.memoryMonitor = memoryMonitor;
        this.currentBatchSize = 3;
    }

    public void initialize(int totalFrames, long availableMemoryMB) {
        int optimalBatchSize = (int)Math.min(10L, Math.max(1L, availableMemoryMB / 400L));
        this.currentBatchSize = Math.min(optimalBatchSize, totalFrames);
    }

    public void updateBatchSize(double memoryUsagePercent) {
        if (memoryUsagePercent > 85.0) {
            this.currentBatchSize = Math.max(1, this.currentBatchSize - 2);
        } else if (memoryUsagePercent < 50.0) {
            this.currentBatchSize = Math.min(10, this.currentBatchSize + 1);
        }
    }

    public void reduceBatchSize() {
        this.currentBatchSize = Math.max(1, this.currentBatchSize - 1);
        System.out.println("Reduced batch size to: " + this.currentBatchSize + " due to memory pressure");
    }

    public int getCurrentBatchSize() {
        return this.currentBatchSize;
    }
}

