/*
 * Decompiled with CFR 0.152.
 */
package plugins.fmp.multiSPOTS96.series;

import icy.gui.frame.progress.ProgressFrame;
import icy.image.IcyBufferedImage;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.util.List;
import plugins.fmp.multiSPOTS96.experiment.Experiment;
import plugins.fmp.multiSPOTS96.series.BuildSeries;
import plugins.fmp.multiSPOTS96.series.DetectFlyTools;
import plugins.fmp.multiSPOTS96.tools.imageTransform.ImageTransformInterface;
import plugins.fmp.multiSPOTS96.tools.imageTransform.ImageTransformOptions;

public class DetectFlyUsingSimpleThreshold
extends BuildSeries {
    public boolean buildBackground = true;
    public boolean detectFlies = true;
    public DetectFlyTools find_flies = new DetectFlyTools();

    @Override
    void analyzeExperiment(Experiment exp) {
        if (!this.loadSeqCamDataAndCages(exp)) {
            return;
        }
        if (!this.checkBoundsForCages(exp)) {
            return;
        }
        this.runFlyDetect1(exp);
        exp.cagesArray.orderFlyPositions();
        if (!this.stopFlag) {
            exp.save_MS96_fliesPositions();
        }
        exp.seqCamData.closeSequence();
        this.closeSequence(this.seqNegative);
    }

    private void runFlyDetect1(Experiment exp) {
        exp.cleanPreviousDetectedFliesROIs();
        this.find_flies.initParametersForDetection(exp, this.options);
        exp.cagesArray.initFlyPositions(this.options.detectCage);
        this.openFlyDetectViewers(exp);
        this.findFliesInAllFrames(exp);
    }

    private void getReferenceImage(Experiment exp, int t, ImageTransformOptions options) {
        switch (options.transformOption) {
            case SUBTRACT_TM1: {
                options.backgroundImage = this.imageIORead(exp.seqCamData.getFileNameFromImageList(t));
                break;
            }
            case SUBTRACT_T0: 
            case SUBTRACT_REF: {
                if (options.backgroundImage != null) break;
                options.backgroundImage = this.imageIORead(exp.seqCamData.getFileNameFromImageList(0));
                break;
            }
        }
    }

    private void findFliesInAllFrames(Experiment exp) {
        ProgressFrame progressBar = new ProgressFrame("Detecting flies...");
        ImageTransformOptions transformOptions = new ImageTransformOptions();
        transformOptions.transformOption = this.options.transformop;
        ImageTransformInterface transformFunction = this.options.transformop.getFunction();
        int t_previous = 0;
        int totalFrames = exp.seqCamData.getImageLoader().getNTotalFrames();
        for (int index = 0; index < totalFrames; ++index) {
            int t_from = index;
            String title = "Frame #" + t_from + "/" + exp.seqCamData.getImageLoader().getNTotalFrames();
            progressBar.setMessage(title);
            IcyBufferedImage sourceImage = this.imageIORead(exp.seqCamData.getFileNameFromImageList(t_from));
            this.getReferenceImage(exp, t_previous, transformOptions);
            IcyBufferedImage workImage = transformFunction.getTransformedImage(sourceImage, transformOptions);
            try {
                this.seqNegative.beginUpdate();
                this.seqNegative.setImage(0, 0, (BufferedImage)workImage);
                this.vNegative.setTitle(title);
                List<Rectangle2D> listRectangles = this.find_flies.findFlies(workImage, t_from);
                this.displayRectanglesAsROIs(this.seqNegative, listRectangles, true);
                this.seqNegative.endUpdate();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            t_previous = t_from;
        }
        progressBar.close();
    }
}

