/*
 * Decompiled with CFR 0.152.
 */
package plugins.fmp.multiSPOTS96.series;

import icy.image.IcyBufferedImage;

public class MemoryMonitor {
    private final Runtime runtime = Runtime.getRuntime();

    public long getTotalMemoryMB() {
        return this.runtime.totalMemory() / 1024L / 1024L;
    }

    public long getFreeMemoryMB() {
        return this.runtime.freeMemory() / 1024L / 1024L;
    }

    public long getUsedMemoryMB() {
        return this.getTotalMemoryMB() - this.getFreeMemoryMB();
    }

    public long getMaxMemoryMB() {
        return this.runtime.maxMemory() / 1024L / 1024L;
    }

    public double getMemoryUsagePercent() {
        return (double)this.getUsedMemoryMB() / (double)this.getMaxMemoryMB() * 100.0;
    }

    public long getAvailableMemoryMB() {
        return this.getMaxMemoryMB() - this.getUsedMemoryMB();
    }

    public long estimateImageMemoryFootprint(IcyBufferedImage image) {
        if (image == null) {
            return 0L;
        }
        long footprint = 0L;
        footprint += 64L;
        int sizeX = image.getSizeX();
        int sizeY = image.getSizeY();
        int sizeC = image.getSizeC();
        for (int c = 0; c < sizeC; ++c) {
            Object data = image.getDataXY(c);
            if (data == null) continue;
            if (data instanceof byte[]) {
                footprint += (long)((byte[])data).length;
                continue;
            }
            if (data instanceof short[]) {
                footprint += (long)(((short[])data).length * 2);
                continue;
            }
            if (data instanceof int[]) {
                footprint += (long)(((int[])data).length * 4);
                continue;
            }
            if (data instanceof float[]) {
                footprint += (long)(((float[])data).length * 4);
                continue;
            }
            if (!(data instanceof double[])) continue;
            footprint += (long)(((double[])data).length * 8);
        }
        return footprint / 1024L / 1024L;
    }
}

